/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import com.mapr.client.impl.rpc.RpcResponse;
import com.mapr.client.impl.util.ByteBufReader;
import com.mapr.utils.ByteReader;
import com.mapr.utils.Crypto;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class RpcMsgDecoder
extends MessageToMessageDecoder<ByteBuf> {
    static final Logger logger = LoggerFactory.getLogger(RpcMsgDecoder.class);
    private final boolean secure;
    private static final RpcMsgDecoder SIMPLE_DECODER = new RpcMsgDecoder(false);
    private static final RpcMsgDecoder SECURED_DECODER = new RpcMsgDecoder(true);

    private RpcMsgDecoder(boolean secure) {
        this.secure = secure;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.secure) {
            throw new UnsupportedOperationException("Secure connections are not supported!");
        }
        if (!ctx.channel().isOpen()) {
            return;
        }
        ByteBuf buff = in.order(ByteOrder.BIG_ENDIAN);
        ByteBufInputStream is = new ByteBufInputStream(buff, buff.readableBytes());
        ByteBuf ticketBuf = null;
        ByteBuf hdrBuf = null;
        ByteBuf respBuf = null;
        ByteBuf payloadBuf = null;
        boolean encrypted = false;
        int ticketLen = 0;
        if (this.secure) {
            encrypted = is.read() != 0;
            ticketLen = this.readInt24(is);
        }
        short hdrLen = is.readShort();
        int respLen = this.readInt24(is);
        byte hdrXor = is.readByte();
        byte respXor = is.readByte();
        if (ticketLen > 0) {
            ticketBuf = buff.slice(buff.readerIndex(), ticketLen);
            buff.skipBytes(ticketLen);
        }
        hdrBuf = buff.slice(buff.readerIndex(), (int)hdrLen);
        buff.skipBytes((int)hdrLen);
        if (!encrypted && hdrXor != Crypto.computeXor((ByteReader)ByteBufReader.wrap(hdrBuf))) {
            throw new CorruptedFrameException("RpcHeader XOR did not match the reported value.");
        }
        respBuf = buff.slice(buff.readerIndex(), respLen);
        buff.skipBytes(respLen);
        if (!encrypted && respXor != Crypto.computeXor((ByteReader)ByteBufReader.wrap(respBuf))) {
            throw new CorruptedFrameException("Response Msg XOR did not match the reported value.");
        }
        RpcResponse msg = new RpcResponse(ticketBuf, hdrBuf, respBuf, payloadBuf);
        out.add(msg);
    }

    private int readInt24(ByteBufInputStream is) throws IOException {
        int v = is.read();
        v |= is.read() << 8;
        return v |= is.read() << 16;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelReadComplete();
    }

    public static ChannelHandler get(boolean secure) {
        return secure ? SECURED_DECODER : SIMPLE_DECODER;
    }
}

