/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.cdc.impl;

import com.mapr.baseutils.BinaryString;
import com.mapr.db.cdc.ChangeDataKeyValue;
import com.mapr.db.cdc.impl.BinaryCell;
import com.mapr.db.cdc.impl.ChangeDataRecordImpl;
import com.mapr.db.cdc.impl.ChangeNodeImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.util.ByteBufs;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.ParsedRow;
import com.mapr.fs.proto.Dbserver;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ojai.FieldPath;
import org.ojai.KeyValue;
import org.ojai.Value;
import org.ojai.store.cdc.ChangeDataReader;
import org.ojai.store.cdc.ChangeEvent;
import org.ojai.store.cdc.ChangeNode;
import org.ojai.store.cdc.ChangeOp;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeDataRecordImplBinary
extends ChangeDataRecordImpl {
    static final Logger LOG = LoggerFactory.getLogger(ChangeDataRecordImplBinary.class);
    Map<byte[], List<BinaryCell>> familyMap_ = new HashMap<byte[], List<BinaryCell>>();
    private ArrayList<byte[]> familyList_ = new ArrayList();

    public ChangeDataRecordImplBinary(Map<Integer, String> idToCFNameMap, Dbserver.RawChangeData rData, ByteBuffer valueBuf) throws IllegalArgumentException {
        super(null, idToCFNameMap, rData, valueBuf);
        if (this.isJson()) {
            throw new IllegalArgumentException("Not a binary record");
        }
        this.opBaseType_ = this.result_.getIsDelete() ? ChangeOp.DELETE : (this.initialCopy_ ? ChangeOp.SET : ChangeOp.MERGE);
        ParsedRow prow = new ParsedRow();
        try {
            this.result_.DecodeByteBuf(prow);
            ChangeDataRecordImplBinary.parseResult(this.result_, this.result_.getKey().array(), this.result_.keyLength, idToCFNameMap, this.familyMap_, this.familyList_);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("failed to parse changedatarecord", e);
        }
    }

    public static void parseResult(MapRResult mresult, byte[] key, int keyLength, Map<Integer, String> familyIdMap, Map<byte[], List<BinaryCell>> familyMap, ArrayList<byte[]> familyList) throws IOException {
        int f;
        if (mresult == null) {
            return;
        }
        if (mresult.isEmpty()) {
            return;
        }
        if (mresult.getIsDelete()) {
            LOG.debug("delete row" + BinaryString.toStringBinary((byte[])key));
            return;
        }
        int cellPos = 0;
        int columnPos = 0;
        Object[] families = new FamilyNameIdMap[mresult.cfIds.length];
        for (f = 0; f < mresult.cfIds.length; ++f) {
            byte[] cfname = Bytes.toBytes((String)familyIdMap.get(mresult.cfIds[f]));
            families[f] = new FamilyNameIdMap(f, cfname, columnPos, cellPos);
            for (int c = 0; c < mresult.cellsPerFamily[f]; ++c) {
                cellPos += mresult.versions[columnPos];
                ++columnPos;
            }
        }
        Arrays.sort(families);
        cellPos = 0;
        columnPos = 0;
        for (f = 0; f < mresult.cfIds.length; ++f) {
            ArrayList<BinaryCell> kvs = new ArrayList<BinaryCell>();
            int index = ((FamilyNameIdMap)families[f]).index;
            byte[] cfname = ((FamilyNameIdMap)families[f]).name;
            columnPos = ((FamilyNameIdMap)families[f]).columnPos;
            cellPos = ((FamilyNameIdMap)families[f]).cellPos;
            for (int c = 0; c < mresult.cellsPerFamily[index]; ++c) {
                for (int v = 0; v < mresult.versions[columnPos]; ++v) {
                    ChangeOp cop = ChangeOp.PUT;
                    long copTS = mresult.timestamps[cellPos];
                    if (mresult.isColDelete[cellPos] == 1 && mresult.isColDeleteExact[cellPos] == 1) {
                        byte[] tmpColumnBytes = new byte[mresult.columnLengths[columnPos]];
                        System.arraycopy(mresult.bufBytes, mresult.columnOffsets[columnPos], tmpColumnBytes, 0, mresult.columnLengths[columnPos]);
                        throw new IllegalArgumentException("row:" + (key == null ? "nil" : BinaryString.toStringBinary((byte[])key)) + "family:" + (cfname == null ? "nil" : BinaryString.toStringBinary((byte[])cfname)) + "column:" + (tmpColumnBytes == null ? "nil" : BinaryString.toStringBinary((byte[])tmpColumnBytes)) + " has both column delete and column delete_exact set");
                    }
                    if (mresult.isColDelete[cellPos] == 1) {
                        cop = ChangeOp.DELETE;
                    } else if (mresult.isColDeleteExact[cellPos] == 1) {
                        cop = ChangeOp.DELETE_EXACT;
                    }
                    if (copTS == Long.MAX_VALUE) {
                        copTS = mresult.getRowTs();
                    }
                    BinaryCell bcell = new BinaryCell(key, cfname, mresult.bufBytes, mresult.columnOffsets[columnPos], mresult.columnLengths[columnPos], mresult.valueOffsets[cellPos], mresult.valueLengths[cellPos], copTS, mresult.rowTs, cop);
                    kvs.add(bcell);
                    ++cellPos;
                }
                ++columnPos;
            }
            familyMap.put(cfname, kvs);
            familyList.add(cfname);
        }
    }

    public Iterator<KeyValue<FieldPath, ChangeNode>> iterator() {
        return new ChangeDataRecordBinaryIterator();
    }

    public ChangeDataReader getReader() {
        return new ChangeDataReaderImplBinary();
    }

    static class FamilyNameIdMap
    implements Comparable<FamilyNameIdMap> {
        byte[] name;
        int index;
        int columnPos;
        int cellPos;

        FamilyNameIdMap(int id, byte[] cfname, int columnPos, int cellPos) {
            this.index = id;
            this.name = cfname;
            this.columnPos = columnPos;
            this.cellPos = cellPos;
        }

        @Override
        public int compareTo(FamilyNameIdMap that) {
            return Bytes.compareTo((byte[])this.name, (byte[])that.name);
        }

        public String toString() {
            return String.format("name(%s) index(%d) columnPos(%d) cellPos(%d)", Bytes.toString((byte[])this.name), this.index, this.columnPos, this.cellPos);
        }
    }

    class ChangeDataRecordBinaryIterator
    implements Iterator<KeyValue<FieldPath, ChangeNode>> {
        private int familyListIndex_ = -1;
        private int columnListIndex_ = -1;
        LinkedList<ChangeNodeImpl> cachedNodes_ = null;

        ChangeDataRecordBinaryIterator() {
            if (ChangeDataRecordImplBinary.this.isJson()) {
                throw new IllegalStateException("Not a json record!");
            }
            if (ChangeDataRecordImplBinary.this.familyMap_ != null && !ChangeDataRecordImplBinary.this.familyMap_.isEmpty()) {
                this.familyListIndex_ = 0;
                this.columnListIndex_ = 0;
            }
            if (ChangeDataRecordImplBinary.this.recCachedNode_ != null) {
                this.cachedNodes_ = new LinkedList();
                this.cachedNodes_.addLast(ChangeDataRecordImplBinary.this.recCachedNode_);
            }
        }

        private String genCurrentFieldName(byte[] cfname, byte[] colname) {
            if (cfname == null || cfname.length <= 0) {
                throw new IllegalArgumentException("column family is null or empty");
            }
            if (colname == null || colname.length <= 0) {
                throw new IllegalArgumentException("column is null or empty");
            }
            return BinaryString.toStringBinary((byte[])cfname) + "." + BinaryString.toStringBinary((byte[])colname);
        }

        @Override
        public boolean hasNext() {
            byte[] currentFamily;
            List<BinaryCell> currentColumn;
            if (this.cachedNodes_ != null && !this.cachedNodes_.isEmpty()) {
                return true;
            }
            if (this.familyListIndex_ == -1 || this.columnListIndex_ == -1) {
                return false;
            }
            boolean ret = false;
            if (this.familyListIndex_ < ChangeDataRecordImplBinary.this.familyList_.size() - 1) {
                ret = true;
            } else if (this.familyListIndex_ == ChangeDataRecordImplBinary.this.familyList_.size() - 1 && this.columnListIndex_ < (currentColumn = ChangeDataRecordImplBinary.this.familyMap_.get(currentFamily = ChangeDataRecordImplBinary.this.familyList_.get(this.familyListIndex_))).size()) {
                ret = true;
            }
            return ret;
        }

        @Override
        public KeyValue<FieldPath, ChangeNode> next() {
            ChangeDataKeyValue ret = null;
            if (this.cachedNodes_ != null && !this.cachedNodes_.isEmpty()) {
                ChangeNodeImpl cNode = this.cachedNodes_.removeFirst();
                String fpName = cNode.getFieldName();
                ret = new ChangeDataKeyValue(fpName == null ? null : FieldPath.parseFrom((String)fpName), cNode);
                return ret;
            }
            if (this.familyListIndex_ == -1 || this.columnListIndex_ == -1) {
                return ret;
            }
            byte[] currentFamily = ChangeDataRecordImplBinary.this.familyList_.get(this.familyListIndex_);
            List<BinaryCell> currentColumnList = ChangeDataRecordImplBinary.this.familyMap_.get(currentFamily);
            BinaryCell currentColumn = currentColumnList.get(this.columnListIndex_);
            String fieldName = null;
            fieldName = currentColumn.columnBytes() != null && currentColumn.columnBytes().length > 0 ? this.genCurrentFieldName(currentFamily, currentColumn.columnBytes()) : BinaryString.toStringBinary((byte[])currentFamily);
            com.mapr.db.rowcol.KeyValue value = null;
            if (currentColumn.getValueBytes().length > 0) {
                value = DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(currentColumn.getValueBytes()));
            }
            ChangeNodeImpl cNode = new ChangeNodeImpl(ChangeEvent.NODE, currentColumn.getOpType(), currentColumn.getTimestamp(), currentColumn.getServerTimestamp(), fieldName, -1, null, (Value)value, true, ChangeDataRecordImplBinary.this.isJson());
            ++this.columnListIndex_;
            if (this.columnListIndex_ == currentColumnList.size()) {
                ++this.familyListIndex_;
                if (this.familyListIndex_ < ChangeDataRecordImplBinary.this.familyList_.size()) {
                    this.columnListIndex_ = 0;
                } else {
                    this.familyListIndex_ = -1;
                    this.columnListIndex_ = -1;
                }
            }
            return new ChangeDataKeyValue(FieldPath.parseFrom((String)fieldName), cNode);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class ChangeDataReaderImplBinary
    implements ChangeDataReader {
        LinkedList<ChangeNodeImpl> cachedNodes_ = null;
        private int familyListIndex_ = -1;
        private int columnListIndex_ = -1;
        ChangeNodeImpl currentChangeNode_ = null;

        public ChangeDataReaderImplBinary() throws IllegalArgumentException {
            if (ChangeDataRecordImplBinary.this.isJson()) {
                throw new IllegalStateException("Not a json record!");
            }
            this.cachedNodes_ = new LinkedList();
            if (ChangeDataRecordImplBinary.this.recCachedNode_ != null) {
                this.cachedNodes_.addLast(ChangeDataRecordImplBinary.this.recCachedNode_);
            }
            if (ChangeDataRecordImplBinary.this.familyMap_ == null || ChangeDataRecordImplBinary.this.familyMap_.isEmpty()) {
                this.familyListIndex_ = -1;
                this.columnListIndex_ = -1;
                return;
            }
            this.familyListIndex_ = 0;
            this.columnListIndex_ = 0;
            ChangeNodeImpl preNode = new ChangeNodeImpl(ChangeEvent.START_MAP, ChangeOp.MERGE, ChangeDataRecordImplBinary.this.result_.rowTs, ChangeDataRecordImplBinary.this.result_.rowTs, null, -1, null, null, true, ChangeDataRecordImplBinary.this.isJson());
            this.cachedNodes_.addLast(preNode);
            byte[] nextFamily = ChangeDataRecordImplBinary.this.familyList_.get(this.familyListIndex_);
            List<BinaryCell> nextColumnList = ChangeDataRecordImplBinary.this.familyMap_.get(nextFamily);
            BinaryCell nextColumn = nextColumnList.get(this.columnListIndex_);
            ++this.columnListIndex_;
            if (nextColumn.columnBytes() != null && nextColumn.columnBytes().length > 0) {
                ChangeNodeImpl postNode = new ChangeNodeImpl(ChangeEvent.START_MAP, ChangeOp.MERGE, ChangeDataRecordImplBinary.this.result_.rowTs, ChangeDataRecordImplBinary.this.result_.rowTs, BinaryString.toStringBinary((byte[])nextFamily), -1, null, null, true, ChangeDataRecordImplBinary.this.isJson());
                this.cachedNodes_.addLast(postNode);
                this.cachedNodes_.addLast(this.genChangeNode(nextColumn));
            } else {
                com.mapr.db.rowcol.KeyValue nextValue = null;
                if (nextColumn.getValueBytes().length > 0) {
                    nextValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(nextColumn.getValueBytes()));
                }
                ChangeNodeImpl postNode = new ChangeNodeImpl(ChangeEvent.NODE, nextColumn.getOpType(), nextColumn.getTimestamp(), nextColumn.getServerTimestamp(), BinaryString.toStringBinary((byte[])ChangeDataRecordImplBinary.this.familyList_.get(this.familyListIndex_)), -1, null, (Value)nextValue, true, ChangeDataRecordImplBinary.this.isJson());
                this.cachedNodes_.addLast(postNode);
            }
        }

        public boolean hasNext() {
            byte[] currentFamily;
            List<BinaryCell> currentColumn;
            if (this.cachedNodes_ == null) {
                return false;
            }
            if (!this.cachedNodes_.isEmpty()) {
                return true;
            }
            if (this.familyListIndex_ == -1 || this.columnListIndex_ == -1) {
                return false;
            }
            boolean ret = false;
            if (this.familyListIndex_ < ChangeDataRecordImplBinary.this.familyList_.size() - 1) {
                ret = true;
            } else if (this.familyListIndex_ == ChangeDataRecordImplBinary.this.familyList_.size() - 1 && this.columnListIndex_ < (currentColumn = ChangeDataRecordImplBinary.this.familyMap_.get(currentFamily = ChangeDataRecordImplBinary.this.familyList_.get(this.familyListIndex_))).size()) {
                ret = true;
            }
            return ret;
        }

        public ChangeNodeImpl genChangeNode(BinaryCell currentColumn) {
            String fieldName = BinaryString.toStringBinary((byte[])currentColumn.columnBytes());
            com.mapr.db.rowcol.KeyValue value = null;
            if (currentColumn.getValueBytes().length > 0) {
                value = DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(currentColumn.getValueBytes()));
            }
            return new ChangeNodeImpl(ChangeEvent.NODE, currentColumn.getOpType(), currentColumn.getTimestamp(), currentColumn.getServerTimestamp(), fieldName, -1, null, (Value)value, true, ChangeDataRecordImplBinary.this.isJson());
        }

        public ChangeEvent next() {
            ChangeNodeImpl postNode;
            if (this.cachedNodes_ != null && !this.cachedNodes_.isEmpty()) {
                this.currentChangeNode_ = this.cachedNodes_.removeFirst();
                return this.currentChangeNode_.getEvent();
            }
            if (this.familyListIndex_ == -1 || this.columnListIndex_ == -1) {
                return null;
            }
            byte[] currentFamily = ChangeDataRecordImplBinary.this.familyList_.get(this.familyListIndex_);
            List<BinaryCell> currentColumnList = ChangeDataRecordImplBinary.this.familyMap_.get(currentFamily);
            if (this.columnListIndex_ < currentColumnList.size()) {
                BinaryCell currentColumn = currentColumnList.get(this.columnListIndex_);
                this.currentChangeNode_ = this.genChangeNode(currentColumn);
                ++this.columnListIndex_;
                return this.currentChangeNode_.getEvent();
            }
            if (!this.cachedNodes_.isEmpty()) {
                throw new IllegalArgumentException("cachedNodes is not empty!");
            }
            BinaryCell currentColumn = currentColumnList.get(this.columnListIndex_ - 1);
            if (currentColumn.columnBytes() != null && currentColumn.columnBytes().length > 0) {
                postNode = new ChangeNodeImpl(ChangeEvent.END_MAP, ChangeOp.NULL, ChangeDataRecordImplBinary.this.result_.rowTs, ChangeDataRecordImplBinary.this.result_.rowTs, BinaryString.toStringBinary((byte[])currentFamily), -1, null, null, true, ChangeDataRecordImplBinary.this.isJson());
                this.cachedNodes_.addLast(postNode);
            }
            ++this.familyListIndex_;
            this.columnListIndex_ = 0;
            if (this.familyListIndex_ < ChangeDataRecordImplBinary.this.familyList_.size()) {
                byte[] nextFamily = ChangeDataRecordImplBinary.this.familyList_.get(this.familyListIndex_);
                List<BinaryCell> nextColumnList = ChangeDataRecordImplBinary.this.familyMap_.get(nextFamily);
                BinaryCell nextColumn = nextColumnList.get(this.columnListIndex_);
                ++this.columnListIndex_;
                if (nextColumn.columnBytes() != null && nextColumn.columnBytes().length > 0) {
                    ChangeNodeImpl postNode2 = new ChangeNodeImpl(ChangeEvent.START_MAP, ChangeOp.MERGE, ChangeDataRecordImplBinary.this.result_.rowTs, ChangeDataRecordImplBinary.this.result_.rowTs, BinaryString.toStringBinary((byte[])nextFamily), -1, null, null, true, ChangeDataRecordImplBinary.this.isJson());
                    this.cachedNodes_.addLast(postNode2);
                    this.cachedNodes_.addLast(this.genChangeNode(nextColumn));
                } else {
                    com.mapr.db.rowcol.KeyValue nextValue = null;
                    if (nextColumn.getValueBytes().length > 0) {
                        nextValue = DBValueBuilderImpl.KeyValueBuilder.initFrom(ByteBuffer.wrap(nextColumn.getValueBytes()));
                    }
                    ChangeNodeImpl postNode3 = new ChangeNodeImpl(ChangeEvent.NODE, nextColumn.getOpType(), nextColumn.getTimestamp(), nextColumn.getServerTimestamp(), BinaryString.toStringBinary((byte[])nextFamily), -1, null, (Value)nextValue, true, ChangeDataRecordImplBinary.this.isJson());
                    this.cachedNodes_.addLast(postNode3);
                }
            } else {
                this.familyListIndex_ = -1;
                this.columnListIndex_ = -1;
                postNode = new ChangeNodeImpl(ChangeEvent.END_MAP, ChangeOp.NULL, ChangeDataRecordImplBinary.this.result_.rowTs, ChangeDataRecordImplBinary.this.result_.rowTs, null, -1, null, null, true, ChangeDataRecordImplBinary.this.isJson());
                this.cachedNodes_.addLast(postNode);
            }
            this.currentChangeNode_ = this.cachedNodes_.removeFirst();
            return this.currentChangeNode_.getEvent();
        }

        public ChangeNodeImpl getChangeNode() {
            return new ChangeNodeImpl(this.currentChangeNode_);
        }

        public ChangeOp getOp() {
            return this.currentChangeNode_.getOp();
        }

        public String getFieldName() {
            return this.currentChangeNode_.getFieldName();
        }

        public ByteBuffer getFieldNameBytes() {
            return this.currentChangeNode_.getFieldNameBytes();
        }

        public boolean inMap() {
            return this.currentChangeNode_.inMap();
        }

        public int getArrayIndex() {
            return this.currentChangeNode_.getArrayIndex();
        }

        public Value.Type getType() {
            return this.currentChangeNode_.getValue().getType();
        }

        public Value getValue() {
            return this.currentChangeNode_.getValue();
        }

        public long getOpTimestamp() {
            return this.currentChangeNode_.getOpTimestamp();
        }

        public boolean inArray() {
            return this.currentChangeNode_.inArray();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public byte getByte() {
            return this.getValue().getByte();
        }

        public short getShort() {
            return this.getValue().getShort();
        }

        public int getInt() {
            return this.getValue().getInt();
        }

        public long getLong() {
            return this.getValue().getLong();
        }

        public float getFloat() {
            return this.getValue().getFloat();
        }

        public double getDouble() {
            return this.getValue().getDouble();
        }

        public BigDecimal getDecimal() {
            return this.getValue().getDecimal();
        }

        public int getDecimalPrecision() {
            return this.getValue().getDecimal().precision();
        }

        public int getDecimalScale() {
            return this.getValue().getDecimal().scale();
        }

        public int getDecimalValueAsInt() {
            return this.getValue().getDecimal().intValue();
        }

        public long getDecimalValueAsLong() {
            return this.getValue().getDecimal().longValue();
        }

        public ByteBuffer getDecimalValueAsBytes() {
            return ByteBufs.decimalValueToBytes((BigDecimal)this.getDecimal());
        }

        public boolean getBoolean() {
            return this.getValue().getBoolean();
        }

        public String getString() {
            return this.getValue().getString();
        }

        public long getTimestampLong() {
            return this.getValue().getTimestampAsLong();
        }

        public OTimestamp getTimestamp() {
            return this.getValue().getTimestamp();
        }

        public int getDateInt() {
            return this.getValue().getDateAsInt();
        }

        public ODate getDate() {
            return this.getValue().getDate();
        }

        public int getTimeInt() {
            return this.getValue().getTimeAsInt();
        }

        public OTime getTime() {
            return this.getValue().getTime();
        }

        public OInterval getInterval() {
            return this.getValue().getInterval();
        }

        public long getIntervalMillis() {
            return this.getValue().getLong();
        }

        public ByteBuffer getBinary() {
            return this.getValue().getBinary();
        }

        public long getServerTimestamp() {
            return this.getOpTimestamp();
        }
    }
}

