/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.table;

import com.mapr.cli.MapRCliUtil;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.fs.proto.Common;
import java.util.ArrayList;
import java.util.List;

public class MfsInstanceStats {
    private MfsInstanceName mfsInsName;
    private List<TabletStatInfo> tabletStatInfoList;
    private int numOfPrimaryTablets;
    private int numOfSecondaryTablets;
    private long totalPrimaryTabletsLogicalSize;
    private long totalPrimaryTabletsPhysicalSize;
    private long totalSecondaryTabletsLogicalSize;
    private long totalSecondaryTabletsPhysicalSize;

    public MfsInstanceStats(MfsInstanceName mfsInsName) {
        this.mfsInsName = mfsInsName;
        this.tabletStatInfoList = new ArrayList<TabletStatInfo>();
        this.numOfPrimaryTablets = 0;
        this.numOfSecondaryTablets = 0;
        this.totalPrimaryTabletsLogicalSize = 0L;
        this.totalPrimaryTabletsPhysicalSize = 0L;
        this.totalSecondaryTabletsLogicalSize = 0L;
        this.totalSecondaryTabletsPhysicalSize = 0L;
    }

    public void addTabletDesc(CommandOutput.OutputHierarchy out, boolean isPrimary, TabletStatInfo tsInfo) throws CLIProcessingException {
        this.tabletStatInfoList.add(tsInfo);
        if (!this.mfsInsName.isValid()) {
            throw new CLIProcessingException("Cannot add tablet " + MapRCliUtil.getFidAsString(tsInfo.getFid()) + " to invalid " + this.mfsInsName);
        }
        if (isPrimary) {
            ++this.numOfPrimaryTablets;
            this.totalPrimaryTabletsLogicalSize += tsInfo.getLogicalSize();
            this.totalPrimaryTabletsPhysicalSize += tsInfo.getPhysicalSize();
        } else {
            ++this.numOfSecondaryTablets;
            this.totalSecondaryTabletsLogicalSize += tsInfo.getLogicalSize();
            this.totalSecondaryTabletsPhysicalSize += tsInfo.getPhysicalSize();
        }
    }

    public MfsInstanceName mfsInsName() {
        return this.mfsInsName;
    }

    public List<TabletStatInfo> tabletStatInfoList() {
        return this.tabletStatInfoList;
    }

    public int numOfPrimaryTablets() {
        return this.numOfPrimaryTablets;
    }

    public int numOfSecondaryTablets() {
        return this.numOfSecondaryTablets;
    }

    public long totalPrimaryTabletsLogicalSize() {
        return this.totalPrimaryTabletsLogicalSize;
    }

    public long totalPrimaryTabletsPhysicalSize() {
        return this.totalPrimaryTabletsPhysicalSize;
    }

    public long totalSecondaryTabletsLogicalSize() {
        return this.totalSecondaryTabletsLogicalSize;
    }

    public long totalSecondaryTabletsPhysicalSize() {
        return this.totalSecondaryTabletsPhysicalSize;
    }

    public static class MfsInstanceName {
        private String node;
        private int mfsPort;

        public MfsInstanceName(String node, int mfsPort) {
            this.node = node;
            this.mfsPort = mfsPort;
        }

        public boolean isValid() {
            return this.mfsPort >= 0;
        }

        public String getNode() {
            return this.node;
        }

        public int getPort() {
            return this.mfsPort;
        }

        public String toString() {
            if (this.mfsPort >= 0) {
                return this.node + ":" + this.mfsPort;
            }
            return this.node;
        }
    }

    public static class TabletStatInfo {
        private byte[] startKey;
        private byte[] endKey;
        private int lastHeartBeat;
        private Common.FidMsg fid;
        private MfsInstanceName primaryMfs;
        private List<MfsInstanceName> secondaryMfsList;
        private long logicalSize;
        private long physicalSize;
        private boolean hasCopyPendingSize;
        private long copyPendingSize;
        private long numRows;
        private boolean hasNumRowsWithDelete;
        private long numRowsWithDelete;
        private boolean hasNumSpills;
        private long numSpills;
        private boolean hasNumSegments;
        private long numSegments;

        public TabletStatInfo(byte[] startKey, byte[] endKey, int lastheartbeat, Common.FidMsg fid, MfsInstanceName primaryMfs, List<MfsInstanceName> secondaryMfsList, long logicalsize, long physicalsize, boolean hasCopyPendingSize, long copypendingsize, long numRows, boolean hasNumRowsWithDelete, long numRowsWithDelete, boolean hasNumSpills, long numSpills, boolean hasNumSegments, long numSegments) {
            this.startKey = startKey;
            this.endKey = endKey;
            this.lastHeartBeat = lastheartbeat;
            this.fid = fid;
            this.primaryMfs = primaryMfs;
            this.secondaryMfsList = secondaryMfsList;
            this.logicalSize = logicalsize;
            this.physicalSize = physicalsize;
            this.hasCopyPendingSize = hasCopyPendingSize;
            this.copyPendingSize = copypendingsize;
            this.numRows = numRows;
            this.hasNumRowsWithDelete = hasNumRowsWithDelete;
            this.numRowsWithDelete = numRowsWithDelete;
            this.hasNumSpills = hasNumSpills;
            this.numSpills = numSpills;
            this.hasNumSegments = hasNumSegments;
            this.numSegments = numSegments;
        }

        public byte[] getStartKey() {
            return this.startKey;
        }

        public byte[] getEndKey() {
            return this.endKey;
        }

        public int getLastheartbeat() {
            return this.lastHeartBeat;
        }

        public Common.FidMsg getFid() {
            return this.fid;
        }

        public MfsInstanceName getPrimaryMfs() {
            return this.primaryMfs;
        }

        public List<MfsInstanceName> getSecondaryMfsList() {
            return this.secondaryMfsList;
        }

        public long getLogicalSize() {
            return this.logicalSize;
        }

        public long getPhysicalSize() {
            return this.physicalSize;
        }

        public boolean getHasCopyPendingSize() {
            return this.hasCopyPendingSize;
        }

        public long getCopypendingSize() {
            return this.copyPendingSize;
        }

        public long getNumRows() {
            return this.numRows;
        }

        public boolean getHasNumRowsWithDelete() {
            return this.hasNumRowsWithDelete;
        }

        public long getNumRowsWithDelete() {
            return this.numRowsWithDelete;
        }

        public boolean getHasNumSpills() {
            return this.hasNumSpills;
        }

        public long getNumSpills() {
            return this.numSpills;
        }

        public boolean getHasNumSegments() {
            return this.hasNumSegments;
        }

        public long getNumSegments() {
            return this.numSegments;
        }
    }
}

