/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.schedulepolicy.commands;

import com.mapr.cliframework.base.CommandOutput;
import com.mapr.fs.cldb.proto.CLDBProto;
import java.util.List;
import org.apache.commons.logging.Log;

public class SchedulePolicyOutputUtil {
    public static boolean extractAndAddPolicyToOutput(CLDBProto.SchedulePolicyProcResponse resp, CommandOutput.OutputHierarchy ch, Log LOG) {
        List policies = resp.getPoliciesList();
        if (policies == null || policies.isEmpty()) {
            LOG.error((Object)"RPC Request to get info of a Schedule failed. No data returned");
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "to get info of a Schedule failed. No data returned."));
            return false;
        }
        if (policies.size() != 1) {
            LOG.error((Object)"RPC Request to get info of a Schedule failed. More than one schedule returned");
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "to get info of a Schedule failed. More than one schedule returned."));
            return false;
        }
        CLDBProto.Policy policy = (CLDBProto.Policy)policies.get(0);
        LOG.debug((Object)("obtained policy details: " + policy.toString()));
        if (!policy.hasPolicyId()) {
            LOG.error((Object)"RPC Request to get info of a Schedule failed. No data returned");
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "to get info of a Schedule failed. No data returned."));
            return false;
        }
        SchedulePolicyOutputUtil.addPolicyToOutput(policy, ch);
        return true;
    }

    public static void addPolicyToOutput(CLDBProto.Policy policy, CommandOutput.OutputHierarchy ch) {
        CommandOutput.OutputHierarchy.OutputNode mainNode = new CommandOutput.OutputHierarchy.OutputNode();
        CommandOutput.OutputHierarchy.OutputNode policyNodeId = new CommandOutput.OutputHierarchy.OutputNode("id", policy.getPolicyId());
        CommandOutput.OutputHierarchy.OutputNode policyNodeName = new CommandOutput.OutputHierarchy.OutputNode("name", (Object)policy.getPolicyName());
        CommandOutput.OutputHierarchy.OutputNode policyNodeInUse = new CommandOutput.OutputHierarchy.OutputNode("inuse", policy.getVolumeIdCount() > 0 ? 1 : 0);
        mainNode.addChild(policyNodeId);
        mainNode.addChild(policyNodeName);
        mainNode.addChild(policyNodeInUse);
        if (policy.getIsTieringInternalPolicy()) {
            CommandOutput.OutputHierarchy.OutputNode policyNodeDesc = new CommandOutput.OutputHierarchy.OutputNode("description", (Object)"Automatic Scheduler for EC and Cold Tier: It uses internal policies to schedule the task");
            mainNode.addChild(policyNodeDesc);
        }
        mainNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("rules"));
        List rules = policy.getPolicyRulesList();
        for (CLDBProto.PolicyRule rule : rules) {
            CommandOutput.OutputHierarchy.OutputNode policyNodeRules = new CommandOutput.OutputHierarchy.OutputNode("rules");
            policyNodeRules.addChild(new CommandOutput.OutputHierarchy.OutputNode("frequency", (Object)rule.getFrequency().name()));
            if (rule.hasDate()) {
                policyNodeRules.addChild(new CommandOutput.OutputHierarchy.OutputNode("date", (Object)rule.getDate()));
            }
            if (rule.hasTime()) {
                policyNodeRules.addChild(new CommandOutput.OutputHierarchy.OutputNode("time", rule.getTime()));
            }
            if (rule.hasMinutes()) {
                policyNodeRules.addChild(new CommandOutput.OutputHierarchy.OutputNode("minute", rule.getMinutes()));
            }
            policyNodeRules.addChild(new CommandOutput.OutputHierarchy.OutputNode("retain", (Object)(rule.getRetainTime().getNumberOfUnits() + rule.getRetainTime().getTimeUnitsEnum().name())));
            mainNode.addChild(policyNodeRules);
        }
        ch.addNode(mainNode);
    }
}

