/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.iamserverutils.IamServerRpcCommonUtils;
import com.mapr.baseutils.policyserverutils.PolicyServerRpcCommonUtils;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.fs.cldb.ClusterAccessController;
import com.mapr.fs.cldb.ClusterAceProcessor;
import com.mapr.fs.cldb.PermissionsManager;
import com.mapr.fs.cldb.VolumeAccessController;
import com.mapr.fs.cldb.VolumeAceProcessor;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.policyserver.iam.IamSupportUtils;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.IAMServerProto;
import com.mapr.fs.proto.PolicyServerProto;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserResourceHelper {
    static PermissionsManager permsManager = PermissionsManager.getInstance();
    public static final Logger LOG = Logger.getLogger(UserResourceHelper.class);
    private static UserResourceHelper s_instance = new UserResourceHelper();

    public static UserResourceHelper getInstance() {
        return s_instance;
    }

    public UserRoleHelper getUserRoleHelper(String uname, Security.CredentialsMsg creds, String cname, CommandOutput.OutputHierarchy oh) {
        return new UserRoleHelper(uname, creds, cname, oh);
    }

    String dumpProtoIdentityInfoMsg(PolicyServerProto.IdentityInfoMsg idInfo) {
        String type = idInfo.getType().name();
        return type + "Name: " + idInfo.getName() + ", " + type + "Id: " + idInfo.getId();
    }

    String dumpProtoListIdentityInfoMsg(List<PolicyServerProto.IdentityInfoMsg> idInfos) {
        StringBuilder sb = new StringBuilder();
        for (PolicyServerProto.IdentityInfoMsg info : idInfos) {
            sb.append(this.dumpProtoIdentityInfoMsg(info) + ", ");
        }
        return sb.toString();
    }

    private String dumpProtoIdentityToRoles(IAMServerProto.IdentityToRoles idToRole) {
        StringBuilder sb = new StringBuilder();
        sb.append("Identity: " + this.dumpProtoIdentityInfoMsg(idToRole.getIdentity()));
        sb.append(", Roles: ");
        int i = 1;
        for (PolicyServerProto.IdentityInfoMsg msg : idToRole.getRolesList()) {
            if (i > 1) {
                sb.append(",");
            }
            sb.append(" Role-" + i++ + ": " + this.dumpProtoIdentityInfoMsg(msg));
        }
        return sb.toString();
    }

    class UserRoleHelper {
        private String username;
        private CommandOutput.OutputHierarchy out;
        private String clustername;
        private Security.CredentialsMsg callersCreds;
        private Security.CredentialsMsg userCreds;
        private Map<String, ResourceActions> clusterActionMap;
        private int status;
        private String errMsg;

        UserRoleHelper(String uname, Security.CredentialsMsg creds, String cname, CommandOutput.OutputHierarchy oh) {
            this.username = uname;
            this.callersCreds = creds;
            this.clustername = cname;
            this.out = oh;
        }

        int getStatus() {
            return this.status;
        }

        void updateRolesInUserCreds(List<IAMServerProto.IdentityToRoles> idToRoleMapping) {
            if (this.userCreds.getRidsCount() > 0) {
                LOG.debug((Object)"updateRolesInUserCreds: user creds contain role-ids. nothing to do.");
                return;
            }
            HashSet<Integer> rids = new HashSet<Integer>();
            for (IAMServerProto.IdentityToRoles idToRole : idToRoleMapping) {
                for (PolicyServerProto.IdentityInfoMsg role : idToRole.getRolesList()) {
                    rids.add(role.getId());
                }
            }
            if (!rids.isEmpty()) {
                this.userCreds = this.userCreds.toBuilder().addAllRids(rids).build();
            }
            LOG.debug((Object)("updateRolesInUserCreds: UserRoleHelper populated. " + this.toString()));
        }

        public String toString() {
            return "UserRoleHelper.toString is not implemented";
        }

        void setError(int errcode, String errmsg) {
            this.status = errcode;
            this.errMsg = errmsg;
        }

        private void buildClusterActionsMap(List<PolicyServerProto.ClusterResourceActionEntry> clusterActionsMapList) {
            this.clusterActionMap = new HashMap<String, ResourceActions>();
            if (this.userCreds == null) {
                LOG.error((Object)"buildClusterActionsMap: userCreds is null, failed to build clusterActionMap.");
                return;
            }
            HashSet<String> allowedActions = new HashSet<String>();
            HashSet<String> deniedActions = new HashSet<String>();
            permsManager.segregateClusterResourceActionForUser(this.userCreds, allowedActions, deniedActions, clusterActionsMapList);
            String curcluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
            String locClusterUrn = "urn:default:" + curcluster;
            LOG.debug((Object)("buildClusterActionsMap: locClusterUrn: " + locClusterUrn));
            ResourceActions resActions = new ResourceActions(locClusterUrn, allowedActions, deniedActions);
            this.clusterActionMap.put(locClusterUrn, resActions);
            this.dumpActionMap(this.clusterActionMap, "defaultClusterActionsMap");
        }

        private void getUserPermissions() {
            CLDBProto.UserInfo userInfo;
            try {
                CLDBProto.PermEntity pe = CLDBProto.PermEntity.newBuilder().setType(CLDBProto.SecureObjectType.OBJECT_TYPE_CLUSTER).build();
                CLDBProto.PermissionsQueryRequest req = CLDBProto.PermissionsQueryRequest.newBuilder().setCreds(this.callersCreds).addUserNames(this.username).addEntities(pe).build();
                byte[] data = null;
                data = this.clustername != null ? CLDBRpcCommonUtils.getInstance().sendRequest(this.clustername, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.UserPermissionsQueryProc.getNumber(), (MessageLite)req, CLDBProto.PermissionsQueryResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.UserPermissionsQueryProc.getNumber(), (MessageLite)req, CLDBProto.PermissionsQueryResponse.class);
                if (data == null) {
                    String msg = "User permission lookup failed: Couldn't connect to the CLDB service";
                    LOG.error((Object)("getUserPermissions: " + msg));
                    this.setError(10009, msg);
                    return;
                }
                CLDBProto.PermissionsQueryResponse resp = CLDBProto.PermissionsQueryResponse.parseFrom((byte[])data);
                int status = resp.getStatus();
                if (status != 0) {
                    String msg = "User permission lookup failed: " + status + ": " + resp.getErrorString();
                    LOG.error((Object)("getUserPermissions: " + msg));
                    this.setError(10003, msg);
                    return;
                }
                CLDBProto.ClusterConfiguration clusterConfig = resp.getConfig();
                boolean rejectRoot = clusterConfig.getRejectRoot();
                boolean squashRoot = clusterConfig.getSquashRoot();
                int clusterOwnerUid = clusterConfig.getClusterOwnerUid();
                CLDBProto.ClusterProperties props = clusterConfig.getProps();
                permsManager.initializeInstance(null, clusterOwnerUid, rejectRoot, squashRoot, props);
                if (clusterConfig.getClusterAceSupported()) {
                    permsManager.setClusterAccessController((ClusterAccessController)new ClusterAceProcessor(null));
                }
                if (clusterConfig.getVolumeAceSupported()) {
                    permsManager.setVolumeAccessController((VolumeAccessController)new VolumeAceProcessor());
                }
                LOG.debug((Object)("getUserPermissions: num user-infos: " + resp.getUserInfoCount()));
                userInfo = resp.getUserInfo(0);
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error((Object)"getUserPermissions: InvalidProtocolBufferException.", (Throwable)e);
                this.setError(10003, "Failed to get user permissions. Invalid protobug");
                return;
            }
            catch (MaprSecurityException e) {
                LOG.error((Object)"getUserPermissions: MaprSecurityException.", (Throwable)e);
                this.setError(10003, "Failed to get user permissions. MaprSecurityException");
                return;
            }
            catch (Exception e) {
                String msg = "Error while trying to get volume/security policy properties";
                LOG.error((Object)("getUserPermissions: " + msg), (Throwable)e);
                this.setError(10003, msg);
                return;
            }
            this.userCreds = userInfo.getCreds();
        }

        List<IAMServerProto.IdentityToRoles> setRoleIdsInUserCreds() throws CLIProcessingException, InvalidProtocolBufferException {
            ArrayList identities = new ArrayList();
            HashSet<Integer> ids = new HashSet<Integer>();
            int uid = this.userCreds.getUid();
            if (uid < 0) {
                String msg = "Invalid (-ve) user id for username " + this.username;
                LOG.error((Object)("setRoleIdsInUserCreds: " + msg));
                this.setError(22, msg);
                return null;
            }
            ids.add(uid);
            identities.addAll(IamSupportUtils.getIdentities(ids, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.User));
            ids.clear();
            Iterator msg = this.userCreds.getGidsList().iterator();
            while (msg.hasNext()) {
                int grp = (Integer)msg.next();
                ids.add(grp);
            }
            if (ids.size() > 0) {
                identities.addAll(IamSupportUtils.getIdentities(ids, (PolicyServerProto.IdentityType)PolicyServerProto.IdentityType.Group));
            }
            byte[] data = null;
            IAMServerProto.IamRoleMappingsRequest req = IAMServerProto.IamRoleMappingsRequest.newBuilder().setCreds(this.callersCreds).addAllIdentities(identities).build();
            IamServerRpcCommonUtils iamRpcUtils = IamServerRpcCommonUtils.getInstance();
            try {
                data = this.clustername != null ? iamRpcUtils.sendRequestToIamServer(this.clustername, IAMServerProto.IAMRoleProc.RoleMappingsProc.getNumber(), (MessageLite)req, IAMServerProto.IamRoleMappingsResponse.class) : iamRpcUtils.sendRequestToIamServer(IAMServerProto.IAMRoleProc.RoleMappingsProc.getNumber(), (MessageLite)req, IAMServerProto.IamRoleMappingsResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
            if (data == null) {
                String msg2 = "Failed to send RPC for RoleMappingsProc to IAM Sever";
                LOG.error((Object)("setRoleIdsInUserCreds: " + msg2));
                this.setError(10009, msg2);
                return null;
            }
            IAMServerProto.IamRoleMappingsResponse resp = IAMServerProto.IamRoleMappingsResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                String msg3 = "Failed to get Identity Role Mappings. " + resp.getStatus() + ": " + resp.getErrMsg();
                LOG.error((Object)("setRoleIdsInUserCreds: " + msg3));
                this.setError(resp.getStatus(), msg3);
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("setRoleIdsInUserCreds: Num mapping received: " + resp.getMappingsCount()));
                StringBuilder sb = new StringBuilder();
                for (IAMServerProto.IdentityToRoles id2roles : resp.getMappingsList()) {
                    LOG.debug((Object)("setRoleIdsInUserCreds: Mapping received: " + UserResourceHelper.this.dumpProtoIdentityToRoles(id2roles)));
                }
            }
            return resp.getMappingsList();
        }

        void fetchClusterResourceActionMap() throws CLIProcessingException, Exception {
            byte[] data = null;
            PolicyServerProto.ClusterActionsFetchRequest req = PolicyServerProto.ClusterActionsFetchRequest.newBuilder().setCreds(this.callersCreds).build();
            int procId = PolicyServerProto.SecurityPolicyProc.ClusterActionsFetchProc.getNumber();
            data = PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(procId, (MessageLite)req, PolicyServerProto.ClusterActionsFetchResponse.class);
            if (data == null) {
                String msg = "Failed to send ClusterActionsFetchProc RPC to Policy Sever";
                LOG.error((Object)("fetchClusterResourceActionMap: " + msg));
                this.setError(10009, msg);
                return;
            }
            PolicyServerProto.ClusterActionsFetchResponse resp = PolicyServerProto.ClusterActionsFetchResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                String msg = "Failed to get Cluster resource actions.";
                LOG.error((Object)("fetchClusterResourceActionMap: " + msg + " " + resp.getStatus() + ": " + resp.getErrMsg()));
                this.setError(resp.getStatus(), msg);
                return;
            }
            List clusterActionsMapList = resp.getClusterActionsMapList();
            this.buildClusterActionsMap(clusterActionsMapList);
        }

        void dumpActionMap(Map<String, ResourceActions> map, String mapname) {
            if (!LOG.isDebugEnabled()) {
                return;
            }
            for (Map.Entry<String, ResourceActions> entry : map.entrySet()) {
                String resourceUrn = entry.getKey();
                ResourceActions act = entry.getValue();
                LOG.debug((Object)("dumpActionMap: " + mapname + ":  resource: " + resourceUrn + ", " + act.toString()));
            }
        }

        void formatMergedActionMap() {
            for (Map.Entry<String, ResourceActions> entry : this.clusterActionMap.entrySet()) {
                CommandOutput.OutputHierarchy.OutputNode tmpop;
                CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
                this.out.addNode(outputNode);
                String resourceUrn = entry.getKey();
                CommandOutput.OutputHierarchy.OutputNode urnNode = new CommandOutput.OutputHierarchy.OutputNode("Resource", (Object)resourceUrn);
                outputNode.addChild(urnNode);
                ResourceActions actions = entry.getValue();
                for (String act : actions.allowedActions) {
                    tmpop = new CommandOutput.OutputHierarchy.OutputNode("AllowedActions", (Object)act);
                    tmpop.setTreatSingleChildAsPeer(true);
                    outputNode.addChild(tmpop);
                }
                for (String act : actions.deniedActions) {
                    tmpop = new CommandOutput.OutputHierarchy.OutputNode("DeniedActions", (Object)act);
                    tmpop.setTreatSingleChildAsPeer(true);
                    outputNode.addChild(tmpop);
                }
            }
        }

        void fetchUserResourceActions() throws CLIProcessingException, InvalidProtocolBufferException, Exception {
            this.getUserPermissions();
            if (this.status != 0) {
                this.out.addError(new CommandOutput.OutputHierarchy.OutputError(this.status, this.errMsg));
                return;
            }
            if (this.userCreds.getRidsCount() > 0) {
                List<IAMServerProto.IdentityToRoles> idToRoleMapping = this.setRoleIdsInUserCreds();
                if (this.status != 0) {
                    this.out.addError(new CommandOutput.OutputHierarchy.OutputError(this.status, this.errMsg));
                    return;
                }
                this.updateRolesInUserCreds(idToRoleMapping);
            }
            this.fetchClusterResourceActionMap();
            if (this.status != 0) {
                this.out.addError(new CommandOutput.OutputHierarchy.OutputError(this.status, this.errMsg));
                return;
            }
        }
    }

    class PolicyResourceAction {
        private String name;
        private List<PolicyServerProto.IdentityPolicyInfoMsg> policyList;
        private Map<String, ResourceActions> policyActionMap;

        PolicyResourceAction(String dbgstr, List<PolicyServerProto.IdentityPolicyInfoMsg> policylist) {
            this.name = dbgstr;
            this.policyList = policylist;
            this.policyActionMap = this.buildResourceActionMap();
        }

        int getNumPolicies() {
            return this.policyList.size();
        }

        private Map<String, ResourceActions> buildResourceActionMap() {
            HashMap<String, ResourceActions> actionMap = new HashMap<String, ResourceActions>();
            if (this.policyList == null) {
                LOG.error((Object)("buildResourceActionMap: name: " + this.name + ", invalid policyList. " + (this.policyList == null ? "null value" : "is empty")));
                return actionMap;
            }
            for (PolicyServerProto.IdentityPolicyInfoMsg identityPolicyInfoMsg : this.policyList) {
                PolicyServerProto.PolicyInfoMsg policy = identityPolicyInfoMsg.getPolicy();
                if (!policy.getIsActive()) {
                    LOG.debug((Object)("buildResourceActionMap: name: " + this.name + ", policy is not active, ignored"));
                    continue;
                }
                for (PolicyServerProto.StatementInfoMsg statementInfo : policy.getStatementsList()) {
                    PolicyServerProto.StatementEffect effect = statementInfo.getEffect();
                    if (effect == null) {
                        LOG.debug((Object)("buildResourceActionMap: name: " + this.name + ", effect is empty, ignored"));
                        continue;
                    }
                    block6: for (PolicyServerProto.ResourceInfoMsg resourceInfo : statementInfo.getResourcesList()) {
                        String resourceUrn = IamSupportUtils.getResourceUrn((PolicyServerProto.ResourceInfoMsg)resourceInfo);
                        if (resourceUrn == null || resourceUrn.isBlank()) {
                            LOG.debug((Object)("buildResourceActionMap: name: " + this.name + ", resourceUrn is empty, ignored"));
                            continue;
                        }
                        HashSet resourceActions = IamSupportUtils.getResourceActions((PolicyServerProto.ResourceInfoMsg)resourceInfo);
                        if (resourceActions == null || resourceActions.isEmpty()) {
                            LOG.error((Object)("buildResourceActionMap: name: " + this.name + ", resourceActions is empty, ignored"));
                            continue;
                        }
                        ResourceActions act = (ResourceActions)actionMap.get(resourceUrn);
                        if (act == null) {
                            act = new ResourceActions(resourceUrn);
                            actionMap.put(resourceUrn, act);
                        }
                        switch (effect) {
                            case Allow: {
                                act.allowedActions.addAll(resourceActions);
                                continue block6;
                            }
                            case Deny: {
                                act.deniedActions.addAll(resourceActions);
                                continue block6;
                            }
                        }
                        LOG.error((Object)("buildResourceActionMap: name: " + this.name + ", unknown effect: " + effect.toString() + ". Ignored."));
                    }
                }
            }
            for (Map.Entry entry : actionMap.entrySet()) {
                ResourceActions act = (ResourceActions)entry.getValue();
                act.removeDeniedFromAllowed();
            }
            return actionMap;
        }

        Map<String, ResourceActions> reinforcePermissions(Map<String, ResourceActions> dstMap) {
            if (dstMap == null) {
                LOG.error((Object)("reinforcePermissions: " + this.name + ", dstMap is null"));
                return null;
            }
            for (Map.Entry<String, ResourceActions> ent : this.policyActionMap.entrySet()) {
                String locUrn = ent.getKey();
                ResourceActions locRa = ent.getValue();
                ResourceActions dstRa = dstMap.get(locUrn);
                if (dstRa == null) {
                    dstMap.put(locUrn, new ResourceActions(locRa));
                    continue;
                }
                locRa.enforceActions(dstRa);
            }
            return dstMap;
        }

        private void dumpPolicyDocs() {
            int i = 1;
            for (PolicyServerProto.IdentityPolicyInfoMsg policyDoc : this.policyList) {
                LOG.debug((Object)("dumpPolicyDocs: name: " + this.name + ", doc-" + i++ + ": " + policyDoc.toString().replaceAll("[\n]{1,}", " ")));
            }
        }

        void dumpPolicyAndMaps() {
            if (!LOG.isDebugEnabled()) {
                return;
            }
            LOG.debug((Object)("dumpPolicyAndMaps: name: " + this.name + ", num-policyDocs: " + this.policyList.size() + ", num-resources: " + this.policyActionMap.size()));
            this.dumpPolicyDocs();
            for (Map.Entry<String, ResourceActions> entry : this.policyActionMap.entrySet()) {
                String resourceUrn = entry.getKey();
                ResourceActions act = entry.getValue();
                LOG.debug((Object)("map-name:" + this.name + ", " + act.toString()));
            }
            LOG.debug((Object)"dumpPolicyAndMaps: -----");
        }
    }

    class ResourceActions {
        String urn;
        Set<String> allowedActions;
        Set<String> deniedActions;

        ResourceActions(String res) {
            this.urn = res;
            this.allowedActions = new HashSet<String>();
            this.deniedActions = new HashSet<String>();
        }

        ResourceActions(String res, Set<String> allowed, Set<String> denied) {
            this.urn = res;
            this.allowedActions = allowed;
            this.deniedActions = denied;
        }

        ResourceActions(ResourceActions other) {
            this.urn = other.urn;
            this.allowedActions = new HashSet<String>(other.allowedActions);
            this.deniedActions = new HashSet<String>(other.deniedActions);
        }

        public String toString() {
            return "resource: " + this.urn + ",\n allowedActions: " + this.allowedActions.toString() + ",\n deniedActions: " + this.deniedActions.toString();
        }

        void removeDeniedFromAllowed() {
            LOG.debug((Object)("before removeDeniedFromAllowed: " + this.toString()));
            this.allowedActions.removeAll(this.deniedActions);
            LOG.debug((Object)("after removeDeniedFromAllowed: " + this.toString()));
        }

        void enforceActions(ResourceActions other) {
            other.allowedActions.removeAll(this.deniedActions);
            other.deniedActions.removeAll(this.allowedActions);
            other.allowedActions.addAll(this.allowedActions);
            other.deniedActions.addAll(this.deniedActions);
        }
    }
}

