/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BitSetBytesHelperUtils;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.NFS4MgmtCommands;
import com.mapr.cli.VolumeCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cli.common.ShareTemplateField;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class ShareTemplateCommands
extends ListCommand
implements CLIInterface {
    private final CLICommand command;
    private NFS4MgmtCommands Nfs4Commands = null;
    private static final Logger LOG = Logger.getLogger(ShareTemplateCommands.class);
    private VolumeCommands VolCommands = null;
    public static final String SHARE_MOUNT_DIR = "/var/mapr/share/";
    public static final String CLUSTER_NAME = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
    public static final String MAPR_MANAGED_PATH_PREFIX = "/mapr/" + CLUSTER_NAME;
    private static final String DUMMY_BUT_REAL_VOLUME_NAME = "mapr.cldb.internal";
    public static final String SHARE_TEMPLATE_PARAM_NAME = "name";
    public static final String SHARE_TEMPLATE_PARAM_TYPE = "type";
    public static final String SHARE_TEMPLATE_PARAM_QUOTA = "quota";
    public static final String SHARE_TEMPLATE_PARAM_ADVISORY_QUOTA = "advisoryquota";
    public static final String SHARE_TEMPLATE_PARAM_ACCESS_TYPE = "access";
    public static final String SHARE_TEMPLATE_PARAM_SCHEDULING_POLICY = "schedule";
    public static final String SHARE_TEMPLATE_PARAM_WIRE_SECURITY_ENABLED = "wiresecurityenabled";
    public static final String SHARE_TEMPLATE_PARAM_VOLUME_ACES = "volaces";
    public static final String SHARE_TEMPLATE_PARAM_SECURITY_TYPE = "sectype";
    public static final String SHARE_TEMPLATE_PARAM_SQUASH = "squash";
    public static final String SHARE_TEMPLATE_CLIENT_SPECS = "clientspecs";
    public static final String SHARE_TEMPLATE_PARAM_PBS_SECURITY_POLICY = "securitypolicy";
    public static final String SHARE_TEMPLATE_READACE_PARAM = "readAce";
    public static final String SHARE_TEMPLATE_WRITEACE_PARAM = "writeAce";
    private static int MAX_SHARETEMPLATEFIELDINFO = 0;
    private static final int NUM_TEMPLATES_PER_RPC = 512;
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String MULTI_ARG_SEP = ",";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String[] TYPE_SET_VALUES = new String[]{"nfsv3", "nfsv4", "smb"};
    public static final Set<String> SUPPORTED_SHARE_TYPES = new HashSet<String>(Arrays.asList(TYPE_SET_VALUES));
    public static final String[] SEC_TYPE_SET_VALUES = new String[]{"sys", "krb5", "krb5i", "krb5p"};
    public static final Set<String> SUPPORTED_SEC_TYPES = new HashSet<String>(Arrays.asList(SEC_TYPE_SET_VALUES));
    public static final String[] ACCESS_TYPE_SET_VALUES = new String[]{"RW", "RO"};
    public static final Set<String> SUPPORTED_ACCESS_TYPES = new HashSet<String>(Arrays.asList(ACCESS_TYPE_SET_VALUES));
    public static final String[] SQUASH_TYPE_SET_VALUES = new String[]{"No_Root_Squash", "Root_Squash", "All_Squash"};
    public static final Set<String> SUPPORTED_SQUASH_TYPES = new HashSet<String>(Arrays.asList(SQUASH_TYPE_SET_VALUES));
    private List<CLDBProto.ShareTemplate> listedTemplates;
    public static final String shareCreateUsage = "share template create -name templateName [ -accesstype <RW|RO>]  default: RW[ -nfsip nsf server ip][ -wiresecurityenabled <true|false> ][ -secType <sys|krb5|krb5i|krb5p>], default: sys[ -squash <No_Root_Squash|Root_Squash|All_Squash>] default: Root_Squash[ -clientspecs <client1:RW:No_Root_Squash,client2:RO:Root_Squash,...> client can have these formats -> 192.168.0.10, CIDR networks (10.0.0.0/24), * (all clients)]";
    public static final String shareListUsage = "share template list [-filter <filters>][-cluster clustername]";
    public static final String shareInfoUsage = "share template info -sharename templateName";
    public static final String shareRemoveUsage = "share template remove -name templateName [-cluster clustername -force <true|false> -filter <filters> -deletes3bucket <true|false>]";
    public static final String shareModifyUsage = "share template modify -name templateName [ -accesstype <RW|RO>]  default: RW[ -nfsip nsf server ip][ -wiresecurityenabled <true|false> ][ -secType <sys|krb5|krb5i|krb5p>], default: sys[ -squash <No_Root_Squash|Root_Squash|All_Squash>] default: Root_Squash[ -clientspecs <client1:RW:No_Root_Squash,client2:RO:Root_Squash,...> client can have these formats -> 192.168.0.10, CIDR networks (10.0.0.0/24), * (all clients)]";
    public static Map<ShareTemplateField, FieldInfo> shareTemplateFieldTable;
    public static ImmutableMap.Builder<ShareTemplateField, FieldInfo> shareTemplateFieldTableBuilder;
    public static Map<String, BaseInputParameter> baseParams;
    public static final CLICommand[] shareTemplateSubCommands;
    public static final CLICommand shareTemplateCommands;

    public ShareTemplateCommands(ProcessedInput input, CLICommand command) {
        super(input, command);
        this.command = command;
        this.VolCommands = new VolumeCommands(input, command);
        this.Nfs4Commands = new NFS4MgmtCommands(input, command);
        this.listedTemplates = new ArrayList<CLDBProto.ShareTemplate>();
    }

    void init() {
        shareTemplateFieldTable = shareTemplateFieldTableBuilder.build();
    }

    private int getStartParamValue() throws CLIProcessingException {
        return this.isParamPresent(START_PARAM_NAME) ? this.getParamIntValue(START_PARAM_NAME, 0) : 0;
    }

    private int getLimitParamValue() throws CLIProcessingException {
        return this.isParamPresent(LIMIT_PARAM_NAME) ? this.getParamIntValue(LIMIT_PARAM_NAME, 0) : Integer.MAX_VALUE;
    }

    private String getOutputParamValue() throws CLIProcessingException {
        return this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
    }

    private String getColumnsParamValue() throws CLIProcessingException {
        return this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
    }

    private String getTemplateNameParam() throws CLIProcessingException {
        return this.isParamPresent(SHARE_TEMPLATE_PARAM_NAME) ? this.getParamTextValue(SHARE_TEMPLATE_PARAM_NAME, 0) : null;
    }

    private String getTemplateClientSpecsParam() throws CLIProcessingException {
        return this.isParamPresent(SHARE_TEMPLATE_CLIENT_SPECS) ? this.getParamTextValue(SHARE_TEMPLATE_CLIENT_SPECS, 0) : null;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.init();
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
            try {
                return this.createTemplate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("modify")) {
            try {
                return this.modifyTemplate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("info")) {
            try {
                return this.infoTemplate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
            try {
                return this.shareRemove();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
            try {
                CommandOutput output = new CommandOutput();
                CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
                output.setOutput(out);
                if (!super.validateInput()) {
                    return output;
                }
                this.list(out);
                return output;
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return this.output;
    }

    public BitSet getColumns() throws CLIProcessingException {
        BitSet columns = new BitSet();
        columns.set(0, MAX_SHARETEMPLATEFIELDINFO + 1);
        String columnsString = this.getColumnsParamValue();
        if (columnsString != null && !columnsString.equals("all")) {
            columns = FilterUtil.getColumns(shareTemplateFieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    @Override
    public MessageLite sendRequest(MessageLite req) throws CLIProcessingException {
        byte[] data;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareTemplateListProc.getNumber(), req, CLDBProto.ShareTemplateListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareTemplateListProc.getNumber(), req, CLDBProto.ShareTemplateListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (data != null) {
            return this.getShareTemplateListResponse(data);
        }
        LOG.error((Object)"RPC Request to list volumes failed. No data returned");
        return null;
    }

    private CLDBProto.ShareTemplateListResponse getShareTemplateListResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.ShareTemplateListResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into ShareTemplateListResponse proto object.", (Throwable)ipbe);
        }
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.ShareTemplateListRequest.Builder newReqBuilder = null;
        if (prevReq != null) {
            newReqBuilder = ((CLDBProto.ShareTemplateListRequest)prevReq).toBuilder();
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.ShareTemplateListResponse)prevResp).getTemplatesCount();
            int origStart = this.getStartParamValue();
            int origLimit = this.getLimitParamValue();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 512));
        } else {
            newReqBuilder = this.getShareTemplateListRequestBuilder();
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        boolean ans = this.hasMore(this.getStartParamValue(), this.getLimitParamValue(), ((CLDBProto.ShareTemplateListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.ShareTemplateListResponse)prevResp).getTemplatesCount());
        LOG.debug((Object)("--Anand: hasMore: super.hasMore() bypassed. super.hasMore: " + ans + ", getStartParamValue:" + this.getStartParamValue() + ", getLimitParamValue:" + this.getLimitParamValue() + ", Limiter.start:" + ((CLDBProto.ShareTemplateListRequest)prevReq).getLimiter().getStart() + ", ItemsReceived:" + ((CLDBProto.ShareTemplateListResponse)prevResp).getTemplatesCount()));
        return false;
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.ShareTemplateListResponse resp = (CLDBProto.ShareTemplateListResponse)response;
        boolean terse = this.getOutputParamValue().equals("terse");
        BitSet columns = this.getColumns();
        for (CLDBProto.ShareTemplate template : resp.getTemplatesList()) {
            CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatShareTemplate(template, terse, columns);
            out.addNode(outputNode);
        }
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        }
        this.listedTemplates.addAll(resp.getTemplatesList());
    }

    private CLDBProto.ShareTemplateListRequest.Builder getShareTemplateListRequestBuilder() throws CLIProcessingException {
        List<CLIProto.Filter> filters = this.getFilters(shareTemplateFieldTable, FILTER_PARAM_NAME);
        BitSet columns = this.getColumns();
        ByteString bString = ByteString.copyFrom((byte[])BitSetBytesHelperUtils.toByteArray((BitSet)columns));
        long columnsOld = BitSetBytesHelperUtils.convert((BitSet)columns);
        CLDBProto.ShareTemplateListRequest.Builder req = CLDBProto.ShareTemplateListRequest.newBuilder();
        CLIProto.Limiter limiter = this.getNextLimiter(this.getStartParamValue(), 0, this.getStartParamValue(), this.getLimitParamValue(), 512);
        return req.setCreds(this.getUserCredentials()).addAllFilter(filters).setColumns(columnsOld).setColumnsAdd(bString).setLimiter(limiter);
    }

    CommandOutput shareRemove() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String templateName = this.getTemplateNameParam();
        LOG.debug((Object)("Removing template " + templateName));
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        LOG.debug((Object)("Trying to remove volume " + templateName));
        CLDBProto.ShareTemplateRemoveRequest shareRemove = CLDBProto.ShareTemplateRemoveRequest.newBuilder().setName(templateName).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareTemplateRemoveProc.getNumber(), (MessageLite)shareRemove, CLDBProto.ShareTemplateRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareTemplateRemoveProc.getNumber(), (MessageLite)shareRemove, CLDBProto.ShareTemplateRemoveResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ShareTemplateRemoveResponse resp = CLDBProto.ShareTemplateRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                LOG.info((Object)("Removed template " + templateName));
            } else {
                String msg = "Template remove failed. status: " + resp.getStatus() + ", " + resp.getErrMsg();
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
                LOG.error((Object)msg);
            }
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)("MaprSecurityException " + e));
            throw new CLIProcessingException("MaprSecurityException ", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception " + e));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Template Remove failed"));
        }
        output.setOutput(out);
        return output;
    }

    CommandOutput createTemplate() throws CLIProcessingException, IOException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String templateName = this.getTemplateNameParam();
        CLDBProto.ShareTemplate template = this.buildShareTemplateForCreate(out);
        if (template == null) {
            LOG.error((Object)"Create template failed:");
            return output;
        }
        CLDBProto.ShareTemplateCreateRequest req = CLDBProto.ShareTemplateCreateRequest.newBuilder().setTemplate(template).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareTemplateCreateProc.getNumber(), (MessageLite)req, CLDBProto.ShareTemplateCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareTemplateCreateProc.getNumber(), (MessageLite)req, CLDBProto.ShareTemplateCreateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ShareTemplateCreateResponse resp = CLDBProto.ShareTemplateCreateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                String opParam = this.getOutputParamValue();
                boolean terse = opParam.equals("terse");
                BitSet columns = this.getColumns();
                CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatShareTemplate(resp.getTemplate(), terse, columns);
                out.addNode(outputNode);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException: ", (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Request for share create failed: " + e.getMessage();
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
        }
        return output;
    }

    private CommandOutput infoTemplate() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String templateName = this.getTemplateNameParam();
        if (templateName == null) {
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Share info arguments missing. Pass  sharename"));
            return output;
        }
        CLDBProto.ShareTemplateInfoRequest req = CLDBProto.ShareTemplateInfoRequest.newBuilder().setName(templateName).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareTemplateInfoProc.getNumber(), (MessageLite)req, CLDBProto.ShareTemplateInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareTemplateInfoProc.getNumber(), (MessageLite)req, CLDBProto.ShareTemplateInfoResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            CLDBProto.ShareTemplateInfoResponse resp = CLDBProto.ShareTemplateInfoResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
                return output;
            }
            String opParam = this.getOutputParamValue();
            boolean terse = opParam.equals("terse");
            BitSet columns = this.getColumns();
            CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatShareTemplate(resp.getTemplate(), terse, columns);
            out.addNode(outputNode);
            return output;
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)"MaprSecurityException: ", (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException...", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception: ", (Throwable)e);
            throw new CLIProcessingException("Exception communicating to CLDB, " + e.getLocalizedMessage());
        }
    }

    CommandOutput modifyTemplate() throws CLIProcessingException, IOException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String templateName = this.getTemplateNameParam();
        String rwShareMountDir = MAPR_MANAGED_PATH_PREFIX + SHARE_MOUNT_DIR;
        CLDBProto.ShareTemplate template = this.buildShareTemplate(out);
        if (template == null) {
            LOG.error((Object)"modify template failed: ");
            return output;
        }
        CLDBProto.ShareTemplateUpdateRequest.Builder shareUpdate = CLDBProto.ShareTemplateUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setTemplate(template).setShareMountDir(rwShareMountDir);
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareTemplateUpdateProc.getNumber(), (MessageLite)shareUpdate.build(), CLDBProto.ShareTemplateUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareTemplateUpdateProc.getNumber(), (MessageLite)shareUpdate.build(), CLDBProto.ShareTemplateUpdateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ShareTemplateUpdateResponse resp = CLDBProto.ShareTemplateUpdateResponse.parseFrom((byte[])data);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)resp.getErrMsg());
            }
            if (resp.getStatus() == 0) {
                String opParam = this.getOutputParamValue();
                boolean terse = opParam.equals("terse");
                BitSet columns = this.getColumns();
                List exportConfigs = resp.getExportConfigsList();
                CommandOutput.OutputHierarchy.OutputNode outputNode = this.formatShareTemplate(resp.getTemplate(), terse, columns);
                out.addNode(outputNode);
                boolean areAllExportsUpdated = NFS4MgmtCommands.updateAllExportsForShare(exportConfigs, out);
                if (!areAllExportsUpdated) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "One or more share exports could not get updated for template: " + templateName));
                }
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)"MaprSecurityException: ", (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Template Modify failed: " + Errno.toString((int)10003)));
            LOG.error((Object)"Exception during Share modify ", (Throwable)e);
        }
        return output;
    }

    public CommandOutput.OutputHierarchy.OutputNode formatShareTemplate(CLDBProto.ShareTemplate template, boolean terse, BitSet columns) {
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        if (columns.get(CLDBProto.ShareTemplateInfoFields.templateId.getNumber()) && template.hasId()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareTemplateFieldTable.get(new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateId)).getName(terse), template.getId()));
        }
        if (columns.get(CLDBProto.ShareTemplateInfoFields.templateName.getNumber()) && template.hasName()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareTemplateFieldTable.get(new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateName)).getName(terse), (Object)template.getName()));
        }
        if (columns.get(CLDBProto.ShareTemplateInfoFields.templateAccessType.getNumber()) && template.hasAccessType()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareTemplateFieldTable.get(new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateAccessType)).getName(terse), (Object)template.getAccessType()));
        }
        if (columns.get(CLDBProto.ShareTemplateInfoFields.templateWireSecurityEnabled.getNumber()) && template.hasWireSecurityEnabled()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareTemplateFieldTable.get(new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateWireSecurityEnabled)).getName(terse), (Object)template.getWireSecurityEnabled()));
        }
        if (columns.get(CLDBProto.ShareTemplateInfoFields.templateSecurityType.getNumber()) && template.hasSecType()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareTemplateFieldTable.get(new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateSecurityType)).getName(terse), (Object)template.getSecType()));
        }
        if (columns.get(CLDBProto.ShareTemplateInfoFields.templateSquash.getNumber()) && template.hasSquash()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareTemplateFieldTable.get(new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateSquash)).getName(terse), (Object)template.getSquash()));
        }
        if (columns.get(CLDBProto.ShareTemplateInfoFields.templateLinkedShares.getNumber())) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareTemplateFieldTable.get(new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateLinkedShares)).getName(terse), template.getLinkedSharesCount()));
        }
        if (columns.get(CLDBProto.ShareTemplateInfoFields.templateCreateTime.getNumber()) && template.hasCreateTime()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareTemplateFieldTable.get(new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateCreateTime)).getName(terse), template.getCreateTime()));
        }
        if (columns.get(CLDBProto.ShareTemplateInfoFields.templateUpdateTime.getNumber()) && template.hasUpdateTime()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareTemplateFieldTable.get(new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateUpdateTime)).getName(terse), template.getUpdateTime()));
        }
        if (columns.get(CLDBProto.ShareTemplateInfoFields.templateClientSpecs.getNumber()) && template.getClientSpecsCount() > 0) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareTemplateFieldTable.get(new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateClientSpecs)).getName(terse), (Object)this.formatShareTemplateClients(template)));
        }
        return outputNode;
    }

    public CommandOutput.OutputHierarchy.OutputNode formatShareTemplateClients(CLDBProto.ShareTemplate template) {
        CommandOutput.OutputHierarchy.OutputNode clientSpecsNode = new CommandOutput.OutputHierarchy.OutputNode(SHARE_TEMPLATE_CLIENT_SPECS);
        for (CLDBProto.ClientSpec clientSpec : template.getClientSpecsList()) {
            CommandOutput.OutputHierarchy.OutputNode clientNode = new CommandOutput.OutputHierarchy.OutputNode("client");
            clientNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("clients", (Object)clientSpec.getClients()));
            clientNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("accesstype", (Object)clientSpec.getAccessType()));
            clientNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SHARE_TEMPLATE_PARAM_SQUASH, (Object)clientSpec.getSquash()));
            clientSpecsNode.addChild(clientNode);
        }
        return clientSpecsNode;
    }

    private static String convertMillisToDate(long millis) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(new Date(millis));
    }

    private CLDBProto.ShareTemplate buildShareTemplateForCreate(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.ShareTemplate.Builder template = CLDBProto.ShareTemplate.newBuilder();
        String templateName = this.getTemplateNameParam();
        template.setName(templateName);
        String accessType = this.getParamTextValue(SHARE_TEMPLATE_PARAM_ACCESS_TYPE, 0);
        if (!SUPPORTED_ACCESS_TYPES.contains(accessType)) {
            String msg = accessType + " is not valid accessType";
            LOG.error((Object)("buildShareTemplateForCreate: " + msg));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
            return null;
        }
        template.setAccessType(accessType);
        boolean wireSecurityEnabled = this.getParamBooleanValue(SHARE_TEMPLATE_PARAM_WIRE_SECURITY_ENABLED, 0);
        template.setWireSecurityEnabled(wireSecurityEnabled);
        String sectype = this.getParamTextValue(SHARE_TEMPLATE_PARAM_SECURITY_TYPE, 0);
        if (!SUPPORTED_SEC_TYPES.contains(sectype)) {
            String msg = sectype + " is not valid securityType";
            LOG.error((Object)("buildShareTemplateForCreate: " + msg));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
            return null;
        }
        template.setSecType(sectype);
        String squash = this.getParamTextValue(SHARE_TEMPLATE_PARAM_SQUASH, 0);
        if (!SUPPORTED_SQUASH_TYPES.contains(squash)) {
            String msg = squash + " is not valid squash";
            LOG.error((Object)("buildShareTemplateForCreate: " + msg));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
            return null;
        }
        template.setSquash(squash);
        CLDBProto.VolumeUpdateRequest.Builder volUpdate = this.getDummyVolumeUpdateRequest(out);
        if (volUpdate == null) {
            String msg = "failed to build volume update request.";
            LOG.error((Object)("buildShareTemplateForCreate: " + msg));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
            return null;
        }
        LOG.error((Object)("buildShareTemplateForCreate: VolumeUpdateRequest: " + volUpdate.toString().replaceAll("[\n]{1,}", " ")));
        template.setVolUpdateReq(volUpdate.build());
        String clientSpecsStr = this.getTemplateClientSpecsParam();
        if (clientSpecsStr != null) {
            String[] clientEntries;
            this.getParamTextValue(SHARE_TEMPLATE_CLIENT_SPECS, 0);
            if (clientSpecsStr == "" || clientSpecsStr.trim().isEmpty()) {
                String msg = "Client specs are empty.";
                LOG.error((Object)("buildShareTemplateForCreate: " + msg));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                return null;
            }
            for (String entry : clientEntries = clientSpecsStr.split(MULTI_ARG_SEP)) {
                CLDBProto.ClientSpec spec = this.parseClientSpec(entry, out);
                if (spec == null) {
                    String msg = "Invalid client spec entry: " + entry;
                    LOG.error((Object)("buildShareTemplateForCreate: " + msg));
                    return null;
                }
                template.addClientSpecs(spec);
            }
        }
        return template.build();
    }

    private CLDBProto.VolumeUpdateRequest.Builder getDummyVolumeUpdateRequest(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.VolumeUpdateRequest.Builder volUpdate = this.VolCommands.buildVolumeUpdateRequest(DUMMY_BUT_REAL_VOLUME_NAME, out);
        if (volUpdate == null) {
            return null;
        }
        CLDBProto.VolumeProperties volProps = volUpdate.getVolProperties().toBuilder().clearVolumeName().build();
        volUpdate.setVolProperties(volProps);
        return volUpdate;
    }

    public CLDBProto.ClientSpec parseClientSpec(String entry, CommandOutput.OutputHierarchy out) {
        if (entry == null || entry.trim().isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Empty client entry"));
            return null;
        }
        String[] parts = entry.split(":");
        if (parts.length != 3) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Client entry must be in format host:access:squash -> " + entry));
            return null;
        }
        String clients = parts[0].trim();
        String access = parts[1].trim();
        String squash = parts[2].trim();
        if (clients.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Host is empty in client entry: " + entry));
            return null;
        }
        if (!SUPPORTED_ACCESS_TYPES.contains(access)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unsupported access type: " + access + " in entry: " + entry));
            return null;
        }
        if (!SUPPORTED_SQUASH_TYPES.contains(squash)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unsupported squash type: " + squash + " in entry: " + entry));
            return null;
        }
        return CLDBProto.ClientSpec.newBuilder().setClients(clients).setAccessType(access).setSquash(squash).build();
    }

    private CLDBProto.ShareTemplate buildShareTemplate(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.VolumeUpdateRequest.Builder volUpdate;
        CLDBProto.ShareTemplate.Builder template = CLDBProto.ShareTemplate.newBuilder();
        String templateName = this.getTemplateNameParam();
        template.setName(templateName);
        if (this.isParamPresent(SHARE_TEMPLATE_PARAM_ACCESS_TYPE)) {
            String accessType = this.getParamTextValue(SHARE_TEMPLATE_PARAM_ACCESS_TYPE, 0);
            if (!SUPPORTED_ACCESS_TYPES.contains(accessType)) {
                String msg = accessType + " is not valid accessType";
                LOG.error((Object)("buildShareTemplate: " + msg));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                return null;
            }
            template.setAccessType(accessType);
        }
        if (this.isParamPresent(SHARE_TEMPLATE_PARAM_WIRE_SECURITY_ENABLED)) {
            boolean wireSecurityEnabled = this.getParamBooleanValue(SHARE_TEMPLATE_PARAM_WIRE_SECURITY_ENABLED, 0);
            template.setWireSecurityEnabled(wireSecurityEnabled);
        }
        if (this.isParamPresent(SHARE_TEMPLATE_PARAM_SECURITY_TYPE)) {
            String sectype = this.getParamTextValue(SHARE_TEMPLATE_PARAM_SECURITY_TYPE, 0);
            if (!SUPPORTED_SEC_TYPES.contains(sectype)) {
                String msg = sectype + " is not valid securityType";
                LOG.error((Object)("buildShareTemplate: " + msg));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                return null;
            }
            template.setSecType(sectype);
        }
        if (this.isParamPresent(SHARE_TEMPLATE_PARAM_SQUASH)) {
            String squash = this.getParamTextValue(SHARE_TEMPLATE_PARAM_SQUASH, 0);
            if (!SUPPORTED_SQUASH_TYPES.contains(squash)) {
                String msg = squash + " is not valid squash";
                LOG.error((Object)("buildShareTemplate: " + msg));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                return null;
            }
            template.setSquash(squash);
        }
        if (this.isParamPresent(SHARE_TEMPLATE_CLIENT_SPECS)) {
            String[] clientEntries;
            String clientSpecsStr = this.getTemplateClientSpecsParam();
            for (String entry : clientEntries = clientSpecsStr.split(MULTI_ARG_SEP)) {
                CLDBProto.ClientSpec spec = this.parseClientSpec(entry, out);
                if (spec == null) {
                    String msg = "Invalid client spec entry: " + entry;
                    LOG.error((Object)("buildShareTemplate: " + msg));
                    return null;
                }
                template.addClientSpecs(spec);
            }
        }
        if ((volUpdate = this.getDummyVolumeUpdateRequest(out)) == null) {
            String msg = "failed to build volume update request.";
            LOG.error((Object)("buildShareTemplate: " + msg));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
            return null;
        }
        LOG.error((Object)("buildShareTemplate: VolumeUpdateRequest: " + volUpdate.toString().replaceAll("[\n]{1,}", " ")));
        template.setVolUpdateReq(volUpdate.build());
        return template.build();
    }

    private void formatVolumeAce(Common.VolumeAces volAces, CommandOutput.OutputHierarchy.OutputNode outputNode) {
        CommandOutput.OutputHierarchy.OutputNode volumeAcesNode = new CommandOutput.OutputHierarchy.OutputNode("volumeAces");
        try {
            Common.VolumeAces volAce = this.VolCommands.getFilledVolAce(volAces);
            for (Object aceEntry : volAce.getAcesList()) {
                if (aceEntry.getAccessType() == Common.VolumeActions.VOLUME_READ) {
                    volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(SHARE_TEMPLATE_READACE_PARAM, (Object)AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8())));
                } else if (aceEntry.getAccessType() == Common.VolumeActions.VOLUME_WRITE) {
                    volumeAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(SHARE_TEMPLATE_WRITEACE_PARAM, (Object)AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8())));
                } else {
                    Assert.assertNotNull(null);
                }
                LOG.debug((Object)(this.VolCommands.getVolActions((Common.VolumeAceEntry)aceEntry) + ": " + AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8())));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to parse volume aces");
        }
        outputNode.addChild(volumeAcesNode);
        if (volAces.getPolicyNamesCount() > 0) {
            Object policiesInCSF = "";
            int i = 0;
            for (String policyName : volAces.getPolicyNamesList()) {
                policiesInCSF = i != 0 ? (String)policiesInCSF + MULTI_ARG_SEP + policyName : policyName;
                ++i;
            }
            CommandOutput.OutputHierarchy.OutputNode securityPolicyNode = new CommandOutput.OutputHierarchy.OutputNode(SHARE_TEMPLATE_PARAM_PBS_SECURITY_POLICY, policiesInCSF);
            outputNode.addChild(securityPolicyNode);
        }
        String enforcementMode = Util.getVolumeEnforcementModeName((boolean)volAces.getEnforcePolicies(), (boolean)volAces.getEnforceAces(), (boolean)volAces.getEnableAuditOnlyPolicyCheck());
        CommandOutput.OutputHierarchy.OutputNode enforcementModeNode = new CommandOutput.OutputHierarchy.OutputNode("enforcementmode", (Object)enforcementMode);
        outputNode.addChild(enforcementModeNode);
    }

    static {
        shareTemplateFieldTableBuilder = new ImmutableMap.Builder().put((Object)new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateId), (Object)new FieldInfo(CLDBProto.ShareTemplateInfoFields.templateId.getNumber(), "tid", "templateid", Integer.class, CLDBProto.ListSortKey.TemplateId)).put((Object)new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateName), (Object)new FieldInfo(CLDBProto.ShareTemplateInfoFields.templateName.getNumber(), "tn", "templatename", String.class, CLDBProto.ListSortKey.TemplateName)).put((Object)new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateAccessType), (Object)new FieldInfo(CLDBProto.ShareTemplateInfoFields.templateAccessType.getNumber(), "at", "accesstype", String.class, CLDBProto.ListSortKey.TemplateAccessType)).put((Object)new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateWireSecurityEnabled), (Object)new FieldInfo(CLDBProto.ShareTemplateInfoFields.templateWireSecurityEnabled.getNumber(), "tws", "sharetemplatewireSecurity", String.class, CLDBProto.ListSortKey.TemplateWireSecurityEnabled)).put((Object)new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateSecurityType), (Object)new FieldInfo(CLDBProto.ShareTemplateInfoFields.templateSecurityType.getNumber(), "st", "securitytype", String.class, CLDBProto.ListSortKey.TemplateSecurityType)).put((Object)new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateSquash), (Object)new FieldInfo(CLDBProto.ShareTemplateInfoFields.templateSquash.getNumber(), "sq", SHARE_TEMPLATE_PARAM_SQUASH, String.class, CLDBProto.ListSortKey.TemplateSquash)).put((Object)new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateLinkedShares), (Object)new FieldInfo(CLDBProto.ShareTemplateInfoFields.templateLinkedShares.getNumber(), "ls", "linkedshares", Integer.class, CLDBProto.ListSortKey.TemplateLinkedShares)).put((Object)new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateCreateTime), (Object)new FieldInfo(CLDBProto.ShareTemplateInfoFields.templateCreateTime.getNumber(), "tct", "templatecreatetime", Long.class, CLDBProto.ListSortKey.TemplateCreateTime)).put((Object)new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateUpdateTime), (Object)new FieldInfo(CLDBProto.ShareTemplateInfoFields.templateUpdateTime.getNumber(), "tut", "templateupdatetime", Long.class, CLDBProto.ListSortKey.TemplateUpdateTime)).put((Object)new ShareTemplateField(CLDBProto.ShareTemplateInfoFields.templateClientSpecs), (Object)new FieldInfo(CLDBProto.ShareTemplateInfoFields.templateClientSpecs.getNumber(), "cs", SHARE_TEMPLATE_CLIENT_SPECS, String.class, CLDBProto.ListSortKey.TemplateClientSpecs));
        CLDBProto.ShareTemplateInfoFields[] values = CLDBProto.ShareTemplateInfoFields.values();
        int max = 0;
        for (CLDBProto.ShareTemplateInfoFields value : values) {
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_SHARETEMPLATEFIELDINFO = max;
        baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
        shareTemplateSubCommands = new CLICommand[]{new CLICommand("create", "", ShareTemplateCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(VolumeCommands.baseParams).put((Object)SHARE_TEMPLATE_PARAM_NAME, (Object)new TextInputParameter(SHARE_TEMPLATE_PARAM_NAME, "share template name", true, null)).put((Object)SHARE_TEMPLATE_PARAM_ACCESS_TYPE, (Object)new TextInputParameter(SHARE_TEMPLATE_PARAM_ACCESS_TYPE, "<RO|RW>", false, "RW")).put((Object)SHARE_TEMPLATE_PARAM_WIRE_SECURITY_ENABLED, (Object)new BooleanInputParameter(SHARE_TEMPLATE_PARAM_WIRE_SECURITY_ENABLED, "<true|false>?", false, Boolean.valueOf(true))).put((Object)SHARE_TEMPLATE_PARAM_SECURITY_TYPE, (Object)new TextInputParameter(SHARE_TEMPLATE_PARAM_SECURITY_TYPE, "<sys|krb5|krb5i|krb5p> security type not allowed if type is nfsv3", false, "sys")).put((Object)SHARE_TEMPLATE_PARAM_SQUASH, (Object)new TextInputParameter(SHARE_TEMPLATE_PARAM_SQUASH, "<No_Root_Squash|Root_Squash|All_Squash>", false, "Root_Squash")).put((Object)SHARE_TEMPLATE_CLIENT_SPECS, (Object)new TextInputParameter(SHARE_TEMPLATE_CLIENT_SPECS, "comma separated client specs -eg: '192.168.1.10:RW:No_Root_Squash,192.168.1.0/24:RO:Root_Squash,10.0.0.5:RO:Root_Squash'", false, null)).build(), null).setUsageInVisible(true).setShortUsage(shareCreateUsage), new CLICommand("remove", "", ShareTemplateCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SHARE_TEMPLATE_PARAM_NAME, (Object)new TextInputParameter(SHARE_TEMPLATE_PARAM_NAME, "share template name", true, null)).build(), null).setUsageInVisible(true).setShortUsage(shareRemoveUsage), new CLICommand("modify", "", ShareTemplateCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SHARE_TEMPLATE_PARAM_NAME, (Object)new TextInputParameter(SHARE_TEMPLATE_PARAM_NAME, "share template name", true, null)).put((Object)SHARE_TEMPLATE_PARAM_ACCESS_TYPE, (Object)new TextInputParameter(SHARE_TEMPLATE_PARAM_ACCESS_TYPE, "<RO|RW>", false, null)).put((Object)SHARE_TEMPLATE_PARAM_WIRE_SECURITY_ENABLED, (Object)new BooleanInputParameter(SHARE_TEMPLATE_PARAM_WIRE_SECURITY_ENABLED, "<true|false>", false, null)).put((Object)SHARE_TEMPLATE_PARAM_SECURITY_TYPE, (Object)new TextInputParameter(SHARE_TEMPLATE_PARAM_SECURITY_TYPE, "<sys|krb5|krb5i|krb5p> security type not allowed if type is nfsv3", false, null)).put((Object)SHARE_TEMPLATE_PARAM_SQUASH, (Object)new TextInputParameter(SHARE_TEMPLATE_PARAM_SQUASH, "<No_Root_Squash|Root_Squash|All_Squash>", false, null)).put((Object)SHARE_TEMPLATE_CLIENT_SPECS, (Object)new TextInputParameter(SHARE_TEMPLATE_CLIENT_SPECS, "comma separated client specs -eg: '192.168.1.10:RW:No_Root_Squash,192.168.1.0/24:RO:Root_Squash,10.0.0.5:RO:Root_Squash'", false, null)).build(), null).setUsageInVisible(true).setShortUsage(shareModifyUsage), new CLICommand("list", "", ShareTemplateCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)FILTER_PARAM_NAME, (Object)new FilterInputParameter(FILTER_PARAM_NAME, "none", false, "none")).put((Object)COLUMNS_PARAM_NAME, (Object)new TextInputParameter(COLUMNS_PARAM_NAME, "comma separated column names", false, "all")).build(), null).setUsageInVisible(true).setShortUsage(shareListUsage), new CLICommand("info", "", ShareTemplateCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SHARE_TEMPLATE_PARAM_NAME, (Object)new TextInputParameter(SHARE_TEMPLATE_PARAM_NAME, "share template name", true, null)).build(), null).setUsageInVisible(true).setShortUsage(shareInfoUsage)};
        shareTemplateCommands = new CLICommand("template", "template [create|modify|remove|list|info]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, shareTemplateSubCommands).setShortUsage("template [create|modify|remove|list|info]");
    }
}

