/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BitSetBytesHelperUtils;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.NFS4MgmtCommands;
import com.mapr.cli.ShareTemplateCommands;
import com.mapr.cli.VolumeCommands;
import com.mapr.cli.common.ListCommand;
import com.mapr.cli.common.ShareField;
import com.mapr.cli.common.VolumeField;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mapr.fs.Nfsmon;
import org.apache.log4j.Logger;

public class NfsShareCommands
extends ListCommand
implements CLIInterface {
    private final CLICommand command;
    private VolumeCommands VolCommands = null;
    private NFS4MgmtCommands Nfs4Commands = null;
    private ShareTemplateCommands TemplateCommands = null;
    private static final Logger LOG = Logger.getLogger(NfsShareCommands.class);
    public static final String SHARE_MOUNT_DIR = Common.MapRShareDefaults.getDefaultInstance().getShareMountDir();
    public static final String CLUSTER_NAME = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
    public static final String MAPR_MANAGED_PATH_PREFIX = "/mapr/" + CLUSTER_NAME;
    public static final String SHARE_PARAM_NAME = "name";
    public static final String SHARE_PARAM_TEMPLATE_NAME = "template";
    public static final String SHARE_PARAM_NFS_SERVER_IP = "nfsip";
    public static final String SHARE_PARAM_NFS_SERVER_PORT = "nfsport";
    public static final String SHARE_PARAM_TYPE = "sharetype";
    public static final String SHARE_PARAM_TYPE_DEFAULT = "nfsv4";
    public static final String SHARE_PARAM_EXPORT_PATH = "exportpath";
    public static final String SHARE_PARAM_FORCE = "force";
    public static final String SHARE_PARAM_OP_NODELAY = "nodelay";
    public static final String SHARE_PARAM_SCHEDULE = "schedulename";
    public static final String SHARE_PARAM_SCHEDULEID = "scheduleid";
    public static final String ASSIGNED_TO_VIP = "assignedtovip";
    public static final String SOURCE_NFS_IP_ADDR = "sourcenfsip";
    public static final String DESTINATION_NFS_IP_ADDR = "destnfsip";
    public static final String SOURCE_NFS_PORT = "sourcenfsport";
    public static final String DESTINATION_NFS_PORT = "destnfsport";
    private static final int SHARE_PARAM_NFS_SERVER_PORT_DEFAULT = 9995;
    private static int MAX_VOLUMEFIELDINFO = 0;
    private static final int SHARE_TEMPLATE_PARAM_NFS_SERVER_PORT_DEFAULT = 9995;
    private static int MAX_SHAREFIELDINFO = 0;
    private static final int NUM_SHARES_PER_RPC = 512;
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String MULTI_ARG_SEP = ",";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String[] TYPE_SET_VALUES = new String[]{"nfsv3", "nfsv4", "smb"};
    public static final Set<String> SUPPORTED_SHARE_TYPES = new HashSet<String>(Arrays.asList(TYPE_SET_VALUES));
    private List<CLDBProto.ShareInfo> listedShares = Lists.newArrayList();
    public static final String shareCreateUsage = "share create -name shareName [-sharetype <nfsv3|nfsv4|smb>]  default: nfsv4 [-quota <quota in MB> [-advisoryquota <quota in MB>] [-schedulename <schedule Name>][-label<storage class on which the volume data should reside>][-nslabel<storage class on which the volume name container should reside>][-exportpath <exportpath>] ";
    public static final String shareListUsage = "share list [-filter <filters>][-cluster clustername]";
    public static final String shareInfoUsage = "share info -sharename shareName";
    public static final String shareRemoveUsage = "share remove -name shareName [-cluster clustername -force <true|false> -filter <filters> -deletes3bucket <true|false>]";
    public static final String shareModifyUsage = "volume modify -name volumeName [-sharetype <nfsv3|nfsv4|smb>]  default: nfsv4 [-quota <quota in MB> [-advisoryquota <quota in MB>] [-schedulename <schedule Name>][-label<storage class on which the volume data should reside>][-nslabel<storage class on which the volume name container should reside>][-exportPath <mountDir>] ";
    public static final String shareFailoverUsage = "share failover -sourcenfsip <source-nfs-ip> -assignedtovip <vip> [-sourcenfsip <source-nfs-ip>] [-sourcenfsport <source-nfs-port>] -destnfsip <destination-nfs-ip> [-destnfsport <destination-nfs-port>] ";
    public static Map<ShareField, FieldInfo> shareFieldTable;
    public static ImmutableMap.Builder<ShareField, FieldInfo> shareFieldTableBuilder;
    public static Map<String, BaseInputParameter> baseParams;
    public static final CLICommand shareCreateCommand;
    public static final CLICommand[] nfsShareCommands;

    public NfsShareCommands(ProcessedInput input, CLICommand command) {
        super(input, command);
        this.command = command;
        this.VolCommands = new VolumeCommands(input, command);
        this.Nfs4Commands = new NFS4MgmtCommands(input, command);
        this.TemplateCommands = new ShareTemplateCommands(input, command);
    }

    void init() {
        shareFieldTable = shareFieldTableBuilder.build();
    }

    private int getStartParamValue() throws CLIProcessingException {
        return this.isParamPresent(START_PARAM_NAME) ? this.getParamIntValue(START_PARAM_NAME, 0) : 0;
    }

    private int getLimitParamValue() throws CLIProcessingException {
        return this.isParamPresent(LIMIT_PARAM_NAME) ? this.getParamIntValue(LIMIT_PARAM_NAME, 0) : Integer.MAX_VALUE;
    }

    private String getOutputParamValue() throws CLIProcessingException {
        return this.isParamPresent(OUTPUT_PARAM_NAME) ? this.getParamTextValue(OUTPUT_PARAM_NAME, 0) : "";
    }

    private String getColumnsParamValue() throws CLIProcessingException {
        return this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.init();
        if (this.cliCommand.getCommandName().equalsIgnoreCase("create")) {
            try {
                return this.shareCreate();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("modify")) {
            try {
                return this.shareModify();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("info")) {
            try {
                return this.shareInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("remove")) {
            try {
                return this.shareRemove();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
            try {
                CommandOutput output = new CommandOutput();
                CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
                output.setOutput(out);
                if (!super.validateInput()) {
                    return output;
                }
                this.list(out);
                return output;
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("failover")) {
            try {
                return this.shareFailover();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Send request Exception", (Throwable)e);
            }
        }
        return this.output;
    }

    @Override
    public MessageLite buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.ShareListRequest.Builder newReqBuilder = null;
        if (prevReq != null) {
            newReqBuilder = CLDBProto.ShareListRequest.newBuilder((CLDBProto.ShareListRequest)((CLDBProto.ShareListRequest)prevReq));
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.ShareListResponse)prevResp).getShareInfosCount();
            int origStart = this.getStartParamValue();
            int origLimit = this.getLimitParamValue();
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 512));
        } else {
            newReqBuilder = this.getShareListRequestBuilder();
        }
        return newReqBuilder.build();
    }

    CommandOutput shareFailover() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String vip = this.getParamTextValue(ASSIGNED_TO_VIP, 0);
        String sourceNfsIp = null;
        if (this.isParamPresent(SOURCE_NFS_IP_ADDR)) {
            sourceNfsIp = this.getParamTextValue(SOURCE_NFS_IP_ADDR, 0);
        }
        if (sourceNfsIp == null && this.isParamPresent(SOURCE_NFS_PORT)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "source Nfs Ip must be there with source nfs port"));
            return output;
        }
        int sourceNfsPort = this.getParamIntValue(SOURCE_NFS_PORT, 0);
        String destinationNfsIp = this.getParamTextValue(DESTINATION_NFS_IP_ADDR, 0);
        int destinationNfsPort = this.getParamIntValue(DESTINATION_NFS_PORT, 0);
        String shareMountDir = MAPR_MANAGED_PATH_PREFIX + SHARE_MOUNT_DIR;
        LOG.info((Object)("shareFailover:  trying to failover shares of vip:" + vip + " to " + destinationNfsIp));
        CLDBProto.GetShareExportsOfVipRequest getExportsReq = CLDBProto.GetShareExportsOfVipRequest.newBuilder().setVip(vip).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetShareExportsOfVipProc.getNumber(), (MessageLite)getExportsReq, CLDBProto.GetShareExportsOfVipResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetShareExportsOfVipProc.getNumber(), (MessageLite)getExportsReq, CLDBProto.GetShareExportsOfVipResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.GetShareExportsOfVipResponse resp = CLDBProto.GetShareExportsOfVipResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                boolean allShareFailedOver = NFS4MgmtCommands.sendFailoverExportRequestForShare(resp.getExportInfosList(), sourceNfsIp, sourceNfsPort, destinationNfsIp, destinationNfsPort, out);
                if (!allShareFailedOver) {
                    LOG.error((Object)"Share failover: Failed to failover exports");
                } else {
                    out.addMessage("Share failover: Successfully failed over all exports to " + destinationNfsIp);
                    LOG.info((Object)("Share failover: Successfully failed over all exports to " + destinationNfsIp));
                }
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Share failover failed: " + resp.getErrMsg()));
                LOG.error((Object)("Share failover failed, " + resp.getErrMsg()));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Share failover: Operation failed"));
            LOG.error((Object)("Exception during share failover " + e));
        }
        return output;
    }

    CommandOutput shareRemove() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String shareName = this.VolCommands.getRwVolumeName();
        LOG.debug((Object)"shareRemove:  trying to remove share export.");
        this.removeExport(out);
        LOG.debug((Object)"shareRemove:  trying to unmount volume.");
        this.VolCommands.volumeUnMount();
        LOG.debug((Object)("Trying to remove volume " + shareName));
        boolean forceRemove = this.getParamBooleanValue(SHARE_PARAM_FORCE, 0);
        CLDBProto.ShareRemoveRequest shareRemove = CLDBProto.ShareRemoveRequest.newBuilder().setName(shareName).setRemovevolume(forceRemove).setCreds(this.getUserCredentials()).build();
        LOG.debug((Object)("Removing share " + shareName));
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareRemoveProc.getNumber(), (MessageLite)shareRemove, CLDBProto.ShareRemoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareRemoveProc.getNumber(), (MessageLite)shareRemove, CLDBProto.ShareRemoveResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ShareRemoveResponse resp = CLDBProto.ShareRemoveResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                LOG.info((Object)("Removed share " + shareName));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Share Remove failed: " + resp.getErrMsg()));
                LOG.error((Object)("remove share volume failed, " + resp.getErrMsg()));
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Share Remove: Operation failed"));
            LOG.error((Object)("Exception during share remove " + e));
        }
        output.setOutput(out);
        return output;
    }

    private CommandOutput removeExport(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String shareName = this.VolCommands.getRwVolumeName();
        CLDBProto.ShareLookupResponse lookresp = this.processInfoRpc(out);
        if (lookresp.getStatus() != 0) {
            String msg = "Share lookup failed. " + lookresp.getStatus() + ": " + lookresp.getErrMsg();
            LOG.error((Object)("removeExport: " + msg));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(lookresp.getStatus(), msg));
            return this.output;
        }
        CLDBProto.ShareProperties shareProps = lookresp.getShareInfo().getShareProps();
        if (shareProps == null) {
            String msg = "Remove export failed. Share properties not found for share " + shareName;
            LOG.error((Object)("removeExport: " + msg));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
            return this.output;
        }
        String nfsHost = shareProps.getIpaddr();
        int nfsPort = shareProps.getPort();
        Integer exportId = shareProps.getExportId();
        Nfsmon.NFSExportResponse expResp = NFS4MgmtCommands.sendRemoveExportRequestForShare(nfsHost, nfsPort, exportId, out);
        if (expResp == null) {
            String msg = "remove-export failed for share: " + shareName + ". Response is null.";
            LOG.error((Object)("removeExport: " + msg));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
            return this.output;
        }
        if (expResp.getStatus() != 0) {
            String msg = "remove-export failed for share: " + shareName + ". " + expResp.getErrMsg();
            LOG.error((Object)("removeExport: " + msg));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(expResp.getStatus(), msg));
            return this.output;
        }
        return this.output;
    }

    private BitSet getColumns() throws CLIProcessingException {
        BitSet columns = new BitSet();
        columns.set(0, MAX_SHAREFIELDINFO + 1);
        String columnsString = this.getColumnsParamValue();
        if (columnsString != null && !columnsString.equals("all")) {
            columns = FilterUtil.getColumns(shareFieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    @Override
    public MessageLite sendRequest(MessageLite req) throws CLIProcessingException {
        byte[] data;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareListProc.getNumber(), req, CLDBProto.ShareListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareListProc.getNumber(), req, CLDBProto.ShareListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (data != null) {
            return this.getShareListResponse(data);
        }
        LOG.error((Object)"RPC Request to list volumes failed. No data returned");
        return null;
    }

    private CLDBProto.ShareListResponse getShareListResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.ShareListResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into ShareListResponse proto object.", (Throwable)ipbe);
        }
    }

    private void formatShareProperties(CLDBProto.ShareInfo shareInfo, boolean terse, BitSet columns, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.ShareProperties shareProps = shareInfo.getShareProps();
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        out.addNode(outputNode);
        String colParam = this.getColumnsParamValue();
        LOG.info((Object)("Columns value param value are " + colParam));
        if (columns.get(CLDBProto.ShareInfoFields.shareId.getNumber()) && shareProps.hasId()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareId)).getName(terse), shareProps.getId()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareName.getNumber()) && shareProps.hasName()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareName)).getName(terse), (Object)shareProps.getName()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareExportPath.getNumber()) && shareProps.hasExportPath()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareExportPath)).getName(terse), (Object)shareProps.getExportPath()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareCreatedBy.getNumber()) && shareProps.hasCreatedBy()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareCreatedBy)).getName(terse), (Object)shareProps.getCreatedBy()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareType.getNumber()) && shareProps.hasShareType()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareType)).getName(terse), (Object)shareProps.getShareType()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareQuotaMB.getNumber()) && shareProps.hasQuotaSizeMB()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareQuotaMB)).getName(terse), shareProps.getQuotaSizeMB()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareAdvisoryQuotaMB.getNumber()) && shareProps.hasAdvisoryQuotaSizeMB()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareAdvisoryQuotaMB)).getName(terse), shareProps.getAdvisoryQuotaSizeMB()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareTemplateName.getNumber()) && shareProps.hasTemplateName()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareTemplateName)).getName(terse), (Object)shareProps.getTemplateName()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareSchedulingPolicyName.getNumber()) && shareProps.hasSchedulingPolicyName()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareSchedulingPolicyName)).getName(terse), (Object)shareProps.getSchedulingPolicyName()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareDatalabel.getNumber()) && shareProps.hasDatalabel()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareDatalabel)).getName(terse), (Object)shareProps.getDatalabel()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareNslabel.getNumber()) && shareProps.hasNslabel()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareNslabel)).getName(terse), (Object)shareProps.getNslabel()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareIpaddr.getNumber()) && shareProps.hasIpaddr()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareIpaddr)).getName(terse), (Object)shareProps.getIpaddr()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.sharePort.getNumber()) && shareProps.hasPort()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.sharePort)).getName(terse), shareProps.getPort()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareCreateTime.getNumber()) && shareProps.hasCreateTime()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareCreateTime)).getName(terse), shareProps.getCreateTime()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareUpdateTime.getNumber()) && shareProps.hasUpdateTime()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareUpdateTime)).getName(terse), shareProps.getUpdateTime()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareTemplateAppliedTime.getNumber()) && shareProps.hasTemplateAppliedTime()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareTemplateAppliedTime)).getName(terse), shareProps.getTemplateAppliedTime()));
        }
        if (columns.get(CLDBProto.ShareInfoFields.shareExportId.getNumber()) && shareProps.hasExportId()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(shareFieldTable.get(new ShareField(CLDBProto.ShareInfoFields.shareExportId)).getName(terse), shareProps.getExportId()));
        }
        if (colParam != null && colParam.equals("all") || colParam == null) {
            CLDBProto.VolumeInfo volInfo;
            if (shareInfo.hasTemplate()) {
                this.TemplateCommands.init();
                String opParam = this.getOutputParamValue();
                boolean newTerse = opParam.equals("terse");
                BitSet newColumns = this.TemplateCommands.getColumns();
                CommandOutput.OutputHierarchy.OutputNode templateNode = this.TemplateCommands.formatShareTemplate(shareInfo.getTemplate(), newTerse, newColumns);
                templateNode.setName(SHARE_PARAM_TEMPLATE_NAME);
                outputNode.addChild(templateNode);
            }
            if (shareInfo.hasVolInfo() && (volInfo = shareInfo.getVolInfo()) != null) {
                CommandOutput.OutputHierarchy.OutputNode volPropsNode = this.formatVolumeInfo(volInfo);
                volPropsNode.setName("volumeproperties");
                outputNode.addChild(volPropsNode);
            }
        }
    }

    private static String convertMillisToDate(long millis) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(new Date(millis));
    }

    private CLDBProto.VolumeProperties setShareReplication(CLDBProto.VolumeProperties volProps) {
        if (volProps == null) {
            return null;
        }
        CLDBProto.ReplicationPolicy replPolicy = volProps.getReplicationPolicy().toBuilder().setNumReplicas(1).setGuaranteedMinReplicas(1).build();
        return volProps.toBuilder().setNumNamespaceReplicas(1).setGuaranteedMinNamespaceReplicas(1).setReplicationPolicy(replPolicy).build();
    }

    private CLDBProto.VolumeProperties clearShareReplication(CLDBProto.VolumeProperties volProps) {
        if (volProps == null) {
            return null;
        }
        CLDBProto.ReplicationPolicy replPolicy = volProps.getReplicationPolicy().toBuilder().clearNumReplicas().clearGuaranteedMinReplicas().build();
        return volProps.toBuilder().clearNumNamespaceReplicas().clearGuaranteedMinNamespaceReplicas().setReplicationPolicy(replPolicy).build();
    }

    private CommandOutput.OutputHierarchy.OutputNode formatVolumeInfo(CLDBProto.VolumeInfo volInfo) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode volPropsNode = new CommandOutput.OutputHierarchy.OutputNode();
        if (volInfo != null) {
            CLDBProto.VolumeProperties volProps = this.clearShareReplication(volInfo.getVolProperties());
            volInfo = volInfo.toBuilder().setVolProperties(volProps).build();
            this.VolCommands.init();
            this.VolCommands.isHandlingShareVolume = true;
            BitSet columns = this.VolCommands.getColumns();
            boolean terse = false;
            int version = this.getVersion();
            if (columns.get(CLDBProto.VolumeInfoFields.volumeAccessTime.getNumber())) {
                Date date = volInfo.hasAtime() ? new Date(volInfo.getAtime()) : null;
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.volumeAccessTime)).getName(terse), date, version));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.mountDir.getNumber())) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.mountDir)).getName(terse), (Object)volProps.getMountDir()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.quota.getNumber())) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.quota)).getName(terse), volProps.getVolumeQuotaSizeMB(), version));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.advisoryquota.getNumber())) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.advisoryquota)).getName(terse), volProps.getVolumeQuotaAdvisorySizeMB(), version));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.snapshotcount.getNumber())) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.snapshotcount)).getName(terse), volProps.getNumSnapshots()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.logicalUsed.getNumber())) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.logicalUsed)).getName(terse), volInfo.getVolQuota().getVolumeLogicalUsedSizeMB(), version));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.used.getNumber())) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.used)).getName(terse), volInfo.getVolQuota().getVolumeUsedSizeMB(), version));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.snapshotUsed.getNumber())) {
                long snapSize = volInfo.getVolumeSnapshotsOwnedSizeMB();
                if ((snapSize -= volInfo.getVolQuota().getVolumeSharedSizeMB()) < 0L) {
                    snapSize = 0L;
                }
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.snapshotUsed)).getName(terse), snapSize, version));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.used.getNumber()) && volInfo.getVolQuota().hasNumFile()) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numFile)).getName(terse), volInfo.getVolQuota().getNumFile(), version));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.used.getNumber()) && volInfo.getVolQuota().hasNumDir()) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.numDir)).getName(terse), volInfo.getVolQuota().getNumDir(), version));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.totalUsed.getNumber())) {
                long snapSize = volInfo.getVolumeSnapshotsOwnedSizeMB();
                if (snapSize < volInfo.getVolQuota().getVolumeSharedSizeMB()) {
                    snapSize = volInfo.getVolQuota().getVolumeSharedSizeMB();
                }
                LOG.debug((Object)("volumeUsedSizeMB:" + volInfo.getVolQuota().getVolumeUsedSizeMB() + ", snapshotOwnedSizeMB:" + volInfo.getVolumeSnapshotsOwnedSizeMB() + ", volumeSharedSizeMB:" + volInfo.getVolQuota().getVolumeSharedSizeMB() + ", volumeOwnedSizeMB:" + volInfo.getVolQuota().getVolumeOwnedSizeMB()));
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.totalUsed)).getName(terse), snapSize + volInfo.getVolQuota().getVolumeOwnedSizeMB(), version));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.maxinodesalarmthreshold.getNumber())) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.maxinodesalarmthreshold)).getName(terse), volProps.getMaxInodesAlarmThreshold(), version));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.createTime.getNumber()) && volProps.hasCreateTime()) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.createTime)).getName(terse), volProps.getCreateTime()));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.metricsEnabled.getNumber())) {
                Integer metricsEnabled = volProps.getMetricsEnabled() ? 1 : 0;
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.metricsEnabled)).getName(terse), (Object)metricsEnabled));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.dataContainerLabel.getNumber())) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.dataContainerLabel)).getName(terse), (Object)(volProps.hasLabel() ? volProps.getLabel() : "default")));
            }
            if (columns.get(CLDBProto.VolumeInfoFields.nameContainerLabel.getNumber())) {
                volPropsNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(VolumeCommands.fieldTable.get(new VolumeField(CLDBProto.VolumeInfoFields.nameContainerLabel)).getName(terse), (Object)(volProps.hasNameCntrLabel() ? volProps.getNameCntrLabel() : "default")));
            }
        }
        return volPropsNode;
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getStartParamValue(), this.getLimitParamValue(), ((CLDBProto.ShareListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.ShareListResponse)prevResp).getShareInfosCount());
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite response) throws CLIProcessingException {
        CLDBProto.ShareListResponse resp = (CLDBProto.ShareListResponse)response;
        boolean terse = this.getOutputParamValue().equals("terse");
        BitSet columns = this.getColumns();
        for (CLDBProto.ShareInfo shInfo : resp.getShareInfosList()) {
            this.formatShareProperties(shInfo, terse, columns, out);
        }
        if (resp.hasTotal()) {
            out.setTotal(resp.getTotal());
        }
        this.listedShares.addAll(resp.getShareInfosList());
    }

    private CLDBProto.ShareListRequest.Builder getShareListRequestBuilder() throws CLIProcessingException {
        List<CLIProto.Filter> filters = this.getFilters(shareFieldTable, FILTER_PARAM_NAME);
        BitSet columns = this.getColumns();
        ByteString bString = ByteString.copyFrom((byte[])BitSetBytesHelperUtils.toByteArray((BitSet)columns));
        long columnsOld = BitSetBytesHelperUtils.convert((BitSet)columns);
        CLDBProto.ShareListRequest.Builder req = CLDBProto.ShareListRequest.newBuilder();
        CLIProto.Limiter limiter = this.getNextLimiter(this.getStartParamValue(), 0, this.getStartParamValue(), this.getLimitParamValue(), 512);
        return req.setCreds(this.getUserCredentials()).addAllFilter(filters).setColumns(columnsOld).setColumnsAdd(bString).setLimiter(limiter);
    }

    CommandOutput shareCreate() throws CLIProcessingException, IOException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String shareName = this.VolCommands.getRwVolumeName();
        String rwShareMountDir = SHARE_MOUNT_DIR + shareName;
        boolean mount = true;
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        String usrname = this.getUserCredentials().getUserName();
        CLDBProto.ShareCreateRequest.Builder shareCreate = CLDBProto.ShareCreateRequest.newBuilder();
        CLDBProto.ShareProperties shareProps = this.buildShareProperties(out);
        if (shareProps == null) {
            return output;
        }
        shareProps = shareProps.toBuilder().setCreatedBy(usrname).build();
        shareCreate.setShare(shareProps);
        CLDBProto.VolumeCreateRequest.Builder volCreate = this.VolCommands.buildVolumeCreateRequest(out);
        if (volCreate == null) {
            LOG.error((Object)"shareCreate: failed to create VolumeCreateRequest");
            return output;
        }
        CLDBProto.VolumeProperties volProps = this.setShareReplication(volCreate.getVolProperties());
        volCreate.setVolProperties(volProps);
        shareCreate.setVolCreateReq(volCreate.build());
        shareCreate.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            Nfsmon.NFSExportResponse expResp;
            String msg;
            MapRFileSystem fs = MapRCliUtil.getMapRFileSystem(this.getUserLoginId());
            if (rwShareMountDir != null && !MapRCliUtil.parentDirExists(fs, cluster, rwShareMountDir)) {
                LOG.error((Object)("Share Mount: Share " + shareName + " parent of mount dir " + rwShareMountDir + " does not exist"));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "Failed to mount " + shareName + ", parent of mount dir " + rwShareMountDir + " does not exist, " + Errno.toString((int)2)));
                return output;
            }
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareCreateProc.getNumber(), (MessageLite)shareCreate.build(), CLDBProto.ShareCreateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareCreateProc.getNumber(), (MessageLite)shareCreate.build(), CLDBProto.ShareCreateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ShareCreateResponse resp = CLDBProto.ShareCreateResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0 && resp.hasErrMsg() && (msg = resp.getErrMsg()) != null && !msg.trim().isEmpty()) {
                out.addWarning(msg);
            }
            LOG.info((Object)"shareCreate: Share successfully created in cldb.");
            if (resp.getStatus() == 0 && rwShareMountDir != null && mount) {
                int mountStatus = -1;
                mountStatus = fs.mountVolume(cluster, shareName, rwShareMountDir, this.getUserLoginId());
                if (mountStatus != 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Share mount for " + rwShareMountDir + " failed, " + Errno.toString((int)mountStatus)).setField(SHARE_PARAM_NAME).setFieldValue(shareName));
                    return output;
                }
            } else {
                CommandOutput.OutputHierarchy.OutputError procssobj = new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg());
                if (resp.getStatus() == 2) {
                    procssobj.setField(SHARE_PARAM_NAME);
                    procssobj.setFieldValue(shareName);
                } else if (resp.getStatus() != 10011) {
                    procssobj.setPropagateErrorSupport(true);
                    procssobj.setField(SHARE_PARAM_NAME);
                    procssobj.setFieldValue(shareName);
                }
                out.addError(procssobj);
                return output;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException procssobj) {
                // empty catch block
            }
            CLDBProto.ShareInfo shInfo = resp.getShareInfo();
            shareProps = shInfo.getShareProps();
            CLDBProto.ShareTemplate template = shInfo.getTemplate();
            String nfsHost = shareProps.getIpaddr();
            int nfsPort = shareProps.getPort();
            int exportId = shareProps.getExportId();
            String path = MAPR_MANAGED_PATH_PREFIX + rwShareMountDir;
            String psudoPath = null;
            if (this.isParamPresent(SHARE_PARAM_EXPORT_PATH)) {
                psudoPath = this.getParamTextValue(SHARE_PARAM_EXPORT_PATH, 0);
            }
            String secType = "sys";
            if (template.hasSecType()) {
                secType = template.getSecType();
            }
            String accessType = "RW";
            if (template.hasAccessType()) {
                accessType = template.getAccessType();
            }
            String squash = "Root_Squash";
            if (template.hasSquash()) {
                squash = template.getSquash();
            }
            List clientSpecs = null;
            if (!template.getClientSpecsList().isEmpty()) {
                clientSpecs = template.getClientSpecsList();
            }
            if ((expResp = NFS4MgmtCommands.sendAddExportRequestForShare(nfsHost, nfsPort, path, psudoPath, secType, accessType, squash, clientSpecs, exportId, out)) == null) {
                String msg2 = "add-export failed for share: " + shareName + ". Response is null.";
                LOG.error((Object)("shareCreate: " + msg2));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg2));
                return output;
            }
            if (expResp.getStatus() != 0) {
                String msg3 = "add-export failed for share: " + shareName + ". " + expResp.getErrMsg();
                LOG.error((Object)("shareCreate: " + msg3));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(expResp.getStatus(), msg3));
                return output;
            }
            LOG.info((Object)("shareCreate: exported on NFS Server " + nfsHost));
            String opParam = this.getOutputParamValue();
            boolean terse = opParam.equals("terse");
            BitSet columns = this.getColumns();
            this.formatShareProperties(resp.getShareInfo(), terse, columns, out);
            return output;
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException: ", (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Request for share Creating failed: " + e.getMessage();
            LOG.error((Object)"--Anand: Exception", (Throwable)e);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
            return output;
        }
    }

    private CLDBProto.ShareProperties buildShareProperties(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        long quotaMB;
        String quotaString;
        CLDBProto.ShareProperties.Builder shareProps = CLDBProto.ShareProperties.newBuilder();
        if (this.isParamPresent(SHARE_PARAM_NAME)) {
            String shareName = this.getParamTextValue(SHARE_PARAM_NAME, 0);
            shareProps.setName(shareName);
        }
        if (this.isParamPresent(SHARE_PARAM_TEMPLATE_NAME)) {
            String tmpName = this.getParamTextValue(SHARE_PARAM_TEMPLATE_NAME, 0);
            shareProps.setTemplateName(tmpName);
        }
        if (this.isParamPresent(SHARE_PARAM_NFS_SERVER_IP)) {
            String ipaddr = this.getParamTextValue(SHARE_PARAM_NFS_SERVER_IP, 0);
            shareProps.setIpaddr(ipaddr);
        }
        if (this.isParamPresent(SHARE_PARAM_NFS_SERVER_PORT)) {
            int port = this.getParamIntValue(SHARE_PARAM_NFS_SERVER_PORT, 0);
            shareProps.setPort(port);
        }
        String shareType = SHARE_PARAM_TYPE_DEFAULT;
        if (this.isParamPresent(SHARE_PARAM_TYPE)) {
            shareType = this.getParamTextValue(SHARE_PARAM_TYPE, 0);
        }
        if (!SUPPORTED_SHARE_TYPES.contains(shareType)) {
            LOG.error((Object)("buildShareProperties: invalid value for shareType: " + shareType));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sharetype: " + shareType));
            return null;
        }
        shareProps.setShareType(shareType);
        String exportPath = null;
        if (this.isParamPresent(SHARE_PARAM_EXPORT_PATH)) {
            exportPath = this.getParamTextValue(SHARE_PARAM_EXPORT_PATH, 0);
            shareProps.setExportPath(exportPath);
        }
        if ("nfsv3".equalsIgnoreCase(exportPath) && shareType != null) {
            String msg = " it is invalid to provide export-path for nfsv3 shares";
            LOG.error((Object)("buildShareProperties: invalid value for shareType: " + shareType));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sharetype: " + shareType));
            return null;
        }
        if (this.isParamPresent("quota")) {
            quotaString = this.getParamTextValue("quota", 0);
            quotaMB = MapRCliUtil.quotaStringToMB(quotaString);
            if (quotaMB < 0L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, " Invalid quota size. Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)"));
                LOG.error((Object)("Invalid quota during Volume modify " + quotaString));
                return null;
            }
            shareProps.setQuotaSizeMB(quotaMB);
        }
        if (this.isParamPresent("advisoryquota")) {
            quotaString = this.getParamTextValue("advisoryquota", 0);
            quotaMB = MapRCliUtil.quotaStringToMB(quotaString);
            if (quotaMB < 0L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, " Invalid quota size. Should be either an Integer, or a decimal value followed by one of (M,MB,G,GB,T,TB,P,PB)"));
                LOG.error((Object)("Invalid advisory quota during Volume modify " + quotaString));
                return null;
            }
            shareProps.setAdvisoryQuotaSizeMB(quotaMB);
        }
        if (this.isParamPresent(SHARE_PARAM_SCHEDULE)) {
            String schedule = this.getParamTextValue(SHARE_PARAM_SCHEDULE, 0);
            shareProps.setSchedulingPolicyName(schedule);
        }
        if (this.isParamPresent(SHARE_PARAM_SCHEDULEID)) {
            String msg = "Invalid parameter 'scheduleid' for shares. Use 'schedulename' instead.";
            LOG.error((Object)("buildShareProperties: " + msg));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
            return null;
        }
        return shareProps.build();
    }

    private CommandOutput shareInfo() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String shareName = this.VolCommands.getRwVolumeName();
        CLDBProto.ShareLookupResponse resp = this.processInfoRpc(out);
        if (resp.getStatus() != 0) {
            String msg = resp.getStatus() == 2 ? "No such share" : Errno.toString((int)resp.getStatus());
            String errorDescription = "Share Info of " + shareName + " failed, " + msg;
            CommandOutput.OutputHierarchy.OutputError errorNode = new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorDescription);
            errorNode.setPropagateErrorSupport(true).setField(SHARE_PARAM_NAME).setFieldValue(shareName);
            out.addError(errorNode);
            return output;
        }
        String opParam = this.getOutputParamValue();
        boolean terse = opParam.equals("terse");
        BitSet columns = this.getColumns();
        this.formatShareProperties(resp.getShareInfo(), terse, columns, out);
        return output;
    }

    private CLDBProto.ShareLookupResponse processInfoRpc(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String shareName = this.VolCommands.getRwVolumeName();
        CLDBProto.ShareLookupRequest shareInfo = CLDBProto.ShareLookupRequest.newBuilder().setName(shareName).setCreds(this.getUserCredentials()).build();
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareInfoProc.getNumber(), (MessageLite)shareInfo, CLDBProto.ShareLookupResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareInfoProc.getNumber(), (MessageLite)shareInfo, CLDBProto.ShareLookupResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            CLDBProto.ShareLookupResponse resp = CLDBProto.ShareLookupResponse.parseFrom((byte[])data);
            return resp;
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)"processInfoRpc: caught MaprSecurityException: ", (Throwable)e);
            throw new CLIProcessingException("MaprSecurityException...", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"processInfoRpc: caught Exception: ", (Throwable)e);
            throw new CLIProcessingException("Exception doing share Info to CLDB, " + e.getLocalizedMessage());
        }
    }

    CommandOutput shareModify() throws CLIProcessingException, IOException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String rwVolumeName = this.VolCommands.getRwVolumeName();
        CLDBProto.ShareProperties shareProps = this.buildShareProperties(out);
        if (shareProps == null) {
            return output;
        }
        CLDBProto.VolumeUpdateRequest.Builder volUpdate = this.VolCommands.buildVolumeUpdateRequest(rwVolumeName, out);
        if (volUpdate == null) {
            LOG.error((Object)"shareModify: failed to build volume update request.");
            return output;
        }
        CLDBProto.ShareUpdateRequest.Builder shareUpdate = CLDBProto.ShareUpdateRequest.newBuilder().setCreds(this.getUserCredentials()).setVolUpdateReq(volUpdate.build()).setShare(shareProps);
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareUpdateProc.getNumber(), (MessageLite)shareUpdate.build(), CLDBProto.ShareUpdateResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ShareUpdateProc.getNumber(), (MessageLite)shareUpdate.build(), CLDBProto.ShareUpdateResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return output;
            }
            CLDBProto.ShareUpdateResponse resp = CLDBProto.ShareUpdateResponse.parseFrom((byte[])data);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)resp.getErrMsg());
            }
            if (resp.getStatus() != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            }
            String opParam = this.getOutputParamValue();
            boolean terse = opParam.equals("terse");
            BitSet columns = this.getColumns();
            this.formatShareProperties(resp.getShareInfo(), terse, columns, out);
            return output;
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Share Modify:  ShareName: " + rwVolumeName + Errno.toString((int)10003) + " Share modify failed"));
            LOG.error((Object)"Exception during Share modify ", (Throwable)e);
            return output;
        }
    }

    static {
        shareFieldTableBuilder = new ImmutableMap.Builder().put((Object)new ShareField(CLDBProto.ShareInfoFields.shareId), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareId.getNumber(), "shid", "shareid", Integer.class, CLDBProto.ListSortKey.ShareId)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareName), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareName.getNumber(), "shn", "sharename", String.class, CLDBProto.ListSortKey.ShareName)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareExportPath), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareExportPath.getNumber(), "xp", SHARE_PARAM_EXPORT_PATH, String.class, CLDBProto.ListSortKey.ShareExportPath)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareCreatedBy), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareCreatedBy.getNumber(), "shon", "sharecreator", String.class, CLDBProto.ListSortKey.ShareOwner)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareType), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareType.getNumber(), "sht", SHARE_PARAM_TYPE, Integer.class, CLDBProto.ListSortKey.ShareType)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareQuotaMB), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareQuotaMB.getNumber(), "shqta", "sharequota", Long.class, CLDBProto.ListSortKey.ShareQuotaMB)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareAdvisoryQuotaMB), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareAdvisoryQuotaMB.getNumber(), "shaqt", "shareadvisoryquota", Long.class, CLDBProto.ListSortKey.ShareAdvisoryQuotaMB)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareTemplateName), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareTemplateName.getNumber(), "tn", "templatename", String.class, CLDBProto.ListSortKey.ShareTemplateName)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareSchedulingPolicyName), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareSchedulingPolicyName.getNumber(), "pn", "schedulingpolicyname", String.class, CLDBProto.ListSortKey.ShareSchedulingPolicyName)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareDatalabel), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareDatalabel.getNumber(), "shl", "sharelabel", String.class, CLDBProto.ListSortKey.ShareDataLabel)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareNslabel), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareNslabel.getNumber(), "shnsl", "sharenslabel", String.class, CLDBProto.ListSortKey.ShareNsLAbel)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareIpaddr), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareIpaddr.getNumber(), "ip", "ipaddr", String.class, CLDBProto.ListSortKey.ShareIpAddr)).put((Object)new ShareField(CLDBProto.ShareInfoFields.sharePort), (Object)new FieldInfo(CLDBProto.ShareInfoFields.sharePort.getNumber(), "po", "port", Integer.class, CLDBProto.ListSortKey.SharePort)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareCreateTime), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareCreateTime.getNumber(), "shct", "sharecreationtime", Long.class, CLDBProto.ListSortKey.ShareCreateTime)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareUpdateTime), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareUpdateTime.getNumber(), "ut", "updatetime", Long.class, CLDBProto.ListSortKey.ShareUpdateTime)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareTemplateAppliedTime), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareTemplateAppliedTime.getNumber(), "at", "appliedtime", Long.class, CLDBProto.ListSortKey.ShareTemplateAppliedTime)).put((Object)new ShareField(CLDBProto.ShareInfoFields.shareExportId), (Object)new FieldInfo(CLDBProto.ShareInfoFields.shareExportId.getNumber(), "xid", "exportid", Integer.class, CLDBProto.ListSortKey.ShareExportId));
        CLDBProto.ShareInfoFields[] values = CLDBProto.ShareInfoFields.values();
        int max = 0;
        for (CLDBProto.ShareInfoFields value : values) {
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_SHAREFIELDINFO = max;
        baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
        shareCreateCommand = new CLICommand("create", "", NfsShareCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SHARE_PARAM_NAME, (Object)new TextInputParameter(SHARE_PARAM_NAME, "shareName", true, null)).put((Object)SHARE_PARAM_TEMPLATE_NAME, (Object)new TextInputParameter(SHARE_PARAM_TEMPLATE_NAME, "<template-name>", true, null)).put((Object)SHARE_PARAM_NFS_SERVER_IP, (Object)new TextInputParameter(SHARE_PARAM_NFS_SERVER_IP, "nfs-server ip-address", true, null)).put((Object)SHARE_PARAM_NFS_SERVER_PORT, (Object)new IntegerInputParameter(SHARE_PARAM_NFS_SERVER_PORT, "nfs-server port number", false, Integer.valueOf(9995))).put((Object)SHARE_PARAM_TYPE, (Object)new TextInputParameter(SHARE_PARAM_TYPE, "<nfsv3|nfsv4|smb>", false, SHARE_PARAM_TYPE_DEFAULT)).put((Object)"quota", (Object)new TextInputParameter("quota", "quota", false, null)).put((Object)"advisoryquota", (Object)new TextInputParameter("advisoryquota", "advisoryquota", false, null)).put((Object)"maxinodesalarmthreshold", (Object)new LongInputParameter("maxinodesalarmthreshold", "maxinodesalarmthreshold", false, null)).put((Object)SHARE_PARAM_SCHEDULE, (Object)new TextInputParameter(SHARE_PARAM_SCHEDULE, "schedule name", false, null)).put((Object)"label", (Object)new TextInputParameter("label", "<data label>", false, null)).put((Object)"nslabel", (Object)new TextInputParameter("nslabel", "<name cntr label>", false, null)).put((Object)SHARE_PARAM_EXPORT_PATH, (Object)new TextInputParameter(SHARE_PARAM_EXPORT_PATH, "mountdir allowed if type is nfsv4", false, null)).build(), null).setUsageInVisible(true).setShortUsage(shareCreateUsage);
        nfsShareCommands = new CLICommand[]{new CLICommand("remove", "", NfsShareCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SHARE_PARAM_NAME, (Object)new TextInputParameter(SHARE_PARAM_NAME, "shareName", true, null)).put((Object)SHARE_PARAM_FORCE, (Object)new BooleanInputParameter(SHARE_PARAM_FORCE, SHARE_PARAM_FORCE, false, Boolean.valueOf(true))).put((Object)SHARE_PARAM_OP_NODELAY, (Object)new BooleanInputParameter(SHARE_PARAM_OP_NODELAY, SHARE_PARAM_OP_NODELAY, false, (Object)0).setInvisible(true)).build(), null).setUsageInVisible(true).setShortUsage(shareRemoveUsage), new CLICommand("modify", "", NfsShareCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)SHARE_PARAM_NAME, (Object)new TextInputParameter(SHARE_PARAM_NAME, "shareName", true, null)).put((Object)SHARE_PARAM_TEMPLATE_NAME, (Object)new TextInputParameter(SHARE_PARAM_TEMPLATE_NAME, "<template-name>", false, null)).put((Object)SHARE_PARAM_NFS_SERVER_IP, (Object)new TextInputParameter(SHARE_PARAM_NFS_SERVER_IP, "nfs-server ip-address", false, null)).put((Object)SHARE_PARAM_NFS_SERVER_PORT, (Object)new IntegerInputParameter(SHARE_PARAM_NFS_SERVER_PORT, "nfs-server port number", false, null)).put((Object)"quota", (Object)new TextInputParameter("quota", "quota", false, null)).put((Object)"advisoryquota", (Object)new TextInputParameter("advisoryquota", "advisoryquota", false, null)).put((Object)"maxinodesalarmthreshold", (Object)new LongInputParameter("maxinodesalarmthreshold", "maxinodesalarmthreshold", false, null)).put((Object)SHARE_PARAM_SCHEDULE, (Object)new TextInputParameter(SHARE_PARAM_SCHEDULE, "schedule name", false, null)).build(), null).setUsageInVisible(true).setShortUsage(shareModifyUsage), new CLICommand("list", "", NfsShareCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)FILTER_PARAM_NAME, (Object)new FilterInputParameter(FILTER_PARAM_NAME, "none", false, "none")).put((Object)COLUMNS_PARAM_NAME, (Object)new TextInputParameter(COLUMNS_PARAM_NAME, "comma separated list of column names", false, "all")).build(), null).setUsageInVisible(true).setShortUsage(shareListUsage), new CLICommand("info", "", NfsShareCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).put((Object)SHARE_PARAM_NAME, (Object)new TextInputParameter(SHARE_PARAM_NAME, "shareName", false, null)).put((Object)COLUMNS_PARAM_NAME, (Object)new TextInputParameter(COLUMNS_PARAM_NAME, "comma separated list of column names", false, "all")).build(), null).setUsageInVisible(true).setShortUsage(shareInfoUsage), new CLICommand("failover", "", NfsShareCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)ASSIGNED_TO_VIP, (Object)new TextInputParameter(ASSIGNED_TO_VIP, ASSIGNED_TO_VIP, true, null)).put((Object)SOURCE_NFS_IP_ADDR, (Object)new TextInputParameter(SOURCE_NFS_IP_ADDR, "source-nfs-ip", false, null)).put((Object)SOURCE_NFS_PORT, (Object)new IntegerInputParameter(SOURCE_NFS_PORT, "source-nfs-port", false, Integer.valueOf(9995))).put((Object)DESTINATION_NFS_IP_ADDR, (Object)new TextInputParameter(DESTINATION_NFS_IP_ADDR, "destination-nfs-ip", true, null)).put((Object)DESTINATION_NFS_PORT, (Object)new IntegerInputParameter(DESTINATION_NFS_PORT, "destination-nfs-port", false, Integer.valueOf(9995))).build(), null).setUsageInVisible(true).setShortUsage(shareFailoverUsage)};
    }
}

