/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.policyserverutils.PolicyServerRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.Rpc;
import com.mapr.fs.policyserver.iam.IamSupportUtils;
import com.mapr.fs.proto.PolicyServerProto;
import com.mapr.fs.proto.Security;
import com.mapr.security.IamRolesHelper;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class IamResourceCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(IamResourceCommands.class);
    private static final String IAM_RESOURCE_TYPE_PARAM = "type";
    private static final String IAM_RESOURCE_ACTIONS_PARAM = "actions";
    private static final String IAM_RESOURCE_CLUSTERGROUP_PARAM = "clustergroup";
    private static final String IAM_RESOURCE_CLUSTERNAME_PARAM = "cluster";
    private static final String IAM_RESOURCE_URN_PARAM = "urn";
    private static final String IAM_RESOURCE_NAME_PARAM = "name";
    private static final String IAM_RESOURCE_PATH_PARAM = "path";
    private static final String IAM_RESOURCE_NAME_REGEX = "^[A-Za-z0-9_.-]*$";
    private static final String IAM_RESOURCE_PATH_REGEX = ".*[/\n\r\t\u0000\f`?*\\<>|\":].*";
    Security.CredentialsMsg creds;
    private static Map<String, BaseInputParameter> typeParam = new ImmutableMap.Builder().put((Object)"type", (Object)new TextInputParameter("type", "<Resource Type>", false, null)).build();
    private static final String getResourceActionsUsage = "resource actions [ -type <Resource Type> ]";
    private static final CLICommand getResourceActionsCommand = new CLICommand("actions", "", IamResourceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(typeParam).build(), null).setShortUsage("resource actions [ -type <Resource Type> ]");
    private static Map<String, BaseInputParameter> resourceUrnParam = new ImmutableMap.Builder().put((Object)"urn", (Object)new TextInputParameter("urn", "<Resource URN>", true, null)).build();
    private static final String getResourceInfoUsage = "resource info -urn <Resource URN>";
    private static final CLICommand getResourceInfoCommand = new CLICommand("info", "", IamResourceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(resourceUrnParam).build(), null).setShortUsage("resource info -urn <Resource URN>");
    private static Map<String, BaseInputParameter> clusterGroupParam = new ImmutableMap.Builder().put((Object)"clustergroup", (Object)new TextInputParameter("clustergroup", "<Cluster Group>", true, null)).build();
    private static Map<String, BaseInputParameter> clusterNameParam = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "<Cluster Name>", true, null)).build();
    private static Map<String, BaseInputParameter> resourceTypeParam = new ImmutableMap.Builder().put((Object)"type", (Object)new TextInputParameter("type", "<Resource Type>", true, null)).build();
    private static Map<String, BaseInputParameter> resourceNameParam = new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "<Resource Name>", false, null)).build();
    private static Map<String, BaseInputParameter> resourcePathParam = new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "<Resource Path>", false, null)).build();
    private static final String getResourceUrnUsage = "resource urn -clustergroup <Cluster Group> -cluster <Cluster Name> -type <Resource Type> [ -name <Resource Name> | -path <Resource Path> ]";
    private static final CLICommand getResourceUrnCommand = new CLICommand("urn", "", IamResourceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(clusterGroupParam).putAll(clusterNameParam).putAll(resourceTypeParam).putAll(resourceNameParam).putAll(resourcePathParam).build(), null).setShortUsage("resource info -urn <Resource URN>");
    public static final CLICommand IamResourceCommands = new CLICommand("resource", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{getResourceActionsCommand, getResourceInfoCommand, getResourceUrnCommand}).setShortUsage("resource [actions|info|urn]");
    private ProcessedInput processedInput;
    private CLICommand cliCommand;
    private UnixUserGroupHelper uugh;
    private IamRolesHelper imrh;
    private String cluster;

    public IamResourceCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
        this.processedInput = input;
        this.cliCommand = cliCommand;
    }

    void initialize() throws CLIProcessingException {
        try {
            this.creds = this.getUserCredentials();
            this.cluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
            this.uugh = new UnixUserGroupHelper();
            this.imrh = new IamRolesHelper(this.cluster);
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Error in RPC initialize");
            }
        }
        catch (Exception exp) {
            LOG.error((Object)("Exception while initializing RPC " + exp));
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.initialize();
        String cmdName = this.cliCommand.getCommandName();
        if (cmdName.equalsIgnoreCase(IAM_RESOURCE_ACTIONS_PARAM)) {
            try {
                return this.getSupportedResourceActions();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Get Supported Resource Actions Exception", (Throwable)e);
            }
        }
        if (cmdName.equalsIgnoreCase("info")) {
            try {
                return this.getIamResourceInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Get IAM Resource Info Exception", (Throwable)e);
            }
        }
        if (cmdName.equalsIgnoreCase(IAM_RESOURCE_URN_PARAM)) {
            try {
                return this.getIamResourceUrn();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Get IAM Resource URN Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput("Iam Resource command failed".getBytes());
    }

    private CommandOutput getSupportedResourceActions() throws Exception, CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        byte[] data = null;
        HashSet<PolicyServerProto.ResourceType> resourceTypeList = new HashSet<PolicyServerProto.ResourceType>();
        HashSet<Object> strResourceTypes = new HashSet();
        String cmdNameResourceTypes = this.getResourceTypes();
        strResourceTypes = cmdNameResourceTypes != null ? this.getValues(cmdNameResourceTypes, ",") : new HashSet(IamSupportUtils.getSupportedResourceTypes());
        for (String string : strResourceTypes) {
            PolicyServerProto.ResourceType resType = IamSupportUtils.StringToResourceType((String)string);
            if (resType == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Resource Type '" + string + "', Supported Resource Types - " + IamSupportUtils.getSupportedResourceTypes().toString()));
                return output;
            }
            resourceTypeList.add(resType);
        }
        PolicyServerProto.IAMResourceActionListRequest req = PolicyServerProto.IAMResourceActionListRequest.newBuilder().setCreds(this.getUserCredentials()).addAllTypes(resourceTypeList).build();
        data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IAMResourceActionListProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IAMResourceActionListResponse iAMResourceActionListResponse = PolicyServerProto.IAMResourceActionListResponse.parseFrom((byte[])data);
        if (iAMResourceActionListResponse.getStatus() == 0) {
            for (PolicyServerProto.ResourceTypeToActions mappingInfo : iAMResourceActionListResponse.getMappingsList()) {
                CommandOutput.OutputHierarchy.OutputNode mapResourceActions = this.formatResourceActionMapping(mappingInfo);
                out.addNode(mapResourceActions);
            }
        } else {
            String errMsg = "Failed to get Resource Action Mappings. " + iAMResourceActionListResponse.getErrMsg();
            out.addError(new CommandOutput.OutputHierarchy.OutputError(iAMResourceActionListResponse.getStatus(), errMsg));
        }
        return output;
    }

    private String getResourceTypes() throws CLIProcessingException {
        return this.isParamPresent(IAM_RESOURCE_TYPE_PARAM) ? this.getParamTextValue(IAM_RESOURCE_TYPE_PARAM, 0) : null;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatResourceActionMapping(PolicyServerProto.ResourceTypeToActions mapInfo) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode output = new CommandOutput.OutputHierarchy.OutputNode();
        String resourceType = IamSupportUtils.ResourceTypeToString((PolicyServerProto.ResourceType)mapInfo.getType());
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResourceType", (Object)resourceType));
        for (String resourceAction : mapInfo.getActionsList()) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResourceActions", (Object)resourceAction));
        }
        return output;
    }

    private HashSet<String> getValues(String value, String seperator) {
        String[] tokens = value.split(seperator);
        HashSet<String> values = new HashSet<String>();
        for (int index = 0; index < tokens.length; ++index) {
            values.add(tokens[index].trim());
        }
        return values;
    }

    private String getResourceUrn() throws CLIProcessingException {
        return this.isParamPresent(IAM_RESOURCE_URN_PARAM) ? this.getParamTextValue(IAM_RESOURCE_URN_PARAM, 0) : null;
    }

    private CommandOutput getIamResourceInfo() throws Exception, CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String strFmt = "urn:<CLUSTER-GROUP>:<CLUSTER-NAME>:<RESOURCE-TYPE>:<RESOURCE-NAME or RESOURCE-PATH>";
        String strUrn = this.getResourceUrn();
        if (strUrn == null || strUrn.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Resource URN, Expected format: " + strFmt));
        } else {
            PolicyServerProto.ResourceInfoMsg resource = IamSupportUtils.getResourceInfo((String)strUrn);
            if (resource == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Resource URN, Expected format: " + strFmt));
            } else {
                CommandOutput.OutputHierarchy.OutputNode iamResourceSpecInfo = this.formatIamResourceInfo(resource);
                out.addNode(iamResourceSpecInfo);
            }
        }
        return output;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatIamResourceInfo(PolicyServerProto.ResourceInfoMsg resource) {
        PolicyServerProto.ResourceType resourceType;
        CommandOutput.OutputHierarchy.OutputNode output = new CommandOutput.OutputHierarchy.OutputNode();
        PolicyServerProto.ResourceType resourceType2 = resourceType = resource.hasType() ? resource.getType() : null;
        if (resourceType == PolicyServerProto.ResourceType.ClusterGroup) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ClusterGroup", (Object)resource.getClusterGroupName()));
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResourceType", (Object)IamSupportUtils.ResourceTypeToString((PolicyServerProto.ResourceType)resourceType)));
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResourceName", (Object)resource.getClusterGroupName()));
        } else if (resourceType == PolicyServerProto.ResourceType.Cluster) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ClusterGroup", (Object)resource.getClusterGroupName()));
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ClusterName", (Object)resource.getClusterName()));
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResourceType", (Object)IamSupportUtils.ResourceTypeToString((PolicyServerProto.ResourceType)resourceType)));
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResourceName", (Object)resource.getClusterName()));
        } else {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ClusterGroup", (Object)resource.getClusterGroupName()));
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ClusterName", (Object)resource.getClusterName()));
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResourceType", (Object)IamSupportUtils.ResourceTypeToString((PolicyServerProto.ResourceType)resourceType)));
            if (resource.hasName()) {
                output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResourceName", (Object)resource.getName()));
            } else if (resource.hasPath()) {
                output.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResourcePath", (Object)resource.getPath()));
            }
        }
        return output;
    }

    private String getClusterGroup() throws CLIProcessingException {
        return this.isParamPresent(IAM_RESOURCE_CLUSTERGROUP_PARAM) ? this.getParamTextValue(IAM_RESOURCE_CLUSTERGROUP_PARAM, 0) : null;
    }

    private String getClusterName() throws CLIProcessingException {
        return this.isParamPresent(IAM_RESOURCE_CLUSTERNAME_PARAM) ? this.getParamTextValue(IAM_RESOURCE_CLUSTERNAME_PARAM, 0) : null;
    }

    private String getResourceType() throws CLIProcessingException {
        return this.isParamPresent(IAM_RESOURCE_TYPE_PARAM) ? this.getParamTextValue(IAM_RESOURCE_TYPE_PARAM, 0) : null;
    }

    private String getStringParam(String strParam) throws CLIProcessingException {
        return this.isParamPresent(strParam) ? this.getParamTextValue(strParam, 0) : null;
    }

    private boolean isValidResourceName(String resourceName) {
        return resourceName.matches(IAM_RESOURCE_NAME_REGEX);
    }

    private boolean isValidResourcePath(String resourcePath) {
        return resourcePath.matches(IAM_RESOURCE_PATH_REGEX);
    }

    /*
     * Enabled aggressive block sorting
     */
    private CommandOutput getIamResourceUrn() throws Exception, CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String clusterGroup = this.getClusterGroup();
        if (clusterGroup == null || clusterGroup.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specify valid Cluster Group"));
            return output;
        }
        String clusterName = this.getClusterName();
        if (clusterName == null || clusterName.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specify valid Cluster Name"));
            return output;
        }
        PolicyServerProto.ResourceType resourceType = null;
        String strResourceType = this.getResourceType();
        if (strResourceType == null || strResourceType.isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Resource Type, Expected values: " + IamSupportUtils.getSupportedResourceTypes()));
            return output;
        }
        resourceType = IamSupportUtils.StringToResourceType((String)(strResourceType = strResourceType.toLowerCase()));
        if (resourceType == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Resource Type, Expected values: " + IamSupportUtils.getSupportedResourceTypes()));
            return output;
        }
        String resourceUrn = "";
        if (resourceType == PolicyServerProto.ResourceType.Cluster) {
            resourceUrn = IamSupportUtils.getResourceUrn((String)clusterGroup, (String)clusterName, (PolicyServerProto.ResourceType)resourceType, null);
        } else {
            String resourceSpec = "";
            if (!(this.isParamPresent(IAM_RESOURCE_NAME_PARAM) ^ this.isParamPresent(IAM_RESOURCE_PATH_PARAM))) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specify either Resource Name or Path"));
                return output;
            }
            String strName = this.getStringParam(IAM_RESOURCE_NAME_PARAM);
            String strPath = this.getStringParam(IAM_RESOURCE_PATH_PARAM);
            if (strName != null && !strName.isEmpty()) {
                if (!this.isValidResourceName(strName)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specify valid Resource Name"));
                    return output;
                }
                resourceSpec = strName;
            } else if (strPath != null && !strPath.isEmpty()) {
                if (!this.isValidResourcePath(strPath)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Specify valid Resource Path"));
                    return output;
                }
                resourceSpec = strPath;
            }
            resourceUrn = IamSupportUtils.getResourceUrn((String)clusterGroup, (String)clusterName, (PolicyServerProto.ResourceType)resourceType, (String)resourceSpec);
        }
        if (resourceUrn != null && !resourceUrn.isEmpty()) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("ResourceURN", (Object)resourceUrn));
            return output;
        }
        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Resource Info"));
        return output;
    }

    private byte[] sendRequestToPolicyServer(int procId, MessageLite request, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Class<PolicyServerProto.IAMResourceActionListResponse> responseClass = null;
        byte[] data = null;
        switch (procId) {
            case 21: {
                responseClass = PolicyServerProto.IAMResourceActionListResponse.class;
                break;
            }
            default: {
                return data;
            }
        }
        if (responseClass == null) {
            LOG.error((Object)("Unknown procId for send requestuest " + procId));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unknown procId for send requestuest " + procId));
            return data;
        }
        try {
            data = PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(procId, request, responseClass);
        }
        catch (Exception exp) {
            throw new CLIProcessingException((Throwable)exp);
        }
        return data;
    }
}

