/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.table;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class TabletStats {
    private static final Logger LOG = Logger.getLogger(TabletStats.class);
    private static ExecutorService tabletStatRpcService = Executors.newFixedThreadPool(10);
    private Map<Dbserver.TabletDesc, Future<Dbserver.TabletStatResponse>> futureResponses;
    private String userId;
    private String path;

    public TabletStats(String path, String userId) {
        this.userId = userId;
        this.path = path;
    }

    public List<Dbserver.TabletDesc> getTablets(CommandOutput.OutputHierarchy out, int start, int limit) throws CLIProcessingException {
        return this.getTablets(out, start, limit, null);
    }

    public List<Dbserver.TabletDesc> getTablets(CommandOutput.OutputHierarchy out, int start, int limit, String indexFid) throws CLIProcessingException {
        ArrayList tablets = Lists.newArrayList();
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.userId);
        final MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        try {
            Dbserver.TabletDesc nextTablet;
            MapRTabletScanner scanner = mfs.getTabletScanner(new Path(this.path), indexFid);
            if (scanner.hasTotal()) {
                out.setTotal(scanner.getTotal());
            }
            while ((nextTablet = scanner.next()) != null) {
                if (start > 0) {
                    --start;
                    continue;
                }
                if (start == 0 && limit > 0) {
                    tablets.add(nextTablet);
                    --limit;
                    continue;
                }
                if (limit != 0) continue;
                break;
            }
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Failed to get list of regions for table: " + this.path + ". Reason: " + e.getMessage()));
            manager.deleteIfNotExist(this.path, mfs);
            return null;
        }
        this.futureResponses = Maps.newHashMap();
        for (final Dbserver.TabletDesc tablet : tablets) {
            this.futureResponses.put(tablet, tabletStatRpcService.submit(new Callable<Dbserver.TabletStatResponse>(){

                @Override
                public Dbserver.TabletStatResponse call() {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Fetching tablet stats for fid: " + MapRCliUtil.getFidAsString(tablet.getFid())));
                        }
                        return mfs.getTabletStat(new Path(TabletStats.this.path), tablet.getFid());
                    }
                    catch (Exception ioe) {
                        LOG.error((Object)("Error fetching tablet stats for fid: " + MapRCliUtil.getFidAsString(tablet.getFid())), (Throwable)ioe);
                        return null;
                    }
                }
            }));
        }
        return tablets;
    }

    public Dbserver.TabletStatResponse getTabletStatResponse(Dbserver.TabletDesc tablet) throws InterruptedException, ExecutionException {
        return this.futureResponses.get(tablet).get();
    }
}

