/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.Map;

public class CheckContainerRepl
extends CLIBaseClass
implements CLIInterface {
    public static final String CONTAINERS_PARAM_NAME = "containers";
    private static final int ERR_CODE_VOLUMES_LOSS = 150;
    private static final int ERR_CODE_METADATA_LOSS = 151;
    private static final int MAX_CONTAINERS_PER_LOOKUP = 100;
    static final CLICommand checkContainerReplCmd = new CLICommand("checkcontainerrepl", "", CheckContainerRepl.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"containers", (Object)new TextInputParameter("containers", "<comma-separated list of containers>", true, null)).build(), null).setUsageInVisible(true).setShortUsage("checkcontainerrepl -cluster <clustername> -containers <comma-separated list of containers>");

    public CheckContainerRepl(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private boolean containersLost(CommandOutput.OutputHierarchy out, CLDBProto.ContainerLookupRequest.Builder req) throws CLIProcessingException {
        try {
            byte[] data = null;
            if (this.isParamPresent("cluster")) {
                String clusterName = this.getParamTextValue("cluster", 0);
                if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(clusterName)) {
                    String msg = "Invalid cluster name " + clusterName;
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(133, msg));
                    return true;
                }
                data = CLDBRpcCommonUtils.getInstance().sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)req.build(), CLDBProto.ContainerLookupResponse.class);
            } else {
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)req.build(), CLDBProto.ContainerLookupResponse.class);
            }
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return true;
            }
            CLDBProto.ContainerLookupResponse resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])data);
            for (CLDBProto.ContainerInfo cinfo : resp.getContainersList()) {
                if (cinfo.getAServersCount() > 1) continue;
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("One or more volumes will be lost due to under replication of containers"));
                return true;
            }
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Exception while running command " + e.getMessage()));
            return true;
        }
        return false;
    }

    private void containersLost(CommandOutput.OutputHierarchy out, String[] containers) throws CLIProcessingException {
        CLDBProto.ContainerLookupRequest.Builder req = CLDBProto.ContainerLookupRequest.newBuilder().setCreds(this.getUserCredentials());
        int i = 0;
        while (i < containers.length) {
            req.addContainerId(Integer.parseInt(containers[i]));
            if (++i % 100 != 0) continue;
            if (this.containersLost(out, req)) {
                return;
            }
            req.clearContainerId();
        }
        if (req.getContainerIdCount() > 0) {
            this.containersLost(out, req);
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("checkcontainerrepl")) {
            String[] containers = this.getParamTextValue(CONTAINERS_PARAM_NAME, 0).split(",");
            if (containers == null || containers.length < 1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid list of containers"));
                return output;
            }
            this.containersLost(out, containers);
        }
        return output;
    }
}

