/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

class SortingEntity<K, E>
implements Comparable<SortingEntity<K, E>> {
    K key;
    E entity;
    KeyType keyType;

    SortingEntity(K k, E ent) throws IllegalArgumentException {
        this.key = k;
        this.entity = ent;
        if (this.key instanceof Integer) {
            this.keyType = KeyType.keyTypeInt;
        } else if (this.key instanceof Long) {
            this.keyType = KeyType.keyTypeLong;
        } else if (this.key instanceof Boolean) {
            this.keyType = KeyType.keyTypeBoolean;
        } else if (this.key instanceof String) {
            this.keyType = KeyType.keyTypeString;
        } else {
            throw new IllegalArgumentException("Unsupported key type:" + this.key.getClass().getName());
        }
    }

    @Override
    public int compareTo(SortingEntity<K, E> se2) {
        K k1 = this.key;
        K k2 = se2.key;
        if (k1 == null || k2 == null) {
            return this.compareObj(k1, k2);
        }
        switch (this.keyType) {
            case keyTypeInt: {
                return this.compareInteger(k1, k2);
            }
            case keyTypeLong: {
                return this.compareLong(k1, k2);
            }
            case keyTypeBoolean: {
                return this.compareBoolean(k1, k2);
            }
            case keyTypeString: {
                return this.compareString(k1, k2);
            }
        }
        return 0;
    }

    private int compareInteger(K k1, K k2) {
        Integer i1 = (Integer)k1;
        Integer i2 = (Integer)k2;
        return i1 - i2;
    }

    private int compareLong(K k1, K k2) {
        Long l1 = (Long)k1;
        Long l2 = (Long)k2;
        return l1.compareTo(l2);
    }

    private int compareString(K k1, K k2) {
        String s1 = (String)k1;
        String s2 = (String)k2;
        return s1.compareToIgnoreCase(s2);
    }

    private int compareBoolean(K k1, K k2) {
        Boolean b1 = (Boolean)k1;
        Boolean b2 = (Boolean)k2;
        return b1.compareTo(b2);
    }

    private int compareObj(K k1, K k2) {
        if (k1 == null && k1 == null) {
            return 0;
        }
        if (k1 == null) {
            return -1;
        }
        return 1;
    }

    static enum KeyType {
        keyTypeInvalid,
        keyTypeInt,
        keyTypeLong,
        keyTypeBoolean,
        keyTypeString;

    }
}

