/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.cli.DbCfColumnSecurityPolicyCommands;
import com.mapr.cli.DbCommands;
import com.mapr.cli.DynamicDataMaskCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRFsUtil;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DbCfColCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DbCfColCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String CFNAME_PARAM_NAME = "cfname";
    private static final String COLNAME_PARAM_NAME = "name";
    private static final String READ_PARAM_NAME = "readperm";
    private static final String WRITE_PARAM_NAME = "writeperm";
    private static final String APPEND_PARAM_NAME = "appendperm";
    private static final String ENCRYPT_PARAM_NAME = "encryptperm";
    private static final String TRAVERSE_PARAM_NAME = "traverseperm";
    private static final String UNMASKED_READ_PARAM_NAME = "unmaskedreadperm";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final int DEFAULT_TTL = Integer.MAX_VALUE;
    private static final CLICommand getCommand = new CLICommand("get", "usage: table cf colperm get -path <tablepath>", DbCfColCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "Column name", false, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).build(), null).setShortUsage("table cf colperm list -path <tablepath> -cfname <cf name>");
    private static final CLICommand setCommand = new CLICommand("set", "usage: table cf colperm set -path <tablepath> -cfname <cfname> -colname <column name> -traverse <traverse permission> -read <read permission> -write <write permission> -append <append permission> -encrypt <encrypt permission> (-traverse is supported for tables with tabletype=json only.)", DbCfColCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "Column name", true, null)).put((Object)"readperm", (Object)new TextInputParameter("readperm", "Read column permission settings", false, null)).put((Object)"unmaskedreadperm", (Object)new TextInputParameter("unmaskedreadperm", "Unmasked Read Permissions", false, null)).put((Object)"writeperm", (Object)new TextInputParameter("writeperm", "Write column permission settings", false, null)).put((Object)"appendperm", (Object)new TextInputParameter("appendperm", "Append column permission settings", false, null)).put((Object)"encryptperm", (Object)new TextInputParameter("encryptperm", "Encrypt column permission settings", false, null).setInvisible(true)).put((Object)"traverseperm", (Object)new TextInputParameter("traverseperm", "Traverse column permission settings", false, null)).build(), null).setShortUsage("table cf colperm create -path <tablepath> -cfname <cfname> -colname <column name> -traverse <traverse permission> -read <read permission> -write <write permission> -append <append permission> -encrypt <encrypt permission>");
    private static final CLICommand deleteCommand = new CLICommand("delete", "usage: table cf colperm delete -path <tablepath> -cfname <cfname> -colname <colname>", DbCfColCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "Column name", true, null)).build(), null).setShortUsage("table cf col delete -path <tablepath> -cfname <cfname> -colname <colname>");
    private static final CLICommand listCommand = new CLICommand("list", "usage: table cf column list -path <tablepath> -cfname <column family name> [-colname <colname>]", DbCfColCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Table path", true, null)).put((Object)"cfname", (Object)new TextInputParameter("cfname", "Column family name", true, null)).put((Object)"name", (Object)new TextInputParameter("name", "Column name", false, null)).build(), null).setShortUsage("table cf column list -path <tablepath> -cfname <column family name> [-colname <colname>]");
    public static final CLICommand cfColCommands = new CLICommand("colperm", "colperm [get|set|delete]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{getCommand, setCommand, deleteCommand}).setShortUsage("table cf colperm [get|set|delete]");
    public static final CLICommand cfColumnCommands = new CLICommand("column", "column [list|securitypolicy|datamask]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{listCommand, DbCfColumnSecurityPolicyCommands.DbCfColumnSecurityPolicyCommands, DynamicDataMaskCommands.DynamicDataMaskCommands}).setShortUsage("table cf column");
    private static final Map<String, String> verboseToTerseMap = new ImmutableMap.Builder().put((Object)"path", (Object)"p").put((Object)"cfname", (Object)"cfn").put((Object)"name", (Object)"n").put((Object)"read", (Object)"r").put((Object)"write", (Object)"w").put((Object)"append", (Object)"a").put((Object)"encrypt", (Object)"e").put((Object)"traverse", (Object)"t").put((Object)"securitypolicy", (Object)"sp").put((Object)"datamask", (Object)"dm").put((Object)"aces", (Object)"ace").put((Object)"readperm", (Object)"pread").put((Object)"unmaskedreadperm", (Object)"punmasked").put((Object)"writeperm", (Object)"pwrite").put((Object)"appendperm", (Object)"papp").put((Object)"traverseperm", (Object)"ptraverse").build();

    public DbCfColCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(setCommand.getCommandName())) {
            this.setCol(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(deleteCommand.getCommandName())) {
            this.deleteCol(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(getCommand.getCommandName())) {
            this.getCol(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(listCommand.getCommandName())) {
            this.listCol(out);
        }
        return output;
    }

    private void listCol(final CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws CLIProcessingException, IOException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    TableProperties tProp = mfs.getTableProperties(new Path(tablePath));
                    RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(DbCfColCommands.this.getUserLoginId());
                    boolean isJson = tProp.getAttr().getJson();
                    try {
                        String cfName = DbCfColCommands.this.getParamTextValue(DbCfColCommands.CFNAME_PARAM_NAME, 0);
                        Dbserver.ColumnFamilyAttr cfa = DbCfColCommands.getColumnFamily(tablePath, cfName);
                        if (cfa == null) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                            return;
                        }
                        Dbserver.SchemaFamily schemaFamily = cfa.getSchFamily();
                        if (schemaFamily != null) {
                            CommandOutput.OutputHierarchy.OutputNode cfNode = new CommandOutput.OutputHierarchy.OutputNode();
                            boolean found = false;
                            for (int i = 0; i < cfa.getColumnAttrCount(); ++i) {
                                Dbserver.ColumnAttr col = cfa.getColumnAttr(i);
                                CommandOutput.OutputHierarchy.OutputNode colNode = new CommandOutput.OutputHierarchy.OutputNode();
                                String qualifier = null;
                                qualifier = isJson && !cfName.equals("default") ? MapRFsUtil.getUnPrefixedColName((String)col.getQualifier().toStringUtf8()) : col.getQualifier().toStringUtf8();
                                if (DbCfColCommands.this.isParamPresent(DbCfColCommands.COLNAME_PARAM_NAME) && !qualifier.equals(DbCfColCommands.this.getParamTextValue(DbCfColCommands.COLNAME_PARAM_NAME, 0))) continue;
                                found = true;
                                colNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(DbCfColCommands.this.getOutputFieldName(DbCfColCommands.COLNAME_PARAM_NAME), (Object)qualifier));
                                CommandOutput.OutputHierarchy.OutputNode acesNode = new CommandOutput.OutputHierarchy.OutputNode();
                                for (Dbserver.AccessControlExpression ace : col.getAcesList()) {
                                    acesNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(DbCfColCommands.this.getOutputFieldName((String)AceHelper.colPermissionMap.get(ace.getAccessType())), (Object)AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8())));
                                }
                                colNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(DbCfColCommands.this.getOutputFieldName("aces"), (Object)acesNode));
                                if (isJson) {
                                    ArrayList securityPolicyTagsList = new ArrayList();
                                    if (col.hasSecurityPolicyIds()) {
                                        Dbserver.SecurityPolicyIds ids = col.getSecurityPolicyIds();
                                        Iterator iterator = ids.getIdsList().iterator();
                                        while (iterator.hasNext()) {
                                            int j = (Integer)iterator.next();
                                            CommandOutput.OutputHierarchy.OutputNode spNode = new CommandOutput.OutputHierarchy.OutputNode(DbCfColCommands.this.getOutputFieldName("securitypolicy"), (Object)mfs.getSecurityPolicyName(j));
                                            spNode.setTreatSingleChildAsPeer(true);
                                            colNode.addNode(spNode);
                                        }
                                    }
                                    String dataMaskName = "";
                                    if (col.hasDataMaskId()) {
                                        int dataMaskId = col.getDataMaskId();
                                        dataMaskName = mfs.getDataMaskNameFromId(dataMaskId);
                                    }
                                    colNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(DbCfColCommands.this.getOutputFieldName("datamask"), (Object)dataMaskName));
                                }
                                CommandOutput.OutputHierarchy.OutputNode newNode = new CommandOutput.OutputHierarchy.OutputNode(DbCfColCommands.this.getOutputFieldName("columnAttr"), (Object)colNode);
                                newNode.setTreatSingleChildAsPeer(true);
                                cfNode.addNode(newNode);
                                out.addNode(cfNode);
                            }
                            if (!found && DbCfColCommands.this.isParamPresent(DbCfColCommands.COLNAME_PARAM_NAME)) {
                                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column '" + DbCfColCommands.this.getParamTextValue(DbCfColCommands.COLNAME_PARAM_NAME, 0) + "' is not defined for table '" + tablePath + "' in cf ' " + cfName + "'."));
                                return;
                            }
                        } else {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                            return;
                        }
                        manager.moveToTop(tablePath);
                    }
                    catch (IOException e) {
                        manager.deleteIfNotExist(tablePath, mfs);
                        throw e;
                    }
                    catch (CLIProcessingException e) {
                        throw e;
                    }
                }
            };
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
    }

    private void setCol(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        Dbserver.ColumnFamilyAttr cfAttr = null;
        Dbserver.SchemaFamily schFamily = null;
        String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
        String colName = null;
        TableProperties tableProp = null;
        boolean isJson = false;
        try {
            tableProp = mfs.getTableProperties(new Path(tablePath));
            isJson = tableProp.getAttr().getJson();
            colName = isJson && !cfName.equals("default") ? MapRFsUtil.getPrefixedColName((String)this.getParamTextValue(COLNAME_PARAM_NAME, 0)) : this.getParamTextValue(COLNAME_PARAM_NAME, 0);
            ByteString colByteName = ByteString.copyFromUtf8((String)colName);
            cfAttr = DbCfColCommands.getColumnFamily(tablePath, cfName);
            if (cfAttr == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                return;
            }
            schFamily = cfAttr.getSchFamily();
            if (schFamily == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Column family " + cfName + " not found under Table " + tablePath));
                return;
            }
            ArrayList ace = AceHelper.getColumnPermission((AceHelper.DBPermission)this);
            Dbserver.ColumnFamilyAttr.Builder cfBuilder = cfAttr.toBuilder();
            int index = this.findColumnPos(colByteName, cfAttr.getColumnAttrList());
            if (index == -1) {
                Dbserver.ColumnAttr.Builder builder = Dbserver.ColumnAttr.newBuilder();
                builder.setQualifier(colByteName);
                if (ace.size() > 0) {
                    builder.addAllAces((Iterable)ace);
                }
                cfBuilder.addColumnAttr(builder.build());
            } else {
                HashMap<Dbserver.DBAccessType, Dbserver.AccessControlExpression> col = new HashMap<Dbserver.DBAccessType, Dbserver.AccessControlExpression>();
                Dbserver.ColumnAttr cAttr = cfBuilder.getColumnAttr(index);
                for (Dbserver.AccessControlExpression a : cAttr.getAcesList()) {
                    col.put(a.getAccessType(), a);
                }
                for (Dbserver.AccessControlExpression a : ace) {
                    col.put(a.getAccessType(), a);
                }
                Dbserver.ColumnAttr.Builder builder = cAttr.toBuilder().clearAces().addAllAces(col.values());
                cfBuilder.setColumnAttr(index, builder.build());
            }
            Dbserver.ColumnFamilyAttr newCfAttr = cfBuilder.clearAces().clearSchFamily().clearJsonFamilyPath().build();
            this.modifyColumnSettings(tablePath, cfName, newCfAttr, out);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
    }

    private void deleteCol(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
        String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
        TableProperties tableProp = null;
        boolean isJson = false;
        String colName = null;
        ByteString colByteName = null;
        try {
            tableProp = mfs.getTableProperties(new Path(tablePath));
            isJson = tableProp.getAttr().getJson();
            colName = isJson && !cfName.equals("default") ? MapRFsUtil.getPrefixedColName((String)this.getParamTextValue(COLNAME_PARAM_NAME, 0)) : this.getParamTextValue(COLNAME_PARAM_NAME, 0);
            colByteName = ByteString.copyFromUtf8((String)colName);
            Dbserver.ColumnFamilyAttr cfAttr = DbCfColCommands.getColumnFamily(tablePath, cfName);
            int pos = this.findColumnPos(colByteName, cfAttr.getColumnAttrList());
            if (pos == -1) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Column " + colName + " not found in " + cfName + " ColumnFamily under Table " + tablePath));
                return;
            }
            Dbserver.ColumnAttr.Builder builder = cfAttr.getColumnAttr(pos).toBuilder();
            builder.clearAces();
            cfAttr = cfAttr.toBuilder().setColumnAttr(pos, builder.build()).clearAces().clearSchFamily().clearJsonFamilyPath().build();
            this.modifyColumnSettings(tablePath, cfName, cfAttr, out);
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
    }

    private void getCol(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        block9: {
            final String tablePath = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
            String cfName = this.getParamTextValue(CFNAME_PARAM_NAME, 0);
            TableProperties tableProp = null;
            boolean isJson = false;
            final ArrayList tablePropList = new ArrayList();
            try {
                new FileclientRun(this.getUserLoginId()){

                    @Override
                    public void runAsProxyUser() throws IOException, CLIProcessingException {
                        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(DbCfColCommands.this.getUserLoginId());
                        try {
                            TableProperties tProp = null;
                            tProp = mfs.getTableProperties(new Path(tablePath));
                            tablePropList.add(tProp);
                            manager.moveToTop(tablePath);
                        }
                        catch (IOException e) {
                            manager.deleteIfNotExist(tablePath, mfs);
                            throw e;
                        }
                    }
                };
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
                return;
            }
            tableProp = (TableProperties)tablePropList.get(0);
            try {
                ByteString colName = null;
                isJson = tableProp.getAttr().getJson();
                Dbserver.ColumnFamilyAttr cfAttr = DbCfColCommands.getColumnFamily(tablePath, cfName);
                Dbserver.SchemaFamily cf = cfAttr.getSchFamily();
                if (cf != null) {
                    boolean cfPrefix;
                    boolean bl = cfPrefix = isJson && !cfName.equals("default");
                    if (this.isParamPresent(COLNAME_PARAM_NAME)) {
                        String colNameStr = this.getParamTextValue(COLNAME_PARAM_NAME, 0);
                        colName = cfPrefix ? ByteString.copyFromUtf8((String)MapRFsUtil.getPrefixedColName((String)colNameStr)) : ByteString.copyFromUtf8((String)colNameStr);
                    }
                    for (int i = 0; i < cfAttr.getColumnAttrCount(); ++i) {
                        Dbserver.ColumnAttr col = cfAttr.getColumnAttr(i);
                        if (col.getAcesCount() <= 0 || colName != null && !colName.equals((Object)col.getQualifier())) continue;
                        CommandOutput.OutputHierarchy.OutputNode colNode = new CommandOutput.OutputHierarchy.OutputNode();
                        String postFixCF = cfPrefix ? MapRFsUtil.getUnPrefixedColName((String)col.getQualifier().toStringUtf8()) : col.getQualifier().toStringUtf8();
                        colNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(COLNAME_PARAM_NAME), (Object)postFixCF));
                        for (Dbserver.AccessControlExpression ace : col.getAcesList()) {
                            colNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName((String)AceHelper.colPermissionMap.get(ace.getAccessType())), (Object)AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8())));
                        }
                        out.addNode(colNode);
                    }
                    break block9;
                }
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10005, "Column family '" + cfName + "' is not defined for table '" + tablePath + "'."));
                return;
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                return;
            }
        }
    }

    public void modifyColumnSettings(final String tablePath, final String cfName, Dbserver.ColumnFamilyAttr cfAttr, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        if (cfAttr != null) {
            try {
                Dbserver.ColumnFamilyAttr.Builder cfBuilder = cfAttr.toBuilder();
                int colAttrCount = cfAttr.getColumnAttrCount();
                for (int i = 0; i < colAttrCount; ++i) {
                    Dbserver.ColumnAttr tmpColAttr = cfAttr.getColumnAttr(i);
                    Dbserver.ColumnAttr.Builder tmpBuilder = tmpColAttr.toBuilder().clearSecurityPolicyIds().clearDataMaskId();
                    cfBuilder.setColumnAttr(i, tmpBuilder.build());
                }
                final Dbserver.ColumnFamilyAttr newCfAttr = cfBuilder.build();
                new FileclientRun(this.getUserLoginId()){

                    @Override
                    public void runAsProxyUser() throws IOException, CLIProcessingException {
                        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                        RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(DbCfColCommands.this.getUserLoginId());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Attempting to modify column settings -> Path: " + tablePath + ", CfName: " + cfName));
                        }
                        try {
                            mfs.modifyColumnFamily(new Path(tablePath), cfName, newCfAttr);
                            manager.moveToTop(tablePath);
                        }
                        catch (IOException e) {
                            manager.deleteIfNotExist(tablePath, mfs);
                            throw e;
                        }
                    }
                };
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            }
        }
    }

    private int findColumnPos(ByteString colName, List<Dbserver.ColumnAttr> colPerm) {
        int i = 0;
        if (colPerm != null) {
            for (Dbserver.ColumnAttr cp : colPerm) {
                if (cp.getQualifier().equals((Object)colName)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private static Dbserver.ColumnFamilyAttr getColumnFamily(String tablePath, String cfName) throws IOException, CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for column family " + cfName));
        }
        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
        for (Dbserver.ColumnFamilyAttr cf : mfs.listColumnFamily(new Path(tablePath), true)) {
            if (!cf.getSchFamily().getName().equals(cfName)) continue;
            return cf;
        }
        return null;
    }

    private String getOutputFieldName(String verboseName) throws CLIProcessingException {
        if (this.isParamPresent(OUTPUT_PARAM_NAME) && "terse".equals(this.getParamTextValue(OUTPUT_PARAM_NAME, 0))) {
            return verboseToTerseMap.get(verboseName);
        }
        return verboseName;
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key)) {
                ret = this.getParamTextValue(key, 0);
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }
}

