/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class KeyServiceCommands
extends CLIBaseClass
implements CLIInterface {
    public static final String KEYSERVICE_PARAM_NAME = "keys";
    public static final String CREDS_PARAM_NAME = "creds";
    public static final String STATUS_PARAM_NAME = "status";
    public static final String STATUS_USAGE = "status";
    public static final String LIST_PARAM_NAME = "list";
    public static final String LIST_USAGE = "list";
    public static final String URL_PARAM_NAME = "url";
    public static final String REGISTER_URL_PARAM_NAME = "registerUrl";
    public static final String RENEWCREDS_URL_PARAM_NAME = "renewCredsUrl";
    public static final String PROXY_URL_PARAM_NAME = "proxyUrl";
    public static final String DEV_URLS_PARAM_NAME = "devUrls";
    public static final String urlUsage = "url [-registerUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]";
    public static final String keysUsage = "keys creds {status | list | url [-registerUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]}";
    private static final Logger LOG = Logger.getLogger(KeyServiceCommands.class);
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static final CLICommand statusSubCommand = new CLICommand("status", "status", KeyServiceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("status");
    public static final CLICommand listSubCommand = new CLICommand("list", "list", KeyServiceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("list");
    public static final CLICommand urlSubCommand = new CLICommand("url", "url [-registerUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]", KeyServiceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"registerUrl", (Object)new TextInputParameter("registerUrl", "<register-url>", false, null)).put((Object)"renewCredsUrl", (Object)new TextInputParameter("renewCredsUrl", "<renew-creds-url>", false, null)).put((Object)"proxyUrl", (Object)new TextInputParameter("proxyUrl", "<proxy-url>", false, null)).put((Object)"devUrls", (Object)new BooleanInputParameter("devUrls", "urls for dev billing cluster", false, Boolean.valueOf(false)).setInvisible(true)).build(), null).setShortUsage("url [-registerUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]");
    public static final CLICommand credsCommand = new CLICommand("creds", "creds commands", KeyServiceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), new CLICommand[]{statusSubCommand, listSubCommand, urlSubCommand}).setShortUsage("keys creds {status | list | url [-registerUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]}");
    public static final CLICommand keysCommand = new CLICommand("keys", "keys commands", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{credsCommand}).setShortUsage("keys creds {status | list | url [-registerUrl <url> | -renewCredsUrl <url> | -proxyUrl <url> ]}");

    public KeyServiceCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    private String epochSecsToStr(long secs) {
        if (secs == 0L) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
        dateFormat.setTimeZone(TimeZone.getDefault());
        String retStr = dateFormat.format(new Date(secs * 1000L));
        return retStr;
    }

    private void getKeysStatus(CommandOutput.OutputHierarchy out, String cluster) throws CLIProcessingException {
        LOG.info((Object)"Inside getKeysStatus");
        CLDBProto.KeysStatusResponse resp = null;
        CLDBProto.KeysStatusRequest.Builder req = CLDBProto.KeysStatusRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.KeysStatusProc.getNumber(), (MessageLite)req.build(), CLDBProto.KeysStatusResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.KeysStatusProc.getNumber(), (MessageLite)req.build(), CLDBProto.KeysStatusResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.KeysStatusResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            String errMsg = Errno.toString((int)resp.getStatus());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Getting usage status failed. " + errMsg));
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode usageStatusNode = new CommandOutput.OutputHierarchy.OutputNode(KEYSERVICE_PARAM_NAME);
        if (resp.hasClusterId()) {
            usageStatusNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("clusterId", (Object)resp.getClusterId()));
        }
        if (resp.hasKeysStatus()) {
            CLDBProto.KeysStatus rs = resp.getKeysStatus();
            String smState = "";
            switch (rs.getSmState()) {
                case KS_WAITING_FOR_LICENSE: {
                    smState = "Waiting for License";
                    break;
                }
                case KS_REGISTRATION: {
                    smState = "Registration";
                    break;
                }
                case KS_UPLOAD_USAGE: {
                    smState = "Upload Usage";
                    break;
                }
                case KS_RENEW_CREDS: {
                    smState = "Renew Creds";
                    break;
                }
                default: {
                    smState = "NONE";
                }
            }
            CommandOutput.OutputHierarchy.OutputNode urNode = new CommandOutput.OutputHierarchy.OutputNode(KEYSERVICE_PARAM_NAME);
            urNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("enabled", (Object)(rs.getEnabled() ? "yes" : "no")));
            String mode = "NA";
            if (rs.hasUsageMode()) {
                if (rs.getUsageMode() == CLDBProto.ClusterUsageMode.AirgappedCluster) {
                    mode = "airgapped";
                }
                if (rs.getUsageMode() == CLDBProto.ClusterUsageMode.ConnectedCluster) {
                    mode = "connected";
                }
            }
            urNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("mode", (Object)mode));
            urNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("credsState", (Object)smState));
            CommandOutput.OutputHierarchy.OutputNode regNode = new CommandOutput.OutputHierarchy.OutputNode("registration");
            CommandOutput.OutputHierarchy.OutputNode upload = new CommandOutput.OutputHierarchy.OutputNode("upload");
            CommandOutput.OutputHierarchy.OutputNode renew = new CommandOutput.OutputHierarchy.OutputNode("renew");
            CommandOutput.OutputHierarchy.OutputNode http = new CommandOutput.OutputHierarchy.OutputNode("httpStatus");
            if (rs.hasRegUrl()) {
                regNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("regUrl", (Object)rs.getRegUrl()));
            }
            if (rs.hasNumRegAttempts()) {
                regNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("numRegAttempts", rs.getNumRegAttempts()));
            }
            if (rs.hasLastRegAttemptEpochSecs()) {
                regNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastRegAttempt", (Object)this.epochSecsToStr(rs.getLastRegAttemptEpochSecs())));
            }
            if (rs.hasRegTimeEpochSecs()) {
                regNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("regTime", (Object)this.epochSecsToStr(rs.getRegTimeEpochSecs())));
            }
            if (rs.hasUploadUrl()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("uploadUrl", (Object)rs.getUploadUrl()));
            }
            if (rs.hasNumUploadAttempts()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("numUploadAttempts", rs.getNumUploadAttempts()));
            }
            if (rs.hasNumUploads()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("numUploads", rs.getNumUploads()));
            }
            if (rs.hasLastUploadAttemptEpochSecs()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastUploadAttempt", (Object)this.epochSecsToStr(rs.getLastUploadAttemptEpochSecs())));
            }
            if (rs.hasLastUploadTimeEpochSecs()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastUploadTime", (Object)this.epochSecsToStr(rs.getLastUploadTimeEpochSecs())));
            }
            if (rs.hasLastUsageTimeReportedEpochSecs()) {
                upload.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastReportedUsageTime", (Object)this.epochSecsToStr(rs.getLastUsageTimeReportedEpochSecs())));
            }
            if (rs.hasRenewUrl()) {
                renew.addNode(new CommandOutput.OutputHierarchy.OutputNode("renewUrl", (Object)rs.getRenewUrl()));
            }
            if (rs.hasNumRenewAttempts()) {
                renew.addNode(new CommandOutput.OutputHierarchy.OutputNode("numRenewAttempts", rs.getNumRenewAttempts()));
            }
            if (rs.hasLastRenewAttemptEpochSecs()) {
                renew.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastRenewAttempt", (Object)this.epochSecsToStr(rs.getLastRenewAttemptEpochSecs())));
            }
            if (rs.hasLastRenewTimeEpochSecs()) {
                renew.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastRenewTime", (Object)this.epochSecsToStr(rs.getLastRenewTimeEpochSecs())));
            }
            if (rs.hasNumRenews()) {
                renew.addNode(new CommandOutput.OutputHierarchy.OutputNode("numRenews", rs.getNumRenews()));
            }
            if (rs.hasHttpRequestInProgress()) {
                http.addNode(new CommandOutput.OutputHierarchy.OutputNode("requestInProgress", (Object)rs.getHttpRequestInProgress()));
            }
            if (rs.hasLastHttpStatus()) {
                http.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastHttpStatus", rs.getLastHttpStatus()));
            }
            if (rs.hasLastHttpReason()) {
                http.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastHttpReason", (Object)rs.getLastHttpReason()));
            }
            if (rs.hasLastHttpErrTime()) {
                http.addNode(new CommandOutput.OutputHierarchy.OutputNode("lastHttpRespTime", (Object)this.epochSecsToStr(rs.getLastHttpErrTime())));
            }
            urNode.addChild(regNode);
            urNode.addChild(renew);
            urNode.addChild(http);
            if (rs.hasNumConsFailures()) {
                urNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("numCscFailures", rs.getNumConsFailures()));
            }
            if (rs.hasProxyUrl()) {
                urNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(PROXY_URL_PARAM_NAME, (Object)rs.getProxyUrl()));
            }
            usageStatusNode.addChild(urNode);
        }
        out.addNode(usageStatusNode);
    }

    private void getCredsList(CommandOutput.OutputHierarchy out, String cluster) throws CLIProcessingException {
        LOG.info((Object)"Inside getKeysCreds");
        CLDBProto.KeysCredsResponse resp = null;
        CLDBProto.KeysCredsRequest.Builder req = CLDBProto.KeysCredsRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.KeysCredsProc.getNumber(), (MessageLite)req.build(), CLDBProto.KeysCredsResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.KeysCredsProc.getNumber(), (MessageLite)req.build(), CLDBProto.KeysCredsResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.KeysCredsResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            String errMsg = Errno.toString((int)resp.getStatus());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Getting keys creds failed. " + errMsg));
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode credsNode = new CommandOutput.OutputHierarchy.OutputNode(CREDS_PARAM_NAME);
        if (resp.hasClusterId()) {
            credsNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("clusterId", (Object)resp.getClusterId()));
        }
        if (resp.hasKeysCreds()) {
            CLDBProto.KeysCreds creds = resp.getKeysCreds();
            if (creds.hasClientId()) {
                credsNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("clientId", (Object)creds.getClientId()));
            } else {
                credsNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("clientId", (Object)""));
            }
            if (creds.hasClientSecret()) {
                credsNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("clientSecret", (Object)creds.getClientSecret()));
            } else {
                credsNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("clientSecret", (Object)""));
            }
            credsNode.addNode(new CommandOutput.OutputHierarchy.OutputNode("createTime", (Object)this.epochSecsToStr(creds.getCredsCreateTime())));
        }
        out.addNode(credsNode);
    }

    private void updateUrl(CommandOutput.OutputHierarchy out, String cluster) throws CLIProcessingException {
        CLDBProto.KeysUrlInfo.Builder exportUrlInfo = CLDBProto.KeysUrlInfo.newBuilder();
        CLDBProto.KeysUrlModifyRequest.Builder req = CLDBProto.KeysUrlModifyRequest.newBuilder();
        CLDBProto.KeysUrlModifyResponse resp = null;
        boolean registerParamPresent = this.isParamPresent(REGISTER_URL_PARAM_NAME);
        boolean renewCredsParamPresent = this.isParamPresent(RENEWCREDS_URL_PARAM_NAME);
        boolean proxyParamPresent = this.isParamPresent(PROXY_URL_PARAM_NAME);
        boolean devUrlsParamPresent = this.isParamPresent(DEV_URLS_PARAM_NAME);
        boolean urlChanged = false;
        LOG.info((Object)("reg: " + registerParamPresent + ", renew: " + renewCredsParamPresent + ", proxy: " + proxyParamPresent + ", devUrls: " + devUrlsParamPresent));
        if (registerParamPresent) {
            String registerUrl = this.getParamTextValue(REGISTER_URL_PARAM_NAME, 0);
            exportUrlInfo.setRegisterUrl(registerUrl);
            urlChanged = true;
        }
        if (renewCredsParamPresent) {
            String renewCredsUrl = this.getParamTextValue(RENEWCREDS_URL_PARAM_NAME, 0);
            exportUrlInfo.setRenewCredsUrl(renewCredsUrl);
            urlChanged = true;
        }
        if (proxyParamPresent) {
            String proxyUrl = this.getParamTextValue(PROXY_URL_PARAM_NAME, 0);
            exportUrlInfo.setProxyUrl(proxyUrl);
            urlChanged = true;
        }
        boolean devUrls = false;
        if (devUrlsParamPresent) {
            devUrls = this.getParamBooleanValue(DEV_URLS_PARAM_NAME, 0);
            urlChanged = true;
            exportUrlInfo.setDevUrls(devUrls);
            if (devUrls && (registerParamPresent || renewCredsParamPresent)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot provider register, or renew urls when devUrls is provided."));
                return;
            }
        }
        if (!urlChanged) {
            return;
        }
        req.setCreds(this.getUserCredentials());
        req.setKeysUrlInfo(exportUrlInfo.build());
        byte[] data = null;
        try {
            data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.KeysUrlModifyProc.getNumber(), (MessageLite)req.build(), CLDBProto.KeysUrlModifyResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.KeysUrlModifyProc.getNumber(), (MessageLite)req.build(), CLDBProto.KeysUrlModifyResponse.class);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.KeysUrlModifyResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        out.addMessage("key service urls updated successfully! ");
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        String cluster = null;
        Object credentials = null;
        String fileName = "NONE";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ExecuteRealCommand" + this.cliCommand.getCommandName()));
        }
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        String cmd = this.cliCommand.getCommandName();
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
        }
        boolean statusParamPresent = this.isParamPresent("status");
        boolean urlParamPresent = this.isParamPresent(URL_PARAM_NAME);
        boolean listParamPresent = this.isParamPresent("list");
        Object outNode = null;
        boolean parseErr = false;
        try {
            if (statusParamPresent) {
                this.getKeysStatus(out, cluster);
            } else if (urlParamPresent) {
                this.updateUrl(out, cluster);
            } else if (listParamPresent) {
                this.getCredsList(out, cluster);
            } else {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid key service parameter"));
            }
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception in key service", (Throwable)e);
        }
        return output;
    }
}

