/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.policyserverutils.PolicyServerRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.fs.Rpc;
import com.mapr.fs.policyserver.iam.IamSupportUtils;
import com.mapr.fs.proto.PolicyServerProto;
import com.mapr.fs.proto.Security;
import com.mapr.security.IamRolesHelper;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IamTaskCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(IamTaskCommands.class);
    private static final String IAM_TASK_TASKID_PARAM = "id";
    private static final String IAM_TASK_CLUSTER_PARAM = "cluster";
    private static final String IAM_TASK_POLICY_PARAM = "policy";
    private static final String IAM_TASK_TASKSTATUS_PARAM = "status";
    private static final String IAM_TASK_TASKID_REGEX = "^[0-9]+.[0-9]+.[0-9]+$";
    Security.CredentialsMsg creds;
    private static Map<PolicyServerProto.IamResourceTaskInfoFields, FieldInfo> fieldTable = new ImmutableMap.Builder().put((Object)PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskId, (Object)new FieldInfo(PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskId.getNumber(), "id", "Id", String.class)).put((Object)PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskStatus, (Object)new FieldInfo(PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskStatus.getNumber(), "status", "Status", String.class)).put((Object)PolicyServerProto.IamResourceTaskInfoFields.iamResourceSpecInfo, (Object)new FieldInfo(PolicyServerProto.IamResourceTaskInfoFields.iamResourceSpecInfo.getNumber(), "resc", "Resource", String.class)).put((Object)PolicyServerProto.IamResourceTaskInfoFields.iamResourceAccessType, (Object)new FieldInfo(PolicyServerProto.IamResourceTaskInfoFields.iamResourceAccessType.getNumber(), "type", "Type", String.class)).put((Object)PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskUsers, (Object)new FieldInfo(PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskUsers.getNumber(), "u", "Users", String.class)).put((Object)PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskGroups, (Object)new FieldInfo(PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskGroups.getNumber(), "g", "Groups", String.class)).put((Object)PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskRoles, (Object)new FieldInfo(PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskRoles.getNumber(), "r", "Roles", String.class)).build();
    private static Map<String, BaseInputParameter> taskIdParam = new ImmutableMap.Builder().put((Object)"id", (Object)new TextInputParameter("id", "<Task ID>", true, null)).build();
    private static final String getIamTaskInfoUsage = "task info -id <Task ID>";
    private static final CLICommand getIamTaskInfoCommand = new CLICommand("info", "", IamTaskCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(taskIdParam).build(), null).setShortUsage("task info -id <Task ID>");
    private static Map<String, BaseInputParameter> clusterNameParam = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "<Cluster Name>", false, null)).build();
    private static Map<String, BaseInputParameter> policyNameParam = new ImmutableMap.Builder().put((Object)"policy", (Object)new TextInputParameter("policy", "<Policy Name>", false, null)).build();
    private static Map<String, BaseInputParameter> taskStatusParam = new ImmutableMap.Builder().put((Object)"status", (Object)new TextInputParameter("status", "<Task Status>", false, null)).build();
    private static final String getIamTaskListUsage = "task list [ -cluster <Cluster Name> | -policy <Policy Name> | -status <Task Status> ]";
    public static final CLICommand getIamTaskListCommand = new CLICommand("list", "", IamTaskCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(clusterNameParam).putAll(policyNameParam).putAll(taskStatusParam).build(), null).setShortUsage("task list [ -cluster <Cluster Name> | -policy <Policy Name> | -status <Task Status> ]");
    private static final String setIamTaskAbortUsage = "task abort -id <Task ID>";
    private static final CLICommand setIamTaskAbortCommand = new CLICommand("abort", "", IamTaskCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(taskIdParam).build(), null).setShortUsage("task abort -id <Task ID>");
    public static final CLICommand IamTaskCommands = new CLICommand("task", "", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{getIamTaskInfoCommand, getIamTaskListCommand, setIamTaskAbortCommand}).setShortUsage("task [info|list|abort]");
    private ProcessedInput processedInput;
    private CLICommand cliCommand;
    private UnixUserGroupHelper uugh;
    private IamRolesHelper imrh;
    private String cluster;

    public IamTaskCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
        this.processedInput = input;
        this.cliCommand = cliCommand;
    }

    void initialize() throws CLIProcessingException {
        try {
            this.creds = this.getUserCredentials();
            this.cluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
            this.uugh = new UnixUserGroupHelper();
            this.imrh = new IamRolesHelper(this.cluster);
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Error in RPC initialize");
            }
        }
        catch (Exception exp) {
            LOG.error((Object)("Exception while initializing RPC " + exp));
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        this.initialize();
        String cmdName = this.cliCommand.getCommandName();
        if (cmdName.equalsIgnoreCase("info")) {
            try {
                return this.getIamTaskInfo();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Get IAM Task Info Exception", (Throwable)e);
            }
        }
        if (cmdName.equalsIgnoreCase("list")) {
            try {
                return this.getIamTaskList();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Get IAM Task List Exception", (Throwable)e);
            }
        }
        if (cmdName.equalsIgnoreCase("abort")) {
            try {
                return this.abortIamTask();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Abort IAM Task Exception", (Throwable)e);
            }
        }
        return new TextCommandOutput("Iam Task command failed".getBytes());
    }

    private String getTaskId() throws CLIProcessingException {
        return this.isParamPresent(IAM_TASK_TASKID_PARAM) ? this.getParamTextValue(IAM_TASK_TASKID_PARAM, 0) : null;
    }

    private boolean isValidTaskId(String taskId) {
        return taskId.matches(IAM_TASK_TASKID_REGEX);
    }

    private CommandOutput getIamTaskInfo() throws Exception, CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String strFmt = "<POLICY-ID>.<STATEMENT-ID>.<SEQUENCE-ID>";
        String taskId = this.getTaskId();
        if (taskId == null || taskId.isEmpty() || !this.isValidTaskId(taskId)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid IAM Task ID, Expected format: " + strFmt));
            return output;
        }
        byte[] data = null;
        PolicyServerProto.IAMResourceTaskInfoRequest req = PolicyServerProto.IAMResourceTaskInfoRequest.newBuilder().setCreds(this.getUserCredentials()).setTaskId(taskId).build();
        data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IAMResourceTaskInfoProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IAMResourceTaskInfoResponse resp = PolicyServerProto.IAMResourceTaskInfoResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            PolicyServerProto.ResourceTaskInfoMsg taskInfo = resp.getTaskInfo();
            if (taskInfo != null) {
                CommandOutput.OutputHierarchy.OutputNode nodeInfo = this.formatResourceTaskInfo(taskInfo, true);
                out.addNode(nodeInfo);
            }
        } else {
            String errMsg = "Failed to get info for IAM Task '" + taskId + "'";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + " error: " + resp.getErrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
        return output;
    }

    private CommandOutput getIamTaskList() throws Exception, CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        PolicyServerProto.IAMResourceTaskListRequest.Builder req = PolicyServerProto.IAMResourceTaskListRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        if (this.isParamPresent(IAM_TASK_CLUSTER_PARAM)) {
            String clusterName = this.getParamTextValue(IAM_TASK_CLUSTER_PARAM, 0);
            if (clusterName == null || clusterName.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Cluster Name"));
                return output;
            }
            req.setCluster(clusterName);
        } else if (this.isParamPresent(IAM_TASK_POLICY_PARAM)) {
            String policyName = this.getParamTextValue(IAM_TASK_POLICY_PARAM, 0);
            if (policyName == null || policyName.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Policy Name"));
                return output;
            }
            req.setPolicy(policyName);
        } else if (this.isParamPresent(IAM_TASK_TASKSTATUS_PARAM)) {
            String strStatus = this.getParamTextValue(IAM_TASK_TASKSTATUS_PARAM, 0);
            if (strStatus == null || strStatus.isEmpty()) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Task Status. Expected values: " + IamSupportUtils.getResourceTaskStatusList().toString()));
                return output;
            }
            PolicyServerProto.ResourceTaskStatus taskStatus = IamSupportUtils.getResponseTaskStatus((String)strStatus);
            if (taskStatus == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid Task Status. Expected values: " + IamSupportUtils.getResourceTaskStatusList().toString()));
                return output;
            }
            req.setStatus(taskStatus);
        }
        byte[] data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IAMResourceTaskListProc.getNumber(), (MessageLite)req.build(), out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IAMResourceTaskListResponse resp = PolicyServerProto.IAMResourceTaskListResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            for (PolicyServerProto.ResourceTaskInfoMsg taskInfo : resp.getTaskInfoList()) {
                CommandOutput.OutputHierarchy.OutputNode nodeInfo = this.formatResourceTaskInfo(taskInfo, false);
                out.addNode(nodeInfo);
            }
        } else {
            Object errMsg = "Failed to get list of IAM Tasks";
            if (resp.hasErrMsg()) {
                errMsg = (String)errMsg + " error: " + resp.getErrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), (String)errMsg));
        }
        return output;
    }

    private CommandOutput abortIamTask() throws Exception, CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String strFmt = "<POLICY-ID>.<STATEMENT-ID>.<SEQUENCE-ID>";
        String taskId = this.getTaskId();
        if (taskId == null || taskId.isEmpty() || !this.isValidTaskId(taskId)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid IAM Task ID, Expected format: " + strFmt));
            return output;
        }
        byte[] data = null;
        PolicyServerProto.IAMResourceTaskAbortRequest req = PolicyServerProto.IAMResourceTaskAbortRequest.newBuilder().setCreds(this.getUserCredentials()).setTaskId(taskId).build();
        data = this.sendRequestToPolicyServer(PolicyServerProto.SecurityPolicyProc.IAMResourceTaskAbortProc.getNumber(), (MessageLite)req, out);
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to send RPC to Policy Sever"));
            return output;
        }
        PolicyServerProto.IAMResourceTaskAbortResponse resp = PolicyServerProto.IAMResourceTaskAbortResponse.parseFrom((byte[])data);
        if (resp.getStatus() == 0) {
            out.addMessage("IAM Task '" + taskId + "' aborted successfully");
        } else {
            String errMsg = "Failed to abort IAM Task '" + taskId + "'";
            if (resp.hasErrMsg()) {
                errMsg = errMsg + " error: " + resp.getErrMsg();
            }
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errMsg));
        }
        return output;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatResourceTaskInfo(PolicyServerProto.ResourceTaskInfoMsg taskInfo, boolean verboseInfo) {
        CommandOutput.OutputHierarchy.OutputNode output = new CommandOutput.OutputHierarchy.OutputNode();
        PolicyServerProto.ResourceTaskRequest taskRequest = taskInfo.getTaskRequest();
        PolicyServerProto.ResourceTaskStatus taskStatus = taskInfo.getTaskStatus();
        if (taskRequest.hasTaskId()) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskId).getName(false), (Object)taskRequest.getTaskId()));
        }
        if (taskRequest.hasResource()) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IamResourceTaskInfoFields.iamResourceSpecInfo).getName(false), (Object)IamSupportUtils.getResourceUrn((PolicyServerProto.ResourceInfoMsg)taskRequest.getResource())));
        }
        if (taskStatus != null) {
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskStatus).getName(false), (Object)IamSupportUtils.getResourceTaskStatus((PolicyServerProto.ResourceTaskStatus)taskStatus)));
        }
        if (verboseInfo) {
            if (taskRequest.hasType()) {
                output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IamResourceTaskInfoFields.iamResourceAccessType).getName(false), (Object)taskRequest.getType().toString()));
            }
            List identityInfoList = taskRequest.getIdentitiesList();
            output.addChild(new CommandOutput.OutputHierarchy.OutputNode("Identities", (Object)this.formatIdentityInfoList(identityInfoList)));
        }
        return output;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatIdentityInfoList(List<PolicyServerProto.IdentityInfoMsg> identityInfoList) {
        CommandOutput.OutputHierarchy.OutputNode output = new CommandOutput.OutputHierarchy.OutputNode();
        HashSet<PolicyServerProto.IdentityInfoMsg> identities = new HashSet<PolicyServerProto.IdentityInfoMsg>();
        if (identityInfoList != null && !identityInfoList.isEmpty()) {
            identities.addAll(identityInfoList);
        }
        HashSet userIds = IamSupportUtils.getUserIds(identities);
        HashSet<String> userNames = new HashSet<String>();
        if (userIds != null && !userIds.isEmpty()) {
            userNames.addAll(this.getNamesFromIds(PolicyServerProto.IdentityType.User, userIds, null));
        }
        String strUserNames = this.getString(userNames);
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskUsers).getName(false), (Object)strUserNames));
        HashSet groupIds = IamSupportUtils.getGroupIds(identities);
        HashSet<String> groupNames = new HashSet<String>();
        if (groupIds != null && !groupIds.isEmpty()) {
            groupNames.addAll(this.getNamesFromIds(PolicyServerProto.IdentityType.Group, groupIds, null));
        }
        String strGroupNames = this.getString(groupNames);
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskGroups).getName(false), (Object)strGroupNames));
        HashSet roleIds = IamSupportUtils.getRoleIds(identities);
        HashSet<String> roleNames = new HashSet<String>();
        if (roleIds != null && !roleIds.isEmpty()) {
            roleNames.addAll(this.getNamesFromIds(PolicyServerProto.IdentityType.Role, roleIds, null));
        }
        String strRoleNames = this.getString(roleNames);
        output.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(PolicyServerProto.IamResourceTaskInfoFields.iamResourceTaskRoles).getName(false), (Object)strRoleNames));
        return output;
    }

    private String getString(HashSet<String> values) {
        return String.join((CharSequence)",", values);
    }

    private HashSet<String> getNamesFromIds(PolicyServerProto.IdentityType type, HashSet<Integer> ids, CommandOutput.OutputHierarchy out) {
        HashSet<String> identites = new HashSet<String>();
        for (int id : ids) {
            String name = null;
            String str = IamSupportUtils.getIdentityType((PolicyServerProto.IdentityType)type);
            try {
                String errmsg;
                if (type == PolicyServerProto.IdentityType.User) {
                    name = this.uugh.getUsername(id);
                } else if (type == PolicyServerProto.IdentityType.Group) {
                    name = this.uugh.getGroupname(id);
                } else if (type == PolicyServerProto.IdentityType.Role) {
                    name = this.imrh.getRolename(id);
                } else {
                    errmsg = String.format("getNamesFromIds not supported for %s: '%s'", str, name);
                    LOG.error((Object)errmsg);
                    if (out != null) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                        return null;
                    }
                }
                if (name == null) {
                    errmsg = String.format("%s '%d' does not exist", str, id);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                    return null;
                }
                identites.add(name);
            }
            catch (Exception exp) {
                String errmsg = String.format("%s '%d' does not exist", str, id);
                LOG.error((Object)errmsg);
                if (out == null) continue;
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errmsg));
                return null;
            }
        }
        return identites;
    }

    private byte[] sendRequestToPolicyServer(int procId, MessageLite request, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Class<PolicyServerProto.IAMResourceTaskInfoResponse> responseClass = null;
        byte[] data = null;
        switch (procId) {
            case 22: {
                responseClass = PolicyServerProto.IAMResourceTaskInfoResponse.class;
                break;
            }
            case 23: {
                responseClass = PolicyServerProto.IAMResourceTaskListResponse.class;
                break;
            }
            case 24: {
                responseClass = PolicyServerProto.IAMResourceTaskAbortResponse.class;
                break;
            }
            default: {
                return data;
            }
        }
        if (responseClass == null) {
            LOG.error((Object)("Unknown procId for send requestuest " + procId));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unknown procId for send requestuest " + procId));
            return data;
        }
        try {
            data = PolicyServerRpcCommonUtils.getInstance().sendRequestToPolicyServer(procId, request, responseClass);
        }
        catch (Exception exp) {
            throw new CLIProcessingException((Throwable)exp);
        }
        return data;
    }
}

