/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.Accesscontrol;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClusterAceCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(ClusterAceCommands.class);
    private static final String READCONFIGACE_PARAM = "readConfigAce";
    private static final String SERVICESACE_PARAM = "servicesAce";
    private static final String VOLUMECREATEACE_PARAM = "volumeCreateAce";
    private static final String ADMINACE_PARAM = "adminAce";
    private static final String FCACE_PARAM = "fcAce";
    private static final String AUDITADMINACE_PARAM = "auditAce";
    private static final Map<String, CLDBProto.ClusterActions> clusterAcesParameterMap = new ImmutableMap.Builder().put((Object)"readConfigAce", (Object)CLDBProto.ClusterActions.CLUSTER_READ_ONLY).put((Object)"servicesAce", (Object)CLDBProto.ClusterActions.CLUSTER_START_STOP_SERVICES).put((Object)"volumeCreateAce", (Object)CLDBProto.ClusterActions.CLUSTER_CREATE_VOLUMES).put((Object)"adminAce", (Object)CLDBProto.ClusterActions.CLUSTER_ADMIN).put((Object)"fcAce", (Object)CLDBProto.ClusterActions.CLUSTER_FULL_CONTROL).put((Object)"auditAce", (Object)CLDBProto.ClusterActions.CLUSTER_AUDIT_ADMIN).build();
    private static final CLICommand setAceCommand = new CLICommand("set", "Sets Aces for Cluster Actions", ClusterAceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"readConfigAce", (Object)new TextInputParameter("readConfigAce", "Ace to Control Viewing of Config Info", false, null)).put((Object)"servicesAce", (Object)new TextInputParameter("servicesAce", "Ace to Control Starting and Stopping Services", false, null)).put((Object)"volumeCreateAce", (Object)new TextInputParameter("volumeCreateAce", "Ace to Control Volume Creation", false, null)).put((Object)"adminAce", (Object)new TextInputParameter("adminAce", "Ace to Control Ace administration", false, null)).put((Object)"fcAce", (Object)new TextInputParameter("fcAce", "Ace to Control administering of all operations except aces", false, null)).put((Object)"auditAce", (Object)new TextInputParameter("auditAce", "Ace to Control Toggling of Audit", false, null)).build(), null);
    private static final CLICommand getAceCommand = new CLICommand("get", "Get Aces for All Cluster Actions", ClusterAceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null);
    public static final CLICommand aceCommands = new CLICommand("ace", "Set or Get ACE on Cluster Actions", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{setAceCommand, getAceCommand});

    public ClusterAceCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (this.cliCommand.getCommandName().equalsIgnoreCase("set")) {
            return this.processSetAceCommand(false);
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("get")) {
            return this.processGetAceCommand(false);
        }
        final CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy(){
            {
                this.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unrecognized argument to Cluster Aces Command"));
            }
        };
        return new CommandOutput(){
            {
                this.setOutput(out);
            }
        };
    }

    private CommandOutput processGetAceCommand(boolean iamAces) throws CLIProcessingException {
        byte[] data;
        final CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput(){
            {
                this.setOutput(out);
            }
        };
        Accesscontrol.GetClusterAcesRequest request = Accesscontrol.GetClusterAcesRequest.newBuilder().setIamAces(iamAces).setCreds(this.getUserCredentials()).build();
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetClusterAcesProc.getNumber(), (MessageLite)request, Accesscontrol.GetClusterAcesResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetClusterAcesProc.getNumber(), (MessageLite)request, Accesscontrol.GetClusterAcesResponse.class);
        }
        catch (InvalidProtocolBufferException | MaprSecurityException e) {
            throw new CLIProcessingException(e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "RPC Error"));
            return output;
        }
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(61, "Empty RPC Response"));
            output.setOutput(out);
            return output;
        }
        Accesscontrol.GetClusterAcesResponse resp = null;
        try {
            resp = Accesscontrol.GetClusterAcesResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                String errorMsg = resp.hasErrorString() ? resp.getErrorString() : "Non Zero Status While Setting Cluster Aces";
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), errorMsg));
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException", (Throwable)e);
        }
        this.formatClusterAces(resp, out, iamAces);
        return output;
    }

    private void formatClusterAces(Accesscontrol.GetClusterAcesResponse resp, CommandOutput.OutputHierarchy out, boolean iamAces) {
        if (!resp.hasAces()) {
            return;
        }
        String aces = iamAces ? "clusterIamAces" : "clusterAces";
        CommandOutput.OutputHierarchy.OutputNode clusterAcesNode = new CommandOutput.OutputHierarchy.OutputNode(aces);
        try {
            for (CLDBProto.ClusterAceEntry aceEntry : resp.getAces().getAcesList()) {
                clusterAcesNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(aceEntry.getClusterAction().name(), (Object)AceHelper.toInfix((String)aceEntry.getExpr().toStringUtf8())));
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to parse cluster aces");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            return;
        }
        out.addNode(clusterAcesNode);
    }

    private CommandOutput processSetAceCommand(boolean iamAces) throws CLIProcessingException {
        byte[] data;
        final CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput(){
            {
                this.setOutput(out);
            }
        };
        Accesscontrol.SetClusterAcesRequest.Builder reqBuilder = Accesscontrol.SetClusterAcesRequest.newBuilder();
        CLDBProto.ClusterAces clusterAces = null;
        try {
            clusterAces = this.buildClusterAcesProtobuf(clusterAcesParameterMap, iamAces);
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to parse Cluster Ace arguments");
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Incorrect expression of Cluster Ace(s)"));
            return output;
        }
        if (clusterAces == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "No Cluster Aces specified in the Command"));
            return output;
        }
        reqBuilder.setAces(clusterAces);
        reqBuilder.setCreds(this.getUserCredentials());
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SetClusterAcesProc.getNumber(), (MessageLite)reqBuilder.build(), Accesscontrol.SetClusterAcesResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SetClusterAcesProc.getNumber(), (MessageLite)reqBuilder.build(), Accesscontrol.SetClusterAcesResponse.class);
        }
        catch (InvalidProtocolBufferException | MaprSecurityException e) {
            throw new CLIProcessingException(e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error Setting Cluster ACEs"));
            return output;
        }
        if (data == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            output.setOutput(out);
            return output;
        }
        try {
            Accesscontrol.SetClusterAcesResponse resp = Accesscontrol.SetClusterAcesResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                String errorMsg = resp.hasErrorString() ? resp.getErrorString() : "Non Zero Status While Setting Cluster Aces";
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, errorMsg));
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException", (Throwable)e);
        }
        return output;
    }

    private CLDBProto.ClusterAces buildClusterAcesProtobuf(Map<String, CLDBProto.ClusterActions> clusterAcesParameterMap, boolean iamAces) throws IOException, CLIProcessingException {
        CLDBProto.ClusterAces.Builder acesBuilder = CLDBProto.ClusterAces.newBuilder();
        for (String param : clusterAcesParameterMap.keySet()) {
            if (!this.isParamPresent(param)) continue;
            String arg = this.getParamTextValue(param, 0);
            acesBuilder.addAces(CLDBProto.ClusterAceEntry.newBuilder().setClusterAction(clusterAcesParameterMap.get(param)).setExpr(ByteString.copyFromUtf8((String)AceHelper.toPostfix((String)arg))).build());
        }
        if (acesBuilder.getAcesCount() > 0) {
            acesBuilder.setIamAces(iamAces);
            return acesBuilder.build();
        }
        return null;
    }
}

