/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.JSONObjectInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.util.MapRFSUtil;
import java.io.EOFException;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class McsCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(McsCommands.class);
    public static final String FILE_NAME = "file";
    public static final String VALUE = "value";
    public static final String KEY = "key";
    public static final CLICommand saveToFileCommand = new CLICommand("save", "save -file filename -value filecontent -key keyvalue", McsCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "file", true, null)).put((Object)"value", (Object)new JSONObjectInputParameter("value", "content", true)).put((Object)"key", (Object)new TextInputParameter("key", "key", false, null)).build(), null).setShortUsage("Save to file").setUsageInVisible(true);
    public static final CLICommand readFromFileCommand = new CLICommand("read", "read -file filename -key keyvalue", McsCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"file", (Object)new TextInputParameter("file", "file", true, null)).put((Object)"key", (Object)new TextInputParameter("key", "key", false, null)).build(), null).setShortUsage("read from file").setUsageInVisible(true);
    public static final CLICommand mcsCommands = new CLICommand("mcs", "mcs", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{saveToFileCommand, readFromFileCommand}).setShortUsage("mcs [save|read]").setUsageInVisible(true);

    public McsCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy ch = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(ch);
        String fileName = (String)this.input.getParameterByName(FILE_NAME).getParamValues().get(0);
        if (fileName == null || fileName.length() == 0) {
            LOG.error((Object)"Invalid parameters. File name is either null or empty.");
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid parameters.File name is either null or empty"));
        }
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase(saveToFileCommand.getCommandName())) {
                this.save(ch, fileName);
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase(readFromFileCommand.getCommandName())) {
                this.read(ch, fileName);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Provided Input is not compliant with enums: " + fileName));
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Provided Input is not compliant with enums: " + fileName));
        }
        catch (IOException e) {
            LOG.error((Object)"I/O Exception while executing the command", (Throwable)e);
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Request to execute the command failed. No data returned"));
        }
        catch (Exception e) {
            LOG.error((Object)"Request to execute the command failed. No data returned");
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Request to execute the command failed. No data returned"));
        }
        return co;
    }

    private void save(CommandOutput.OutputHierarchy ch, String fileName) throws CLIProcessingException, IOException, JSONException {
        String jsonString;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Saving to file for user: " + this.getUserLoginId()));
        }
        if ((jsonString = (String)this.input.getParameterByName(VALUE).getParamValues().get(0)) == null || jsonString.length() == 0) {
            LOG.error((Object)"Required parameters are either null or empty.");
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10002, "Required parameters are either null or empty."));
        }
        String key = null;
        if (this.input.getParameterByName(KEY) != null) {
            key = (String)this.input.getParameterByName(KEY).getParamValues().get(0);
        }
        FSDataOutputStream fsDos = null;
        String filePath = "/var/mapr/mcsmetadata/" + fileName;
        MapRFileSystem fs = MapRFSUtil.getMapRFileSystem();
        Path p = new Path(filePath);
        JSONObject jsonObj = null;
        if (key == null || key.trim().length() == 0) {
            fsDos = fs.create(p, true);
            fsDos.writeBytes(jsonString);
        } else {
            jsonObj = this.readFromFile(filePath);
            if (jsonObj == null) {
                jsonObj = new JSONObject();
            }
            jsonObj.put(key, (Object)new JSONObject(jsonString));
            fsDos = fs.create(p, true);
            fsDos.writeBytes(jsonObj.toString());
        }
        fsDos.close();
        fs.close();
    }

    private void read(CommandOutput.OutputHierarchy ch, String fileName) throws CLIProcessingException, IOException, JSONException {
        String filePath;
        JSONObject jsonObj;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading the file: " + fileName));
        }
        if ((jsonObj = this.readFromFile(filePath = "/var/mapr/mcsmetadata/" + fileName)) == null) {
            ch.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Invalid file. Please provide the correct path"));
        }
        String key = null;
        if (this.input.getParameterByName(KEY) != null) {
            key = (String)this.input.getParameterByName(KEY).getParamValues().get(0);
        }
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        if (key == null || key.trim().length() == 0) {
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("", (Object)jsonObj));
        } else {
            Object obj = null;
            try {
                obj = jsonObj.get(key);
            }
            catch (JSONException je) {
                LOG.info((Object)("Exception while parsing the json object: " + je.getMessage()));
            }
            if (obj != null) {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode("", obj));
            }
        }
        ch.addNode(node);
    }

    private JSONObject readFromFile(String filePath) throws IOException, JSONException {
        Path p;
        FSDataInputStream fsDis = null;
        MapRFileSystem fs = MapRFSUtil.getMapRFileSystem();
        if (!fs.exists(p = new Path(filePath))) {
            return null;
        }
        try {
            fsDis = fs.open(p);
            long fileLength = fsDis.getFileLength();
            byte[] buf = new byte[(int)fileLength];
            int bytesRead = fsDis.read(buf, 0, (int)fileLength);
            String content = new String(buf);
            return new JSONObject(content);
        }
        catch (EOFException eofEx) {
            LOG.error((Object)"EOF reached", (Throwable)eofEx);
            if (fsDis != null) {
                try {
                    fsDis.close();
                }
                catch (IOException ie) {
                    LOG.error((Object)"Exception while close the input stream", (Throwable)ie);
                }
            }
            return null;
        }
    }
}

