/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.Rpc;
import com.mapr.fs.proto.Dbserver;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMaskSecurityCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = LoggerFactory.getLogger(DataMaskSecurityCommands.class);
    public static final String COLUMNS_PARAM = "columns";
    public static final String OUTPUT_PARAM = "output";
    public static final String DATA_MASK_NAME_PARAM = "name";
    public static String securityDataMaskListUsage = "security datamask list [ -cluster clusterName] [ -output terse|verbose (default:verbose)[ -columns comma separated list of column names(default:all)] ";
    public static final String securityDataMaskInfoUsage = "security datamask info [ -cluster clusterName] [ -output terse|verbose. Default: verbose ] [ -columns comma separated list of column names. Default: all ] ";
    static final CLICommand dataMaskListCommand = new CLICommand("list", "usage : " + securityDataMaskListUsage, DataMaskSecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "clusterName", false, null)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose")).put((Object)"columns", (Object)new TextInputParameter("columns", "name|description|applicability|all", false, "all")).build(), null).setShortUsage(securityDataMaskListUsage);
    static final CLICommand dataMaskInfoCommand = new CLICommand("info", "usage : security datamask info [ -cluster clusterName] [ -output terse|verbose. Default: verbose ] [ -columns comma separated list of column names. Default: all ] ", DataMaskSecurityCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "dataMask", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "clusterName", false, null)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose")).put((Object)"columns", (Object)new TextInputParameter("columns", "name|description|applicability|all", false, "all")).build(), null).setShortUsage("security datamask info [ -cluster clusterName] [ -output terse|verbose. Default: verbose ] [ -columns comma separated list of column names. Default: all ] ");
    public static CLICommand[] dataMaskCommandsArray = new CLICommand[]{dataMaskListCommand, dataMaskInfoCommand};
    public static CLICommand dataMaskCommands = new CLICommand("datamask", "datamask", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, dataMaskCommandsArray).setShortUsage("security datamask [list|info]");

    public DataMaskSecurityCommands(ProcessedInput input, CLICommand cliCommand) throws CLIProcessingException {
        super(input, cliCommand);
    }

    void init() throws CLIProcessingException {
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            LOG.error("Exception while initializing RPC " + e);
        }
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        LOG.debug("Processing::executeRealCommand");
        this.init();
        try {
            if (this.cliCommand.getCommandName().equalsIgnoreCase("list")) {
                return this.dataMaskGetInfo(true);
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("info")) {
                return this.dataMaskGetInfo(false);
            }
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request Exception", (Throwable)e);
        }
        return new TextCommandOutput("Data Mask command failed".getBytes());
    }

    CommandOutput dataMaskGetInfo(boolean getAll) throws CLIProcessingException {
        try {
            final CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            CommandOutput output = new CommandOutput();
            output.setOutput(out);
            String cluster = this.isParamPresent("cluster") ? this.getParamTextValue("cluster", 0) : null;
            String tempDmName = null;
            if (!getAll) {
                if (!this.isParamPresent(DATA_MASK_NAME_PARAM)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Missing data mask name in the command").setField(DATA_MASK_NAME_PARAM));
                    return output;
                }
                tempDmName = this.getParamTextValue(DATA_MASK_NAME_PARAM, 0);
                if (tempDmName == null) {
                    out.addMessage(this.getCommandUsage());
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Data mask name argument missing."));
                    return output;
                }
            }
            final String dmName = tempDmName;
            final Set<String> colOutput = this.getOutputCols(this.isParamPresent(COLUMNS_PARAM) ? this.getParamTextValue(COLUMNS_PARAM, 0) : "all");
            try {
                new FileclientRun(this.getUserLoginId()){

                    @Override
                    public void runAsProxyUser() throws CLIProcessingException, IOException {
                        MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                        if (dmName == null) {
                            List dms = mfs.getAllDataMasks();
                            for (Dbserver.DataMask dm : dms) {
                                out.addNode(DataMaskSecurityCommands.this.createDMOutput(dm, colOutput));
                            }
                        } else {
                            Dbserver.DataMask dm = mfs.getDataMask(dmName);
                            out.addNode(DataMaskSecurityCommands.this.createDMOutput(dm, colOutput));
                        }
                    }
                };
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
            }
            catch (CLIProcessingException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            }
            return output;
        }
        catch (Exception e) {
            throw new CLIProcessingException("Send request exception", (Throwable)e);
        }
    }

    private String getOutputFieldName(String verboseName) throws CLIProcessingException {
        return "terse".equals(this.getParamTextValue(OUTPUT_PARAM, 0)) ? verboseName.substring(0, 1) : verboseName;
    }

    private Set<String> getOutputCols(String str) {
        HashSet<String> res = new HashSet<String>();
        if (str == null || "all".equals(str)) {
            res.add("id");
            res.add(DATA_MASK_NAME_PARAM);
            res.add("description");
            res.add("type");
            res.add("applicability");
        } else {
            block19: for (String curr : str.trim().split(",")) {
                switch (curr.toLowerCase().trim()) {
                    case "id": 
                    case "i": {
                        res.add("id");
                        continue block19;
                    }
                    case "name": 
                    case "n": {
                        res.add(DATA_MASK_NAME_PARAM);
                        continue block19;
                    }
                    case "description": 
                    case "d": {
                        res.add("description");
                        continue block19;
                    }
                    case "type": 
                    case "t": {
                        res.add("type");
                        continue block19;
                    }
                    case "applicability": 
                    case "a": {
                        res.add("applicability");
                        continue block19;
                    }
                }
            }
        }
        return res;
    }

    private CommandOutput.OutputHierarchy.OutputNode createDMOutput(Dbserver.DataMask dm, Set<String> outputCol) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode dmNode = new CommandOutput.OutputHierarchy.OutputNode();
        if (outputCol.contains("id")) {
            dmNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("id"), dm.getId()));
        }
        if (outputCol.contains(DATA_MASK_NAME_PARAM)) {
            dmNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(DATA_MASK_NAME_PARAM), (Object)dm.getName()));
        }
        if (dm.hasDesc() && outputCol.contains("description")) {
            dmNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("description"), (Object)dm.getDesc()));
        }
        if (dm.getAppCount() > 0 && outputCol.contains("applicability")) {
            dmNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("applicability"), (Object)dm.getAppList()));
        }
        return dmNode;
    }
}

