/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@Deprecated
public class NodePathSwitchCommand
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(NodePathSwitchCommand.class);
    public static final String FILTER_PARAM = "filter";
    public static final String NODES_PARAM = "nodes";
    public static final String WHICH_PARAM = "which";
    public static final String PATH_PARAM = "path";
    public static final String ZK_CONNECTSTRING = "zkconnect";
    public static final int TIMEOUT_SERVER = 30000;
    public static final String NODES_SERVICES_MNGMNT_TOP_PATH = "/nodes";
    public static final String NODES_SERVICES_MNGMNT_SERVICE_PATH = "/services";
    public static final CLICommand nodePathCommand = new CLICommand("path", "path change command ", NodePathSwitchCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"filter", (Object)new FilterInputParameter("filter", "node names filter. Please put it in quotes\"\"", false, null)).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, "localhost:5181")).put((Object)"nodes", (Object)new TextInputParameter("nodes", "node names space separated", false, null)).put((Object)"which", (Object)new TextInputParameter("which", "which path to change: switch, rack or both", false, PathTypeEnum.RACK.getExtName())).put((Object)"path", (Object)new TextInputParameter("path", "path to change", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null);

    public NodePathSwitchCommand(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput co = new CommandOutput(oh);
        String clusterName = "";
        if (this.isParamPresent("cluster")) {
            clusterName = this.getParamTextValue("cluster", 0);
        }
        String zkConnectString = null;
        if (!clusterName.isEmpty()) {
            CLDBRpcCommonUtils.getInstance().getZkConnect(clusterName);
        } else {
            CLDBRpcCommonUtils.getInstance().getZkConnect();
        }
        if (zkConnectString == null) {
            this.getParamTextValue(ZK_CONNECTSTRING, 0);
        }
        List<String> nodes = NodesCommonUtils.findNodeIps(zkConnectString, clusterName);
        List<String> nodeHostNames = new ArrayList();
        if (this.isParamPresent(NODES_PARAM)) {
            nodeHostNames = this.input.getParameterByName(NODES_PARAM).getParamValues();
        } else if (this.isParamPresent(FILTER_PARAM)) {
            String filter = this.getParamTextValue(FILTER_PARAM, 0);
            try {
                nodeHostNames = NodesCommonUtils.findFilteredNodeIps(filter, zkConnectString);
            }
            catch (CLIProcessingException e) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error while trying to get nodes list. Cannot do an action on service"));
                return co;
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "Invalid parameters provided: neither \"filter\", nor \"nodes\" were specified"));
            return co;
        }
        if (nodeHostNames == null || nodeHostNames.isEmpty()) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10008, "No nodes match input parameters"));
            return co;
        }
        List<CLDBRpcCommonUtils.IpAddr> nodeNamesIpAddr = NodesCommonUtils.convertHostToIpAddrList(nodeHostNames);
        ArrayList<String> nodeNames = new ArrayList<String>();
        for (CLDBRpcCommonUtils.IpAddr ipAddr : nodeNamesIpAddr) {
            nodeNames.add(ipAddr.toString());
        }
        HashSet nodeNamesSet = new HashSet(nodeNames);
        nodeNamesSet.removeAll(nodes);
        nodeNames.removeAll(nodeNamesSet);
        return co;
    }

    public static enum PathTypeEnum {
        SWITCH{

            @Override
            public String getExtName() {
                return "switch";
            }
        }
        ,
        RACK{

            @Override
            public String getExtName() {
                return "rack";
            }
        }
        ,
        BOTH{

            @Override
            public String getExtName() {
                return "both";
            }
        };


        public String getExtName() {
            return null;
        }
    }
}

