/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.beans.QueryServiceParam;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DbQueryServiceCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String CMD_GETCONFIG = "getconfig";
    private static final String CMD_SETCONFIG = "setconfig";
    private static final String CMD_CLEARCONFIG = "clearconfig";
    private static final String QUERY_SERVICE_ENABLED = "enabled";
    private static final String QUERY_SERVICE_ENABLED_DESC = "Boolean flag indicating if the Query Service is enabled";
    private static final String QUERY_SERVICE_CLUSTER_ID = "clusterid";
    private static final String QUERY_SERVICE_CLUSTER_ID_DESC = "`cluster-id` of Apache Drill cluster (See the value of `cluster-id` in `drill-distrib.conf`)";
    private static final String QUERY_SERVICE_STORAGE_PLUGIN = "storageplugin";
    private static final String QUERY_SERVICE_STORAGE_PLUGIN_DESC = "Name of the Apache Drill Storage Plugin instance to run OJAI queries (usually `dfs`).";
    private static final String QUERY_SERVICE_ZNODE = "znode";
    private static final String QUERY_SERVICE_ZNODE_DESC = "Root ZooKeeper node used by Apache Drill cluster (usually `/drill`)";
    private static final CLICommand queryServiceSetConfig = new CLICommand("setconfig", "Set Query Service Configuration", DbQueryServiceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(clusterParams).put((Object)"enabled", (Object)new BooleanInputParameter("enabled", "Boolean flag indicating if the Query Service is enabled", true, null)).put((Object)"clusterid", (Object)new TextInputParameter("clusterid", "`cluster-id` of Apache Drill cluster (See the value of `cluster-id` in `drill-distrib.conf`)", true, null)).put((Object)"storageplugin", (Object)new TextInputParameter("storageplugin", "Name of the Apache Drill Storage Plugin instance to run OJAI queries (usually `dfs`).", true, null)).put((Object)"znode", (Object)new TextInputParameter("znode", "Root ZooKeeper node used by Apache Drill cluster (usually `/drill`)", true, null)).build(), null).setShortUsage("Sets Query Service Configuration").setUsageInVisible(false);
    private static final CLICommand queryServiceGetConfig = new CLICommand("getconfig", "Get Query Service Configuration", DbQueryServiceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(clusterParams).build(), null).setShortUsage("Shows Query Service Configuration").setUsageInVisible(false);
    private static final CLICommand queryServiceClearConfig = new CLICommand("clearconfig", "Clear Query Service Configuration", DbQueryServiceCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(clusterParams).build(), null).setShortUsage("Remove Query Service Configuration").setUsageInVisible(false);
    public static final CLICommand queryServiceCommands = new CLICommand("queryservice", "Get or Set Cluster wide QueryService configuration", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{queryServiceGetConfig, queryServiceSetConfig, queryServiceClearConfig}).setUsageInVisible(false);

    public DbQueryServiceCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        switch (this.cliCommand.getCommandName().toLowerCase()) {
            case "getconfig": {
                this.getConfig(out);
                break;
            }
            case "setconfig": {
                this.setConfig(out);
                break;
            }
            case "clearconfig": {
                this.clearConfig(out);
            }
        }
        return output;
    }

    private void getConfig(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            QueryServiceParam qsp;
            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                qsp = mfs.getQueryServiceParam(cluster);
            } else {
                qsp = mfs.getQueryServiceParam();
            }
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(QUERY_SERVICE_ENABLED, (Object)qsp.isEnabled()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("zookeeper", (Object)qsp.getZookeeperConnect()));
            for (Map.Entry param : qsp.getConnectionParams().entrySet()) {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode((String)param.getKey(), param.getValue()));
            }
            out.addNode(node);
        }
        catch (IOException | InterruptedException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    private void setConfig(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            boolean isEnabled = this.getParamBooleanValue(QUERY_SERVICE_ENABLED, 0);
            HashMap params = Maps.newHashMap();
            params.put(QUERY_SERVICE_ZNODE, this.getParamTextValue(QUERY_SERVICE_ZNODE, 0));
            params.put(QUERY_SERVICE_CLUSTER_ID, this.getParamTextValue(QUERY_SERVICE_CLUSTER_ID, 0));
            params.put(QUERY_SERVICE_STORAGE_PLUGIN, this.getParamTextValue(QUERY_SERVICE_STORAGE_PLUGIN, 0));
            QueryServiceParam qsp = new QueryServiceParam(isEnabled, null, (Map)params);
            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                mfs.setQueryServiceParam(cluster, qsp);
            } else {
                mfs.setQueryServiceParam(qsp);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    private void clearConfig(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
            if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                mfs.clearQueryServiceParam(cluster);
            } else {
                mfs.clearQueryServiceParam();
            }
        }
        catch (IOException | InterruptedException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }
}

