/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.License;
import com.mapr.security.MaprSecurityException;
import java.util.Map;
import org.apache.log4j.Logger;

public class EulaCommands
extends CLIBaseClass {
    private static final Logger LOG = Logger.getLogger(EulaCommands.class);
    private static final String USER_PARAM_NAME = "user";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    private static final CLICommand showacceptCommand = new CLICommand("showaccept", "usage: eula showaccept -cluster clustername", EulaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("eula showaccept -cluster <clustername>");
    private static final CLICommand acceptCommand = new CLICommand("accept", "usage: eula accept -user username -cluster clustername", EulaCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"user", (Object)new TextInputParameter("user", "username", true, null)).build(), null).setShortUsage("eula accept -user <username> -cluster <clustername>");
    public static final CLICommand eulaCommands = new CLICommand("eula", "eula [accept|showaccept]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{acceptCommand, showacceptCommand}).setShortUsage("eula [accept|showaccept]").setUsageInVisible(true);

    public EulaCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("accept")) {
            this.acceptEula(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase("showaccept")) {
            this.showacceptEula(out);
        }
        return output;
    }

    private void acceptEula(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        License.EulaAcceptResponse resp;
        String user = this.getParamTextValue(USER_PARAM_NAME, 0);
        if (user == null || user.trim().isEmpty()) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid user  " + Errno.toString((int)22)));
            return;
        }
        License.EulaAcceptRequest.Builder b = License.EulaAcceptRequest.newBuilder();
        b.setAcceptedUser(user);
        try {
            byte[] data;
            if (this.isParamPresent("cluster")) {
                String cluster = this.getParamTextValue("cluster", 0);
                if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                    return;
                }
                data = CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.EulaAcceptProc.getNumber(), (MessageLite)b.build(), License.EulaAcceptResponse.class);
            } else {
                data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.EulaAcceptProc.getNumber(), (MessageLite)b.build(), License.EulaAcceptResponse.class);
            }
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            resp = License.EulaAcceptResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "EulaAccept: " + Errno.toString((int)10003)));
            LOG.error((Object)"Exception during EulaAccept", (Throwable)e);
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, Errno.toString((int)status)));
        }
    }

    private void showacceptEula(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        License.EulaShowAcceptResponse resp;
        String cluster = null;
        if (this.isParamPresent("cluster")) {
            cluster = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(cluster)) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(133, "Invalid cluster: " + cluster));
                return;
            }
        }
        if ((resp = EulaCommands.fetchEula(cluster)) == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return;
        }
        int status = resp.getStatus();
        if (status != 0) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, Errno.toString((int)status)));
            return;
        }
        if (resp.hasAcceptedUser()) {
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode(USER_PARAM_NAME, (Object)resp.getAcceptedUser()));
            node.addChild(new CommandOutput.OutputHierarchy.OutputNode("time", resp.getAcceptedTime()));
            out.addNode(node);
        }
    }

    public static License.EulaShowAcceptResponse fetchEula(String cluster) throws CLIProcessingException {
        License.EulaShowAcceptResponse resp;
        License.EulaShowAcceptRequest.Builder b = License.EulaShowAcceptRequest.newBuilder();
        try {
            byte[] data = cluster != null ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.EulaShowAcceptProc.getNumber(), (MessageLite)b.build(), License.EulaShowAcceptResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.EulaShowAcceptProc.getNumber(), (MessageLite)b.build(), License.EulaShowAcceptResponse.class);
            if (data == null) {
                return null;
            }
            resp = License.EulaShowAcceptResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing RPC to CLDB");
        }
        return resp;
    }
}

