/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class JobLogLinkUtils {
    private static final Log LOG = LogFactory.getLog(JobLogLinkUtils.class);
    private static final String HOSTS_DIR_NAME = "hosts";
    private static final String MAPPERS_DIR_NAME = "mappers";
    private static final String REDUCERS_DIR_NAME = "reducers";

    public static Path setupTargetJobDir(FileSystem fs, String targetBaseDir, String jobId, boolean mapreduce) throws IOException {
        Path targetJobDirPath = new Path(targetBaseDir + "/" + jobId);
        if (!targetJobDirPath.isAbsolute()) {
            targetJobDirPath = new Path(fs.getHomeDirectory(), targetJobDirPath);
        }
        fs.mkdirs(JobLogLinkUtils.getHostDirPath(targetJobDirPath));
        if (mapreduce) {
            fs.mkdirs(JobLogLinkUtils.getMapperDirPath(targetJobDirPath));
            fs.mkdirs(JobLogLinkUtils.getReducerDirPath(targetJobDirPath));
        }
        return targetJobDirPath;
    }

    public static Path getHostDirPath(Path dirPath) {
        return new Path(dirPath, HOSTS_DIR_NAME);
    }

    public static Path getMapperDirPath(Path dirPath) {
        return new Path(dirPath, MAPPERS_DIR_NAME);
    }

    public static Path getReducerDirPath(Path dirPath) {
        return new Path(dirPath, REDUCERS_DIR_NAME);
    }

    public static void createSymlinkIfAbsent(FileSystem fs, Path targetPath, Path linkPath) throws IOException {
        if (fs.exists(linkPath)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(linkPath + " already exists."));
            }
        } else {
            StringBuilder rootRelativeToLinkDirStr = new StringBuilder(1024);
            for (int i = 0; i < linkPath.depth() - 1; ++i) {
                rootRelativeToLinkDirStr.append("../");
            }
            String targetPathStr = targetPath.toUri().getPath();
            rootRelativeToLinkDirStr.append(targetPath.isAbsolute() ? targetPathStr.substring(1) : targetPathStr.toString());
            Path relativeTargetPath = new Path(rootRelativeToLinkDirStr.toString());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating a symlink " + linkPath + " -> " + relativeTargetPath));
            }
            fs.createSymlink(relativeTargetPath, linkPath, true);
        }
    }
}

