/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.perf;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ListCommandPerformance {
    private String filePath;
    private Map<String, List<Data>> perfData = new HashMap<String, List<Data>>();

    public ListCommandPerformance(String filePath) {
        this.filePath = filePath;
    }

    public void generateReport() throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(this.filePath));
        String line = "";
        String thread = "";
        while ((line = reader.readLine()) != null) {
            List<Data> dataList;
            if (!line.contains("thread") || !line.contains("[") || !line.contains("]")) continue;
            thread = line.substring(line.indexOf(91), line.indexOf(93) + 1);
            if (line.contains("CLDBCallable: Parameters")) {
                String url = line.substring(line.indexOf("= [") + 2);
                if (!url.contains("node, list") && !url.contains("volume, list")) continue;
                dataList = this.perfData.get(thread);
                if (dataList == null) {
                    dataList = new ArrayList<Data>();
                    this.perfData.put(thread, dataList);
                }
                dataList.add(new Data(thread, url));
                continue;
            }
            if (!line.contains("Perf::list()")) continue;
            int perf = Integer.parseInt(line.substring(line.indexOf("=") + 2));
            dataList = this.perfData.get(thread);
            if (dataList == null || dataList.isEmpty()) continue;
            boolean perfSet = false;
            for (Data d : dataList) {
                if (d.getPerf() != -1) continue;
                perfSet = true;
                d.setPerf(perf);
            }
            if (perfSet) continue;
        }
        TreeMap<String, ArrayList<Data>> urlToPerf = new TreeMap<String, ArrayList<Data>>();
        for (List<Data> dataList : this.perfData.values()) {
            for (Data data : dataList) {
                ArrayList<Data> list = (ArrayList<Data>)urlToPerf.get(data.url);
                if (list == null || list.isEmpty()) {
                    list = new ArrayList<Data>();
                    urlToPerf.put(data.url, list);
                }
                list.add(data);
            }
        }
        System.out.println("URL\tNum Samples\tAvg. Time");
        for (String url : urlToPerf.keySet()) {
            List list = (List)urlToPerf.get(url);
            float perf = 0.0f;
            for (Data data : list) {
                perf += (float)data.getPerf();
            }
            System.out.println(url + "\t" + list.size() + "\t" + (perf /= (float)list.size()));
        }
        reader.close();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Please input the path to adminuiapp.log file");
            System.exit(1);
        }
        ListCommandPerformance perf = new ListCommandPerformance(args[0]);
        perf.generateReport();
    }

    private class Data {
        private String thread;
        private String url;
        private int perf;

        public Data(String thread, String url) {
            this.thread = thread;
            this.url = url;
            this.perf = -1;
        }

        public void setPerf(int perf) {
            this.perf = perf;
        }

        public int getPerf() {
            return this.perf;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.perf;
            result = 31 * result + (this.thread == null ? 0 : this.thread.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Data other = (Data)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.perf != other.perf) {
                return false;
            }
            if (this.thread == null ? other.thread != null : !this.thread.equals(other.thread)) {
                return false;
            }
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }

        private ListCommandPerformance getOuterType() {
            return ListCommandPerformance.this;
        }

        public String toString() {
            return "Thread : " + this.thread + ", URL : " + this.url + ", Time: " + this.perf;
        }
    }
}

