/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.bulk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.bulk.AbstractTask;
import com.mapr.cli.bulk.TaskResult;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import org.apache.log4j.Logger;

public class VolumeRemoveTask
extends AbstractTask {
    private static final Logger LOG = Logger.getLogger(VolumeRemoveTask.class);
    private static final String TASK_NAME = "VolumeRemove";
    private CLDBProto.VolumeProperties properties;
    private boolean forceRemove;
    private Security.CredentialsMsg userCreds;
    private String cluster;

    public VolumeRemoveTask(CLDBProto.VolumeProperties properties, boolean forceRemove, Security.CredentialsMsg userCreds, String cluster) {
        super(TASK_NAME);
        this.properties = properties;
        this.forceRemove = forceRemove;
        this.userCreds = userCreds;
        this.cluster = cluster;
    }

    @Override
    public TaskResult executeTask() {
        CLDBProto.VolumeRemoveRequest volumeRemove = CLDBProto.VolumeRemoveRequest.newBuilder().setVolumeName(this.properties.getVolumeName()).setCreds(this.userCreds).setForceRemove(this.forceRemove).build();
        CLDBProto.VolumeRemoveResponse response = this.sendRpc(volumeRemove);
        TaskResult result = new TaskResult();
        if (response != null) {
            result.setEntityName(this.properties.getVolumeName());
            result.setStatus(response.getStatus());
            if (response.getStatus() != 0) {
                String failureMsg = "Volume remove failed: " + Errno.toString((int)response.getStatus());
                result.setFailureMsg(failureMsg);
                LOG.warn((Object)failureMsg);
            }
        } else {
            String failureMsg = "Rpc failure during volume removal.";
            result.setFailureMsg(failureMsg);
            LOG.warn((Object)failureMsg);
        }
        return result;
    }

    private CLDBProto.VolumeRemoveResponse sendRpc(CLDBProto.VolumeRemoveRequest volumeRemove) {
        CLDBProto.VolumeRemoveResponse response = null;
        try {
            response = CLDBProto.VolumeRemoveResponse.parseFrom((byte[])MapRCliUtil.sendRpc((MessageLite)volumeRemove, CLDBProto.CLDBProg.VolumeRemoveProc.getNumber(), this.cluster, CLDBProto.VolumeRemoveResponse.class));
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)("Encountered exception while parsing VolumeRemoveResponse. Volume: " + volumeRemove.getVolumeName()));
        }
        catch (Exception e) {
            LOG.error((Object)("Removal of volume: " + volumeRemove.getVolumeName() + " failed due to exception " + e));
        }
        return response;
    }

    @Override
    public TaskResult validateInput() {
        String volName = this.properties.getVolumeName();
        TaskResult result = new TaskResult();
        result.setEntityName(volName);
        if (volName.equals(Common.MapRClusterDefaults.getDefaultInstance().getClusterRootName())) {
            String failureMsg = "Cannot remove volume " + volName + " " + Errno.toString((int)22);
            result.setStatus(22);
            result.setFailureMsg(failureMsg);
            LOG.warn((Object)failureMsg);
            return result;
        }
        if (this.properties.getNumSnapshots() > 0 && !this.forceRemove) {
            String failureMsg = "Volume Remove: " + Errno.toString((int)39) + " Volume has " + this.properties.getNumSnapshots() + " snapshots. Please use -force option to remove Volume and Snapshots";
            result.setStatus(22);
            result.setFailureMsg(failureMsg);
            LOG.warn((Object)failureMsg);
            return result;
        }
        result.setStatus(0);
        return result;
    }
}

