/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.zookeeper.KSStateManager;
import com.mapr.cli.DbGatewayCommands;
import com.mapr.cli.DbQueryServiceCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.VolumeMetricsCommand;
import com.mapr.cli.common.ClusterServicesUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClusterCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String SETMODE_PARAM = "mode";
    private static final String FEATURE_NAME = "name";
    private static final String FEATURE_FORCE = "force";
    private static final String FEATURE_ENABLED = "enabled";
    private static final String FEATURE_DISABLED = "disabled";
    private static final String FEATURE_ALL = "all";
    private static final String MULTI_ARG_SEP = ",";
    private static final String GET_MINMAX_PARAM = "getminmax";
    private static final String S3CONFIG_SUBCMD_NAME = "s3config";
    private static final String S3SERVER_PARENT_CMD = "cluster s3config";
    private static final String S3SERVER_PARAM = "s3server";
    public static final String versionFilePath = "/hadoop/hadoopversion";
    private static final String maprInstallPath = MapRCliUtil.getMapRInstallDir();
    private static final String hadoopVersionLocalFile = maprInstallPath + "/hadoop/hadoopversion";
    private static final String daemonConfFile = maprInstallPath + "/conf/daemon.conf";
    private static final String CLASSIC_VERSION_TOKEN = "classic_version";
    private static final String YARN_VERSION_TOKEN = "yarn_version";
    private static final String DEFAULT_MODE_TOKEN = "default_mode";
    private static final String SERVICES_COMMAND = "cluster services";
    private static final String SERVICES_ENABLE = "enable";
    private static final String SERVICES_STATUS = "status";
    private static final String SERVICES_TOKEN = "activationKey";
    private static final String STARTUP_SUBCMD_NAME = "startup";
    private static final String STARTUP_PARENT_CMD = "cluster startup";
    private static final String STARTUP_STATE_ALL_PARAM = "all";
    private static final String STARTUP_GET_PARAM_NAME = "get";
    private static final String STARTUP_SET_PARAM_NAME = "set";
    private static final String STARTUP_ACTIVATION_KEY_PARAM_NAME = "activationkey";
    private static final String STARTUP_STATE_KS_PARAM = "enabled";
    private static final String STARTUP_STATE_USAGE_PARAM = "usage";
    private static final String STARTUP_STATE_CLUSTERID_PARAM = "clusterid";
    private static final String STARTUP_STATE_SSO_PARAM = "sso";
    private static final String STARTUP_STATE_RESOURCE_PARAM = "resource";
    private static final String STARTUP_STATE_OUT_PARAM = "file";
    private static final String STARTUP_STATE_ISFILE_PARAM = "is_file";
    private static final String ISSUERS_PARAM_NAME = "issuerendpoint";
    private static final String SSO_PROVIDER_PARAM_NAME = "providername";
    private static final String CLIENT_ID_PARAM_NAME = "clientid";
    private static final String CLIENT_SECRET_PARAM_NAME = "clientsecret";
    private static final String SSO_PROVIDER_CERT_FILE = "certfile";
    private static final String SSO_PROVIDER_CERT_BYTES = "certbytes";
    private static final String SHOW_CERT_PARAM_NAME = "showcert";
    private static final Logger LOG = Logger.getLogger(ClusterCommands.class);
    private static final CLICommand mapreduceGetAllVersionCommand = new CLICommand("getall", "Get MapReduce Version values", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("Shows the MapReduce version info").setUsageInVisible(true);
    private static final CLICommand mapreduceGetVersionCommand = new CLICommand("get", "Get Cluster wide MapReduce default mode", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("Shows the current cluster MapReduce default version");
    private static final CLICommand mapreduceSetVersionCommand = new CLICommand("set", "Set Cluster wide MapReduce default mode", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"mode", (Object)new TextInputParameter("mode", "Sets the default MapReduce default version <yarn>", true, null)).build(), null);
    private static final CLICommand mapreduceCommands = new CLICommand("mapreduce", "Get or Set Cluster wide MapReduce defaults such as version", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{mapreduceGetAllVersionCommand, mapreduceGetVersionCommand, mapreduceSetVersionCommand});
    private static final CLICommand s3ConfigSetCommand = new CLICommand("set", "Set (replace) existing s3Server configurations with new list", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"s3server", (Object)new TextInputParameter("s3server", "<hostname:port> for s3 server", false, null)).build(), null);
    private static final CLICommand s3ConfigAddCommand = new CLICommand("add", "Adds new s3Server configuration to existing s3 Server configurations", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"s3server", (Object)new TextInputParameter("s3server", "<hostname:port> for s3 server", false, null)).build(), null);
    private static final CLICommand s3ConfigRemoveCommand = new CLICommand("remove", "remove s3Server configuration from existing s3 Server configurations", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"s3server", (Object)new TextInputParameter("s3server", "<hostname:port> for s3 server", false, null)).build(), null);
    private static final CLICommand s3ConfigShowCommand = new CLICommand("show", "display existing s3Server configurations", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null);
    private static final CLICommand s3ConfigCommands = new CLICommand("s3config", "Addd, Set or Remove s3 server instances to cldb", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{s3ConfigSetCommand, s3ConfigAddCommand, s3ConfigRemoveCommand, s3ConfigShowCommand});
    static final CLICommand featureEnableCommand = new CLICommand("enable", "usage: cluster feature enable [-name <feature name> | -force <true|false> | -all ]", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "feature name", false, null)).put((Object)"force", (Object)new BooleanInputParameter("force", "<true|false> true enables depedency features too", false, null)).put((Object)"all", (Object)new NoValueInputParameter("all", "all features", false, false)).build(), null).setShortUsage("Enables feature");
    static final CLICommand featureListCommand = new CLICommand("list", "usage: cluster feature list [ -name <featurename> -type <cldb|mfs> -state <enabled|disabled> -class <v2|v3> ]", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "feature name", false, null)).put((Object)"enabled", (Object)new NoValueInputParameter("enabled", "enabled features only", false, false)).put((Object)"disabled", (Object)new NoValueInputParameter("disabled", "disabled features only", false, false)).build(), null).setShortUsage("Lists features on the cluster");
    static String supportedMinMaxEntities;
    static final CLICommand infoCommand;
    public static final CLICommand featureCommand;
    private static String billingUsage;
    public static final CLICommand getBillingUsageCommand;
    private static String meteringUsage;
    public static final CLICommand getMeteringUsageCommand;
    private static String STATUS_USAGE;
    private static String ENABLE_USAGE;
    private static String SERVICE_USAGE;
    public static final CLICommand statusSubCommand;
    public static final CLICommand serviceCommand;
    public static final CLICommand setSsoCommand;
    public static final CLICommand getSsoCommand;
    public static final CLICommand resetSsoCommand;
    public static final CLICommand getStartupStateCommand;
    public static final CLICommand setStartupStateCommand;
    public static final CLICommand startupCommand;
    public static final CLICommand clusterCommands;
    private ProcessedInput processedInput;
    private CLICommand cliCommand;

    public ClusterCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
        this.processedInput = input;
        this.cliCommand = cliCommand;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(oh);
        String cmd = this.cliCommand.getCommandName();
        String parentNames = this.cliCommand.getParentCommand().getParentCommandNames();
        boolean isS3ConfigCmd = S3SERVER_PARENT_CMD.equalsIgnoreCase(parentNames);
        boolean isServicesCmd = SERVICES_COMMAND.equalsIgnoreCase(parentNames);
        boolean isStartupCmd = STARTUP_PARENT_CMD.equalsIgnoreCase(parentNames);
        LOG.debug((Object)("Parent Command: " + parentNames));
        if (isS3ConfigCmd) {
            this.processS3ConfigCmd(oh, cmd);
            return output;
        }
        if (isStartupCmd) {
            this.processStartupCommand(oh, cmd);
        } else if (cmd.equalsIgnoreCase(STARTUP_SET_PARAM_NAME)) {
            this.addContentsToOutput(oh, ClusterCommands.readHadoopVersionFile());
        } else if (cmd.equalsIgnoreCase(STARTUP_GET_PARAM_NAME)) {
            VersionFileContents contents = ClusterCommands.readHadoopVersionFile();
            if (contents != null) {
                this.addContentsToOutput(oh, contents);
            }
        } else if (cmd.equalsIgnoreCase("getall")) {
            VersionFileContents contents = ClusterCommands.readHadoopVersionFile();
            if (contents != null) {
                this.addAllContentsToOutput(oh, contents);
            }
        } else if (cmd.equalsIgnoreCase(SERVICES_ENABLE)) {
            this.enableFeature(oh);
            LOG.error((Object)("enable: cluster feature " + cmd));
        } else if (cmd.equalsIgnoreCase("list")) {
            this.listFeatures(oh);
            LOG.error((Object)("list: cluster feature " + cmd));
        } else if (cmd.equalsIgnoreCase("info")) {
            this.processInfo(oh);
            LOG.error((Object)("info: " + cmd));
        } else if (cmd.equalsIgnoreCase("getbillingusage")) {
            this.getbillingusage(oh);
        } else if (cmd.equalsIgnoreCase("getmeteringusage")) {
            this.getmeteringusage(oh);
        } else if (isServicesCmd) {
            this.processServicesStatusSubCommand(oh, cmd);
        } else if (!cmd.equalsIgnoreCase("services")) {
            if (cmd.equalsIgnoreCase("getssoconf")) {
                this.getsso(oh);
            } else if (cmd.equalsIgnoreCase("setssoconf")) {
                this.setsso(oh);
            } else if (cmd.equalsIgnoreCase("resetssoconf")) {
                this.resetsso(oh);
            }
        }
        return output;
    }

    private void getsso(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.SsoGetConfigRequest.Builder req = CLDBProto.SsoGetConfigRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SsoGetConfigProc.getNumber(), (MessageLite)req.build(), CLDBProto.SsoGetConfigResponse.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Caught Exception while sendRequest. " + e.getMessage()), (Throwable)e);
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Couldn't connect to the CLDB service. Check for CLDB process"));
            return;
        }
        CLDBProto.SsoGetConfigResponse resp = null;
        try {
            resp = CLDBProto.SsoGetConfigResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while parsing response");
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        CLDBProto.SsoConfigParams ssoParams = resp.getSsoParams();
        if (ssoParams.hasIssuer()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ISSUERS_PARAM_NAME, (Object)ssoParams.getIssuer()));
        }
        if (ssoParams.hasType()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SSO_PROVIDER_PARAM_NAME, (Object)ssoParams.getType()));
        }
        if (ssoParams.hasClientId()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(CLIENT_ID_PARAM_NAME, (Object)ssoParams.getClientId()));
        }
        if (ssoParams.hasClientSecret()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(CLIENT_SECRET_PARAM_NAME, (Object)ssoParams.getClientSecret()));
        }
        if (this.isParamPresent(SHOW_CERT_PARAM_NAME) && this.getParamBooleanValue(SHOW_CERT_PARAM_NAME, 0) && ssoParams.hasCertificate()) {
            outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SSO_PROVIDER_CERT_BYTES, (Object)new String(ssoParams.getCertificate().toByteArray()).trim()));
        }
        oh.addNode(outputNode);
    }

    private void setsso(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        String certStr;
        CLDBProto.SsoSetConfigRequest.Builder req = CLDBProto.SsoSetConfigRequest.newBuilder();
        CLDBProto.SsoConfigParams.Builder ssoCfg = CLDBProto.SsoConfigParams.newBuilder();
        boolean paramPresent = false;
        if (this.isParamPresent(ISSUERS_PARAM_NAME)) {
            String issuer = this.getParamTextValue(ISSUERS_PARAM_NAME, 0);
            if (issuer.endsWith("/")) {
                issuer = issuer.substring(0, issuer.length() - 1);
            }
            ssoCfg.setIssuer(issuer);
            paramPresent = true;
        }
        if (this.isParamPresent(SSO_PROVIDER_PARAM_NAME)) {
            String type = this.getParamTextValue(SSO_PROVIDER_PARAM_NAME, 0).toLowerCase();
            if (!type.equals("okta") && !type.equals("keycloak")) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "invalid sso provider type"));
                return;
            }
            ssoCfg.setType(type);
            paramPresent = true;
        }
        if (this.isParamPresent(CLIENT_ID_PARAM_NAME)) {
            ssoCfg.setClientId(this.getParamTextValue(CLIENT_ID_PARAM_NAME, 0));
            paramPresent = true;
        }
        if (this.isParamPresent(CLIENT_SECRET_PARAM_NAME)) {
            ssoCfg.setClientSecret(this.getParamTextValue(CLIENT_SECRET_PARAM_NAME, 0));
            paramPresent = true;
        }
        if (this.isParamPresent(SSO_PROVIDER_CERT_FILE)) {
            try {
                certStr = Files.readString(Path.of(this.getParamTextValue(SSO_PROVIDER_CERT_FILE, 0), new String[0]));
                certStr = certStr.trim();
                ssoCfg.setCertificate(ByteString.copyFrom((byte[])certStr.getBytes()));
            }
            catch (CLIProcessingException | IOException e) {
                String err = "Could not read cert file " + this.getParamTextValue(SSO_PROVIDER_CERT_FILE, 0);
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, err));
                LOG.error((Object)(err + e.getMessage()));
                LOG.debug((Object)e.toString());
                return;
            }
            paramPresent = true;
        } else if (this.isParamPresent(SSO_PROVIDER_CERT_BYTES)) {
            certStr = this.getParamTextValue(SSO_PROVIDER_CERT_BYTES, 0).trim();
            ssoCfg.setCertificate(ByteString.copyFrom((byte[])certStr.getBytes()));
            paramPresent = true;
        }
        req.setCreds(this.getUserCredentials());
        if (paramPresent) {
            req.setSsoParams(ssoCfg.build());
        }
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SsoSetConfigProc.getNumber(), (MessageLite)req.build(), CLDBProto.SsoSetConfigResponse.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Caught Exception while sendRequest. " + e.getMessage()), (Throwable)e);
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Couldn't connect to the CLDB service. Check for CLDB process"));
            return;
        }
        CLDBProto.SsoSetConfigResponse resp = null;
        try {
            resp = CLDBProto.SsoSetConfigResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while parsing response");
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SERVICES_STATUS, (Object)"SUCCESS: SSO configuartion set on CLDB."));
        oh.addNode(outputNode);
    }

    private void resetsso(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.SsoResetConfigRequest.Builder req = CLDBProto.SsoResetConfigRequest.newBuilder();
        req.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SsoResetConfigProc.getNumber(), (MessageLite)req.build(), CLDBProto.SsoResetConfigResponse.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Caught Exception while sendRequest. " + e.getMessage()), (Throwable)e);
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Couldn't connect to the CLDB service. Check for CLDB process"));
            return;
        }
        CLDBProto.SsoResetConfigResponse resp = null;
        try {
            resp = CLDBProto.SsoResetConfigResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while parsing response");
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SERVICES_STATUS, (Object)"SUCCESS: SSO configuartion reset on CLDB."));
        oh.addNode(outputNode);
    }

    private void processServicesStatusSubCommand(CommandOutput.OutputHierarchy oh, String cmd) throws CLIProcessingException {
        if (oh == null || cmd == null) {
            return;
        }
        if (cmd.equalsIgnoreCase(SERVICES_STATUS)) {
            try {
                this.showServicesStatus(oh);
                return;
            }
            catch (Exception e) {
                throw new CLIProcessingException("Exception in cluster services status ", (Throwable)e);
            }
        }
    }

    private void processServicesCmd(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        boolean parseErr = false;
        boolean isTokenPresent = this.isParamPresent(SERVICES_TOKEN);
        String enableStr = this.getParamTextValue(SERVICES_ENABLE, 0);
        if (enableStr.equalsIgnoreCase("true") && isTokenPresent) {
            String keyFile = this.getParamTextValue(SERVICES_TOKEN, 0);
            try {
                this.enableServices(oh, keyFile);
                return;
            }
            catch (Exception e) {
                throw new CLIProcessingException("Exception in cluster services", (Throwable)e);
            }
        }
        if (enableStr.equalsIgnoreCase("false")) {
            try {
                this.disableServices(oh);
                return;
            }
            catch (Exception e) {
                throw new CLIProcessingException("Exception in cluster services", (Throwable)e);
            }
        }
        if (enableStr.equalsIgnoreCase("true") && !isTokenPresent) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Activation key must be provided with this option"));
            return;
        }
        oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid enable parameter value"));
    }

    private void disableServices(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.ClusterServicesRequest.Builder req = CLDBProto.ClusterServicesRequest.newBuilder();
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        req.setCreds(this.getUserCredentials());
        req.setEnableServices(false);
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterServicesProc.getNumber(), (MessageLite)req.build(), CLDBProto.ClusterServicesResponse.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Caught Exception while sendRequest. " + e.getMessage()), (Throwable)e);
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response ...check cldb logs"));
            return;
        }
        CLDBProto.ClusterServicesResponse resp = null;
        try {
            resp = CLDBProto.ClusterServicesResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while parsing response");
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SERVICES_STATUS, (Object)"DISABLED"));
        oh.addNode(outputNode);
    }

    private void enableServices(CommandOutput.OutputHierarchy oh, String keyFile) throws CLIProcessingException {
        CLDBProto.ClusterServicesRequest.Builder req = CLDBProto.ClusterServicesRequest.newBuilder();
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode();
        String jsonString = "";
        try {
            jsonString = new String(Files.readAllBytes(Paths.get(keyFile, new String[0])));
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception " + e.getLocalizedMessage());
        }
        req.setCreds(this.getUserCredentials());
        req.setEnableServices(true);
        req.setToken(jsonString);
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterServicesProc.getNumber(), (MessageLite)req.build(), CLDBProto.ClusterServicesResponse.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Caught Exception while sendRequest. " + e.getMessage()), (Throwable)e);
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response ...check cldb logs"));
            return;
        }
        CLDBProto.ClusterServicesResponse resp = null;
        try {
            resp = CLDBProto.ClusterServicesResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while parsing response");
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        outputNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SERVICES_STATUS, (Object)"ENABLED"));
        oh.addNode(outputNode);
    }

    private void showServicesStatus(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.ClusterServicesRequest.Builder req = CLDBProto.ClusterServicesRequest.newBuilder();
        CommandOutput.OutputHierarchy.OutputNode outputNode = new CommandOutput.OutputHierarchy.OutputNode("servicesStatus");
        req.setCreds(this.getUserCredentials());
        byte[] data = null;
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterServicesProc.getNumber(), (MessageLite)req.build(), CLDBProto.ClusterServicesResponse.class);
        }
        catch (Exception e) {
            LOG.error((Object)("Caught Exception while sendRequest. " + e.getMessage()), (Throwable)e);
            throw new CLIProcessingException((Throwable)e);
        }
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Null response ...check cldb logs"));
            return;
        }
        CLDBProto.ClusterServicesResponse resp = null;
        try {
            resp = CLDBProto.ClusterServicesResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)"Exception while parsing response");
            throw new CLIProcessingException("InvalidProtocolBufferException " + e);
        }
        if (resp.getStatus() != 0) {
            if (resp.hasErrMsg()) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            } else {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), Errno.toString((int)resp.getStatus())));
            }
            return;
        }
        CLDBProto.ClusterServicesInfo csi = resp.getClusterServicesInfo();
        outputNode.addNode(new CommandOutput.OutputHierarchy.OutputNode(SERVICES_STATUS, (Object)(csi.getServicesEnabled() ? "ENABLED" : "DISABLED")));
        oh.addNode(outputNode);
    }

    public void getmeteringusage(CommandOutput.OutputHierarchy oh) {
        CommandOutput cmdOp = new CommandOutput(oh);
        VolumeMetricsCommand vmc = new VolumeMetricsCommand(this.processedInput, this.cliCommand);
        if (this.isParamPresent("from") && !this.isParamPresent("till") && !this.isParamPresent("duration")) {
            String msg = "Invalid paramaters. Either till or duration must be included with from";
            LOG.error((Object)msg);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
            return;
        }
        if ((this.isParamPresent("till") || this.isParamPresent("duration")) && !this.isParamPresent("from")) {
            String msg = "Invalid paramaters. Parameter from must be included with till and duration";
            LOG.error((Object)msg);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
            return;
        }
        try {
            vmc.getVolUsage(oh);
        }
        catch (Exception e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getLocalizedMessage()));
            return;
        }
    }

    public void getbillingusage(CommandOutput.OutputHierarchy oh) {
        CommandOutput cmdOp = new CommandOutput(oh);
        VolumeMetricsCommand vmc = new VolumeMetricsCommand(this.processedInput, this.cliCommand);
        if (this.isParamPresent("from") && !this.isParamPresent("till") && !this.isParamPresent("duration")) {
            String msg = "Invalid paramaters. Either till or duration must be included with from";
            LOG.error((Object)msg);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
            return;
        }
        if ((this.isParamPresent("till") || this.isParamPresent("duration")) && !this.isParamPresent("from")) {
            String msg = "Invalid paramaters. Parameter from must be included with till and duration";
            LOG.error((Object)msg);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
            return;
        }
        try {
            boolean isFromPresent = this.isParamPresent("from");
            String file = this.getParamTextValue("fileName", 0);
            boolean isClearTextPresent = this.isParamPresent("clearText");
            boolean clearText = isClearTextPresent ? this.getParamBooleanValue("clearText", 0) : false;
            vmc.generateMetricUsgaeFile(oh, file, isFromPresent, clearText);
            return;
        }
        catch (Exception e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getLocalizedMessage()));
            return;
        }
    }

    private void processS3ConfigCmd(CommandOutput.OutputHierarchy oh, String cmd) throws CLIProcessingException {
        if (oh == null || cmd == null) {
            return;
        }
        if (cmd.equalsIgnoreCase(STARTUP_SET_PARAM_NAME)) {
            this.processS3ConfigSet(oh);
        } else if (cmd.equalsIgnoreCase("add")) {
            this.processS3ConfigAdd(oh);
        } else if (cmd.equalsIgnoreCase("remove")) {
            this.processS3ConfigRemove(oh);
        } else if (cmd.equalsIgnoreCase("show")) {
            this.processS3ConfigShow(oh);
        }
    }

    private CLDBProto.S3ServerConfigProperties makeS3ServerConfigProperties(String hostname, String port) {
        List<CLDBRpcCommonUtils.IpAddr> hostIps = MapRCliUtil.getHostIps(hostname);
        if (hostIps.size() > 0) {
            CLDBRpcCommonUtils.IpPort ipPort = new CLDBRpcCommonUtils.IpPort(hostIps, Integer.parseInt(port));
            return CLDBProto.S3ServerConfigProperties.newBuilder().setHostname(hostname).setIpPort(ipPort.toIPPort()).build();
        }
        return null;
    }

    private void processS3ConfigSet(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        byte[] data;
        CLDBProto.S3ServerConfigSetRequest.Builder req = CLDBProto.S3ServerConfigSetRequest.newBuilder().setCreds(this.getUserCredentials());
        if (this.isParamPresent(S3SERVER_PARAM)) {
            String[] hosts;
            for (String host : hosts = this.getParamTextValue(S3SERVER_PARAM, 0).split(MULTI_ARG_SEP)) {
                Object[] pair = host.split(":");
                if (pair.length != 2) {
                    LOG.error((Object)("Invalid <hostname:port> pair " + Arrays.toString(pair)));
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid <hostname:port> pair " + Arrays.toString(pair)));
                    return;
                }
                CLDBProto.S3ServerConfigProperties s3ServerProps = this.makeS3ServerConfigProperties((String)pair[0], (String)pair[1]);
                if (s3ServerProps == null) {
                    LOG.error((Object)("s3Config set failed to resolve host " + host));
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "s3config set failed to resolve host " + host));
                    return;
                }
                req.addS3Servers(s3ServerProps);
            }
        }
        if ((data = this.sendRequestInternal(CLDBProto.CLDBProg.S3ServerConfigSetProc, (MessageLite)req.build(), oh)) == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return;
        }
        CLDBProto.S3ServerConfigSetResponse resp = null;
        try {
            resp = CLDBProto.S3ServerConfigSetResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing s3Config set response."));
            LOG.error((Object)"s3Config set failed. Exception parsing s3Config set response.", (Throwable)e);
            return;
        }
        if (resp.getStatus() == 0) {
            LOG.info((Object)"s3 servers set to new values");
        } else {
            LOG.error((Object)("Failed to set s3 servers. Error " + resp.getErrMsg()));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
        }
    }

    private void processS3ConfigAdd(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        byte[] data;
        CLDBProto.S3ServerConfigAddRequest.Builder req = CLDBProto.S3ServerConfigAddRequest.newBuilder().setCreds(this.getUserCredentials());
        String host = null;
        if (this.isParamPresent(S3SERVER_PARAM)) {
            host = this.getParamTextValue(S3SERVER_PARAM, 0);
            Object[] pair = host.split(":");
            if (pair.length != 2) {
                LOG.error((Object)("Invalid <hostname:port> pair " + Arrays.toString(pair)));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid <hostname:port> pair " + Arrays.toString(pair)));
                return;
            }
            CLDBProto.S3ServerConfigProperties s3ServerProps = this.makeS3ServerConfigProperties((String)pair[0], (String)pair[1]);
            if (s3ServerProps == null) {
                LOG.error((Object)("s3Config add failed to resolve host " + host));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "s3config add failed to resolve host " + host));
                return;
            }
            req.setS3Server(s3ServerProps);
        }
        if ((data = this.sendRequestInternal(CLDBProto.CLDBProg.S3ServerConfigAddProc, (MessageLite)req.build(), oh)) == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return;
        }
        CLDBProto.S3ServerConfigAddResponse resp = null;
        try {
            resp = CLDBProto.S3ServerConfigAddResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing s3Config add response."));
            LOG.error((Object)"s3Config add failed. Exception parsing s3Config add response.", (Throwable)e);
            return;
        }
        if (resp.getStatus() == 0) {
            LOG.info((Object)("added s3 server to cldb " + host));
        } else {
            LOG.error((Object)("Failed to add s3 server. Error " + resp.getErrMsg()));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
        }
    }

    private void processS3ConfigRemove(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        byte[] data;
        CLDBProto.S3ServerConfigRemoveRequest.Builder req = CLDBProto.S3ServerConfigRemoveRequest.newBuilder().setCreds(this.getUserCredentials());
        String host = null;
        if (this.isParamPresent(S3SERVER_PARAM)) {
            host = this.getParamTextValue(S3SERVER_PARAM, 0);
            Object[] pair = host.split(":");
            if (pair.length != 2) {
                LOG.error((Object)("Invalid <hostname:port> pair " + Arrays.toString(pair)));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid <hostname:port> pair " + Arrays.toString(pair)));
                return;
            }
            CLDBProto.S3ServerConfigProperties s3ServerProps = this.makeS3ServerConfigProperties((String)pair[0], (String)pair[1]);
            if (s3ServerProps == null) {
                LOG.error((Object)("s3Config remove failed to resolve host " + host));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "s3config remove failed to resolve host " + host));
                return;
            }
            req.setS3Server(s3ServerProps);
        }
        if ((data = this.sendRequestInternal(CLDBProto.CLDBProg.S3ServerConfigRemoveProc, (MessageLite)req.build(), oh)) == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return;
        }
        CLDBProto.S3ServerConfigRemoveResponse resp = null;
        try {
            resp = CLDBProto.S3ServerConfigRemoveResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing s3Config remove response."));
            LOG.error((Object)"s3Config remove failed. Exception parsing s3Config remove response.", (Throwable)e);
            return;
        }
        if (resp.getStatus() == 0) {
            LOG.info((Object)("removed s3 server " + host + " from cldb"));
        } else {
            LOG.error((Object)("Failed to remove s3 server. Error " + resp.getErrMsg()));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
        }
    }

    private void processS3ConfigShow(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.ClusterInfoRequest req = CLDBProto.ClusterInfoRequest.newBuilder().setCreds(this.getUserCredentials()).build();
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.S3ServerConfigShowProc, (MessageLite)req, oh);
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return;
        }
        CLDBProto.ClusterInfoResponse resp = null;
        try {
            resp = CLDBProto.ClusterInfoResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing s3Config show response."));
            LOG.error((Object)"s3Config show failed. Exception parsing s3Config show response.", (Throwable)e);
            return;
        }
        if (resp.getStatus() == 0) {
            this.formatS3ServerConfig(resp.getS3ServerLocationList(), oh);
        } else {
            int status = resp.getStatus();
            LOG.error((Object)("Failed to show s3 servers. Error " + Errno.toString((int)status)));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(status, Errno.toString((int)status)));
        }
    }

    private void formatS3ServerConfig(List<CLDBProto.S3ServerConfigProperties> configs, CommandOutput.OutputHierarchy oh) {
        for (CLDBProto.S3ServerConfigProperties cfg : configs) {
            CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
            if (cfg.hasHostname()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("hostname", (Object)cfg.getHostname()));
            }
            Common.IPPort ip = cfg.getIpPort();
            CLDBRpcCommonUtils.SocketAddr sockAddr = new CLDBRpcCommonUtils.SocketAddr(ip);
            if (ip != null) {
                if (ip.getHostsCount() > 0) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ip", (Object)sockAddr.getIpAddr().toString()));
                }
                if (ip.hasPort()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("port", (Object)sockAddr.getPort().toString()));
                }
            }
            oh.addNode(out);
        }
    }

    private void enableFeature(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        if (!this.isParamPresent(FEATURE_NAME) && !this.isParamPresent("all")) {
            oh.addMessage(this.getCommandUsage());
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "feature enable arguments missing. Pass either featurename or 'all'"));
            return;
        }
        if (this.isParamPresent(FEATURE_NAME) && this.isParamPresent("all")) {
            oh.addMessage(this.getCommandUsage());
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "feature enable arguments must not provide 'name' and 'all' together."));
            return;
        }
        boolean force = false;
        if (this.isParamPresent(FEATURE_FORCE)) {
            force = this.getParamBooleanValue(FEATURE_FORCE, 0);
        }
        CLDBProto.FeatureEnableRequest.Builder featureEnableReqBuilder = CLDBProto.FeatureEnableRequest.newBuilder().setCreds(this.getUserCredentials()).setForce(force);
        if (this.isParamPresent(FEATURE_NAME)) {
            String featureNames = this.getParamTextValue(FEATURE_NAME, 0);
            List<String> names = new ArrayList<String>();
            if (featureNames.contains(MULTI_ARG_SEP)) {
                names = Arrays.asList(featureNames.split(MULTI_ARG_SEP));
            } else {
                names.add(featureNames);
            }
            featureEnableReqBuilder.addAllFeatures(names);
        } else if (this.isParamPresent("all")) {
            featureEnableReqBuilder.addFeatures("all");
        }
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.FeatureEnableProc, (MessageLite)featureEnableReqBuilder.build(), oh);
        CLDBProto.FeatureEnableResponse resp = null;
        try {
            resp = CLDBProto.FeatureEnableResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing feature enable response."));
            LOG.error((Object)"Feature enable failed. Exception parsing feature enable response.", (Throwable)ipbe);
            return;
        }
        if (resp.getStatus() == 0) {
            CommandOutput.OutputHierarchy toh = this.formatMaprFeatureInfoList(resp.getFeaturesList());
            for (CommandOutput.OutputHierarchy.OutputNode a : toh.getOutputNodes()) {
                oh.addNode(a);
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            LOG.error((Object)("Feature enable failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
        }
    }

    private void listFeatures(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.FeatureListRequest.Builder featureInfoRequestBuilder = CLDBProto.FeatureListRequest.newBuilder().setCreds(this.getUserCredentials());
        List<String> names = new ArrayList<String>();
        if (this.isParamPresent(FEATURE_NAME)) {
            String featureNames = this.getParamTextValue(FEATURE_NAME, 0);
            if (!featureNames.contains(MULTI_ARG_SEP)) {
                names.add(featureNames);
            } else {
                names = Arrays.asList(featureNames.split(MULTI_ARG_SEP));
            }
        } else {
            names.add("all");
        }
        featureInfoRequestBuilder.addAllFeatures(names);
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.FeatureListProc, (MessageLite)featureInfoRequestBuilder.build(), oh);
        CLDBProto.FeatureListResponse resp = null;
        try {
            resp = CLDBProto.FeatureListResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing feature list response."));
            LOG.error((Object)"Feature list failed. Exception parsing feature list response.", (Throwable)ipbe);
            return;
        }
        if (resp.getStatus() == 0) {
            CommandOutput.OutputHierarchy toh = this.formatMaprFeatureInfoList(resp.getFeaturesList());
            for (CommandOutput.OutputHierarchy.OutputNode a : toh.getOutputNodes()) {
                oh.addNode(a);
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Feature list failed: " + resp.getErrMsg()));
            LOG.error((Object)("Feature list failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
        }
    }

    private CommandOutput.OutputHierarchy formatMaprFeatureInfoList(List<CLDBProto.MaprFeatureInfo> mfList) throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        for (CLDBProto.MaprFeatureInfo mf : mfList) {
            if (!(this.isParamPresent("enabled") && mf.getEnabled() || this.isParamPresent(FEATURE_DISABLED) && !mf.getEnabled()) && (this.isParamPresent("enabled") || this.isParamPresent(FEATURE_DISABLED))) continue;
            oh.addNode(this.formatMaprFeatureInfo(mf));
        }
        return oh;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatMaprFeatureInfo(CLDBProto.MaprFeatureInfo mf) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        if (mf.hasFeatureName()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FEATURE_NAME, (Object)mf.getFeatureName()));
        }
        if (mf.hasEnabled()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("enabled", (Object)mf.getEnabled()));
        }
        if (mf.hasDescription()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("description", (Object)mf.getDescription()));
        }
        if (mf.getDependenceInfoList().size() > 0) {
            CommandOutput.OutputHierarchy oh = this.formatMaprFeatureInfoList(mf.getDependenceInfoList());
            for (CommandOutput.OutputHierarchy.OutputNode a : oh.getOutputNodes()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("dependency", (Object)a));
            }
        }
        return out;
    }

    private byte[] sendRequestInternal(CLDBProto.CLDBProg procId, MessageLite req, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Class<CLDBProto.FeatureEnableResponse> responseClass = null;
        switch (procId) {
            case FeatureEnableProc: {
                responseClass = CLDBProto.FeatureEnableResponse.class;
                break;
            }
            case FeatureListProc: {
                responseClass = CLDBProto.FeatureListResponse.class;
                break;
            }
            case GetMinMaxProc: {
                responseClass = CLDBProto.GetMinMaxResponse.class;
                break;
            }
            case S3ServerConfigSetProc: {
                responseClass = CLDBProto.S3ServerConfigSetResponse.class;
                break;
            }
            case S3ServerConfigAddProc: {
                responseClass = CLDBProto.S3ServerConfigAddResponse.class;
                break;
            }
            case S3ServerConfigRemoveProc: {
                responseClass = CLDBProto.S3ServerConfigRemoveResponse.class;
                break;
            }
            case S3ServerConfigShowProc: {
                responseClass = CLDBProto.ClusterInfoResponse.class;
            }
        }
        if (responseClass == null) {
            LOG.error((Object)("Unknown procId for send request " + procId));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unknown procId for send request " + procId));
            return null;
        }
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), procId.getNumber(), req, responseClass) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), procId.getNumber(), req, responseClass);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        return data;
    }

    private void addAllContentsToOutput(CommandOutput.OutputHierarchy oh, VersionFileContents contents) {
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(CLASSIC_VERSION_TOKEN, (Object)contents.classic_version));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(YARN_VERSION_TOKEN, (Object)contents.yarn_version));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEFAULT_MODE_TOKEN, (Object)contents.default_mode));
        oh.addNode(node);
    }

    private void addContentsToOutput(CommandOutput.OutputHierarchy oh, VersionFileContents contents) {
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEFAULT_MODE_TOKEN, (Object)contents.default_mode));
        String version = "";
        if (contents.default_mode != null) {
            version = contents.default_mode.equals("classic") ? contents.classic_version : contents.yarn_version;
        }
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode("mapreduce_version", (Object)version));
        oh.addNode(node);
    }

    public static VersionFileContents readHadoopVersionFile() {
        VersionFileContents contents = new VersionFileContents();
        contents.classic_version = "0.20.2";
        contents.default_mode = "yarn";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(hadoopVersionLocalFile));
            contents.yarn_version = reader.readLine();
            reader.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Error while trying to get hadoop version", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Error while trying to get hadoop version", (Throwable)e);
        }
        return contents;
    }

    private void processInfo(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        if (this.isParamPresent(GET_MINMAX_PARAM)) {
            this.processGetMinMax(oh);
        }
    }

    private void processGetMinMax(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.GetMinMaxRequest.Builder GetMinMaxRequestBuilder = CLDBProto.GetMinMaxRequest.newBuilder().setCreds(this.getUserCredentials());
        HashMap<String, CLDBProto.MinMaxAttributes> nameToEnumMap = new HashMap<String, CLDBProto.MinMaxAttributes>();
        for (CLDBProto.MinMaxAttributes attrib : CLDBProto.MinMaxAttributes.values()) {
            nameToEnumMap.put(attrib.name().toLowerCase(), attrib);
        }
        String entityName = this.getParamTextValue(GET_MINMAX_PARAM, 0);
        ArrayList<CLDBProto.MinMaxAttributes> attribs = new ArrayList<CLDBProto.MinMaxAttributes>();
        CLDBProto.MinMaxAttributes attrib = null;
        if (entityName.contains(MULTI_ARG_SEP)) {
            List<String> entityList = Arrays.asList(entityName.split(MULTI_ARG_SEP));
            Iterator<String> iterator = entityList.iterator();
            while (iterator.hasNext()) {
                String name;
                entityName = name = iterator.next();
                attrib = (CLDBProto.MinMaxAttributes)nameToEnumMap.get(name = name.toLowerCase());
                if (attrib != null) {
                    attribs.add(attrib);
                    continue;
                }
                break;
            }
        } else {
            String name = entityName.toLowerCase();
            attrib = (CLDBProto.MinMaxAttributes)nameToEnumMap.get(name);
            if (attrib != null) {
                attribs.add(attrib);
            }
        }
        if (attrib == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing entityName " + entityName));
            LOG.error((Object)("info getminmax failed. " + entityName + " is not a valid keyword."));
            return;
        }
        GetMinMaxRequestBuilder.addAllMinMaxAttribs(attribs);
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.GetMinMaxProc, (MessageLite)GetMinMaxRequestBuilder.build(), oh);
        CLDBProto.GetMinMaxResponse resp = null;
        try {
            resp = CLDBProto.GetMinMaxResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing info getminmax response."));
            LOG.error((Object)"info getminmax failed. Exception parsing info getminmax response.", (Throwable)ipbe);
            return;
        }
        if (resp.getStatus() == 0) {
            CommandOutput.OutputHierarchy toh = this.formatMinMaxResponse(resp.getEntityList());
            for (CommandOutput.OutputHierarchy.OutputNode a : toh.getOutputNodes()) {
                oh.addNode(a);
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Feature list failed: " + resp.getErrMsg()));
            LOG.error((Object)("Feature list failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
        }
    }

    private CommandOutput.OutputHierarchy formatMinMaxResponse(List<CLDBProto.GetMinMaxResponse.MinMaxEntity> eList) throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        for (CLDBProto.GetMinMaxResponse.MinMaxEntity mf : eList) {
            oh.addNode(this.formatMinMaxEntity(mf));
        }
        return oh;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatMinMaxEntity(CLDBProto.GetMinMaxResponse.MinMaxEntity mf) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        if (mf.hasName()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FEATURE_NAME, (Object)mf.getName()));
        }
        if (mf.hasMinVal()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("min", (Object)mf.getMinVal()));
        }
        if (mf.hasMaxVal()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("max", (Object)mf.getMaxVal()));
        }
        if (mf.hasUnit()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("unit", (Object)mf.getUnit()));
        }
        return out;
    }

    private String getActivationKey(boolean isFile, String activationStr) throws CLIProcessingException {
        if (!isFile) {
            return activationStr;
        }
        StringBuilder sb = new StringBuilder();
        FileReader reader = null;
        try {
            int len;
            reader = new FileReader(activationStr);
            char[] data = new char[1024];
            while ((len = reader.read(data)) != -1) {
                sb.append(data, 0, len);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new CLIProcessingException(fnfe.getMessage(), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new CLIProcessingException(ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String file, CharSequence data, CommandOutput.OutputHierarchy oh, String paramName) {
        if (file == null) {
            return;
        }
        if (file.trim().isEmpty()) {
            LOG.error((Object)"file param empty");
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "File param Empty"));
            return;
        }
        Writer writer = null;
        Charset UTF_8 = StandardCharsets.UTF_8;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF_8));
            writer.append(data);
            oh.addMessage(paramName + " data written to the file " + file);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while writing to file ", (Throwable)e);
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Facing issues while writing to file " + e.getMessage()));
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ex) {
                LOG.warn((Object)"Exception while closing file writer ", (Throwable)ex);
            }
        }
    }

    private CommandOutput.OutputHierarchy.OutputNode constructSsoNode(CLDBProto.SsoConfigParams ssoParams) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode ssoNode = new CommandOutput.OutputHierarchy.OutputNode();
        if (ssoParams.hasIssuer()) {
            ssoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(ISSUERS_PARAM_NAME, (Object)ssoParams.getIssuer()));
        }
        if (ssoParams.hasType()) {
            ssoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SSO_PROVIDER_PARAM_NAME, (Object)ssoParams.getType()));
        }
        if (ssoParams.hasClientId()) {
            ssoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(CLIENT_ID_PARAM_NAME, (Object)ssoParams.getClientId()));
        }
        if (ssoParams.hasClientSecret()) {
            ssoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(CLIENT_SECRET_PARAM_NAME, (Object)ssoParams.getClientSecret()));
        }
        if (this.isParamPresent(SHOW_CERT_PARAM_NAME) && this.getParamBooleanValue(SHOW_CERT_PARAM_NAME, 0) && ssoParams.hasCertificate()) {
            ssoNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(SSO_PROVIDER_CERT_BYTES, (Object)new String(ssoParams.getCertificate().toByteArray()).trim()));
        }
        return ssoNode;
    }

    private KSStateManager getKSStateManager() {
        return new KSStateManager(ClusterServicesUtils.getInstance().getZKClient());
    }

    private void processGetState(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        LOG.debug((Object)"Reached ProcessGetState");
        KSStateManager ks = this.getKSStateManager();
        CLDBProto.KSStateResponse resp = ks.getKSState();
        if (resp.getStatus() != 0) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Startup Get State Failed " + resp.getErrMsg()));
            LOG.error((Object)("Startup Get State Failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
            return;
        }
        String paramValue = this.getParamTextValue(STARTUP_STATE_RESOURCE_PARAM, 0);
        boolean getAll = false;
        String file = null;
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        if (paramValue.equals("all")) {
            getAll = true;
        }
        if (this.isParamPresent(STARTUP_STATE_OUT_PARAM)) {
            file = this.getParamTextValue(STARTUP_STATE_OUT_PARAM, 0).trim();
        }
        if (paramValue.equals("enabled") || getAll) {
            Boolean enabled = resp.getStateInfo().hasEnabled() ? resp.getStateInfo().getEnabled() : false;
            if (!getAll && file != null) {
                this.writeToFile(file, enabled.toString(), oh, "enabled");
            } else {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode("enabled", (Object)enabled));
            }
        }
        if (paramValue.equals(STARTUP_ACTIVATION_KEY_PARAM_NAME) || getAll) {
            String key;
            String string = key = resp.getStateInfo().hasActivationKey() ? resp.getStateInfo().getActivationKey() : "";
            if (!getAll && file != null) {
                this.writeToFile(file, key, oh, STARTUP_ACTIVATION_KEY_PARAM_NAME);
            } else {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(STARTUP_ACTIVATION_KEY_PARAM_NAME, (Object)key));
            }
        }
        if (paramValue.equals(STARTUP_STATE_USAGE_PARAM) || getAll) {
            String usage;
            String string = usage = resp.getStateInfo().hasUsageFile() ? resp.getStateInfo().getUsageFile() : "";
            if (!getAll && file != null) {
                this.writeToFile(file, usage, oh, STARTUP_STATE_USAGE_PARAM);
            } else {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(STARTUP_STATE_USAGE_PARAM, (Object)usage));
            }
        }
        if (paramValue.equals(STARTUP_STATE_CLUSTERID_PARAM) || getAll) {
            String clusterId;
            String string = clusterId = resp.getStateInfo().hasClusterId() ? resp.getStateInfo().getClusterId() : "";
            if (!getAll && file != null) {
                this.writeToFile(file, clusterId, oh, STARTUP_STATE_CLUSTERID_PARAM);
            } else {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(STARTUP_STATE_CLUSTERID_PARAM, (Object)clusterId));
            }
        }
        if (paramValue.equals(STARTUP_STATE_SSO_PARAM) || getAll) {
            CLDBProto.SsoConfigParams ssoParams = resp.getStateInfo().hasSsoParams() ? resp.getStateInfo().getSsoParams() : CLDBProto.SsoConfigParams.newBuilder().build();
            CommandOutput.OutputHierarchy.OutputNode ssoNode = this.constructSsoNode(ssoParams);
            if (!getAll && file != null) {
                this.writeToFile(file, ssoNode.toJSONString(), oh, STARTUP_STATE_CLUSTERID_PARAM);
            } else {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode(STARTUP_STATE_SSO_PARAM, (Object)ssoNode));
            }
        }
        if (getAll) {
            this.writeToFile(file, node.toJSONString(), oh, STARTUP_STATE_CLUSTERID_PARAM);
        }
        oh.addNode(node);
    }

    private void processSetState(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.KSStateResponse resp;
        LOG.debug((Object)"Reached ProcessSetState");
        CLDBProto.KSStateInfo.Builder ksInfo = CLDBProto.KSStateInfo.newBuilder();
        KSStateManager ks = this.getKSStateManager();
        if (this.isParamPresent(STARTUP_ACTIVATION_KEY_PARAM_NAME)) {
            boolean isFile = this.isParamPresent(STARTUP_STATE_ISFILE_PARAM) ? this.getParamBooleanValue(STARTUP_STATE_ISFILE_PARAM, 0) : false;
            String activationStr = this.getParamTextValue(STARTUP_ACTIVATION_KEY_PARAM_NAME, 0);
            try {
                String activationKey = this.getActivationKey(isFile, activationStr);
                ksInfo.setActivationKey(activationKey);
            }
            catch (Exception e) {
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "SetACtivationKey: " + e.getMessage()));
                LOG.error((Object)"Exception During Set ActivationKey", (Throwable)e);
                return;
            }
        }
        if ((resp = ks.setKSState(ksInfo.build())).getStatus() != 0) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Startup Set State Failed, " + resp.getErrMsg()));
            LOG.error((Object)("Startup Set State Failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
            return;
        }
        ks.startService("kvstore");
        ks.startService("cldb");
    }

    private void processStartupCommand(CommandOutput.OutputHierarchy oh, String cmd) throws CLIProcessingException {
        if (oh == null || cmd == null) {
            return;
        }
        try {
            if (this.isParamPresent(STARTUP_GET_PARAM_NAME)) {
                this.processGetState(oh);
            } else if (this.isParamPresent(STARTUP_SET_PARAM_NAME)) {
                this.processSetState(oh);
            }
        }
        catch (Exception e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getLocalizedMessage()));
            return;
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.MinMaxAttributes attrib : CLDBProto.MinMaxAttributes.values()) {
            if (sb.length() == 0) {
                sb.append(attrib.name().toLowerCase());
                continue;
            }
            sb.append("|" + attrib.name().toLowerCase());
        }
        supportedMinMaxEntities = "[" + sb.toString() + "]";
        infoCommand = new CLICommand("info", "usage: cluster info getminmax <comma seperated list of entities>", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)GET_MINMAX_PARAM, (Object)new TextInputParameter(GET_MINMAX_PARAM, "list of entities to fetch min and max values from: " + supportedMinMaxEntities, true, null)).build(), null).setShortUsage("returns cluster wide min and max values for given list of comma seperated entities");
        featureCommand = new CLICommand("feature", "Enable or List features on the cluster", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{featureEnableCommand, featureListCommand});
        billingUsage = "cluster getbillingusage -fileName <usage file path> [-from <timeframe>] [-till <timeframe>] [-duration <duration in minutes>] [-clearText <true|false>]";
        getBillingUsageCommand = new CLICommand("getbillingusage", billingUsage, ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"from", (Object)new TextInputParameter("from", "start_time (UTC timestamp in millisecond or time in yyyy-MM-dd,HH:mm format)", false, null)).put((Object)"till", (Object)new TextInputParameter("till", "end_time (UTC timestamp in millisecond or time in yyyy-MM-dd,HH:mm format)", false, null)).put((Object)"duration", (Object)new IntegerInputParameter("duration", "duration (in minutes. Minimum value is 60 minutes)", false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).put((Object)"fileName", (Object)new TextInputParameter("fileName", "fileName (file path)", true, null)).put((Object)"clearText", (Object)new BooleanInputParameter("clearText", "<true|false> true generates the file in clear text", false, null)).build(), null).setShortUsage(billingUsage);
        meteringUsage = "cluster getmeteringusage [-from <timeframe>] [-till <timeframe>] [-duration <duration in minutes>]";
        getMeteringUsageCommand = new CLICommand("getmeteringusage", meteringUsage, ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"from", (Object)new TextInputParameter("from", "start_time (UTC timestamp in millisecond or time in yyyy-MM-dd,HH:mm format)", false, null)).put((Object)"till", (Object)new TextInputParameter("till", "end_time (UTC timestamp in millisecond or time in yyyy-MM-dd,HH:mm format)", false, null)).put((Object)"duration", (Object)new IntegerInputParameter("duration", "duration (in minutes. Minimum value is 60 minutes)", false, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build(), null).setShortUsage(meteringUsage);
        STATUS_USAGE = SERVICES_STATUS;
        ENABLE_USAGE = "enable {false | true -token <token>}";
        SERVICE_USAGE = "cluster services status";
        statusSubCommand = new CLICommand(SERVICES_STATUS, SERVICE_USAGE, ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, null).setShortUsage(SERVICE_USAGE);
        serviceCommand = new CLICommand("services", "enable, disable and status of the kill Switch command", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), new CLICommand[]{statusSubCommand}).setShortUsage(SERVICE_USAGE);
        setSsoCommand = new CLICommand("setssoconf", "set the cluster level SSO Params", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)ISSUERS_PARAM_NAME, (Object)new TextInputParameter(ISSUERS_PARAM_NAME, "issuers endpoint", true, null)).put((Object)SSO_PROVIDER_PARAM_NAME, (Object)new TextInputParameter(SSO_PROVIDER_PARAM_NAME, "sso provider name keycloak | okta", true, null)).put((Object)CLIENT_ID_PARAM_NAME, (Object)new TextInputParameter(CLIENT_ID_PARAM_NAME, "client's id", false, null)).put((Object)CLIENT_SECRET_PARAM_NAME, (Object)new TextInputParameter(CLIENT_SECRET_PARAM_NAME, "client's secret", false, null)).put((Object)SSO_PROVIDER_CERT_FILE, (Object)new TextInputParameter(SSO_PROVIDER_CERT_FILE, "sso certificate", false, null)).put((Object)SSO_PROVIDER_CERT_BYTES, (Object)new TextInputParameter(SSO_PROVIDER_CERT_BYTES, "sso certificate", false, null).setInvisible(true)).build(), null).setShortUsage("");
        getSsoCommand = new CLICommand("getssoconf", "fetches the cluster level SSO params", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)SHOW_CERT_PARAM_NAME, (Object)new BooleanInputParameter(SHOW_CERT_PARAM_NAME, "show certificate", false, null).setInvisible(true)).build(), null).setShortUsage("");
        resetSsoCommand = new CLICommand("resetssoconf", "fetches the cluster level SSO params", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("");
        getStartupStateCommand = new CLICommand(STARTUP_GET_PARAM_NAME, "fetches the KSState(startup) parameters from zookeeper", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)STARTUP_STATE_RESOURCE_PARAM, (Object)new TextInputParameter(STARTUP_STATE_RESOURCE_PARAM, "[enabled | usage | clusterid | sso | activationkey | all]", true, null)).put((Object)STARTUP_STATE_OUT_PARAM, (Object)new TextInputParameter(STARTUP_STATE_OUT_PARAM, "outfile", false, null)).build(), null).setShortUsage("cluster startup get -resource [activationkey|usage|enabled|clusterid|sso|all] -file <FILE>");
        setStartupStateCommand = new CLICommand(STARTUP_SET_PARAM_NAME, "sets the KSState(startup) parameters in zookeeper", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)STARTUP_ACTIVATION_KEY_PARAM_NAME, (Object)new TextInputParameter(STARTUP_ACTIVATION_KEY_PARAM_NAME, "new activation key", false, null)).put((Object)STARTUP_STATE_ISFILE_PARAM, (Object)new BooleanInputParameter(STARTUP_STATE_ISFILE_PARAM, "true|false", false, Boolean.valueOf(false))).build(), null).setShortUsage("cluster startup set -activationkey ACTIVATONKEY is_file [true|false]");
        startupCommand = new CLICommand(STARTUP_SUBCMD_NAME, "get, set kill Switch state values in zookeeper", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), new CLICommand[]{getStartupStateCommand, setStartupStateCommand}).setShortUsage("");
        clusterCommands = new CLICommand("cluster", "set and get cluster wide info", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{mapreduceCommands, DbGatewayCommands.gatewayCommands, featureCommand, infoCommand, DbQueryServiceCommands.queryServiceCommands, s3ConfigCommands, getBillingUsageCommand, getMeteringUsageCommand, serviceCommand, startupCommand, setSsoCommand, getSsoCommand, resetSsoCommand}).setShortUsage("cluster [mapreduce [get|set] | gateway | feature [enable|list] | info getminmax | s3config [set|add|remove|show] | getbillingusage [from|till|duration|fileName] | services status | setssoconf | getssoconf | resetssoconf] | getmeteringusage [from|till|duration] | startup [get -resource [enabled|activationkey|usage|sso|clusterid|all]|set -activationkey <Key>]]");
    }

    public static class VersionFileContents {
        String classic_version;
        String yarn_version;
        String default_mode;
    }
}

