/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.DumpCommands;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class VolumeMirrorCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(VolumeMirrorCommands.class);
    public static final String MIRROR_VOLUME_PARAM_NAME = "name";
    public static final String ROLLFWD_POST_MIRROR = "rollforward";
    public static final String DEL_SRCSNAP = "deletesourcesnap";
    public static final String MIRROR_VERBOSE_OUTPUT = "verbose";
    public static final String IS_FULL_MIRROR = "full";
    public static final String MULTI_ARG_SEP = ",";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String SRC_SNAPSHOT_NAME = "sourcesnapshot";
    public static final String SRC_SNAPSHOT_FORCE_MIRROR_START = "force";
    Security.CredentialsMsg srcCreds;
    Security.CredentialsMsg dstCreds;
    private String clusterName;
    boolean printVerboseMsg;
    static boolean isHardMount = false;
    public static final String startMirrorUsage = "volume mirror start -name volname [-full <true|false>] [-cluster clustername] [-sourcesnapshot source snapshot name] [-force force mirror from source snapshot]";
    public static final String stopMirrorUsage = "volume mirror stop -name volname [-cluster clustername]";
    public static final String pushMirrorUsage = "volume mirror push -name volname [-cluster clustername] [-verbose <true|false> Default:true (if true then print the mirror progress)";
    public static final String mirrorStatusUsage = "volume mirror status -name volname [-cluster clustername][-verbose <true|false> default:true] (if true, will displayed detailed container information)";
    public static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster_name", false, null)).build();
    public static final CLICommand mirrorStartCommand = new CLICommand("start", "", VolumeMirrorCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"full", (Object)new BooleanInputParameter("full", "<true|false>", false, Boolean.valueOf(false))).put((Object)"rollforward", (Object)new BooleanInputParameter("rollforward", "rollforward", false, Boolean.valueOf(true)).setInvisible(true)).put((Object)"deletesourcesnap", (Object)new BooleanInputParameter("deletesourcesnap", "delsourcesnap", false, Boolean.valueOf(true)).setInvisible(true)).put((Object)"sourcesnapshot", (Object)new TextInputParameter("sourcesnapshot", "source snapshot name", false, null)).put((Object)"force", (Object)new BooleanInputParameter("force", "force mirror", false, null)).build(), null).setShortUsage("volume mirror start -name volname [-full <true|false>] [-cluster clustername] [-sourcesnapshot source snapshot name] [-force force mirror from source snapshot]");
    public static final CLICommand mirrorStopCommand = new CLICommand("stop", "", VolumeMirrorCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).build(), null).setShortUsage("volume mirror stop -name volname [-cluster clustername]");
    public static final CLICommand mirrorStatusCommand = new CLICommand("status", "", VolumeMirrorCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(1))).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)"verbose", (Object)new BooleanInputParameter("verbose", "<true/false> if true, will displayed detailed container information", false, Boolean.valueOf(true))).build(), null).setShortUsage("volume mirror status -name volname [-cluster clustername][-verbose <true|false> default:true] (if true, will displayed detailed container information)");
    public static final CLICommand mirrorPushCommand = new CLICommand("push", "", VolumeMirrorCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)"name", (Object)new TextInputParameter("name", "name", true, null)).put((Object)"verbose", (Object)new BooleanInputParameter("verbose", "verbose", false, Boolean.valueOf(true))).build(), null).setShortUsage("volume mirror push -name volname [-cluster clustername] [-verbose <true|false> Default:true (if true then print the mirror progress)");
    public static CLICommand[] mirrorCommandsArray = new CLICommand[]{mirrorStartCommand, mirrorStopCommand, mirrorStatusCommand, mirrorPushCommand};
    public static CLICommand mirrorCommands = new CLICommand("mirror", "mirror", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, mirrorCommandsArray).setShortUsage("mirror [start|stop|status|push]");

    public VolumeMirrorCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ExecuteRealCommand" + this.cliCommand.getCommandName()));
        }
        this.init();
        if (this.cliCommand.getCommandName().equalsIgnoreCase(START_PARAM_NAME)) {
            try {
                return this.startMirror();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Start Mirror Exception ", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("stop")) {
            try {
                return this.stopMirror();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Stop Mirror Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("push")) {
            try {
                return this.pushMirror();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Push Mirror Exception", (Throwable)e);
            }
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase("status")) {
            try {
                return this.statusMirror();
            }
            catch (Exception e) {
                throw new CLIProcessingException("Status Mirror Exception", (Throwable)e);
            }
        }
        return null;
    }

    private CommandOutput startMirror() throws CLIProcessingException {
        MirrorVolumeInfo mInfo;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> volumeNames = new ArrayList<String>();
        ArrayList<MirrorVolumeInfo> volumeMirrorList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoEntList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoSrcVolList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNotMirrorList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeFailedStartList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoCrossClusterMirrorList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoSrcLicenseList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoDestLicenseList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoSrcEntList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoSrcPermList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoDestPermList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeMirrorInProgressList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> finalMirrorList = new ArrayList<MirrorVolumeInfo>();
        String userDefinedSrcSnapshotName = null;
        CLDBProto.MirrorSrcSnapshotInfo.Builder userDefinedSrcSnapshotInfo = null;
        boolean forceMirrorStart = false;
        boolean rollForwardPostMirror = this.getParamBooleanValue(ROLLFWD_POST_MIRROR, 0);
        boolean delSrcSnapshot = this.getParamBooleanValue(DEL_SRCSNAP, 0);
        boolean isFullMirror = this.getParamBooleanValue(IS_FULL_MIRROR, 0);
        String mirrorVolumeName = this.getParamTextValue(MIRROR_VOLUME_PARAM_NAME, 0);
        if (this.isParamPresent(SRC_SNAPSHOT_NAME)) {
            userDefinedSrcSnapshotName = this.getParamTextValue(SRC_SNAPSHOT_NAME, 0);
            delSrcSnapshot = false;
            forceMirrorStart = this.isParamPresent(SRC_SNAPSHOT_FORCE_MIRROR_START) ? this.getParamBooleanValue(SRC_SNAPSHOT_FORCE_MIRROR_START, 0) : false;
        } else if (this.isParamPresent(SRC_SNAPSHOT_FORCE_MIRROR_START)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "force option is valid with sourcesnapshot only"));
            return output;
        }
        if (!mirrorVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.add(mirrorVolumeName);
        } else {
            volumeNames.addAll(Arrays.asList(mirrorVolumeName.split(MULTI_ARG_SEP)));
        }
        if (userDefinedSrcSnapshotName != null && volumeNames.size() > 1) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "sourcesnapshot can be provided for single volume only"));
            return output;
        }
        for (String volumeName : volumeNames) {
            mInfo = new MirrorVolumeInfo(volumeName, this.clusterName);
            int status = VolumeMirrorCommands.ValidateMirrorVolume(mInfo, this.getUserCredentials());
            if (status == 0) {
                CLDBProto.MirrorInfo.MirrorStatus mStatus = mInfo.volProperties.getMirrorInfo().getMirrorStatus();
                if (mStatus != CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_COMPLETE && mStatus != CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_FAILED && mStatus != CLDBProto.MirrorInfo.MirrorStatus.STATE_CONVERT_COMPLETE) {
                    LOG.info((Object)("Volume " + volumeName + " mirroring is already in progress  cluster " + this.clusterName));
                    volumeMirrorInProgressList.add(mInfo);
                    continue;
                }
                if (mInfo.volProperties.getMirrorInfo().getSrcVolumeId() == 0) {
                    LOG.info((Object)("Volume " + volumeName + " doesn't have src volume id  cluster " + this.clusterName + ". User need to use volume modify command to set the src  volume information in the volume before starting the mirroring"));
                    volumeNoSrcVolList.add(mInfo);
                    continue;
                }
                LOG.info((Object)("Volume " + volumeName + " is a valid mirror volume in cluster " + this.clusterName));
                volumeMirrorList.add(mInfo);
                continue;
            }
            if (status == 2) {
                LOG.error((Object)("Volume " + volumeName + " doesn't exist in cluster " + this.clusterName));
                volumeNoEntList.add(mInfo);
                continue;
            }
            if (status == 22) {
                LOG.error((Object)("Volume " + volumeName + " is not a mirror volume in  cluster " + this.clusterName));
                volumeNotMirrorList.add(mInfo);
                continue;
            }
            if (status == 10010) {
                LOG.error((Object)("No mirror license in cluster " + this.clusterName + " for mirroring of volume " + volumeName));
                volumeNoDestLicenseList.add(mInfo);
                continue;
            }
            if (status == 1) {
                LOG.error((Object)("No permission to mirror restore in cluster " + this.clusterName + " for mirroring of volume " + volumeName));
                volumeNoDestPermList.add(mInfo);
                continue;
            }
            LOG.error((Object)("Failed to get the mirror information for Volume " + volumeName + " from CLDB of cluster " + this.clusterName + ". status code " + status));
            mInfo.err = status;
            volumeFailedStartList.add(mInfo);
        }
        for (MirrorVolumeInfo mInfo2 : volumeMirrorList) {
            String volumeName = mInfo2.volumeName;
            int volumeId = mInfo2.volProperties.getVolumeId();
            int status = 0;
            if (userDefinedSrcSnapshotName != null) {
                CLDBProto.MirrorInfo mirrInfo = mInfo2.volProperties.getMirrorInfo();
                userDefinedSrcSnapshotInfo = CLDBProto.MirrorSrcSnapshotInfo.newBuilder();
                try {
                    status = this.lookupSnapshot(mirrInfo, userDefinedSrcSnapshotName, forceMirrorStart, userDefinedSrcSnapshotInfo);
                }
                catch (CLIProcessingException e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getLocalizedMessage()));
                    continue;
                }
                if (status == 2) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "source snapshot does not exist"));
                    continue;
                }
                if (status != 0) {
                    LOG.error((Object)("Failed to start mirroring for volume " + volumeName + " in cluster " + this.clusterName + ", Lookup of source snapshot " + userDefinedSrcSnapshotName + " failed, status code " + status));
                    mInfo2.err = status;
                    volumeFailedStartList.add(mInfo2);
                    continue;
                }
            }
            if ((status = this.startMirror(this.clusterName, volumeName, volumeId, rollForwardPostMirror, delSrcSnapshot, isFullMirror, userDefinedSrcSnapshotInfo != null ? userDefinedSrcSnapshotInfo.build() : null)) != 0) {
                LOG.error((Object)("Failed to start mirroring for volume" + volumeName + " in cluster " + this.clusterName + ". Failure status code " + status));
                mInfo2.err = status;
                volumeFailedStartList.add(mInfo2);
                continue;
            }
            finalMirrorList.add(mInfo2);
        }
        if (finalMirrorList.size() > 0) {
            Object successVolumeNames = "";
            int i = 0;
            for (i = 0; i < finalMirrorList.size() - 1; ++i) {
                mInfo = (MirrorVolumeInfo)finalMirrorList.get(i);
                successVolumeNames = (String)successVolumeNames + "'" + mInfo.volumeName + "', ";
            }
            mInfo = (MirrorVolumeInfo)finalMirrorList.get(i);
            successVolumeNames = (String)successVolumeNames + "'" + mInfo.volumeName + "' ";
            LOG.info((Object)("Starting mirroring operation for volumes : " + (String)successVolumeNames));
            String msgString = volumeMirrorList.size() > 20 ? "Started mirror operation for " + volumeMirrorList.size() + " volumes." : "Started mirror operation for volume(s) " + (String)successVolumeNames;
            out.addMessage(msgString);
        }
        String s = "Start mirror operation for ";
        this.PrintErrorMsgForVolumeList(s, volumeNoEntList, "Volume not found", out);
        this.PrintErrorMsgForVolumeList(s, volumeNotMirrorList, "not a mirror volume", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoDestPermList, "Operation not permitted", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoDestLicenseList, "No license for mirroring", out);
        this.PrintErrorMsgForVolumeList(s, volumeMirrorInProgressList, "Mirroring already in progress", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoSrcEntList, "Source volume not found", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoSrcPermList, "Operation not permitted on source volume", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoSrcEntList, "Source volume not found", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoSrcLicenseList, "No license for mirroring on source cluster", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoCrossClusterMirrorList, "Cross cluster mirroring from MapR security enabled source cluster is not supported in this release", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoSrcVolList, "Not attached with a source volume for mirroring.  Use \"maprcli volume modify -source \" command to setup the source volume", out);
        if (volumeFailedStartList.size() > 0) {
            int err = ((MirrorVolumeInfo)volumeFailedStartList.get((int)0)).err;
            Object errStr = "errcode " + err;
            if (err == 10019) {
                errStr = "snapshot restore operation is in progress";
            }
            this.PrintErrorMsgForVolumeList(s, volumeFailedStartList, (String)errStr, out);
        }
        return output;
    }

    private int lookupSnapshot(CLDBProto.MirrorInfo mirrInfo, String userDefinedSrcSnapshotName, boolean forceMirrorStart, CLDBProto.MirrorSrcSnapshotInfo.Builder userDefinedSrcSnapshotInfo) throws CLIProcessingException {
        byte[] data = null;
        String srcClusterName = mirrInfo.getSrcClusterName();
        String srcVolumeName = mirrInfo.getSrcVolumeName();
        CLDBProto.SnapshotLookupResponse snapLookupResp = null;
        CLDBProto.SnapshotLookupRequest snapLookupReq = CLDBProto.SnapshotLookupRequest.newBuilder().setRwVolumeName(srcVolumeName).setSnapshotName(userDefinedSrcSnapshotName).setCreds(this.getUserCredentials()).build();
        try {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(srcClusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.SnapshotLookupProc.getNumber(), (MessageLite)snapLookupReq, CLDBProto.SnapshotLookupResponse.class, VolumeMirrorCommands.getKeyType((String)srcClusterName, (boolean)this.isServerCall));
            if (data == null) {
                throw new CLIProcessingException("Exception while processing source SnapshotLookup RPC");
            }
            snapLookupResp = CLDBProto.SnapshotLookupResponse.parseFrom((byte[])data);
            if (snapLookupResp.getStatus() == 0) {
                this.ValidateAndSetSrcSnapshotInfo(mirrInfo, snapLookupResp, userDefinedSrcSnapshotName, forceMirrorStart, userDefinedSrcSnapshotInfo);
            }
            return snapLookupResp.getStatus();
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException...", (Throwable)e);
        }
        catch (CLIProcessingException e) {
            throw new CLIProcessingException("SourceSnapshot: " + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception doing snapshot lookup to CLDB, " + e.getLocalizedMessage());
        }
    }

    private void ValidateAndSetSrcSnapshotInfo(CLDBProto.MirrorInfo mirrInfo, CLDBProto.SnapshotLookupResponse snapLookupResp, String userDefinedSrcSnapshotName, boolean forceMirrorStart, CLDBProto.MirrorSrcSnapshotInfo.Builder userDefinedSrcSnapshotInfo) throws CLIProcessingException {
        long currDataSrcSnapCreateTimeMillis = snapLookupResp.getSnapshotInfo().getDataSrcSnapCreateTimeMillis();
        if (currDataSrcSnapCreateTimeMillis < mirrInfo.getDataSrcSnapCreateTimeMillis() && !forceMirrorStart) {
            throw new CLIProcessingException("snapshot provided is older than previously resynced snapshot");
        }
        userDefinedSrcSnapshotInfo.setSnapshotName(userDefinedSrcSnapshotName);
        userDefinedSrcSnapshotInfo.setSnapshotId(snapLookupResp.getSnapshotInfo().getSnapshotId());
        userDefinedSrcSnapshotInfo.setRootContainerId(snapLookupResp.getSnapshotInfo().getRootContainerId());
        userDefinedSrcSnapshotInfo.setDataSrcSnapCreateTimeMillis(currDataSrcSnapCreateTimeMillis);
    }

    private void PrintErrorMsgForVolumeList(String msgPrefix, List<MirrorVolumeInfo> list, String errString, CommandOutput.OutputHierarchy out) {
        if (list.size() > 0) {
            MirrorVolumeInfo mInfo;
            Object volumeNames = "";
            int i = 0;
            for (i = 0; i < list.size() - 1; ++i) {
                mInfo = list.get(i);
                volumeNames = (String)volumeNames + "'" + mInfo.volumeName + "', ";
            }
            mInfo = list.get(i);
            volumeNames = (String)volumeNames + "'" + mInfo.volumeName + "' ";
            String msgString = list.size() > 20 ? msgPrefix + list.size() + " volumes :" + errString : msgPrefix + (String)volumeNames + "failed : " + errString;
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msgString));
        }
    }

    private int startMirror(String clusterName, String volumeName, int volumeId, boolean rollForwardPostMirror, boolean delSrcSnapshot, boolean isFullMirror, CLDBProto.MirrorSrcSnapshotInfo userDefinedSrcSnapshotInfo) throws CLIProcessingException {
        CLDBProto.MirrorStartRequest.Builder req = CLDBProto.MirrorStartRequest.newBuilder();
        CLDBProto.MirrorStartResponse resp = null;
        byte[] data = null;
        req.setMirrorType(CLDBProto.MirrorType.MIRROR_TYPE_LIVE);
        req.setVolumeName(volumeName);
        req.setVolumeId(volumeId);
        req.setSrcCreds(this.getUserCredentials());
        req.setDestCreds(this.getUserCredentials());
        if (clusterName != null) {
            req.setClusterName(clusterName);
        }
        if (userDefinedSrcSnapshotInfo != null) {
            req.setUserDefinedSrcSnapshotInfo(userDefinedSrcSnapshotInfo);
        }
        req.setRollForwardPostMirror(rollForwardPostMirror);
        req.setDeleteSrcSnapshot(delSrcSnapshot);
        req.setIsFullMirror(isFullMirror);
        try {
            data = VolumeMirrorCommands.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.MirrorStartProc.getNumber(), (MessageLite)req.build(), CLDBProto.MirrorStartResponse.class, isHardMount);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.MirrorStartResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to cluster" + clusterName, (Throwable)e);
        }
        if (resp.getStatus() != 0) {
            LOG.error((Object)("Mirror start RPC to CLDB for volume " + volumeName + "@" + clusterName + " failed with status " + resp.getStatus()));
            return resp.getStatus();
        }
        return 0;
    }

    private CommandOutput stopMirror() throws CLIProcessingException {
        MirrorVolumeInfo mInfo;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> volumeNames = new ArrayList<String>();
        ArrayList<MirrorVolumeInfo> volumeMirrorList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> inProgressMirrorList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoEntList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNotMirrorList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeFailedStartList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoDestLicenseList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> volumeNoDestPermList = new ArrayList<MirrorVolumeInfo>();
        ArrayList<MirrorVolumeInfo> finalMirrorList = new ArrayList<MirrorVolumeInfo>();
        String mirrorVolumeName = this.getParamTextValue(MIRROR_VOLUME_PARAM_NAME, 0);
        if (!mirrorVolumeName.contains(MULTI_ARG_SEP)) {
            volumeNames.add(mirrorVolumeName);
        } else {
            volumeNames.addAll(Arrays.asList(mirrorVolumeName.split(MULTI_ARG_SEP)));
        }
        for (String volumeName : volumeNames) {
            mInfo = new MirrorVolumeInfo(volumeName, this.clusterName);
            int status = VolumeMirrorCommands.ValidateMirrorVolume(mInfo, this.getUserCredentials());
            if (status == 0) {
                CLDBProto.MirrorInfo.MirrorStatus mStatus = mInfo.volProperties.getMirrorInfo().getMirrorStatus();
                if (mStatus == CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_COMPLETE || mStatus == CLDBProto.MirrorInfo.MirrorStatus.STATE_CONVERT_COMPLETE || mStatus == CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_FAILED) {
                    LOG.info((Object)("Volume " + volumeName + " mirroring is already stopped cluster " + this.clusterName + "status " + mStatus));
                    finalMirrorList.add(mInfo);
                    continue;
                }
                if (mInfo.volProperties.getMirrorInfo().getStopMirrorInProgress()) {
                    LOG.info((Object)("Volume " + volumeName + " mirror stop is in progress cluster " + this.clusterName + "status " + mStatus));
                    inProgressMirrorList.add(mInfo);
                    continue;
                }
                LOG.info((Object)("Volume " + volumeName + " is a valid mirror volume in cluster " + this.clusterName));
                volumeMirrorList.add(mInfo);
                continue;
            }
            if (status == 2) {
                LOG.error((Object)("Volume " + volumeName + " doesn't exist in cluster " + this.clusterName));
                volumeNoEntList.add(mInfo);
                continue;
            }
            if (status == 22) {
                LOG.error((Object)("Volume " + volumeName + " is not a mirror volume in  cluster " + this.clusterName));
                volumeNotMirrorList.add(mInfo);
                continue;
            }
            if (status == 10010) {
                LOG.error((Object)("No mirror license in cluster " + this.clusterName + " for mirroring of volume " + volumeName));
                volumeNoDestLicenseList.add(mInfo);
                continue;
            }
            if (status == 1) {
                LOG.error((Object)("No permission to mirror restore in cluster " + this.clusterName + " for mirroring of volume " + volumeName));
                volumeNoDestPermList.add(mInfo);
                continue;
            }
            LOG.error((Object)("Failed to get the mirror information for Volume " + volumeName + " from CLDB of cluster " + this.clusterName + ". status code " + status));
            mInfo.err = status;
            volumeFailedStartList.add(mInfo);
        }
        for (MirrorVolumeInfo mInfo2 : volumeMirrorList) {
            String volumeName = mInfo2.volumeName;
            int volumeId = mInfo2.volProperties.getVolumeId();
            int status = this.stopMirror(this.clusterName, volumeName, volumeId);
            if (status != 0) {
                LOG.error((Object)("Failed to stop mirroring for volume " + volumeName + " in cluster " + this.clusterName + ". Failure status code " + status));
                mInfo2.err = status;
                volumeFailedStartList.add(mInfo2);
                continue;
            }
            finalMirrorList.add(mInfo2);
        }
        if (finalMirrorList.size() > 0) {
            Object successVolumeNames = "";
            int i = 0;
            for (i = 0; i < finalMirrorList.size() - 1; ++i) {
                mInfo = (MirrorVolumeInfo)finalMirrorList.get(i);
                successVolumeNames = (String)successVolumeNames + "'" + mInfo.volumeName + "', ";
            }
            mInfo = (MirrorVolumeInfo)finalMirrorList.get(i);
            successVolumeNames = (String)successVolumeNames + "'" + mInfo.volumeName + "' ";
            LOG.info((Object)("Stopped mirroring operation for volumes : " + (String)successVolumeNames));
            String msgString = finalMirrorList.size() > 20 ? "Stopped mirror operation for " + volumeMirrorList.size() + " volumes." : "Stopped mirror operation for " + (String)successVolumeNames;
            out.addMessage(msgString);
        }
        String s = "Stop mirror operation for ";
        this.PrintErrorMsgForVolumeList(s, inProgressMirrorList, "mirror stop in progress", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoEntList, "Volume not found", out);
        this.PrintErrorMsgForVolumeList(s, volumeNotMirrorList, "not a mirror volume", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoDestPermList, "Operation not permitted", out);
        this.PrintErrorMsgForVolumeList(s, volumeNoDestLicenseList, "No license for mirroring", out);
        if (volumeFailedStartList.size() > 0) {
            int err = ((MirrorVolumeInfo)volumeFailedStartList.get((int)0)).err;
            if (err == 114) {
                this.PrintErrorMsgForVolumeList(s, volumeFailedStartList, "Operation already in progress", out);
            } else if (err == 115) {
                this.PrintErrorMsgForVolumeList(s, volumeFailedStartList, "Other Operation already in progress. Please check logs.", out);
            } else {
                this.PrintErrorMsgForVolumeList(s, volumeFailedStartList, "errcode " + err, out);
            }
        }
        return output;
    }

    private int stopMirror(String clusterName, String volumeName, int volumeId) throws CLIProcessingException {
        LOG.info((Object)("Stopping mirror for volume " + volumeName + "@" + clusterName + " volId " + volumeId));
        CLDBProto.MirrorStopRequest.Builder req = CLDBProto.MirrorStopRequest.newBuilder();
        CLDBProto.MirrorStopResponse resp = null;
        byte[] data = null;
        req.setVolumeName(volumeName);
        req.setVolumeId(volumeId);
        req.setSrcCreds(this.getUserCredentials());
        req.setDestCreds(this.getUserCredentials());
        if (clusterName != null) {
            req.setClusterName(clusterName);
        }
        try {
            data = VolumeMirrorCommands.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.MirrorStopProc.getNumber(), (MessageLite)req.build(), CLDBProto.MirrorStopResponse.class, isHardMount);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.MirrorStopResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to cluster" + clusterName, (Throwable)e);
        }
        if (resp.getStatus() != 0) {
            LOG.error((Object)("Mirror stop RPC to CLDB for volume " + volumeName + "@" + clusterName + " failed with status " + resp.getStatus()));
            return resp.getStatus();
        }
        return resp.getStatus();
    }

    void init() throws CLIProcessingException {
        if (this.isParamPresent("cluster")) {
            this.clusterName = this.getParamTextValue("cluster", 0);
            if (!CLDBRpcCommonUtils.getInstance().isValidClusterName(this.clusterName)) {
                throw new CLIProcessingException("Invalid cluster: " + this.clusterName);
            }
        } else {
            this.clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using the clustername : " + this.clusterName));
        }
        this.srcCreds = this.getUserCredentials();
        this.dstCreds = this.getUserCredentials();
    }

    public static boolean ValidateClusterName(String clusterName) {
        int index = clusterName.indexOf(58);
        if (index == -1 || index == 0) {
            return false;
        }
        try {
            Integer.parseInt(clusterName.substring(index + 1));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static int ValidateMirrorVolume(MirrorVolumeInfo mInfo, Security.CredentialsMsg creds) throws CLIProcessingException {
        String volumeName = mInfo.volumeName;
        String clusterName = mInfo.clusterName;
        CLDBProto.VolumeLookupRequest.Builder req = CLDBProto.VolumeLookupRequest.newBuilder().setCreds(creds).setVolumeName(volumeName);
        CLDBProto.VolumeLookupResponse resp = null;
        byte[] data = null;
        try {
            data = VolumeMirrorCommands.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req.build(), CLDBProto.VolumeLookupResponse.class, isHardMount);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to cluster" + clusterName, (Throwable)e);
        }
        if (resp.getStatus() != 0) {
            LOG.error((Object)("VolumeLookup RPC to CLDB for volume " + volumeName + "@" + clusterName + " failed with status " + resp.getStatus()));
            return resp.getStatus();
        }
        if (!resp.getVolInfo().getVolProperties().getIsMirrorVol()) {
            LOG.error((Object)("volume " + volumeName + "@" + clusterName + " is not a mirror volume"));
            return 22;
        }
        mInfo.volProperties = resp.getVolInfo().getVolProperties();
        return VolumeMirrorCommands.CheckMirrorPermission(mInfo.volProperties.getVolumeId(), mInfo.volProperties.getVolumetype(), clusterName, true, creds);
    }

    public static int ValidateSourceVolume(MirrorVolumeInfo mInfo, Security.CredentialsMsg creds) throws CLIProcessingException {
        int volumeId = mInfo.volProperties.getMirrorInfo().getSrcVolumeId();
        String clusterName = mInfo.volProperties.getMirrorInfo().getSrcClusterName();
        return VolumeMirrorCommands.CheckMirrorPermission(volumeId, Common.VolumeType.VTRwConvertibleMirror, clusterName, false, creds);
    }

    public static int CheckMirrorPermission(int volumeId, Common.VolumeType vt, String clusterName, boolean isRestore, Security.CredentialsMsg creds) throws CLIProcessingException {
        byte[] data = null;
        CLDBProto.MirrorDumpPermCheckRequest.Builder mirrorDumpPermCheckReq = CLDBProto.MirrorDumpPermCheckRequest.newBuilder();
        CLDBProto.MirrorDumpPermCheckResponse mirrorDumpPermCheckResp = null;
        mirrorDumpPermCheckReq.setVolumeId(volumeId);
        mirrorDumpPermCheckReq.setVolumetype(vt);
        mirrorDumpPermCheckReq.setCreds(creds);
        if (isRestore) {
            mirrorDumpPermCheckReq.setCanRestore(true);
        } else {
            mirrorDumpPermCheckReq.setCanMirror(true);
        }
        try {
            data = VolumeMirrorCommands.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.MirrorDumpPermCheckProc.getNumber(), (MessageLite)mirrorDumpPermCheckReq.build(), CLDBProto.MirrorDumpPermCheckResponse.class, isHardMount);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            mirrorDumpPermCheckResp = CLDBProto.MirrorDumpPermCheckResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to cluster" + clusterName, (Throwable)e);
        }
        return mirrorDumpPermCheckResp.getStatus();
    }

    private void PrintVerboseMsg(String msg) {
        if (this.printVerboseMsg) {
            System.out.println(msg);
        }
    }

    private CommandOutput pushMirror() throws CLIProcessingException, InterruptedException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        isHardMount = true;
        String volumeName = this.getParamTextValue(MIRROR_VOLUME_PARAM_NAME, 0);
        this.printVerboseMsg = this.getParamBooleanValue(MIRROR_VERBOSE_OUTPUT, 0);
        CLDBProto.VolumeLookupRequest.Builder req = CLDBProto.VolumeLookupRequest.newBuilder().setCreds(this.getUserCredentials()).setVolumeName(volumeName);
        CLDBProto.VolumeLookupResponse resp = null;
        byte[] data = null;
        try {
            data = VolumeMirrorCommands.sendRequest(this.clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req.build(), CLDBProto.VolumeLookupResponse.class, isHardMount);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            resp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to cluster" + this.clusterName, (Throwable)e);
        }
        if (resp.getStatus() == 2) {
            LOG.error((Object)("Volume Push command volume " + volumeName + "@" + this.clusterName + " doesn't exist" + resp.getStatus()));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(2, "volume " + volumeName + " doesn't exist"));
            return output;
        }
        if (resp.getStatus() != 0) {
            LOG.error((Object)("Volume Push command volume " + volumeName + "@" + this.clusterName + " CLDB returned error in query volume properties, errcode" + resp.getStatus()));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Could not get volume properties for volume " + volumeName));
            return output;
        }
        int status = VolumeMirrorCommands.CheckMirrorPermission(resp.getVolInfo().getVolumeId(), resp.getVolInfo().getVolProperties().getVolumetype(), this.clusterName, false, this.getUserCredentials());
        if (status == 10010) {
            LOG.error((Object)("Volume Push command volume " + volumeName + "@" + this.clusterName + " no mirror license found , errcode" + status));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, " No mirror license for mirroring of " + volumeName));
            return output;
        }
        if (status == 1) {
            LOG.error((Object)("Volume Push command volume " + volumeName + "@" + this.clusterName + " not enough privileges, errcode" + status));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, " No permission to mirror " + volumeName));
            return output;
        }
        status = this.PushToMirrors(volumeName, resp.getVolInfo().getVolumeId(), this.clusterName);
        if (status != 0) {
            LOG.error((Object)("Volume push failed for volume " + volumeName + " error " + status));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, "Failed to push to mirrors for volume" + volumeName));
        } else {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Successfully completed mirror push to all local mirrors of volume " + volumeName));
        }
        return output;
    }

    private int PushToMirrors(String volumeName, int volumeId, String cluster) throws CLIProcessingException, InterruptedException {
        ArrayList<CLDBProto.VolumeInfo> mirrorVolumes = new ArrayList<CLDBProto.VolumeInfo>();
        int status = this.getMirrorVolumes(volumeName, volumeId, cluster, mirrorVolumes);
        if (status != 0) {
            return status;
        }
        ArrayList<MirrorPushThread> pushThreads = new ArrayList<MirrorPushThread>();
        for (CLDBProto.VolumeInfo mirrorVolume : mirrorVolumes) {
            String mirrorVolumeName = mirrorVolume.getVolProperties().getVolumeName();
            MirrorPushThread t = new MirrorPushThread(mirrorVolumeName, mirrorVolume.getVolProperties().getVolumeId(), cluster);
            pushThreads.add(t);
            t.start();
        }
        for (MirrorPushThread t : pushThreads) {
            t.join();
            LOG.info((Object)("Completed mirroring of volume " + t.mirrorVolumeName + " status " + t.status));
            if (t.status == 0) continue;
            status = t.status;
        }
        return status;
    }

    private int getMirrorVolumes(String volumeName, int volumeId, String cluster, List<CLDBProto.VolumeInfo> retMirrorVolumes) throws CLIProcessingException {
        boolean hasMoreVolumes = true;
        int startIndex = 0;
        int Limit = 40;
        while (hasMoreVolumes) {
            CLDBProto.VolumeListResponse resp;
            CLDBProto.VolumeListRequest.Builder req = CLDBProto.VolumeListRequest.newBuilder();
            ArrayList<CLIProto.Filter> filters = new ArrayList<CLIProto.Filter>();
            CLIProto.Filter.Builder filter1 = CLIProto.Filter.newBuilder();
            CLIProto.Filter.Builder filter2 = CLIProto.Filter.newBuilder();
            LOG.info((Object)("GetMirrorVolume for volume " + volumeName + " volId " + volumeId));
            filter1.setFieldId(CLDBProto.VolumeInfoFields.mirrorSrcVolumeId.getNumber()).setFieldOp(CLIProto.FieldOp.EqualTo).setFieldVal(CLIProto.FieldVal.newBuilder().setValSignedInteger32(volumeId)).setFilterOp(CLIProto.FilterOp.AND);
            filter2.setFieldId(CLDBProto.VolumeInfoFields.mirrorSrcClusterName.getNumber()).setFieldOp(CLIProto.FieldOp.EqualTo).setFieldVal(CLIProto.FieldVal.newBuilder().setValString(cluster)).setFilterOp(CLIProto.FilterOp.AND);
            filters.add(filter1.build());
            filters.add(filter2.build());
            CLIProto.Limiter.Builder limiter = CLIProto.Limiter.newBuilder();
            limiter.setStart(startIndex).setLimit(Limit);
            req.setColumns(-1L);
            req.setCreds(this.getUserCredentials());
            req.addAllFilter(filters);
            req.setLimiter(limiter.build());
            byte[] data = null;
            try {
                data = VolumeMirrorCommands.sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeListProc.getNumber(), (MessageLite)req.build(), CLDBProto.VolumeListResponse.class, isHardMount);
                if (data == null) {
                    throw new CLIProcessingException("Exception while processing RPC");
                }
                resp = CLDBProto.VolumeListResponse.parseFrom((byte[])data);
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                throw new CLIProcessingException("Exception while sending RPC to cluster " + this.clusterName, (Throwable)e);
            }
            if (resp.getStatus() == 2) {
                hasMoreVolumes = false;
                continue;
            }
            if (resp.getStatus() != 0) {
                LOG.error((Object)("Volume Push command : Failed to get the list  of mirror volumes for volume " + volumeName + "@" + cluster + " , err " + resp.getStatus()));
                return resp.getStatus();
            }
            retMirrorVolumes.addAll(resp.getVolumesList());
            if (resp.getVolumesCount() >= Limit) {
                hasMoreVolumes = true;
                startIndex += resp.getVolumesCount();
                continue;
            }
            hasMoreVolumes = false;
        }
        return 0;
    }

    private CommandOutput statusMirror() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        Object errMsg = "";
        String volName = null;
        boolean verbose = true;
        int start = 1;
        int limit = Integer.MAX_VALUE;
        if (this.isParamPresent(MIRROR_VOLUME_PARAM_NAME)) {
            volName = this.getParamTextValue(MIRROR_VOLUME_PARAM_NAME, 0);
        }
        if (volName == null || volName.equals("")) {
            errMsg = "Volume name can not be empty";
            LOG.error(errMsg);
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, (String)errMsg));
            return output;
        }
        if (this.isParamPresent(MIRROR_VERBOSE_OUTPUT)) {
            verbose = this.getParamBooleanValue(MIRROR_VERBOSE_OUTPUT, 0);
        }
        if (this.isParamPresent(LIMIT_PARAM_NAME)) {
            limit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
        }
        if (this.isParamPresent(START_PARAM_NAME)) {
            start = this.getParamIntValue(START_PARAM_NAME, 0);
        }
        if (start < 1) {
            errMsg = "parameter 'start' position can not be less then 1, value provided:" + start;
            LOG.error(errMsg);
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, (String)errMsg));
            return output;
        }
        if (limit == 0) {
            errMsg = "parameter 'limit' value can not be 0";
            LOG.error(errMsg);
            out.addMessage(this.getCommandUsage());
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, (String)errMsg));
            return output;
        }
        CLDBProto.VolumeMirrorStatusResponse resp = null;
        MirrorVolumeInfo mInfo = new MirrorVolumeInfo(volName, this.clusterName);
        int status = VolumeMirrorCommands.ValidateMirrorVolume(mInfo, this.getUserCredentials());
        if (status == 0) {
            CLDBProto.MirrorInfo.MirrorStatus mirrorState = mInfo.volProperties.getMirrorInfo().getMirrorStatus();
            if (mirrorState == CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_FAILED) {
                errMsg = mInfo.volProperties.getMirrorInfo().hasErrorCode() ? ((status = mInfo.volProperties.getMirrorInfo().getErrorCode()) == 10019 ? "Mirror job was failed for volume " + volName + ", as snapshot restore operation is in progress for source volume" : "Mirror job was failed for volume " + volName + " with error " + mInfo.volProperties.getMirrorInfo().getErrorCode()) : "Mirror job was failed for volume " + volName + " with unknown error ";
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, (String)errMsg));
                LOG.error(errMsg);
                return output;
            }
            if (mirrorState == CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_COMPLETE) {
                errMsg = "No mirror jobs are in progress for volume " + volName;
                LOG.error(errMsg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, (String)errMsg));
                return output;
            }
            resp = this.statusMirror(volName, this.clusterName, start, limit);
            if (resp.getStatus() != 0) {
                errMsg = "VolumeMirrorStatuProc failed, ErrCode : " + resp.getStatus();
                LOG.error(errMsg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), (String)errMsg));
                return output;
            }
            this.addVolumeMirrorStats(resp, out, mInfo, verbose);
        } else if (status == 2) {
            errMsg = "Volume " + volName + " doesn't exist in cluster " + this.clusterName;
            LOG.error(errMsg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, (String)errMsg));
        } else if (status == 22) {
            errMsg = "Volume " + volName + " is not a mirror volume in cluster " + this.clusterName;
            LOG.error(errMsg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, (String)errMsg));
        } else if (status == 10010) {
            errMsg = "No mirror license in cluster " + this.clusterName + " for mirroring";
            LOG.error(errMsg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, (String)errMsg));
        } else {
            errMsg = "Failed to get the mirror information for Volume " + volName + " from CLDB of cluster " + this.clusterName + ". errCode " + status;
            LOG.error(errMsg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(status, (String)errMsg));
        }
        return output;
    }

    private CLDBProto.VolumeMirrorStatusResponse statusMirror(String volName, String clusterName, int start, int limit) throws CLIProcessingException {
        CLDBProto.VolumeMirrorStatusRequest req = CLDBProto.VolumeMirrorStatusRequest.newBuilder().setVolName(volName).setClusterName(clusterName).setCreds(this.getUserCredentials()).setStart(start).setLimit(limit).build();
        byte[] data = null;
        try {
            data = VolumeMirrorCommands.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.MirrorStatusProc.getNumber(), (MessageLite)req, CLDBProto.VolumeMirrorStatusResponse.class, false);
            if (data == null) {
                throw new CLIProcessingException("Exception while processing RPC");
            }
            return CLDBProto.VolumeMirrorStatusResponse.parseFrom((byte[])data);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            throw new CLIProcessingException("Exception while sending RPC to cluster" + clusterName, (Throwable)e);
        }
    }

    private void addVolumeMirrorStats(CLDBProto.VolumeMirrorStatusResponse resp, CommandOutput.OutputHierarchy out, MirrorVolumeInfo mInfo, boolean verbose) {
        CommandOutput.OutputHierarchy.OutputNode volumeStatus = new CommandOutput.OutputHierarchy.OutputNode();
        if (resp.getResyncInProgressCidsList().size() > 0) {
            mInfo.resyncInProgressCids = new ArrayList<CLDBProto.VolumeMirrorStatusResponse.MirrorContainerInfo>();
            mInfo.resyncInProgressCids.addAll(resp.getResyncInProgressCidsList());
        }
        volumeStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("SourceVolumeName", (Object)mInfo.volProperties.getMirrorInfo().getSrcVolumeName()));
        volumeStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("SourceClusterName", (Object)mInfo.volProperties.getMirrorInfo().getSrcClusterName()));
        if (mInfo.volProperties.getMirrorInfo().hasSrcVolSnapshotName()) {
            volumeStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("SourceSnapshotName", (Object)mInfo.volProperties.getMirrorInfo().getSrcVolSnapshotName()));
        }
        if (resp.hasTotalRollForwardInProgressCids() && resp.getTotalRollForwardInProgressCids() > 0) {
            volumeStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("TotalRollForwardInProgressCid", resp.getTotalRollForwardInProgressCids()));
        }
        if (resp.hasStartedTime()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
            dateFormat.setTimeZone(TimeZone.getDefault());
            String timeStamp = dateFormat.format(resp.getStartedTime());
            volumeStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("MirroringStarted", (Object)timeStamp));
        }
        if (resp.hasMirrorState()) {
            volumeStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("MirrorState", (Object)resp.getMirrorState()));
        }
        if (resp.hasTotalResyncInProgressCids() && resp.getTotalResyncInProgressCids() > 0) {
            volumeStatus.addChild(new CommandOutput.OutputHierarchy.OutputNode("TotalResyncInProgressCids", resp.getTotalResyncInProgressCids()));
        }
        if (resp.getResyncInProgressCidsList().size() > 0) {
            if (verbose) {
                this.populateContainerInfo(mInfo);
            }
            this.addContainerStatus(volumeStatus, mInfo, verbose);
        }
        out.addNode(volumeStatus);
    }

    private void populateContainerInfo(MirrorVolumeInfo mInfo) {
        mInfo.resyncInProgressCidInfo = new ArrayList<CLDBProto.VolumeMirrorStatusResponse.MirrorContainerInfo>();
        for (CLDBProto.VolumeMirrorStatusResponse.MirrorContainerInfo cInfo : mInfo.resyncInProgressCids) {
            CLDBProto.ContainerInfo destCInfo;
            CLDBProto.VolumeMirrorStatusResponse.MirrorContainerInfo.Builder newMirrorCInfo = CLDBProto.VolumeMirrorStatusResponse.MirrorContainerInfo.newBuilder((CLDBProto.VolumeMirrorStatusResponse.MirrorContainerInfo)cInfo);
            CLDBProto.ContainerInfo sourceCInfo = this.getContainerInfo(cInfo.getSourceCid(), mInfo.volProperties.getMirrorInfo().getSrcClusterName());
            if (sourceCInfo != null) {
                newMirrorCInfo.setSourceCInfo(sourceCInfo);
            }
            if ((destCInfo = this.getContainerInfo(cInfo.getDestCid(), this.clusterName)) != null) {
                newMirrorCInfo.setDestCInfo(this.getContainerInfo(cInfo.getDestCid(), this.clusterName));
            }
            mInfo.resyncInProgressCidInfo.add(newMirrorCInfo.build());
        }
    }

    private CLDBProto.ContainerInfo getContainerInfo(int cid, String clusterName) {
        CLDBProto.DumpInfoRequest req = CLDBProto.DumpInfoRequest.newBuilder().setDumpOp(CLDBProto.DumpInfoRequest.DumpOp.CONTAINER_DUMP_OP).setContainerId(cid).setCreds(this.getUserCredentials()).build();
        try {
            byte[] data = CLDBRpcCommonUtils.getInstance().sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.DumpInfoProc.getNumber(), (MessageLite)req, CLDBProto.DumpInfoResponse.class);
            if (data == null) {
                LOG.error((Object)"Couldn't connect to the CLDB service");
                return null;
            }
            CLDBProto.DumpInfoResponse resp = CLDBProto.DumpInfoResponse.parseFrom((byte[])data);
            if (resp.getStatus() == 0) {
                return resp.getContainerInfo();
            }
            return null;
        }
        catch (MaprSecurityException e) {
            LOG.error((Object)"MaprSecurityException in getContainerInfo", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in getContainerInfo", (Throwable)e);
            return null;
        }
    }

    private void addContainerStatus(CommandOutput.OutputHierarchy.OutputNode volumeStatus, MirrorVolumeInfo mInfo, boolean verbose) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS 'GMT'Z");
        dateFormat.setTimeZone(TimeZone.getDefault());
        if (verbose) {
            for (CLDBProto.VolumeMirrorStatusResponse.MirrorContainerInfo cInfo : mInfo.resyncInProgressCidInfo) {
                CommandOutput.OutputHierarchy.OutputNode cNode = new CommandOutput.OutputHierarchy.OutputNode("ResyncInProgressCids");
                cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ErrorCode", cInfo.getErrCode()));
                cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Progress", cInfo.getPercentProgress()));
                String timeStamp = dateFormat.format(cInfo.getResyncStartedTime());
                cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResyncStartedTime", (Object)timeStamp));
                if (cInfo.hasDestCInfo()) {
                    cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("DestinationCid", (Object)DumpCommands.formatContainerInfo(cInfo.getDestCInfo(), null, null, this.getVersion())));
                } else {
                    cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("DestinationCid", cInfo.getDestCid()));
                }
                if (cInfo.hasSourceCInfo()) {
                    cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("SourceSnapCid", (Object)DumpCommands.formatContainerInfo(cInfo.getSourceCInfo(), null, null, this.getVersion())));
                } else {
                    cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("SourceSnapCid", cInfo.getSourceCid()));
                }
                volumeStatus.addChild(cNode);
            }
        } else {
            for (CLDBProto.VolumeMirrorStatusResponse.MirrorContainerInfo cInfo : mInfo.resyncInProgressCids) {
                CommandOutput.OutputHierarchy.OutputNode cNode = new CommandOutput.OutputHierarchy.OutputNode("ResyncInProgressCids");
                cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ErrorCode", cInfo.getErrCode()));
                cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("Progress", cInfo.getPercentProgress()));
                String timeStamp = dateFormat.format(cInfo.getResyncStartedTime());
                cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ResyncStartedTime", (Object)timeStamp));
                cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("DestinationCid", cInfo.getDestCid()));
                cNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("SourceSnapCid", cInfo.getSourceCid()));
                volumeStatus.addChild(cNode);
            }
        }
    }

    public static byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, boolean isHardMount) throws Exception {
        byte[] resp;
        int sleepTimeMillis = 5000;
        int i = 0;
        do {
            if (clusterName != null) {
                if (!clusterName.equals(CLDBRpcCommonUtils.getInstance().getCurrentClusterName())) {
                    Util.updateClusterConfInfos((String)clusterName);
                }
                resp = CLDBRpcCommonUtils.getInstance().sendRequest(clusterName, programId, procedureId, request, responseClass);
            } else {
                resp = CLDBRpcCommonUtils.getInstance().sendRequest(programId, procedureId, request, responseClass);
            }
            if (!isHardMount) {
                return resp;
            }
            if (resp != null) continue;
            if (++i > 6) {
                i = 6;
            }
            Thread.sleep(sleepTimeMillis * (1 << i));
        } while (resp == null);
        return resp;
    }

    public class MirrorPushThread
    extends Thread {
        public int status;
        public String errString;
        public int mirrorId;
        public String mirrorVolumeName;
        public String mirrorClusterName;
        public int mirrorVolumeId;

        public MirrorPushThread(String volumeName, int volumeId, String clusterName) {
            this.mirrorVolumeName = volumeName;
            this.mirrorVolumeId = volumeId;
            this.mirrorClusterName = clusterName;
        }

        @Override
        public void run() {
            try {
                this.WaitForMirroringToComplete(true);
                if (this.status != 0) {
                    return;
                }
                VolumeMirrorCommands.this.PrintVerboseMsg("Starting mirroring of volume " + this.mirrorVolumeName);
                this.status = VolumeMirrorCommands.this.startMirror(this.mirrorClusterName, this.mirrorVolumeName, this.mirrorVolumeId, true, true, false, null);
                if (this.status != 0) {
                    return;
                }
                this.WaitForMirroringToComplete(false);
                if (this.status != 0) {
                    return;
                }
                this.status = VolumeMirrorCommands.this.PushToMirrors(this.mirrorVolumeName, this.mirrorVolumeId, this.mirrorClusterName);
            }
            catch (Exception e) {
                this.status = 70;
                this.errString = "Exception while processing mirroring for volume " + this.mirrorVolumeName + " " + e.toString();
                return;
            }
        }

        private void WaitForMirroringToComplete(boolean justWaitForMirroringStop) throws CLIProcessingException {
            while (true) {
                CLDBProto.VolumeLookupRequest.Builder req = CLDBProto.VolumeLookupRequest.newBuilder().setCreds(VolumeMirrorCommands.this.getUserCredentials()).setVolumeName(this.mirrorVolumeName);
                CLDBProto.VolumeLookupResponse resp = null;
                byte[] data = null;
                try {
                    data = VolumeMirrorCommands.sendRequest(VolumeMirrorCommands.this.clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.VolumeLookupProc.getNumber(), (MessageLite)req.build(), CLDBProto.VolumeLookupResponse.class, isHardMount);
                    if (data == null) {
                        throw new CLIProcessingException("Exception while processing RPC");
                    }
                    resp = CLDBProto.VolumeLookupResponse.parseFrom((byte[])data);
                }
                catch (MaprSecurityException e) {
                    throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
                }
                catch (Exception e) {
                    this.errString = "Exception while sending the RPC to CLDB " + e.toString();
                    this.status = 70;
                    return;
                }
                if (resp.getStatus() != 0) {
                    LOG.error((Object)("Mirroring failed for volume " + this.mirrorVolumeName + "@" + VolumeMirrorCommands.this.clusterName + " CLDB returned error in volume lookup response, errcode " + resp.getStatus()));
                    this.status = resp.getStatus();
                    VolumeMirrorCommands.this.PrintVerboseMsg("Mirroring failed for volume " + this.mirrorVolumeName + " error code : " + this.status);
                    return;
                }
                CLDBProto.MirrorInfo mirrorInfo = resp.getVolInfo().getVolProperties().getMirrorInfo();
                if (mirrorInfo.getMirrorStatus() == CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_FAILED) {
                    LOG.error((Object)("Mirroring failed for volume " + this.mirrorVolumeName + "@" + this.mirrorClusterName + " as mirroring is in failed state"));
                    VolumeMirrorCommands.this.PrintVerboseMsg("Mirroring failed for volume " + this.mirrorVolumeName + " because it is already in failed state: ");
                    this.status = 5;
                    return;
                }
                if (justWaitForMirroringStop) {
                    if (mirrorInfo.getMirrorStatus() == CLDBProto.MirrorInfo.MirrorStatus.STATE_MIRROR_COMPLETE) {
                        this.mirrorId = mirrorInfo.getMirrorId();
                        LOG.info((Object)("Initial mirror id of volume " + this.mirrorVolumeName + " is " + this.mirrorId));
                        return;
                    }
                } else if (mirrorInfo.getMirrorId() > this.mirrorId) {
                    LOG.info((Object)("Mirror volume " + this.mirrorVolumeName + " mirroring complete mirrorId " + mirrorInfo.getMirrorId() + " mirrorState " + mirrorInfo.getMirrorStatus().name()));
                    VolumeMirrorCommands.this.PrintVerboseMsg("Mirroring complete for volume " + this.mirrorVolumeName);
                    return;
                }
                LOG.info((Object)("Mirror volume " + this.mirrorVolumeName + " mirrorId " + mirrorInfo.getMirrorId() + " mirrorState " + mirrorInfo.getMirrorStatus().name()));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public class MirrorVolumeInfo {
        public String volumeName;
        public String clusterName;
        public int err;
        public CLDBProto.VolumeProperties volProperties;
        public List<CLDBProto.VolumeMirrorStatusResponse.MirrorContainerInfo> resyncInProgressCids;
        public List<CLDBProto.VolumeMirrorStatusResponse.MirrorContainerInfo> resyncInProgressCidInfo;

        public MirrorVolumeInfo(String volumeName, String clusterName) {
            this.volumeName = volumeName;
            this.clusterName = clusterName;
        }
    }
}

