/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.ProtocolStringList;
import com.mapr.baseutils.BitSetBytesHelperUtils;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.Heatmap;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.NodeMetricsCommand;
import com.mapr.cli.NodeRemoveCommand;
import com.mapr.cli.NodeServicesManagementCommand;
import com.mapr.cli.common.ListCommand;
import com.mapr.cli.common.NodeField;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.PluggableAlarmUtil;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.FilterInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.cliframework.util.FieldInfo;
import com.mapr.cliframework.util.FilterUtil;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.cli.proto.CLIProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.MaprSecurityException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ServerCommands
extends ListCommand
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(ServerCommands.class);
    private static List<CLDBProto.FileServerInfo> fsInfo = new ArrayList<CLDBProto.FileServerInfo>();
    private Map<String, List<String>> runningServices = null;
    private Map<String, List<String>> configuredServices = null;
    public static final int NUM_NODES_PER_RPC = 100;
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String ALARMEDNODES_PARAM_NAME = "alarmednodes";
    public static final String NFSNODES_PARAM_NAME = "nfsnodes";
    public static final String SORT_PARAM_NAME = "sort";
    public static final String SORT_DIRECTION_PARAM_NAME = "dir";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String TOPO_PARENT_PARAM_NAME = "path";
    public static final String CLIENTS_ONLY_PARAM_NAME = "clientsonly";
    public static final String SP_CANREMOVE_PARAM_NAME = "canremovesp";
    public static final String SP_CANREMOVE_SPID_PARAM_NAME = "spid";
    public static final String FILESERVER_ID_PARAM_NAME = "serverids";
    public static final String HOSTID_PARAM_NAME = "hostids";
    public static final String FILESERVER_HOSTPORT_PARAM_NAME = "hostports";
    public static final String FILESERVER_NODES_PARAM_NAME = "nodes";
    public static final String FILESERVER_MARKMAINTENANCE_TIMEOUT_MINUTES = "timeoutminutes";
    public static final String FILESERVER_TOPOLOGY_PARAM_NAME = "topology";
    public static final String BLOCK_OUT_MOVES_PARAM_NAME = "blockMovesOut";
    public static final String BLOCK_IN_MOVES_PARAM_NAME = "blockMovesIn";
    public static final String LOCAL_CONTAINERS_PARAM_NAME = "localcontainers";
    public static final String NUM_SPS_PERINSTANCE_PARAM = "numSpsPerInstance";
    public static final String NUM_INSTANCES_ON_A_NODE_PARAM = "numInstances";
    public static final String MEMORY_PERINSTANCE_PARAM = "memoryPerInstance";
    public static final String SORTBY_PARAM_NAME = "sortby";
    public static final String SORTING_ORDER_PARAM_NAME = "sortorder";
    public static final String ASCENDING_SORTING_ORDER_PARAM_NAME = "asc";
    public static final String DESCENDING_SORTING_ORDER_PARAM_NAME = "desc";
    public static final String ADD_SPINFO = "addspinfo";
    public static final String DEFAULT_LABEL = "default";
    public static final String MULTI_ARG_SEP = ",";
    private static final String CLDB_PARAM_NAME = "cldb";
    private static int MAX_NODEFIELDINFO = 1;
    private static Map<CLDBProto.NodeState, String> nodeStateDesc = new ImmutableMap.Builder().put((Object)CLDBProto.NodeState.CRITICAL_NO_HEARTBEAT, (Object)"No heartbeat from node for more than 5 minutes").put((Object)CLDBProto.NodeState.CRITICAL_NO_DISKS, (Object)"All MapR-Fs disks on the node are dead or offlined").put((Object)CLDBProto.NodeState.CRITICAL_FILESERVER_REPLICATE, (Object)"FileServer process in replicate state").put((Object)CLDBProto.NodeState.CRITICAL_FILESERVER_DEAD, (Object)"FileServer process is dead/inactive").put((Object)CLDBProto.NodeState.CRITICAL_NFS_DEAD, (Object)"NFS process is dead").put((Object)CLDBProto.NodeState.CRITICAL_OPT_MAPR_FULL, (Object)("MapR Install directory " + MapRCliUtil.getMapRInstallDir() + " is full")).put((Object)CLDBProto.NodeState.CRITICAL_HIGH_MFS_MEMORY, (Object)"FileServer process on the node has high memory usage").put((Object)CLDBProto.NodeState.MAINTENANCE_FILESERVER, (Object)"FileServer process in maintenance mode").put((Object)CLDBProto.NodeState.DRAINING_MISSING_HEARTBEAT, (Object)"No heartbeat from node for more than 60 seconds").put((Object)CLDBProto.NodeState.DRAINING_SERVICES_DOWN, (Object)"One or more services is down").put((Object)CLDBProto.NodeState.DRAINING_ALARMS_RAISED, (Object)"One or more alarms raised").put((Object)CLDBProto.NodeState.HEALTHY, (Object)"Healthy").build();
    private static Map<String, BaseInputParameter> baseParams = new ImmutableMap.Builder().put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    public static Map<NodeField, FieldInfo> fieldTable;
    public static ImmutableMap.Builder<NodeField, FieldInfo> fieldTableBuilder;
    static String supportedSortKeys;
    static Map<String, CLDBProto.ListSortKey> nameToEnumMap;
    public static Map<String, BaseInputParameter> serverListParams;
    public static Map<String, BaseInputParameter> topoParams;
    public static Map<String, BaseInputParameter> topoSizeParams;
    public static Map<String, BaseInputParameter> cldbPrimaryParams;
    public static Map<String, BaseInputParameter> canRemoveSpParams;
    public static Map<String, BaseInputParameter> moveParams;
    public static Map<String, BaseInputParameter> modifyParams;
    public static Map<String, BaseInputParameter> allowIntoClusterParams;
    public static Map<String, BaseInputParameter> markMaintenanceParams;
    public static Map<String, BaseInputParameter> failoverNodeParams;
    static final CLICommand serverMarkMaintenanceCommand;
    static final CLICommand serverFailoverCommand;
    static final CLICommand serverMoveCommand;
    static final CLICommand serverModifyCommand;
    static final CLICommand allowIntoClusterCommand;
    static final CLICommand canRemoveSpCommand;
    static final CLICommand cldbMasterCommand;
    static final CLICommand cldbPrimaryCommand;
    static final CLICommand serverListCommand;
    static final CLICommand topoCommand;
    static final CLICommand topoSizeCommand;
    private static final CLICommand listCldbsCommand;
    private static final CLICommand listZksCommand;
    private static final CLICommand listCldbsAndZksCommand;
    private static final CLICommand listapiserversCommand;
    public static Map<String, BaseInputParameter> refillParams;
    static final CLICommand serverRefillCommand;
    public static final CLICommand serverCommands;

    public ServerCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"serverCommands start");
        }
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        try {
            int port = Rpc.initialize((int)0, (int)0, null);
            if (port < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            System.out.println("Exception in Rpc.initialize " + e);
        }
        fieldTable = PluggableAlarmUtil.appendNodeMap(this.getUserCredentials(), fieldTableBuilder);
        MAX_NODEFIELDINFO = PluggableAlarmUtil.getMaxNumNodes(this.getUserCredentials(), MAX_NODEFIELDINFO);
        String cmd = this.cliCommand.getCommandName();
        if (cmd.equalsIgnoreCase("list")) {
            int retval = this.processListCommand(out);
            if (retval != 0) {
                return output;
            }
        } else if (cmd.equalsIgnoreCase("toposize")) {
            this.topoSizeList(out);
            this.ProcessTopoSizeOutput(out);
        } else if (cmd.equalsIgnoreCase("topo")) {
            CLDBProto.ClusterTopologyRequest.Builder req = CLDBProto.ClusterTopologyRequest.newBuilder().setCreds(this.getUserCredentials());
            if (this.isParamPresent(TOPO_PARENT_PARAM_NAME)) {
                req.setPath(this.getParamTextValue(TOPO_PARENT_PARAM_NAME, 0));
            }
            try {
                byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterTopologyProc.getNumber(), (MessageLite)req.build(), CLDBProto.ClusterTopologyResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterTopologyProc.getNumber(), (MessageLite)req.build(), CLDBProto.ClusterTopologyResponse.class);
                if (replyData == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                    return output;
                }
                CLDBProto.ClusterTopologyResponse resp = CLDBProto.ClusterTopologyResponse.parseFrom((byte[])replyData);
                for (String n : resp.getNodeList()) {
                    CommandOutput.OutputHierarchy.OutputNode topoInfo = new CommandOutput.OutputHierarchy.OutputNode();
                    topoInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(TOPO_PARENT_PARAM_NAME, (Object)n));
                    out.addNode(topoInfo);
                }
            }
            catch (MaprSecurityException e) {
                throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
            }
            catch (Exception e) {
                throw new CLIProcessingException("InvalidProtocolBufferException  Exception", (Throwable)e);
            }
        } else {
            if (cmd.equalsIgnoreCase("move")) {
                try {
                    return this.fileServerMove();
                }
                catch (Exception e) {
                    throw new CLIProcessingException("Send request Exception", (Throwable)e);
                }
            }
            if (cmd.equalsIgnoreCase("refill")) {
                try {
                    return this.refillFileServerSps();
                }
                catch (Exception e) {
                    throw new CLIProcessingException("Send request Exception", (Throwable)e);
                }
            }
            if (cmd.equalsIgnoreCase("modify")) {
                try {
                    return this.fileServerModify();
                }
                catch (Exception e) {
                    throw new CLIProcessingException("Send request Exception", (Throwable)e);
                }
            }
            if (cmd.equalsIgnoreCase("allow-into-cluster")) {
                try {
                    return this.fileServerAllowIntoCluster();
                }
                catch (Exception e) {
                    throw new CLIProcessingException("Send request Exception", (Throwable)e);
                }
            }
            if (cmd.equalsIgnoreCase("maintenance")) {
                try {
                    return this.fileServerMaintenance();
                }
                catch (Exception e) {
                    throw new CLIProcessingException("Send request Exception", (Throwable)e);
                }
            }
            if (cmd.equalsIgnoreCase("failover")) {
                try {
                    return this.failoverFileServer();
                }
                catch (Exception e) {
                    throw new CLIProcessingException("Send request Exception", (Throwable)e);
                }
            }
            if (cmd.equalsIgnoreCase(SP_CANREMOVE_PARAM_NAME)) {
                try {
                    if (this.isParamPresent(SP_CANREMOVE_SPID_PARAM_NAME)) {
                        String spid = this.getParamTextValue(SP_CANREMOVE_SPID_PARAM_NAME, 0);
                        return this.canRemoveSP(spid);
                    }
                    LOG.error((Object)"Invalid request: SP id missing with canremovesp.");
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid request: Storagepool id missing with canremovesp"));
                    return output;
                }
                catch (Exception e) {
                    throw new CLIProcessingException("Send request Exception", (Throwable)e);
                }
            }
            if (cmd.equalsIgnoreCase("cldbmaster") || cmd.equalsIgnoreCase("cldbprimary")) {
                try {
                    return this.cldbMaster();
                }
                catch (Exception e) {
                    throw new CLIProcessingException("Send request Exception", (Throwable)e);
                }
            }
            if (this.cliCommand.getCommandName().equalsIgnoreCase("listcldbs")) {
                this.listCldbs(out);
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase("listzookeepers")) {
                this.listZks(out);
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase("listcldbzks")) {
                this.listCldbZks(out);
            } else if (this.cliCommand.getCommandName().equalsIgnoreCase("listapiservers")) {
                this.listapiservers(out);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"serverCommands end");
        }
        return output;
    }

    private int processListCommand(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String sortbyStr;
        CLDBProto.ListSortKey sortKey;
        if (this.getParamBooleanValue(ALARMEDNODES_PARAM_NAME, 0) && this.getParamBooleanValue(NFSNODES_PARAM_NAME, 0)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Cannot use both alarmednodes and nfsnodes together"));
            return -1;
        }
        if (this.isParamPresent(SORTBY_PARAM_NAME) && (sortKey = nameToEnumMap.get((sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0)).toLowerCase())) == null) {
            LOG.error((Object)("failed to set sort key. " + sortbyStr + " is not a valid keyword to sort nodes."));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid sortkey: " + sortbyStr));
            return -1;
        }
        if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
            if (!this.isParamPresent(SORTBY_PARAM_NAME)) {
                String msg = "Invalid use of sortorder. Must be used with sortby";
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                return -1;
            }
            String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
            if (!sortOrder.equalsIgnoreCase(ASCENDING_SORTING_ORDER_PARAM_NAME) && !sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME)) {
                String msg = "Invalid value for sortorder. Valid values are asc and desc";
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, msg));
                return -1;
            }
        }
        this.getServicesInfo();
        this.list(out);
        return 0;
    }

    private void ProcessTopoSizeOutput(CommandOutput.OutputHierarchy out) {
        TreeMap<String, DiskInfo> topoSizeMap = new TreeMap<String, DiskInfo>();
        topoSizeMap.clear();
        for (CLDBProto.FileServerInfo fs : fsInfo) {
            long diskTotalNodeGB;
            long diskAvailNodeGB;
            long diskUsedNodeGB;
            CLDBProto.FileServerHeartbeatStats hb = fs.getHbStats();
            long diskUsedGB = diskUsedNodeGB = hb.getServerUsedSizeMB() / 1024L;
            long diskAvailGB = diskAvailNodeGB = hb.getServerAvailableSizeMB() / 1024L;
            long diskTotalGB = diskTotalNodeGB = hb.getServerCapacitySizeMB() / 1024L;
            String nodeTopology = fs.getNetworkLocation();
            while (nodeTopology != "/" && nodeTopology != null) {
                if ((nodeTopology = Util.getParentInTopology((String)nodeTopology)) == null) continue;
                DiskInfo diskInfo = (DiskInfo)topoSizeMap.get(nodeTopology);
                if (diskInfo != null) {
                    diskUsedGB = diskUsedNodeGB + diskInfo.getDiskUsed();
                    diskAvailGB = diskAvailNodeGB + diskInfo.getDiskAvailable();
                    diskTotalGB = diskTotalNodeGB + diskInfo.getDiskTotal();
                }
                topoSizeMap.put(nodeTopology, new DiskInfo(diskUsedGB, diskAvailGB, diskTotalGB));
            }
        }
        for (String rackPath : topoSizeMap.keySet()) {
            DiskInfo info = (DiskInfo)topoSizeMap.get(rackPath);
            CommandOutput.OutputHierarchy.OutputNode topoSize = new CommandOutput.OutputHierarchy.OutputNode();
            topoSize.addChild(new CommandOutput.OutputHierarchy.OutputNode(TOPO_PARENT_PARAM_NAME, (Object)rackPath));
            topoSize.addChild(new CommandOutput.OutputHierarchy.OutputNode("TotalSpace(GB)", info.getDiskTotal()));
            topoSize.addChild(new CommandOutput.OutputHierarchy.OutputNode("UsedSpace(GB)", info.getDiskUsed()));
            topoSize.addChild(new CommandOutput.OutputHierarchy.OutputNode("AvailableSpace(GB)", info.getDiskAvailable()));
            out.addNode(topoSize);
        }
        fsInfo.clear();
    }

    private CommandOutput canRemoveSP(String spid) throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.canRemoveSpRequest req = CLDBProto.canRemoveSpRequest.newBuilder().setCreds(this.getUserCredentials()).setSpid(spid).build();
        byte[] replyData = null;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.CanRemoveSPProc.getNumber(), (MessageLite)req, CLDBProto.canRemoveSpResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.CanRemoveSPProc.getNumber(), (MessageLite)req, CLDBProto.canRemoveSpResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return output;
        }
        try {
            CLDBProto.canRemoveSpResponse resp = CLDBProto.canRemoveSpResponse.parseFrom((byte[])replyData);
            if (resp == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Could not contact any CLDB for primary"));
                return output;
            }
            if (resp.getStatus() != 0) {
                LOG.error((Object)("node canRemoveSP: failed with status: " + resp.getStatus()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Can not remove SP: " + spid + ". " + resp.getErrMsg()).setPropagateErrorSupport(true).setField(spid));
                return output;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("node canRemoveSP: failed with Exception " + e));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "node canRemoveSP: failed with Exception " + e));
            return output;
        }
        return output;
    }

    private CommandOutput cldbMaster() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        CLDBProto.isCLDBMasterRequest req = CLDBProto.isCLDBMasterRequest.newBuilder().build();
        byte[] replyData = null;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.IsCLDBMasterProc.getNumber(), (MessageLite)req, CLDBProto.isCLDBMasterResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.IsCLDBMasterProc.getNumber(), (MessageLite)req, CLDBProto.isCLDBMasterResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData == null) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return output;
        }
        try {
            CLDBProto.isCLDBMasterResponse resp = CLDBProto.isCLDBMasterResponse.parseFrom((byte[])replyData);
            if (resp == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Could not contact any CLDB for primary"));
                return output;
            }
            if (resp.getStatus() != 0) {
                LOG.error((Object)("primary cldb node: failed with status: " + resp.getStatus()));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "primary cldb node failed with status:" + resp.getStatus()));
                return output;
            }
            String master = resp.getCurrentMaster().equals("") ? "No Primary" : resp.getCurrentMaster();
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("cldbprimary", (Object)master));
        }
        catch (Exception e) {
            LOG.error((Object)("primary cldb node: failed with Exception " + e));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "primary cldb node: failed with Exception " + e));
            return output;
        }
        return output;
    }

    private CommandOutput fileServerMove() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> serverIds = new ArrayList<String>();
        String fileServerIds = this.getParamTextValue(FILESERVER_ID_PARAM_NAME, 0);
        if (fileServerIds.contains(MULTI_ARG_SEP)) {
            serverIds.addAll(Arrays.asList(fileServerIds.split(MULTI_ARG_SEP)));
        } else {
            serverIds.add(fileServerIds);
        }
        for (String serverIdString : serverIds) {
            long serverId = -1L;
            try {
                serverId = new BigInteger(serverIdString).longValue();
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"node move: Invalid serverId specified");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid serverid " + serverIdString + " specified"));
                continue;
            }
            String topology = this.getParamTextValue(FILESERVER_TOPOLOGY_PARAM_NAME, 0);
            CLDBProto.FileServerMoveRequest req = CLDBProto.FileServerMoveRequest.newBuilder().setServerId(serverId).setTopology(topology).setCreds(this.getUserCredentials()).build();
            byte[] replyData = null;
            try {
                replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerMoveProc.getNumber(), (MessageLite)req, CLDBProto.FileServerMoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerMoveProc.getNumber(), (MessageLite)req, CLDBProto.FileServerMoveResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                continue;
            }
            try {
                CLDBProto.FileServerMoveResponse resp = CLDBProto.FileServerMoveResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) continue;
                String errMsg = Errno.toString((int)resp.getStatus());
                if (resp.hasErrMsg()) {
                    errMsg = resp.getErrMsg();
                }
                String msg = "node move for fileServer " + serverId + " failed with " + errMsg;
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
            }
            catch (Exception e) {
                LOG.error((Object)("node move: failed with InvalidProtocolBufferException " + e + " for server " + serverIdString));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "node move: failed with InvalidProtocolBufferException " + e + " for server " + serverIdString));
            }
        }
        return output;
    }

    private CommandOutput refillFileServerSps() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        String fileServerIds = this.getParamTextValue(FILESERVER_ID_PARAM_NAME, 0);
        ArrayList<String> serverIds = new ArrayList<String>();
        if (fileServerIds.contains(MULTI_ARG_SEP)) {
            serverIds.addAll(Arrays.asList(fileServerIds.split(MULTI_ARG_SEP)));
        } else {
            serverIds.add(fileServerIds);
        }
        for (String fsIdStr : serverIds) {
            long fsId = -1L;
            try {
                fsId = new BigInteger(fsIdStr).longValue();
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"node refill: Invalid serverId specified");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid serverid " + fsIdStr + " specified"));
                continue;
            }
            CLDBProto.FileServerRefillRequest req = CLDBProto.FileServerRefillRequest.newBuilder().setFsId(fsId).setCreds(this.getUserCredentials()).build();
            byte[] replyData = null;
            try {
                replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerRefillProc.getNumber(), (MessageLite)req, CLDBProto.FileServerMoveResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerRefillProc.getNumber(), (MessageLite)req, CLDBProto.FileServerMoveResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                continue;
            }
            try {
                CLDBProto.FileServerRefillResponse resp = CLDBProto.FileServerRefillResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) continue;
                String errMsg = Errno.toString((int)resp.getStatus());
                if (resp.hasErrMsg()) {
                    errMsg = resp.getErrMsg();
                }
                String msg = "node refill for fileServer " + fsId + " failed with " + errMsg;
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
            }
            catch (Exception e) {
                LOG.error((Object)("node refill: failed with InvalidProtocolBufferException " + e + " for server " + fsIdStr));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "node refill: failed with InvalidProtocolBufferException " + e + " for server " + fsIdStr));
            }
        }
        return output;
    }

    private CommandOutput fileServerModify() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> hostnames = new ArrayList<String>();
        String hosts = this.getParamTextValue(FILESERVER_NODES_PARAM_NAME, 0);
        if (hosts.contains(MULTI_ARG_SEP)) {
            hostnames.addAll(Arrays.asList(hosts.split(MULTI_ARG_SEP)));
        } else {
            hostnames.add(hosts);
        }
        if (!(this.isParamPresent(BLOCK_IN_MOVES_PARAM_NAME) || this.isParamPresent(BLOCK_OUT_MOVES_PARAM_NAME) || this.isParamPresent(NUM_SPS_PERINSTANCE_PARAM) || this.isParamPresent(NUM_INSTANCES_ON_A_NODE_PARAM) || this.isParamPresent(MEMORY_PERINSTANCE_PARAM))) {
            String errMsg = "node modify: invalid arguments. One of  -blockMovesOut -blockMovesIn -numSpsPerInstance -numInstances -memoryPerInstance needs to be specified";
            LOG.error((Object)errMsg);
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
            return output;
        }
        CLDBProto.FileServerModifyRequest.Builder builder = CLDBProto.FileServerModifyRequest.newBuilder();
        builder.setCreds(this.getUserCredentials());
        if (this.isParamPresent(BLOCK_OUT_MOVES_PARAM_NAME)) {
            builder.setBlockMovesOut(this.getParamBooleanValue(BLOCK_OUT_MOVES_PARAM_NAME, 0));
        }
        if (this.isParamPresent(BLOCK_IN_MOVES_PARAM_NAME)) {
            builder.setBlockMovesIn(this.getParamBooleanValue(BLOCK_IN_MOVES_PARAM_NAME, 0));
        }
        CLDBProto.MfsInstancesInfo.Builder mfsInstancesInfoBuilder = null;
        if (this.isParamPresent(NUM_SPS_PERINSTANCE_PARAM)) {
            int numSpsPerInstance = this.getParamIntValue(NUM_SPS_PERINSTANCE_PARAM, 0);
            if (numSpsPerInstance < 0) {
                String errMsg = "Invalid Value for numSpsPerInstance. Must be greater than or equal to Zero";
                LOG.error((Object)errMsg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
                return output;
            }
            if (mfsInstancesInfoBuilder == null) {
                mfsInstancesInfoBuilder = CLDBProto.MfsInstancesInfo.newBuilder();
            }
            mfsInstancesInfoBuilder.setNumSpsPerInstance(numSpsPerInstance);
        }
        if (this.isParamPresent(MEMORY_PERINSTANCE_PARAM)) {
            int memoryPerInstance = this.getParamIntValue(MEMORY_PERINSTANCE_PARAM, 0);
            if (memoryPerInstance <= 0) {
                String errMsg = "Invalid Value for memoryPerInstance. Must be greater than Zero";
                LOG.error((Object)errMsg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
                return output;
            }
            if (mfsInstancesInfoBuilder == null) {
                mfsInstancesInfoBuilder = CLDBProto.MfsInstancesInfo.newBuilder();
            }
            mfsInstancesInfoBuilder.setMemoryPerInstance(memoryPerInstance);
        }
        if (this.isParamPresent(NUM_INSTANCES_ON_A_NODE_PARAM)) {
            int numInstances = this.getParamIntValue(NUM_INSTANCES_ON_A_NODE_PARAM, 0);
            if (numInstances < 0) {
                String errMsg = "Invalid Value for numInstances. Must be greater than or equal to Zero";
                LOG.error((Object)errMsg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, errMsg));
                return output;
            }
            if (mfsInstancesInfoBuilder == null) {
                mfsInstancesInfoBuilder = CLDBProto.MfsInstancesInfo.newBuilder();
            }
            mfsInstancesInfoBuilder.setNumInstances(numInstances);
        }
        if (mfsInstancesInfoBuilder != null) {
            builder.setMfsInstancesInfo(mfsInstancesInfoBuilder.build());
        }
        CLDBProto.FileServerModifyRequest commonReq = builder.build();
        for (String host : hostnames) {
            CLDBProto.FileServerModifyRequest req = CLDBProto.FileServerModifyRequest.newBuilder((CLDBProto.FileServerModifyRequest)commonReq).setHostname(host).build();
            byte[] replyData = null;
            try {
                replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerModifyProc.getNumber(), (MessageLite)req, CLDBProto.FileServerModifyResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerModifyProc.getNumber(), (MessageLite)req, CLDBProto.FileServerModifyResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                continue;
            }
            try {
                CLDBProto.FileServerModifyResponse resp = CLDBProto.FileServerModifyResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) continue;
                String errMsg = resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString((int)resp.getStatus());
                String msg = "node modify for " + host + " failed with " + errMsg;
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
            }
            catch (Exception e) {
                String msg = "node modify for " + host + " failed due to exception " + e.toString();
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
            }
        }
        return output;
    }

    private CommandOutput fileServerAllowIntoCluster() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        ArrayList<String> serverIds = new ArrayList<String>();
        String fileServerIds = this.getParamTextValue(HOSTID_PARAM_NAME, 0);
        if (fileServerIds.contains(MULTI_ARG_SEP)) {
            serverIds.addAll(Arrays.asList(fileServerIds.split(MULTI_ARG_SEP)));
        } else {
            serverIds.add(fileServerIds);
        }
        for (String serverIdString : serverIds) {
            long serverId = -1L;
            try {
                serverId = new BigInteger(serverIdString).longValue();
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"node allow-into-cluster: Invalid hostid specified");
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid hostid " + serverIdString + " specified"));
                continue;
            }
            CLDBProto.FileServerAllowIntoClusterRequest req = CLDBProto.FileServerAllowIntoClusterRequest.newBuilder().setServerId(serverId).setCreds(this.getUserCredentials()).build();
            byte[] replyData = null;
            try {
                replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerAllowIntoClusterProc.getNumber(), (MessageLite)req, CLDBProto.FileServerAllowIntoClusterResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerAllowIntoClusterProc.getNumber(), (MessageLite)req, CLDBProto.FileServerAllowIntoClusterResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                continue;
            }
            try {
                CLDBProto.FileServerAllowIntoClusterResponse resp = CLDBProto.FileServerAllowIntoClusterResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) continue;
                String errMsg = Errno.toString((int)resp.getStatus());
                if (resp.hasErrMsg()) {
                    errMsg = resp.getErrMsg();
                }
                String msg = "node allow-into-cluster for hostid " + serverId + " failed with " + errMsg;
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
            }
            catch (Exception e) {
                String msg = "node allow-into-cluster: failed with InvalidProtocolBufferException " + e + " for hostid " + serverIdString;
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, msg));
            }
        }
        return output;
    }

    private CommandOutput fileServerMaintenance() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (this.isParamPresent(FILESERVER_ID_PARAM_NAME) && this.isParamPresent(FILESERVER_NODES_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Please specify either nodes or serverids not both"));
            return output;
        }
        if (!this.isParamPresent(FILESERVER_ID_PARAM_NAME) && !this.isParamPresent(FILESERVER_NODES_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Please specify either nodes or serverids atleast one option is required"));
            return output;
        }
        boolean serverIds = this.isParamPresent(FILESERVER_ID_PARAM_NAME);
        String serversString = "";
        ArrayList<String> servers = new ArrayList<String>();
        serversString = serverIds ? this.getParamTextValue(FILESERVER_ID_PARAM_NAME, 0) : this.getParamTextValue(FILESERVER_NODES_PARAM_NAME, 0);
        if (serversString.contains(MULTI_ARG_SEP)) {
            servers.addAll(Arrays.asList(serversString.split(MULTI_ARG_SEP)));
        } else {
            servers.add(serversString);
        }
        for (String server : servers) {
            int timeOutMinutes = this.getParamIntValue(FILESERVER_MARKMAINTENANCE_TIMEOUT_MINUTES, 0);
            CLDBProto.FileServerMarkMaintenanceRequest.Builder req = CLDBProto.FileServerMarkMaintenanceRequest.newBuilder().setMaintenanceTimeOutMinutes(timeOutMinutes).setCreds(this.getUserCredentials());
            if (serverIds) {
                long serverId = -1L;
                try {
                    serverId = new BigInteger(server).longValue();
                }
                catch (NumberFormatException e) {
                    LOG.error((Object)("node maintenance: Invalid serverId specified for server " + server));
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid serverid " + server + " specified"));
                    continue;
                }
                req.setServerId(serverId);
            } else {
                List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(server));
                if (ips.isEmpty()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not get valid IP address out of provided name: " + server));
                    continue;
                }
                int hostIP = Util.ipToInt((String)ips.get(0));
                req.setHostIP(hostIP);
            }
            byte[] replyData = null;
            try {
                replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerMarkMaintenanceProc.getNumber(), (MessageLite)req.build(), CLDBProto.FileServerMarkMaintenanceResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerMarkMaintenanceProc.getNumber(), (MessageLite)req.build(), CLDBProto.FileServerMarkMaintenanceResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                continue;
            }
            try {
                CLDBProto.FileServerMarkMaintenanceResponse resp = CLDBProto.FileServerMarkMaintenanceResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) continue;
                String errMsg = Errno.toString((int)resp.getStatus());
                if (resp.hasErrMsg()) {
                    errMsg = resp.getErrMsg();
                }
                String msg = "node maintenance for fileServer " + server + " failed with " + errMsg;
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
            }
            catch (Exception e) {
                LOG.error((Object)("node maintenance: failed with InvalidProtocolBufferException " + e + " for server " + server));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "node maintenance: failed with InvalidProtocolBufferException " + e + " for server " + server));
            }
        }
        return output;
    }

    private CommandOutput failoverFileServer() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        output.setOutput(out);
        if (!this.isParamPresent(FILESERVER_NODES_PARAM_NAME)) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Please specify one or more nodes on which the primaries and vips need to be failed over"));
            return output;
        }
        String serversString = "";
        ArrayList<String> servers = new ArrayList<String>();
        serversString = this.getParamTextValue(FILESERVER_NODES_PARAM_NAME, 0);
        if (serversString.contains(MULTI_ARG_SEP)) {
            servers.addAll(Arrays.asList(serversString.split(MULTI_ARG_SEP)));
        } else {
            servers.add(serversString);
        }
        boolean failoverLocalContainers = this.getParamBooleanValue(LOCAL_CONTAINERS_PARAM_NAME, 0);
        for (String server : servers) {
            CLDBProto.FileServerFailoverRequest.Builder req = CLDBProto.FileServerFailoverRequest.newBuilder();
            req.setCreds(this.getUserCredentials());
            req.setHostname(server);
            req.setFailoverLocalContainers(failoverLocalContainers);
            byte[] replyData = null;
            try {
                replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerFailoverProc.getNumber(), (MessageLite)req.build(), CLDBProto.FileServerFailoverResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerFailoverProc.getNumber(), (MessageLite)req.build(), CLDBProto.FileServerFailoverResponse.class);
            }
            catch (Exception e) {
                throw new CLIProcessingException((Throwable)e);
            }
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                continue;
            }
            try {
                CLDBProto.FileServerFailoverResponse resp = CLDBProto.FileServerFailoverResponse.parseFrom((byte[])replyData);
                if (resp.getStatus() == 0) continue;
                String errMsg = Errno.toString((int)resp.getStatus());
                if (resp.hasErrMsg()) {
                    errMsg = resp.getErrMsg();
                }
                String msg = "node failover for fileServer " + server + " failed with " + errMsg;
                LOG.error((Object)msg);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), msg));
            }
            catch (Exception e) {
                LOG.error((Object)("node failover: failed with InvalidProtocolBufferException " + e + " for server " + server));
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "node failover: failed with InvalidProtocolBufferException " + e + " for server " + server));
            }
        }
        return output;
    }

    private CLDBProto.FileServerListRequest.Builder getFileServerListRequestBuilder() throws CLIProcessingException {
        List<CLIProto.Filter> filters = this.getFilters(fieldTable, FILTER_PARAM_NAME);
        BitSet columns = this.getColumns();
        ByteString bString = ByteString.copyFrom((byte[])BitSetBytesHelperUtils.toByteArray((BitSet)columns));
        long columnsOld = BitSetBytesHelperUtils.convert((BitSet)columns);
        boolean alarmedNodes = this.getParamBooleanValue(ALARMEDNODES_PARAM_NAME, 0);
        boolean nfsNodes = this.getParamBooleanValue(NFSNODES_PARAM_NAME, 0);
        boolean clientsOnly = this.getParamBooleanValue(CLIENTS_ONLY_PARAM_NAME, 0);
        CLIProto.Limiter limiter = this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 100);
        CLDBProto.FileServerListRequest.Builder req = CLDBProto.FileServerListRequest.newBuilder().setCreds(this.getUserCredentials()).addAllFilter(filters).setColumns(columnsOld).setAlarmednodes(alarmedNodes).setNfsnodes(nfsNodes |= clientsOnly).setLimiter(limiter).setColumnsAdd(bString);
        if (this.isParamPresent(ADD_SPINFO) && this.getParamBooleanValue(ADD_SPINFO, 0)) {
            req.setAddSpInfoToLabels(true);
        }
        if (this.isParamPresent(SORTBY_PARAM_NAME)) {
            String sortbyStr = this.getParamTextValue(SORTBY_PARAM_NAME, 0);
            CLDBProto.ListSortKey sortKey = nameToEnumMap.get(sortbyStr.toLowerCase());
            if (sortKey != null) {
                req.setSortKey(sortKey);
            } else {
                LOG.error((Object)("failed to set sort key: " + sortbyStr + " is not a valid keyword to sort nodes"));
            }
            if (this.isParamPresent(SORTING_ORDER_PARAM_NAME)) {
                String sortOrder = this.getParamTextValue(SORTING_ORDER_PARAM_NAME, 0);
                req.setSortDescending(sortOrder.equalsIgnoreCase(DESCENDING_SORTING_ORDER_PARAM_NAME));
            }
        }
        return req;
    }

    public CLDBProto.FileServerListRequest buildNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.FileServerListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.FileServerListRequest.newBuilder((CLDBProto.FileServerListRequest)((CLDBProto.FileServerListRequest)prevReq)) : this.getFileServerListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.FileServerListResponse)prevResp).getInfoCount();
            int origStart = this.getParamIntValue(START_PARAM_NAME, 0);
            int origLimit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    @Override
    public boolean hasMore(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        return this.hasMore(this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), ((CLDBProto.FileServerListRequest)prevReq).getLimiter().getStart(), ((CLDBProto.FileServerListResponse)prevResp).getInfoCount());
    }

    @Override
    public void processResponse(CommandOutput.OutputHierarchy out, MessageLite resp) throws CLIProcessingException {
        BitSet columns = this.getColumns();
        boolean terse = this.getParamTextValue(OUTPUT_PARAM_NAME, 0).equals("terse");
        boolean clientsInfoOnly = this.getParamBooleanValue(CLIENTS_ONLY_PARAM_NAME, 0);
        CLDBProto.FileServerListResponse response = (CLDBProto.FileServerListResponse)resp;
        for (CLDBProto.FileServerInfo fs : response.getInfoList()) {
            if (clientsInfoOnly) {
                CommandOutput.OutputHierarchy.OutputNode outNode = this.formatClientsOnlyFileServerInfo(fs, terse);
                if (outNode == null) continue;
                out.addNode(outNode);
                continue;
            }
            out.addNode(this.formatFileServerInfo(fs, terse, columns));
        }
        if (response.hasTotal()) {
            out.setTotal(response.getTotal());
        }
    }

    public CLDBProto.FileServerListResponse sendRequest(MessageLite request) throws CLIProcessingException {
        CLDBProto.FileServerListRequest req = (CLDBProto.FileServerListRequest)request;
        byte[] replyData = null;
        try {
            replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerListProc.getNumber(), (MessageLite)req, CLDBProto.FileServerListResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.FileServerListProc.getNumber(), (MessageLite)req, CLDBProto.FileServerListResponse.class);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        if (replyData != null) {
            return this.getFileServerListResponse(replyData);
        }
        LOG.error((Object)"RPC Request to list Nodes failed. No data returned");
        return null;
    }

    private CLDBProto.FileServerListResponse getFileServerListResponse(byte[] replyData) throws CLIProcessingException {
        try {
            return CLDBProto.FileServerListResponse.parseFrom((byte[])replyData);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new CLIProcessingException("Exception while parsing the RPC response data into FileServerListResponse proto object.", (Throwable)ipbe);
        }
    }

    private CLDBProto.FileServerListRequest.Builder getFileServerTopoSizeListRequestBuilder() throws CLIProcessingException {
        BitSet columns = this.getColumns();
        ByteString bString = ByteString.copyFrom((byte[])BitSetBytesHelperUtils.toByteArray((BitSet)columns));
        long columnsOld = BitSetBytesHelperUtils.convert((BitSet)columns);
        CLIProto.Limiter limiter = this.getNextLimiter(this.getParamIntValue(START_PARAM_NAME, 0), 0, this.getParamIntValue(START_PARAM_NAME, 0), this.getParamIntValue(LIMIT_PARAM_NAME, 0), 100);
        CLDBProto.FileServerListRequest.Builder req = CLDBProto.FileServerListRequest.newBuilder().setCreds(this.getUserCredentials()).setColumns(columnsOld).setLimiter(limiter).setColumnsAdd(bString);
        return req;
    }

    private CLDBProto.FileServerListRequest buildTopoSizeNextRequest(MessageLite prevReq, MessageLite prevResp) throws CLIProcessingException {
        CLDBProto.FileServerListRequest.Builder newReqBuilder = null;
        newReqBuilder = prevReq != null ? CLDBProto.FileServerListRequest.newBuilder((CLDBProto.FileServerListRequest)((CLDBProto.FileServerListRequest)prevReq)) : this.getFileServerTopoSizeListRequestBuilder();
        if (prevResp != null) {
            int prevStart = newReqBuilder.getLimiter().getStart();
            int prevCount = ((CLDBProto.FileServerListResponse)prevResp).getInfoCount();
            int origStart = this.getParamIntValue(START_PARAM_NAME, 0);
            int origLimit = this.getParamIntValue(LIMIT_PARAM_NAME, 0);
            newReqBuilder.setLimiter(this.getNextLimiter(prevStart, prevCount, origStart, origLimit, 100));
        }
        return newReqBuilder.build();
    }

    private void topoSizeList(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        long time = System.currentTimeMillis();
        long start = System.currentTimeMillis();
        CLDBProto.FileServerListRequest req = null;
        CLDBProto.FileServerListResponse resp = null;
        while (req == null && resp == null || this.hasMore((MessageLite)req, (MessageLite)resp)) {
            req = this.buildTopoSizeNextRequest((MessageLite)req, (MessageLite)resp);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Perf::buildTopoSizeNextRequest() = " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            resp = this.sendRequest((MessageLite)req);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Perf::sendRequest() = " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            if (resp == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service. Check if at least one CLDB is running."));
                return;
            }
            this.processTopoSizeResponse((MessageLite)resp);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Perf::processTopoSizeResponse() = " + (System.currentTimeMillis() - time)));
            time = System.currentTimeMillis();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Perf::list() = " + (System.currentTimeMillis() - start)));
        }
    }

    private void processTopoSizeResponse(MessageLite resp) throws CLIProcessingException {
        CLDBProto.FileServerListResponse response = (CLDBProto.FileServerListResponse)resp;
        for (CLDBProto.FileServerInfo fs : response.getInfoList()) {
            fsInfo.add(fs);
        }
    }

    private void getServicesInfo() throws CLIProcessingException {
        String zkConnectString = null;
        String clusterName = "";
        if (this.isParamPresent("cluster")) {
            clusterName = this.getParamTextValue("cluster", 0);
            zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect(clusterName);
        } else {
            zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
        }
        if ((zkConnectString == null || zkConnectString.trim().isEmpty()) && this.isParamPresent("zkconnect")) {
            zkConnectString = this.getParamTextValue("zkconnect", 0);
        }
        if (zkConnectString == null || zkConnectString.trim().isEmpty()) {
            LOG.error((Object)"zkConnectString is null/empty. Cannot proceed further.");
            return;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"getServicesInfo start");
                LOG.debug((Object)"findServicesRunningHierarchy");
            }
            if (clusterName.isEmpty()) {
                this.runningServices = NodesCommonUtils.findServicesRunningHierarchy(zkConnectString);
                this.configuredServices = NodesCommonUtils.findServicesConfiguredHierarchy(zkConnectString);
            } else {
                this.runningServices = NodesCommonUtils.findServicesRunningHierarchy(zkConnectString, clusterName);
                this.configuredServices = NodesCommonUtils.findServicesConfiguredHierarchy(zkConnectString, clusterName);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Error while trying to fetch services info from ZK. Check ZK connection", t);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getServicesInfo end");
        }
    }

    private BitSet getColumns() throws CLIProcessingException {
        BitSet columns = new BitSet();
        columns.set(0, MAX_NODEFIELDINFO + 1);
        String columnsString = this.getParamTextValue(COLUMNS_PARAM_NAME, 0);
        if (columnsString != null && !columnsString.equals("all")) {
            if (!columnsString.contains("ip")) {
                columnsString = columnsString.concat(",ip");
            }
            if (!columnsString.contains("hn") && !columnsString.contains("hostname")) {
                columnsString = columnsString.concat(",hn");
            }
            columns = FilterUtil.getColumns(fieldTable, (String)columnsString.trim());
        }
        return columns;
    }

    public static int formatNodeState(CLDBProto.NodeState s) {
        String str = s.toString();
        if (str.startsWith("CRITICAL")) {
            return 4;
        }
        if (str.startsWith("MAINTENANCE")) {
            return 3;
        }
        if (str.startsWith("DRAINING")) {
            return 2;
        }
        if (str.startsWith("HEALTHY")) {
            return 0;
        }
        return 5;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatFileServerInfo(CLDBProto.FileServerInfo fs, boolean terse, BitSet columns) {
        CLDBProto.FileServerHeartbeatStats hb = fs.getHbStats();
        CommandOutput.OutputHierarchy.OutputNode serverInfo = new CommandOutput.OutputHierarchy.OutputNode();
        String runningServicesString = null;
        String configuredServicesString = null;
        List<Common.PluggableAlarm> pluggableAlarms = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("formatFileServerInfo: Received node ID:  " + Long.toString(fs.getFileServerId()) + " hostname: " + MapRCliUtil.getHostname(fs) + " ip: " + Util.intToIp((int)((Common.IPAddress)fs.getAddressList().get(0)).getHost())));
        }
        try {
            pluggableAlarms = PluggableAlarmUtil.getNodeAlarms(this.getUserCredentials(), 0, 50);
        }
        catch (CLIProcessingException e) {
            LOG.error((Object)("Error getting alarms. Alarm message might be incomplete: " + e.getMessage()));
        }
        if (columns.get(CLDBProto.NodeInfo.Id.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.Id)).getName(terse), (Object)Long.toUnsignedString(fs.getFileServerId())));
        }
        if (columns.get(CLDBProto.NodeInfo.Ip.getNumber())) {
            HashSet<String> ipSet = new HashSet<String>(fs.getAddressList().size());
            for (Common.IPAddress ip : fs.getAddressList()) {
                StringBuilder sb;
                String svcName;
                List<String> services;
                String ipA = Util.intToIp((int)ip.getHost());
                if (!ipSet.add(ipA)) continue;
                serverInfo.addChild((CommandOutput.OutputHierarchy.OutputNode)new IpAddressNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.Ip)).getName(terse), Util.intToIp((int)ip.getHost())));
                if (this.runningServices != null) {
                    services = this.runningServices.get(ipA);
                    if (services == null) {
                        services = new ArrayList<String>();
                    }
                    if (fs.hasLoopbackNfsRunning() && fs.getLoopbackNfsRunning()) {
                        services.add("loopbacknfs");
                    }
                    if (fs.hasFuseClientRunning() && fs.getFuseClientRunning() && (svcName = this.formatFuseClientInfo(fs)) != null) {
                        services.add(svcName);
                    }
                    if (fs.getNfsInstanceInfoList().size() > 0) {
                        services.addAll(this.formatNFSInstanceInfo(fs.getNfsInstanceInfoList(), true));
                    }
                    if (!services.isEmpty()) {
                        sb = new StringBuilder();
                        for (String service : services) {
                            sb.append(service);
                            sb.append(MULTI_ARG_SEP);
                        }
                        runningServicesString = sb.deleteCharAt(sb.length() - 1).toString();
                    }
                }
                if (this.configuredServices == null) continue;
                services = this.configuredServices.get(ipA);
                if (services == null) {
                    services = new ArrayList<String>();
                }
                if (fs.getLoopbackNfsConfigured()) {
                    services.add("loopbacknfs");
                }
                if (fs.hasPosixClientInfo() && (svcName = this.formatFuseClientInfo(fs)) != null) {
                    services.add(svcName);
                }
                if (fs.getNfsInstanceInfoList().size() > 0) {
                    services.addAll(this.formatNFSInstanceInfo(fs.getNfsInstanceInfoList(), false));
                }
                if (services.isEmpty()) continue;
                sb = new StringBuilder();
                for (String service : services) {
                    sb.append(service);
                    sb.append(MULTI_ARG_SEP);
                }
                configuredServicesString = sb.deleteCharAt(sb.length() - 1).toString();
            }
            for (Common.IPAddress extIp : fs.getExternalIPsList()) {
                serverInfo.addChild((CommandOutput.OutputHierarchy.OutputNode)new IpAddressNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ExtIp)).getName(terse), Util.printIPAddress((Common.IPAddress)extIp)));
            }
        }
        if (columns.get(CLDBProto.NodeInfo.RdmaPort.getNumber()) && fs.getRdmaPortsCount() > 0) {
            List rdmaPorts = fs.getRdmaPortsList();
            Object valueStr = String.valueOf(rdmaPorts.get(0));
            if (rdmaPorts.size() > 1) {
                valueStr = (String)valueStr + "(" + rdmaPorts.size() + ")";
            }
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.RdmaPort)).getName(terse), valueStr));
        }
        if (columns.get(CLDBProto.NodeInfo.Hostname.getNumber())) {
            Object sb;
            String svcName;
            List<String> services;
            String hostName = MapRCliUtil.getHostname(fs);
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.Hostname)).getName(terse), (Object)hostName));
            if (this.runningServices != null) {
                services = this.runningServices.get(hostName);
                if (services == null) {
                    services = new ArrayList<String>();
                }
                if (fs.hasLoopbackNfsRunning() && fs.getLoopbackNfsRunning()) {
                    services.add("loopbacknfs");
                }
                if (fs.hasFuseClientRunning() && fs.getFuseClientRunning() && (svcName = this.formatFuseClientInfo(fs)) != null) {
                    services.add(svcName);
                }
                if (fs.getNfsInstanceInfoList().size() > 0) {
                    services.addAll(this.formatNFSInstanceInfo(fs.getNfsInstanceInfoList(), true));
                }
                if (!services.isEmpty()) {
                    sb = new StringBuilder();
                    for (String service : services) {
                        ((StringBuilder)sb).append(service);
                        ((StringBuilder)sb).append(MULTI_ARG_SEP);
                    }
                    runningServicesString = ((StringBuilder)sb).deleteCharAt(((StringBuilder)sb).length() - 1).toString();
                }
            }
            if (this.configuredServices != null) {
                services = this.configuredServices.get(hostName);
                if (services == null) {
                    services = new ArrayList<String>();
                }
                if (fs.getLoopbackNfsConfigured()) {
                    services.add("loopbacknfs");
                }
                if (fs.hasPosixClientInfo() && (svcName = this.formatFuseClientInfo(fs)) != null) {
                    services.add(svcName);
                }
                if (fs.getNfsInstanceInfoList().size() > 0) {
                    services.addAll(this.formatNFSInstanceInfo(fs.getNfsInstanceInfoList(), false));
                }
                if (!services.isEmpty()) {
                    sb = new StringBuilder();
                    for (String service : services) {
                        ((StringBuilder)sb).append(service);
                        ((StringBuilder)sb).append(MULTI_ARG_SEP);
                    }
                    configuredServicesString = ((StringBuilder)sb).deleteCharAt(((StringBuilder)sb).length() - 1).toString();
                }
            }
        }
        if (columns.get(CLDBProto.NodeInfo.RackPath.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.RackPath)).getName(terse), (Object)fs.getNetworkLocation()));
        }
        if (columns.get(CLDBProto.NodeInfo.Labels.getNumber())) {
            this.addLabelsInfo(fs, serverInfo);
        }
        if (columns.get(CLDBProto.NodeInfo.isFips.getNumber()) && fs.hasIsFips()) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.isFips)).getName(terse), fs.getIsFips()));
        }
        if (columns.get(CLDBProto.NodeInfo.Status.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.Status)).getName(terse), ServerCommands.formatNodeState(fs.getNodeState())));
        }
        if (columns.get(CLDBProto.NodeInfo.StatusDesc.getNumber())) {
            String desc = nodeStateDesc.get(fs.getNodeState());
            if (desc == null || desc.trim().isEmpty()) {
                desc = "Unknown reason";
            }
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.StatusDesc)).getName(terse), (Object)desc));
        }
        if (columns.get(CLDBProto.NodeInfo.Services.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.Services)).getName(terse), (Object)(runningServicesString == null ? "" : runningServicesString)));
        }
        if (columns.get(CLDBProto.NodeInfo.ConfiguredServices.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ConfiguredServices)).getName(terse), (Object)(configuredServicesString == null ? "" : configuredServicesString)));
        }
        if (columns.get(CLDBProto.NodeInfo.FSHB.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.FSHB)).getName(terse), fs.getLastHeartbeatSec()));
        }
        if (columns.get(CLDBProto.NodeInfo.JTHB.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.JTHB)).getName(terse), 2));
        }
        if (columns.get(CLDBProto.NodeInfo.DiskTotal.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskTotal)).getName(terse), hb.getServerCapacitySizeMB() / 1024L));
        }
        if (columns.get(CLDBProto.NodeInfo.DiskUsed.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskUsed)).getName(terse), hb.getServerUsedSizeMB() / 1024L));
        }
        if (columns.get(CLDBProto.NodeInfo.DiskAvail.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskAvail)).getName(terse), hb.getServerAvailableSizeMB() / 1024L));
        }
        if (columns.get(CLDBProto.NodeInfo.Rpc.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.Rpc)).getName(terse), hb.getRpcCount()));
        }
        if (columns.get(CLDBProto.NodeInfo.RpcIn.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.RpcIn)).getName(terse), hb.getRpcInBytes()));
        }
        if (columns.get(CLDBProto.NodeInfo.RpcOut.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.RpcOut)).getName(terse), hb.getRpcOutBytes()));
        }
        if (columns.get(CLDBProto.NodeInfo.DiskCount.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskCount)).getName(terse), hb.getDiskCount()));
        }
        if (columns.get(CLDBProto.NodeInfo.MapRDiskCount.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.MapRDiskCount)).getName(terse), hb.getMaprdiskCount()));
        }
        if (columns.get(CLDBProto.NodeInfo.FailedDisks.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.FailedDisks)).getName(terse), hb.getFaileddisks()));
        }
        if (columns.get(CLDBProto.NodeInfo.DiskReadOps.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskReadOps)).getName(terse), hb.getDiskReadOps()));
        }
        if (columns.get(CLDBProto.NodeInfo.DiskReadKbytes.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskReadKbytes)).getName(terse), hb.getDiskReadKBytes()));
        }
        if (columns.get(CLDBProto.NodeInfo.DiskWriteOps.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskWriteOps)).getName(terse), hb.getDiskWriteOps()));
        }
        if (columns.get(CLDBProto.NodeInfo.DiskWriteKbytes.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskWriteKbytes)).getName(terse), hb.getDiskWriteKBytes()));
        }
        if (columns.get(CLDBProto.NodeInfo.CpuCount.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.CpuCount)).getName(terse), hb.getCpuCount()));
        }
        if (columns.get(CLDBProto.NodeInfo.CpuUtil.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.CpuUtil)).getName(terse), 100L - hb.getCpuIdle()));
        }
        if (columns.get(CLDBProto.NodeInfo.CpuUptime.getNumber())) {
            Long uptime = terse ? Long.valueOf(hb.getCpuUptime()) : new Date(hb.getCpuUptime() * 1000L).toString();
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.CpuUptime)).getName(terse), (Object)uptime));
        }
        if (columns.get(CLDBProto.NodeInfo.MemTotal.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.MemTotal)).getName(terse), hb.getMemoryTotalMB()));
        }
        if (columns.get(CLDBProto.NodeInfo.MemUsed.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.MemUsed)).getName(terse), hb.getMemoryUsedMB()));
        }
        if (columns.get(CLDBProto.NodeInfo.TTMapSlotsTotal.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.TTMapSlotsTotal)).getName(terse), hb.getTtMapSlots()));
        }
        if (columns.get(CLDBProto.NodeInfo.TTMapSlotsOccupied.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.TTMapSlotsOccupied)).getName(terse), hb.getTtMapUsed()));
        }
        if (columns.get(CLDBProto.NodeInfo.TTReduceSlotsTotal.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.TTReduceSlotsTotal)).getName(terse), hb.getTtReduceSlots()));
        }
        if (columns.get(CLDBProto.NodeInfo.TTReduceSlotsOccupied.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.TTReduceSlotsOccupied)).getName(terse), hb.getTtReduceUsed()));
        }
        if (columns.get(CLDBProto.NodeInfo.BytesReceived.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.BytesReceived)).getName(terse), hb.getNetworkBytesRecd()));
        }
        if (columns.get(CLDBProto.NodeInfo.BytesSent.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.BytesSent)).getName(terse), hb.getNetworkBytesXmit()));
        }
        if (hb.hasNumResyncSlots() && columns.get(CLDBProto.NodeInfo.NumResyncSlots.getNumber())) {
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NumResyncSlots)).getName(terse), hb.getNumResyncSlots()));
        }
        if (columns.get(CLDBProto.NodeInfo.BlockMovesOut.getNumber())) {
            boolean blockMovesOut = false;
            if (fs.hasBlockMovesOut()) {
                blockMovesOut = fs.getBlockMovesOut();
            }
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.BlockMovesOut)).getName(terse), (Object)blockMovesOut));
        }
        if (columns.get(CLDBProto.NodeInfo.BlockMovesIn.getNumber())) {
            boolean blockMovesIn = false;
            if (fs.hasBlockMovesIn()) {
                blockMovesIn = fs.getBlockMovesIn();
            }
            serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.BlockMovesIn)).getName(terse), (Object)blockMovesIn));
        }
        if (columns.get(CLDBProto.NodeInfo.NumInstances.getNumber()) || columns.get(CLDBProto.NodeInfo.NumReportedInstances.getNumber()) || columns.get(CLDBProto.NodeInfo.NumSpsPerInstance.getNumber())) {
            CLDBProto.MfsInstancesInfo tmp = fs.getMfsInstancesInfo();
            if (columns.get(CLDBProto.NodeInfo.NumInstances.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NumInstances)).getName(terse), (Object)(tmp.hasNumInstances() ? String.valueOf(tmp.getNumInstances()) : "N/A")));
            }
            if (columns.get(CLDBProto.NodeInfo.NumReportedInstances.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NumReportedInstances)).getName(terse), (Object)(tmp.hasNumReportedInstances() ? String.valueOf(tmp.getNumReportedInstances()) : "N/A")));
            }
            if (columns.get(CLDBProto.NodeInfo.NumSpsPerInstance.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NumSpsPerInstance)).getName(terse), (Object)(tmp.hasNumSpsPerInstance() ? String.valueOf(tmp.getNumSpsPerInstance()) : "N/A")));
            }
        }
        if (fs.hasDbStats()) {
            if (columns.get(CLDBProto.NodeInfo.DbPuts10s.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbPuts10s)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbPuts10s, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbPuts1m.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbPuts1m)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbPuts1m, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbPuts5m.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbPuts5m)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbPuts5m, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbPuts15m.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbPuts15m)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbPuts15m, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbGets10s.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbGets10s)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbGets10s, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbGets1m.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbGets1m)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbGets1m, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbGets5m.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbGets5m)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbGets5m, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbGets15m.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbGets15m)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbGets15m, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbScans10s.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbScans10s)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbScans10s, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbScans1m.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbScans1m)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbScans1m, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbScans5m.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbScans5m)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbScans5m, fs.getDbStats())));
            }
            if (columns.get(CLDBProto.NodeInfo.DbScans15m.getNumber())) {
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DbScans15m)).getName(terse), (Object)this.getDbStatValue(CLDBProto.NodeInfo.DbScans15m, fs.getDbStats())));
            }
        }
        block8: for (Common.AlarmMsg fsAlarm : fs.getFsAlarmsList()) {
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_DEBUG_LOGGING) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.LogLevelAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.LogLevelAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_CLDB_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceCLDBDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceCLDBDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_FILESERVER_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceFileserverDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceFileserverDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_JT_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceJTDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceJTDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_TT_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceTTDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceTTDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_HBMASTER_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceHBMasterDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHBMasterDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_HBREGION_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceHBRegionDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHBRegionDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_NFS_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceNFSDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceNFSDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_NFS4_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceNFS4DownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceNFS4DownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_WEBSERVER_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceWebserverDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceWebserverDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_HOSTSTATS_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceHoststatsDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHoststatsDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_DISK_FAILURE) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.DiskFailureAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.DiskFailureAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_VERSION_MISMATCH) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.VersionMismatchAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.VersionMismatchAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_TIME_SKEW) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.TimeSkewAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.TimeSkewAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_HB_PROCESSING_SLOW) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.HbProcessingSlow.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.HbProcessingSlow)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_ROOT_PARTITION_FULL) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodeRootPartitionFull.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeRootPartitionFull)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_OPT_MAPR_FULL) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodeOptMapRFull.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeOptMapRFull)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_CORE_PRESENT) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodeCorePresent.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeCorePresent)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_MFS_THROTTLING_RPCS) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.MfsThrottlingRpcs.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.MfsThrottlingRpcs)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_HIGH_MFS_MEMORY) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodeHighMfsMemory.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeHighMfsMemory)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_PAM_MISCONFIGURED) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodePamMisconfigured.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodePamMisconfigured)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_TT_LOCALDIR_FULL) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodeTTLocaldirFull.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeTTLocaldirFull)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_NO_HEARTBEAT) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodeNoHeartbeat.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeNoHeartbeat)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_MAPRUSER_MISMATCH) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodeMaprUserMismatch.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeMaprUserMismatch)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_DUPLICATE_HOSTID) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodeDuplicateHostId.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeDuplicateHostId)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_METRICS_WRITE_PROBLEM) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodeMetricsWriteProblemAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeMetricsWriteProblemAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_TOO_MANY_CONTAINERS) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.NodeTooManyContainersAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.NodeTooManyContainersAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_INCORRECT_TOPOLOGY_ALARM) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.IncorrectTopologyAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.IncorrectTopologyAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_HUE_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceHueDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHueDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_HTTPFS_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceHttpfsDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHttpfsDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_BEESWAX_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceBeeswaxDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceBeeswaxDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_HIVEMETA_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceHiveMetaDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHiveMetaDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_HS2_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceHs2DownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceHs2DownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            if (fsAlarm.getAlarmId().compareTo((Enum)Common.AlarmId.NODE_ALARM_SERVICE_OOZIE_DOWN) == 0) {
                if (!columns.get(CLDBProto.NodeInfo.ServiceOozieDownAlarm.getNumber())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ServiceOozieDownAlarm)).getName(terse), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue;
            }
            for (Common.PluggableAlarm pluggableAlarm : pluggableAlarms) {
                if (!fsAlarm.getAlarmName().equals(pluggableAlarm.getName())) continue;
                serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(terse ? pluggableAlarm.getTerse() : pluggableAlarm.getDisplayName(), fsAlarm.getAlarmState() ? fsAlarm.getAlarmTimeStamp() : 0L));
                continue block8;
            }
        }
        if (columns.get(CLDBProto.NodeInfo.VirtualIp.getNumber())) {
            for (Common.IPAddress ip : fs.getAddressList()) {
                if (!ip.hasVirtualIP()) continue;
                String ipA = Util.longToIp((long)ip.getVirtualIP());
                serverInfo.addChild((CommandOutput.OutputHierarchy.OutputNode)new IpAddressNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.VirtualIp)).getName(terse), ipA));
            }
        }
        return serverInfo;
    }

    private void addLabelsInfo(CLDBProto.FileServerInfo fsInfo, CommandOutput.OutputHierarchy.OutputNode serverInfo) {
        if (fsInfo.getSpAttrsCount() == 0) {
            CommandOutput.OutputHierarchy.OutputNode labelNode = new CommandOutput.OutputHierarchy.OutputNode("labels", (Object)DEFAULT_LABEL);
            labelNode.setTreatSingleChildAsPeer(true);
            serverInfo.addChild(labelNode);
            return;
        }
        if (fsInfo.getSpAttrs(0).hasSpId()) {
            for (Common.StoragePoolAttrs spAttrs : fsInfo.getSpAttrsList()) {
                CommandOutput.OutputHierarchy.OutputNode spLabel = new CommandOutput.OutputHierarchy.OutputNode("labels");
                spLabel.addChild(new CommandOutput.OutputHierarchy.OutputNode("spId", (Object)spAttrs.getSpId()));
                spLabel.addChild(new CommandOutput.OutputHierarchy.OutputNode("label", (Object)spAttrs.getLabel().getName()));
                spLabel.addChild(new CommandOutput.OutputHierarchy.OutputNode("fsId", spAttrs.getFsId()));
                serverInfo.addChild(spLabel);
            }
        } else {
            for (Common.StoragePoolAttrs spAttrs : fsInfo.getSpAttrsList()) {
                CommandOutput.OutputHierarchy.OutputNode labelNode = new CommandOutput.OutputHierarchy.OutputNode("labels", (Object)spAttrs.getLabel().getName());
                labelNode.setTreatSingleChildAsPeer(true);
                serverInfo.addChild(labelNode);
            }
        }
    }

    private CommandOutput.OutputHierarchy.OutputNode formatClientsOnlyFileServerInfo(CLDBProto.FileServerInfo fs, boolean terse) {
        long twentyFourHour = 86400L;
        if ((long)fs.getLastHeartbeatSec() > twentyFourHour) {
            return null;
        }
        CommandOutput.OutputHierarchy.OutputNode serverInfo = new CommandOutput.OutputHierarchy.OutputNode();
        String hostName = MapRCliUtil.getHostname(fs);
        HashSet<String> ipSet = new HashSet<String>(fs.getAddressList().size());
        serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.Id)).getName(terse), (Object)Long.toString(fs.getFileServerId())));
        serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.Hostname)).getName(terse), (Object)hostName));
        for (Common.IPAddress ip : fs.getAddressList()) {
            String ipA = Util.intToIp((int)ip.getHost());
            if (!ipSet.add(ipA)) continue;
            serverInfo.addChild((CommandOutput.OutputHierarchy.OutputNode)new IpAddressNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.Ip)).getName(terse), Util.intToIp((int)ip.getHost())));
        }
        CLDBProto.ClientType clientType = fs.getClientType();
        String clientTypeDesc = clientType == CLDBProto.ClientType.POSIX_CLIENT_FUSE ? this.formatFuseClientInfo(fs) : clientType.toString();
        serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.TypeOfClient)).getName(terse), (Object)clientTypeDesc));
        int fiveMin = 300;
        int lastHeartBeatSec = fs.getLastHeartbeatSec();
        lastHeartBeatSec = lastHeartBeatSec == 0 ? 1 : lastHeartBeatSec;
        String nodeStateDesc = "Active";
        if (fs.getNodeState() != CLDBProto.NodeState.HEALTHY && lastHeartBeatSec > fiveMin) {
            nodeStateDesc = "Inactive";
        }
        serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fieldTable.get(new NodeField(CLDBProto.NodeInfo.ClientHealth)).getName(terse), (Object)nodeStateDesc));
        String fsHBHeader = "lasthb";
        if (terse) {
            fsHBHeader = "lhb";
        }
        serverInfo.addChild(new CommandOutput.OutputHierarchy.OutputNode(fsHBHeader, lastHeartBeatSec));
        return serverInfo;
    }

    List<String> formatNFSInstanceInfo(List<CLDBProto.NFSInstanceInfo> nfsiInfos, boolean getRunningOnly) {
        ArrayList<String> names = new ArrayList<String>();
        for (CLDBProto.NFSInstanceInfo nfsi : nfsiInfos) {
            if (getRunningOnly) {
                if (nfsi.hasLoopbackNfsRunning() && nfsi.getLoopbackNfsRunning()) {
                    names.add("loopbacknfs");
                }
                if (!nfsi.hasFuseClientRunning() || !nfsi.getFuseClientRunning()) continue;
                names.add(this.posixclientTypeToString(nfsi.getPosixClientType()));
                continue;
            }
            if (nfsi.hasLoopbackNfsConfigured() && nfsi.getLoopbackNfsConfigured()) {
                names.add("loopbacknfs");
            }
            if (!nfsi.hasPosixClientType()) continue;
            names.add(this.posixclientTypeToString(nfsi.getPosixClientType()));
        }
        return names;
    }

    String formatFuseClientInfo(CLDBProto.FileServerInfo fs) {
        if (!fs.hasPosixClientInfo()) {
            return null;
        }
        CLDBProto.PosixClientInfo pcInfo = fs.getPosixClientInfo();
        return this.posixclientTypeToString(pcInfo.getClientType());
    }

    String posixclientTypeToString(CLDBProto.PosixClientType type) {
        Object svcName = "posixclient";
        switch (type) {
            case BASIC: {
                svcName = (String)svcName + "basic";
                break;
            }
            case GOLD: {
                svcName = (String)svcName + "gold";
                break;
            }
            case PLATINUM: {
                svcName = (String)svcName + "platinum";
                break;
            }
            default: {
                svcName = null;
            }
        }
        return svcName;
    }

    private CLDBProto.ClusterInfoResponse doClusterInfo(CommandOutput.OutputHierarchy out, boolean needCldbList) {
        try {
            byte[] data;
            CLDBProto.ClusterInfoRequest req = CLDBProto.ClusterInfoRequest.newBuilder().setCreds(this.getUserCredentials()).setColumns(-1L).setNeedCldbList(needCldbList).build();
            if (this.isParamPresent(CLDB_PARAM_NAME)) {
                List<String> ips;
                int cldbPort = 7222;
                String cldbHostStr = this.getParamTextValue(CLDB_PARAM_NAME, 0);
                if (cldbHostStr == null || cldbHostStr.isEmpty()) {
                    return null;
                }
                if (cldbHostStr.contains(":")) {
                    String[] arr = cldbHostStr.split(":");
                    cldbHostStr = arr[0];
                    cldbPort = Integer.valueOf(arr[1]);
                    if (cldbPort <= 0) {
                        cldbPort = 7222;
                    }
                }
                if ((ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(cldbHostStr))).isEmpty()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Can not get valid IP address out of provided name: " + cldbHostStr));
                    return null;
                }
                cldbHostStr = ips.get(0);
                int cldbHost = Util.ipToInt((String)cldbHostStr);
                try {
                    int port = Rpc.initialize((int)0, (int)0, null);
                    if (port < 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to initialize Rpc"));
                        return null;
                    }
                }
                catch (Exception e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Failed to initialize Rpc"));
                    return null;
                }
                long binding = Rpc.createBindingFor((int)cldbHost, (int)cldbPort, null, (int)Security.ServerKeyType.ServerKey.getNumber());
                data = Rpc.sendRequest((long)binding, (int)Common.MapRProgramId.CldbProgramId.getNumber(), (int)CLDBProto.CLDBProg.ClusterInfoProc.getNumber(), (MessageLite)req);
            } else {
                data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterInfoProc.getNumber(), (MessageLite)req, CLDBProto.ClusterInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterInfoProc.getNumber(), (MessageLite)req, CLDBProto.ClusterInfoResponse.class);
            }
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return null;
            }
            CLDBProto.ClusterInfoResponse resp = CLDBProto.ClusterInfoResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(status, Errno.toString((int)status)));
                return null;
            }
            return resp;
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "doClusterInfo: " + Errno.toString((int)10003)));
            LOG.error((Object)"Exception during doClusterInfo", (Throwable)e);
            return null;
        }
    }

    private Long getDbStatValue(CLDBProto.NodeInfo stat, CLDBProto.DbNodeStats dbNodeStats) {
        List statValues;
        int statDuration;
        List durations = dbNodeStats.getDurationsList();
        switch (stat) {
            case DbPuts10s: {
                statDuration = 10;
                statValues = dbNodeStats.getPutsCountList();
                break;
            }
            case DbPuts1m: {
                statDuration = 60;
                statValues = dbNodeStats.getPutsCountList();
                break;
            }
            case DbPuts5m: {
                statDuration = 300;
                statValues = dbNodeStats.getPutsCountList();
                break;
            }
            case DbPuts15m: {
                statDuration = 900;
                statValues = dbNodeStats.getPutsCountList();
                break;
            }
            case DbGets10s: {
                statDuration = 10;
                statValues = dbNodeStats.getGetsCountList();
                break;
            }
            case DbGets1m: {
                statDuration = 60;
                statValues = dbNodeStats.getGetsCountList();
                break;
            }
            case DbGets5m: {
                statDuration = 300;
                statValues = dbNodeStats.getGetsCountList();
                break;
            }
            case DbGets15m: {
                statDuration = 900;
                statValues = dbNodeStats.getGetsCountList();
                break;
            }
            case DbScans10s: {
                statDuration = 10;
                statValues = dbNodeStats.getScansCountList();
                break;
            }
            case DbScans1m: {
                statDuration = 60;
                statValues = dbNodeStats.getScansCountList();
                break;
            }
            case DbScans5m: {
                statDuration = 300;
                statValues = dbNodeStats.getScansCountList();
                break;
            }
            case DbScans15m: {
                statDuration = 900;
                statValues = dbNodeStats.getScansCountList();
                break;
            }
            default: {
                return 0L;
            }
        }
        int index = durations.indexOf(statDuration);
        if (index == -1 || durations.size() != statValues.size()) {
            return 0L;
        }
        return (Long)statValues.get(index);
    }

    private void listCldbs(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String cldblist;
        CLDBProto.ClusterInfoResponse resp = this.doClusterInfo(out, true);
        if (resp != null && (cldblist = resp.getCldbList()) != null && !cldblist.isEmpty()) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("CLDBs", (Object)cldblist));
        }
    }

    private void listZks(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String zklist;
        CLDBProto.ClusterInfoResponse resp = this.doClusterInfo(out, false);
        if (resp != null && (zklist = resp.getZkConnectString()) != null && !zklist.isEmpty()) {
            out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Zookeepers", (Object)zklist));
        }
    }

    private void listCldbZks(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.ClusterInfoResponse resp = this.doClusterInfo(out, true);
        if (resp != null) {
            String zklist;
            String cldblist = resp.getCldbList();
            CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
            if (cldblist != null && !cldblist.isEmpty()) {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode("CLDBs", (Object)cldblist));
            }
            if ((zklist = resp.getZkConnectString()) != null && !zklist.isEmpty()) {
                node.addChild(new CommandOutput.OutputHierarchy.OutputNode("Zookeepers", (Object)zklist));
            }
            out.addNode(node);
        }
    }

    private void listapiservers(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        CLDBProto.GetApiServerInfoRequest.Builder req = CLDBProto.GetApiServerInfoRequest.newBuilder().setCreds(this.getUserCredentials());
        try {
            byte[] replyData = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetApiServerInfoProc.getNumber(), (MessageLite)req.build(), CLDBProto.GetApiServerInfoResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetApiServerInfoProc.getNumber(), (MessageLite)req.build(), CLDBProto.GetApiServerInfoResponse.class);
            if (replyData == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                return;
            }
            CLDBProto.GetApiServerInfoResponse resp = CLDBProto.GetApiServerInfoResponse.parseFrom((byte[])replyData);
            if (resp != null) {
                ProtocolStringList apiServerslist = resp.getApiServersList();
                CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
                if (apiServerslist != null && !apiServerslist.isEmpty()) {
                    node.addChild(new CommandOutput.OutputHierarchy.OutputNode("apiServers", (Object)apiServerslist));
                }
                out.addNode(node);
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "listapiservers: " + Errno.toString((int)10003)));
            LOG.error((Object)"Exception during listapiservers", (Throwable)e);
        }
    }

    public String getCommandUsage() {
        return "node list";
    }

    static {
        fieldTableBuilder = new ImmutableMap.Builder().put((Object)new NodeField(CLDBProto.NodeInfo.Id), (Object)new FieldInfo(CLDBProto.NodeInfo.Id.getNumber(), "id", "id", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.Ip), (Object)new FieldInfo(CLDBProto.NodeInfo.Ip.getNumber(), "ip", "ip", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.Hostname), (Object)new FieldInfo(CLDBProto.NodeInfo.Hostname.getNumber(), "hn", "hostname", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.RackPath), (Object)new FieldInfo(CLDBProto.NodeInfo.RackPath.getNumber(), "rp", "racktopo", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.SwitchPath), (Object)new FieldInfo(CLDBProto.NodeInfo.SwitchPath.getNumber(), "sp", "switchtopo", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.Status), (Object)new FieldInfo(CLDBProto.NodeInfo.Status.getNumber(), "h", "health", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.StatusDesc), (Object)new FieldInfo(CLDBProto.NodeInfo.StatusDesc.getNumber(), "hd", "healthDesc", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.Services), (Object)new FieldInfo(CLDBProto.NodeInfo.Services.getNumber(), "svc", "service", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ConfiguredServices), (Object)new FieldInfo(CLDBProto.NodeInfo.ConfiguredServices.getNumber(), "csvc", "configuredservice", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.FSHB), (Object)new FieldInfo(CLDBProto.NodeInfo.FSHB.getNumber(), "fhb", "fs-heartbeat", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.JTHB), (Object)new FieldInfo(CLDBProto.NodeInfo.JTHB.getNumber(), "jhb", "jt-heartbeat", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DiskTotal), (Object)new FieldInfo(CLDBProto.NodeInfo.DiskTotal.getNumber(), "dst", "dtotal", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DiskUsed), (Object)new FieldInfo(CLDBProto.NodeInfo.DiskUsed.getNumber(), "dsu", "dused", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DiskAvail), (Object)new FieldInfo(CLDBProto.NodeInfo.DiskAvail.getNumber(), "dsa", "davail", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.Rpc), (Object)new FieldInfo(CLDBProto.NodeInfo.Rpc.getNumber(), "rpc", "rpcs", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.RpcIn), (Object)new FieldInfo(CLDBProto.NodeInfo.RpcIn.getNumber(), "rpi", "rpcin", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.RpcOut), (Object)new FieldInfo(CLDBProto.NodeInfo.RpcOut.getNumber(), "rpo", "rpcout", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DiskCount), (Object)new FieldInfo(CLDBProto.NodeInfo.DiskCount.getNumber(), "dsc", "disks", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.MapRDiskCount), (Object)new FieldInfo(CLDBProto.NodeInfo.MapRDiskCount.getNumber(), "nmd", "MapRfs disks", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DiskReadOps), (Object)new FieldInfo(CLDBProto.NodeInfo.DiskReadOps.getNumber(), "dro", "dreads", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DiskReadKbytes), (Object)new FieldInfo(CLDBProto.NodeInfo.DiskReadKbytes.getNumber(), "drk", "dreadK", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DiskWriteOps), (Object)new FieldInfo(CLDBProto.NodeInfo.DiskWriteOps.getNumber(), "dwo", "dwrites", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DiskWriteKbytes), (Object)new FieldInfo(CLDBProto.NodeInfo.DiskWriteKbytes.getNumber(), "dwk", "dwriteK", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.CpuCount), (Object)new FieldInfo(CLDBProto.NodeInfo.CpuCount.getNumber(), "cpc", "cpus", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.CpuUtil), (Object)new FieldInfo(CLDBProto.NodeInfo.CpuUtil.getNumber(), "cpu", "utilization", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.MemTotal), (Object)new FieldInfo(CLDBProto.NodeInfo.MemTotal.getNumber(), "mt", "mtotal", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.MemUsed), (Object)new FieldInfo(CLDBProto.NodeInfo.MemUsed.getNumber(), "mu", "mused", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.TTMapSlotsTotal), (Object)new FieldInfo(CLDBProto.NodeInfo.TTMapSlotsTotal.getNumber(), "tms", "ttmapSlots", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.TTMapSlotsOccupied), (Object)new FieldInfo(CLDBProto.NodeInfo.TTMapSlotsOccupied.getNumber(), "tmu", "ttmapUsed", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.TTReduceSlotsTotal), (Object)new FieldInfo(CLDBProto.NodeInfo.TTReduceSlotsTotal.getNumber(), "trs", "ttReduceSlots", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.TTReduceSlotsOccupied), (Object)new FieldInfo(CLDBProto.NodeInfo.TTReduceSlotsOccupied.getNumber(), "tru", "ttReduceUsed", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.FailedDisks), (Object)new FieldInfo(CLDBProto.NodeInfo.FailedDisks.getNumber(), "nfd", "faileddisks", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NumInstances), (Object)new FieldInfo(CLDBProto.NodeInfo.NumInstances.getNumber(), "ni", NUM_INSTANCES_ON_A_NODE_PARAM, String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NumReportedInstances), (Object)new FieldInfo(CLDBProto.NodeInfo.NumReportedInstances.getNumber(), "nri", "numReportedInstances", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NumSpsPerInstance), (Object)new FieldInfo(CLDBProto.NodeInfo.NumSpsPerInstance.getNumber(), "nsp", "spsPerInstance", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.LogLevelAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.LogLevelAlarm.getNumber(), "lla", "LogLevelAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceCLDBDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceCLDBDownAlarm.getNumber(), "sca", "ServiceCLDBDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceFileserverDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceFileserverDownAlarm.getNumber(), "sfsa", "ServiceFileserverDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceJTDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceJTDownAlarm.getNumber(), "sja", "ServiceJTDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceTTDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceTTDownAlarm.getNumber(), "sta", "ServiceTTDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceHBMasterDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceHBMasterDownAlarm.getNumber(), "shpa", "ServiceHBPrimaryDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceHBRegionDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceHBRegionDownAlarm.getNumber(), "shra", "ServiceHBRegionDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceNFSDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceNFSDownAlarm.getNumber(), "sna", "ServiceNFSDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceNFS4DownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceNFS4DownAlarm.getNumber(), "sn4a", "ServiceNFS4DownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceWebserverDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceWebserverDownAlarm.getNumber(), "swa", "ServiceWebserverDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceHoststatsDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceHoststatsDownAlarm.getNumber(), "sha", "ServiceHoststatsDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceHueDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceHueDownAlarm.getNumber(), "shuea", "ServiceHueDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceHttpfsDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceHttpfsDownAlarm.getNumber(), "shfsa", "ServiceHttpfsDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceBeeswaxDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceBeeswaxDownAlarm.getNumber(), "sbwa", "ServiceBeeswaxDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceHiveMetaDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceHiveMetaDownAlarm.getNumber(), "shsma", "ServiceHiveDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceHs2DownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceHs2DownAlarm.getNumber(), "shsa", "ServiceHs2DownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ServiceOozieDownAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.ServiceOozieDownAlarm.getNumber(), "sooza", "ServiceOozieDownNotRunningAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DiskFailureAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.DiskFailureAlarm.getNumber(), "fda", "DiskFailureAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.VersionMismatchAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.VersionMismatchAlarm.getNumber(), "vma", "VersionMismatchAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.TimeSkewAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.TimeSkewAlarm.getNumber(), "tsa", "TimeSkewAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.HbProcessingSlow), (Object)new FieldInfo(CLDBProto.NodeInfo.HbProcessingSlow.getNumber(), "hps", "HbProcessingSlow", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeRootPartitionFull), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeRootPartitionFull.getNumber(), "rpf", "RootPartitionFullAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeOptMapRFull), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeOptMapRFull.getNumber(), "hmf", "HomeMapRFullAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeCorePresent), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeCorePresent.getNumber(), "ncp", "CorePresentAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.MfsThrottlingRpcs), (Object)new FieldInfo(CLDBProto.NodeInfo.MfsThrottlingRpcs.getNumber(), "mtr", "MfsThrottlingRpcs", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeHighMfsMemory), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeHighMfsMemory.getNumber(), "nhmm", "HighMfsMemoryAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodePamMisconfigured), (Object)new FieldInfo(CLDBProto.NodeInfo.NodePamMisconfigured.getNumber(), "pma", "PamMisconfiguredAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeTTLocaldirFull), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeTTLocaldirFull.getNumber(), "tla", "TTLocaldirFullAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeNoHeartbeat), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeNoHeartbeat.getNumber(), "nha", "NodeNoHeartbeatAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeMaprUserMismatch), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeMaprUserMismatch.getNumber(), "nma", "NodeMaprUserMismatchAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeDuplicateHostId), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeDuplicateHostId.getNumber(), "ndh", "NodeDuplicateHostIdAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeMetricsWriteProblemAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeMetricsWriteProblemAlarm.getNumber(), "nmw", "NodeMetricsWriteProblemAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeTooManyContainersAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeTooManyContainersAlarm.getNumber(), "nmc", "NodeTooManyContainersAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NodeM7ConfigMismatchAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.NodeM7ConfigMismatchAlarm.getNumber(), "nca", "NodeM7ConfigMismatchAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.IncorrectTopologyAlarm), (Object)new FieldInfo(CLDBProto.NodeInfo.IncorrectTopologyAlarm.getNumber(), "ita", "IncorrectTopologyAlarm", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.VirtualIp), (Object)new FieldInfo(CLDBProto.NodeInfo.VirtualIp.getNumber(), "vip", "vip", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.VirtualIpEnd), (Object)new FieldInfo(CLDBProto.NodeInfo.VirtualIpEnd.getNumber(), "vipe", "vipe", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NetMask), (Object)new FieldInfo(CLDBProto.NodeInfo.NetMask.getNumber(), "nm", "nm", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.MacAddress), (Object)new FieldInfo(CLDBProto.NodeInfo.MacAddress.getNumber(), "mac", "mac", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.Gateway), (Object)new FieldInfo(CLDBProto.NodeInfo.Gateway.getNumber(), "gw", "gw", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.BytesReceived), (Object)new FieldInfo(CLDBProto.NodeInfo.BytesReceived.getNumber(), "br", "bytesReceived", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.BytesSent), (Object)new FieldInfo(CLDBProto.NodeInfo.BytesSent.getNumber(), "bs", "bytesSent", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.NumResyncSlots), (Object)new FieldInfo(CLDBProto.NodeInfo.NumResyncSlots.getNumber(), "nrs", "numResyncSlots", Integer.class)).put((Object)new NodeField(CLDBProto.NodeInfo.CpuUptime), (Object)new FieldInfo(CLDBProto.NodeInfo.CpuUptime.getNumber(), "cpt", "uptime", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.BlockMovesOut), (Object)new FieldInfo(CLDBProto.NodeInfo.BlockMovesOut.getNumber(), "bmo", BLOCK_OUT_MOVES_PARAM_NAME, Boolean.class)).put((Object)new NodeField(CLDBProto.NodeInfo.BlockMovesIn), (Object)new FieldInfo(CLDBProto.NodeInfo.BlockMovesIn.getNumber(), "bmi", BLOCK_IN_MOVES_PARAM_NAME, Boolean.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbPuts10s), (Object)new FieldInfo(CLDBProto.NodeInfo.DbPuts10s.getNumber(), "p10s", "numPutsInLastTenSeconds", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbPuts1m), (Object)new FieldInfo(CLDBProto.NodeInfo.DbPuts1m.getNumber(), "p1m", "numPutsInLastMinute", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbPuts5m), (Object)new FieldInfo(CLDBProto.NodeInfo.DbPuts5m.getNumber(), "p5m", "numPutsInLastFiveMinutes", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbPuts15m), (Object)new FieldInfo(CLDBProto.NodeInfo.DbPuts15m.getNumber(), "p15m", "numPutsInLastFifteenMinutes", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbGets10s), (Object)new FieldInfo(CLDBProto.NodeInfo.DbGets10s.getNumber(), "g10s", "numGetsInLastTenSeconds", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbGets1m), (Object)new FieldInfo(CLDBProto.NodeInfo.DbGets1m.getNumber(), "g1m", "numGetsInLastMinute", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbGets5m), (Object)new FieldInfo(CLDBProto.NodeInfo.DbGets5m.getNumber(), "g5m", "numGetsInLastFiveMinutes", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbGets15m), (Object)new FieldInfo(CLDBProto.NodeInfo.DbGets15m.getNumber(), "g15m", "numGetsInLastFifteenMinutes", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbScans10s), (Object)new FieldInfo(CLDBProto.NodeInfo.DbScans10s.getNumber(), "s10s", "numScansInLastTenSeconds", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbScans1m), (Object)new FieldInfo(CLDBProto.NodeInfo.DbScans1m.getNumber(), "s1m", "numScansInLastMinute", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbScans5m), (Object)new FieldInfo(CLDBProto.NodeInfo.DbScans5m.getNumber(), "s5m", "numScansInLastFiveMinutes", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.DbScans15m), (Object)new FieldInfo(CLDBProto.NodeInfo.DbScans15m.getNumber(), "s15m", "numScansInLastFifteenMinutes", Long.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ExtIp), (Object)new FieldInfo(CLDBProto.NodeInfo.ExtIp.getNumber(), "extIp", "extIp", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.TypeOfClient), (Object)new FieldInfo(CLDBProto.NodeInfo.TypeOfClient.getNumber(), "cltype", "clienttype", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.ClientHealth), (Object)new FieldInfo(CLDBProto.NodeInfo.ClientHealth.getNumber(), "clhealth", "clienthealth", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.Labels), (Object)new FieldInfo(CLDBProto.NodeInfo.Labels.getNumber(), "lbl", "labels", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.RdmaPort), (Object)new FieldInfo(CLDBProto.NodeInfo.RdmaPort.getNumber(), "rp", "rdmaPort", String.class)).put((Object)new NodeField(CLDBProto.NodeInfo.isFips), (Object)new FieldInfo(CLDBProto.NodeInfo.isFips.getNumber(), "isF", "isFips", Integer.class));
        CLDBProto.NodeInfo[] values = CLDBProto.NodeInfo.values();
        int max = 0;
        CLDBProto.NodeInfo[] nodeInfoArray = values;
        int n = nodeInfoArray.length;
        for (int i = 0; i < n; ++i) {
            CLDBProto.NodeInfo value = nodeInfoArray[i];
            if (value.getNumber() <= max) continue;
            max = value.getNumber();
        }
        MAX_NODEFIELDINFO = max;
        nameToEnumMap = new HashMap<String, CLDBProto.ListSortKey>();
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.ListSortKey key : CLDBProto.ListSortKey.values()) {
            if (!key.name().startsWith("Node")) continue;
            nameToEnumMap.put(key.name().toLowerCase(), key);
            if (sb.length() == 0) {
                sb.append(key.name().toLowerCase());
                continue;
            }
            sb.append("|" + key.name().toLowerCase());
        }
        supportedSortKeys = "<" + sb.toString() + ">";
        serverListParams = new ImmutableMap.Builder().putAll(baseParams).put((Object)SORT_PARAM_NAME, (Object)new TextInputParameter(SORT_PARAM_NAME, "none", false, "hostname").setInvisible(true)).put((Object)SORT_DIRECTION_PARAM_NAME, (Object)new TextInputParameter(SORT_DIRECTION_PARAM_NAME, "none", false, "ASC").setInvisible(true)).put((Object)OUTPUT_PARAM_NAME, (Object)new TextInputParameter(OUTPUT_PARAM_NAME, "verbose", false, "verbose")).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0))).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE))).put((Object)FILTER_PARAM_NAME, (Object)new FilterInputParameter(FILTER_PARAM_NAME, "none", false, "none")).put((Object)COLUMNS_PARAM_NAME, (Object)new TextInputParameter(COLUMNS_PARAM_NAME, "none", false, "all")).put((Object)ALARMEDNODES_PARAM_NAME, (Object)new BooleanInputParameter(ALARMEDNODES_PARAM_NAME, ALARMEDNODES_PARAM_NAME, false, (Object)0)).put((Object)CLIENTS_ONLY_PARAM_NAME, (Object)new BooleanInputParameter(CLIENTS_ONLY_PARAM_NAME, CLIENTS_ONLY_PARAM_NAME, false, Boolean.valueOf(false))).put((Object)NFSNODES_PARAM_NAME, (Object)new BooleanInputParameter(NFSNODES_PARAM_NAME, NFSNODES_PARAM_NAME, false, (Object)0)).put((Object)"zkconnect", (Object)new TextInputParameter("zkconnect", "ZooKeeper Connect String: 'host:port,host:port,host:port,...'", false, null)).put((Object)SORTBY_PARAM_NAME, (Object)new TextInputParameter(SORTBY_PARAM_NAME, supportedSortKeys, false, null)).put((Object)SORTING_ORDER_PARAM_NAME, (Object)new TextInputParameter(SORTING_ORDER_PARAM_NAME, "<asc|desc>", false, null)).put((Object)ADD_SPINFO, (Object)new BooleanInputParameter(ADD_SPINFO, "add spinfo", false, Boolean.valueOf(false)).setInvisible(true)).build();
        topoParams = new ImmutableMap.Builder().putAll(baseParams).put((Object)TOPO_PARENT_PARAM_NAME, (Object)new TextInputParameter(TOPO_PARENT_PARAM_NAME, TOPO_PARENT_PARAM_NAME, false, null)).build();
        topoSizeParams = new ImmutableMap.Builder().putAll(baseParams).put((Object)START_PARAM_NAME, (Object)new IntegerInputParameter(START_PARAM_NAME, START_PARAM_NAME, false, Integer.valueOf(0)).setInvisible(true)).put((Object)LIMIT_PARAM_NAME, (Object)new IntegerInputParameter(LIMIT_PARAM_NAME, LIMIT_PARAM_NAME, false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).put((Object)COLUMNS_PARAM_NAME, (Object)new TextInputParameter(COLUMNS_PARAM_NAME, "none", false, "dtotal,dused,davail,racktopo").setInvisible(true)).build();
        cldbPrimaryParams = new ImmutableMap.Builder().putAll(baseParams).build();
        canRemoveSpParams = new ImmutableMap.Builder().putAll(baseParams).put((Object)SP_CANREMOVE_SPID_PARAM_NAME, (Object)new TextInputParameter(SP_CANREMOVE_SPID_PARAM_NAME, SP_CANREMOVE_SPID_PARAM_NAME, true, null)).build();
        moveParams = new ImmutableMap.Builder().putAll(baseParams).put((Object)FILESERVER_ID_PARAM_NAME, (Object)new TextInputParameter(FILESERVER_ID_PARAM_NAME, FILESERVER_ID_PARAM_NAME, true, null)).put((Object)FILESERVER_TOPOLOGY_PARAM_NAME, (Object)new TextInputParameter(FILESERVER_TOPOLOGY_PARAM_NAME, FILESERVER_TOPOLOGY_PARAM_NAME, true, null)).build();
        modifyParams = new ImmutableMap.Builder().putAll(baseParams).put((Object)FILESERVER_NODES_PARAM_NAME, (Object)new TextInputParameter(FILESERVER_NODES_PARAM_NAME, FILESERVER_NODES_PARAM_NAME, true, null)).put((Object)BLOCK_OUT_MOVES_PARAM_NAME, (Object)new BooleanInputParameter(BLOCK_OUT_MOVES_PARAM_NAME, "true/false", false, null).setInvisible(true)).put((Object)BLOCK_IN_MOVES_PARAM_NAME, (Object)new BooleanInputParameter(BLOCK_IN_MOVES_PARAM_NAME, "true/false", false, null).setInvisible(true)).put((Object)NUM_SPS_PERINSTANCE_PARAM, (Object)new IntegerInputParameter(NUM_SPS_PERINSTANCE_PARAM, "<number of SPs per mfs instance>", false, null)).put((Object)NUM_INSTANCES_ON_A_NODE_PARAM, (Object)new IntegerInputParameter(NUM_INSTANCES_ON_A_NODE_PARAM, "<number of mfs instances on a node>", false, null).setInvisible(true)).put((Object)MEMORY_PERINSTANCE_PARAM, (Object)new IntegerInputParameter(MEMORY_PERINSTANCE_PARAM, "<memory (in MB) for each mfs instance>", false, null).setInvisible(true)).build();
        allowIntoClusterParams = new ImmutableMap.Builder().putAll(baseParams).put((Object)HOSTID_PARAM_NAME, (Object)new TextInputParameter(HOSTID_PARAM_NAME, HOSTID_PARAM_NAME, true, null)).build();
        markMaintenanceParams = new ImmutableMap.Builder().putAll(baseParams).put((Object)FILESERVER_ID_PARAM_NAME, (Object)new TextInputParameter(FILESERVER_ID_PARAM_NAME, FILESERVER_ID_PARAM_NAME, false, null)).put((Object)FILESERVER_NODES_PARAM_NAME, (Object)new TextInputParameter(FILESERVER_NODES_PARAM_NAME, FILESERVER_NODES_PARAM_NAME, false, null)).put((Object)FILESERVER_MARKMAINTENANCE_TIMEOUT_MINUTES, (Object)new IntegerInputParameter(FILESERVER_MARKMAINTENANCE_TIMEOUT_MINUTES, FILESERVER_MARKMAINTENANCE_TIMEOUT_MINUTES, true, null)).build();
        failoverNodeParams = new ImmutableMap.Builder().putAll(baseParams).put((Object)FILESERVER_NODES_PARAM_NAME, (Object)new TextInputParameter(FILESERVER_NODES_PARAM_NAME, FILESERVER_NODES_PARAM_NAME, false, null)).put((Object)LOCAL_CONTAINERS_PARAM_NAME, (Object)new BooleanInputParameter(LOCAL_CONTAINERS_PARAM_NAME, LOCAL_CONTAINERS_PARAM_NAME, false, (Object)0)).build();
        serverMarkMaintenanceCommand = new CLICommand("maintenance", "usage: node maintenance (-serverids serverid[,servierid2] |  -nodes node1[,node2] -timeoutminutes [0|minutes] ", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, markMaintenanceParams, null);
        serverFailoverCommand = new CLICommand("failover", "usage: node failover -nodes node1[,node2] -localcontainers=[true|false]", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, failoverNodeParams, null).setUsageInVisible(true);
        serverMoveCommand = new CLICommand("move", "usage: node move -serverids serverid[,serverid2,serverid3] -topology newtoplogy", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, moveParams, null).setShortUsage("node move -serverids serverid[,serverid2,serverid3] -topology topology -cluster clustername");
        serverModifyCommand = new CLICommand("modify", "usage: node modify -nodes hostname[,hostname] [-blockMovesOut true/false] [-blockMovesIn true/false] [-numSpsPerInstance<count>] [-memoryPerInstance<amount of memory>]", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, modifyParams, null).setShortUsage("node modify -nodes hostname[,hostname2,hostname3] -blockMovesOut true/false -blockMovesIn true/false [-numSpsPerInstance<count>] [-memoryPerInstance<amount of memory>]");
        allowIntoClusterCommand = new CLICommand("allow-into-cluster", "usage: node allow-into-cluster -hostids hostid[,hostid2,hostid3]", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, allowIntoClusterParams, null).setShortUsage("node allow-into-cluster -hostids hostid[,hostid2,hostid3] -cluster clustername");
        canRemoveSpCommand = new CLICommand(SP_CANREMOVE_PARAM_NAME, "usage: node -canremovesp <spid>", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, canRemoveSpParams, null).setShortUsage("node -canremovesp <spid>");
        cldbMasterCommand = new CLICommand("cldbmaster", "usage: node cldbmaster", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, cldbPrimaryParams, null).setShortUsage("node cldbmaster").setUsageInVisible(true);
        cldbPrimaryCommand = new CLICommand("cldbprimary", "usage: node cldbprimary", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, cldbPrimaryParams, null).setShortUsage("node cldbprimary");
        serverListCommand = new CLICommand("list", "usage: node list -output terse|verbose -h cldbIp -p cldbPort", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, serverListParams, null).setShortUsage("node list -h cldbIp (a.b.c.d) -p cldbPort");
        topoCommand = new CLICommand("topo", "usage: node topo -h cldbIp (a.b.c.d) -p cldbPort", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, topoParams, null).setShortUsage("usage: node topo -h cldbIp (a.b.c.d)  -p cldbPort");
        topoSizeCommand = new CLICommand("toposize", "usage: node toposize -h cldbIp (a.b.c.d) -p cldbPort", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, topoSizeParams, null).setShortUsage("node toposize -h cldbIp (a.b.c.d) -p cldbPort");
        listCldbsCommand = new CLICommand("listcldbs", "usage: node listcldbs -cluster <clustername> | -cldb <cldb hostname/ip>", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)CLDB_PARAM_NAME, (Object)new TextInputParameter(CLDB_PARAM_NAME, "<cldb hostname|ip:port>", false, null)).build(), null).setShortUsage("node listcldbs -cluster <clustername> | -cldb <hostname|ip:port>");
        listZksCommand = new CLICommand("listzookeepers", "usage: node listzookeepers -cluster <clustername>", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)CLDB_PARAM_NAME, (Object)new TextInputParameter(CLDB_PARAM_NAME, "<cldb hostname|ip:port>", false, null)).build(), null).setShortUsage("node listzookeepers -cluster <clustername> | -cldb <hostname|ip:port>");
        listCldbsAndZksCommand = new CLICommand("listcldbzks", "usage: node listcldbzks -cluster <clustername> | -cldb <hostname|ip:port>", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).put((Object)CLDB_PARAM_NAME, (Object)new TextInputParameter(CLDB_PARAM_NAME, "<cldb hostname|ip:port>", false, null)).build(), null).setShortUsage("node listcldbzks -cluster <clustername> | -cldb <hostname|ip:port>").setUsageInVisible(true);
        listapiserversCommand = new CLICommand("listapiservers", "usage: node listapiservers -cluster <clustername>", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(baseParams).build(), null).setShortUsage("node listapiservers -cluster <clustername>").setUsageInVisible(true);
        refillParams = new ImmutableMap.Builder().putAll(baseParams).put((Object)FILESERVER_ID_PARAM_NAME, (Object)new TextInputParameter(FILESERVER_ID_PARAM_NAME, FILESERVER_ID_PARAM_NAME, true, null)).build();
        serverRefillCommand = new CLICommand("refill", "usage: node refill -serverids serverid[,serverid2,serverid3]", ServerCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, refillParams, null).setShortUsage("node refill -serverids serverid[,serverid2,serverid3] -cluster clustername");
        serverCommands = new CLICommand("node", "node [list|move|modify|allow-into-cluster|services|topo|toposize|remove|heatmap|listcldbs|listzookeepers|cldbprimary|canremovesp|maintenance|metrics|listcldbzks|refill]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{serverListCommand, serverMoveCommand, serverModifyCommand, allowIntoClusterCommand, cldbMasterCommand, cldbPrimaryCommand, canRemoveSpCommand, serverMarkMaintenanceCommand, topoCommand, topoSizeCommand, serverFailoverCommand, NodeRemoveCommand.nodeRemove, NodeMetricsCommand.nodeMetricsCmd, NodeMetricsCommand.showMemoryCmd, NodeServicesManagementCommand.nodeServices, Heatmap.heatmapCmds, listCldbsCommand, listZksCommand, listCldbsAndZksCommand, listapiserversCommand, serverRefillCommand}).setShortUsage("node [list|move|modify|allow-into-cluster|services|topo|remove|heatmap|listcldbs|listzookeepers|cldbprimary|canremovesp|maintenance|metrics|show|listcldbzks|refill]");
    }

    static class IpAddressNode
    extends CommandOutput.OutputHierarchy.OutputNode {
        public IpAddressNode(String name, Object value) {
            super(name, value);
        }

        public String peersString() {
            StringBuffer sb = new StringBuffer();
            boolean addComma = false;
            for (CommandOutput.OutputHierarchy.OutputNode ipaddr : super.getPeers()) {
                if (addComma) {
                    sb.append(ServerCommands.MULTI_ARG_SEP);
                }
                sb.append(ipaddr.getValue().toString());
                addComma = true;
            }
            return sb.toString();
        }
    }

    class DiskInfo {
        long diskTotal;
        long diskUsed;
        long diskAvailable;

        public DiskInfo(long diskUsed, long diskAvailable, long diskTotal) {
            this.diskTotal = diskTotal;
            this.diskUsed = diskUsed;
            this.diskAvailable = diskAvailable;
        }

        public long getDiskTotal() {
            return this.diskTotal;
        }

        public long getDiskUsed() {
            return this.diskUsed;
        }

        public long getDiskAvailable() {
            return this.diskAvailable;
        }

        public void setDiskTotal(long total) {
            this.diskTotal = total;
        }

        public void setDiskUsed(long used) {
            this.diskUsed = used;
        }

        public void setDiskAvailable(long avail) {
            this.diskAvailable = avail;
        }
    }
}

