/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.Util;
import com.mapr.cli.DbGatewayCommands;
import com.mapr.cli.DbQueryServiceCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.NoValueInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ClusterCommands
extends CLIBaseClass
implements CLIInterface {
    private static final String SETMODE_PARAM = "mode";
    private static final String FEATURE_NAME = "name";
    private static final String FEATURE_FORCE = "force";
    private static final String FEATURE_ENABLED = "enabled";
    private static final String FEATURE_DISABLED = "disabled";
    private static final String FEATURE_ALL = "all";
    private static final String MULTI_ARG_SEP = ",";
    private static final String GET_MINMAX_PARAM = "getminmax";
    private static final String S3CONFIG_SUBCMD_NAME = "s3config";
    private static final String S3SERVER_PARENT_CMD = "cluster s3config";
    private static final String S3SERVER_PARAM = "s3server";
    public static final String versionFilePath = "/hadoop/hadoopversion";
    private static final String maprInstallPath = MapRCliUtil.getMapRInstallDir();
    private static final String hadoopVersionLocalFile = maprInstallPath + "/hadoop/hadoopversion";
    private static final String daemonConfFile = maprInstallPath + "/conf/daemon.conf";
    private static final String CLASSIC_VERSION_TOKEN = "classic_version";
    private static final String YARN_VERSION_TOKEN = "yarn_version";
    private static final String DEFAULT_MODE_TOKEN = "default_mode";
    private static final Logger LOG = Logger.getLogger(ClusterCommands.class);
    private static final CLICommand mapreduceGetAllVersionCommand = new CLICommand("getall", "Get MapReduce Version values", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("Shows the MapReduce version info").setUsageInVisible(true);
    private static final CLICommand mapreduceGetVersionCommand = new CLICommand("get", "Get Cluster wide MapReduce default mode", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null).setShortUsage("Shows the current cluster MapReduce default version");
    private static final CLICommand mapreduceSetVersionCommand = new CLICommand("set", "Set Cluster wide MapReduce default mode", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"mode", (Object)new TextInputParameter("mode", "Sets the default MapReduce default version <yarn>", true, null)).build(), null);
    private static final CLICommand mapreduceCommands = new CLICommand("mapreduce", "Get or Set Cluster wide MapReduce defaults such as version", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{mapreduceGetAllVersionCommand, mapreduceGetVersionCommand, mapreduceSetVersionCommand});
    private static final CLICommand s3ConfigSetCommand = new CLICommand("set", "Set (replace) existing s3Server configurations with new list", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"s3server", (Object)new TextInputParameter("s3server", "<hostname:port> for s3 server", false, null)).build(), null);
    private static final CLICommand s3ConfigAddCommand = new CLICommand("add", "Adds new s3Server configuration to existing s3 Server configurations", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"s3server", (Object)new TextInputParameter("s3server", "<hostname:port> for s3 server", false, null)).build(), null);
    private static final CLICommand s3ConfigRemoveCommand = new CLICommand("remove", "remove s3Server configuration from existing s3 Server configurations", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"s3server", (Object)new TextInputParameter("s3server", "<hostname:port> for s3 server", false, null)).build(), null);
    private static final CLICommand s3ConfigShowCommand = new CLICommand("show", "display existing s3Server configurations", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().build(), null);
    private static final CLICommand s3ConfigCommands = new CLICommand("s3config", "Addd, Set or Remove s3 server instances to cldb", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{s3ConfigSetCommand, s3ConfigAddCommand, s3ConfigRemoveCommand, s3ConfigShowCommand});
    static final CLICommand featureEnableCommand = new CLICommand("enable", "usage: cluster feature enable [-name <feature name> | -force <true|false> | -all ]", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "feature name", false, null)).put((Object)"force", (Object)new BooleanInputParameter("force", "<true|false> true enables depedency features too", false, null)).put((Object)"all", (Object)new NoValueInputParameter("all", "all features", false, false)).build(), null).setShortUsage("Enables feature");
    static final CLICommand featureListCommand = new CLICommand("list", "usage: cluster feature list [ -name <featurename> -type <cldb|mfs> -state <enabled|disabled> -class <v2|v3> ]", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"name", (Object)new TextInputParameter("name", "feature name", false, null)).put((Object)"enabled", (Object)new NoValueInputParameter("enabled", "enabled features only", false, false)).put((Object)"disabled", (Object)new NoValueInputParameter("disabled", "disabled features only", false, false)).build(), null).setShortUsage("Lists features on the cluster");
    static String supportedMinMaxEntities;
    static final CLICommand infoCommand;
    public static final CLICommand featureCommand;
    public static final CLICommand clusterCommands;

    public ClusterCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(oh);
        String cmd = this.cliCommand.getCommandName();
        String parentNames = this.cliCommand.getParentCommand().getParentCommandNames();
        boolean isS3ConfigCmd = S3SERVER_PARENT_CMD.equalsIgnoreCase(parentNames);
        if (isS3ConfigCmd) {
            this.processS3ConfigCmd(oh, cmd);
            return output;
        }
        if (cmd.equalsIgnoreCase("set")) {
            this.addContentsToOutput(oh, ClusterCommands.readHadoopVersionFile());
        } else if (cmd.equalsIgnoreCase("get")) {
            VersionFileContents contents = ClusterCommands.readHadoopVersionFile();
            if (contents != null) {
                this.addContentsToOutput(oh, contents);
            }
        } else if (cmd.equalsIgnoreCase("getall")) {
            VersionFileContents contents = ClusterCommands.readHadoopVersionFile();
            if (contents != null) {
                this.addAllContentsToOutput(oh, contents);
            }
        } else if (cmd.equalsIgnoreCase("enable")) {
            this.enableFeature(oh);
            LOG.error((Object)("enable: cluster feature " + cmd));
        } else if (cmd.equalsIgnoreCase("list")) {
            this.listFeatures(oh);
            LOG.error((Object)("list: cluster feature " + cmd));
        } else if (cmd.equalsIgnoreCase("info")) {
            this.processInfo(oh);
            LOG.error((Object)("info: " + cmd));
        }
        return output;
    }

    private void processS3ConfigCmd(CommandOutput.OutputHierarchy oh, String cmd) throws CLIProcessingException {
        if (oh == null || cmd == null) {
            return;
        }
        if (cmd.equalsIgnoreCase("set")) {
            this.processS3ConfigSet(oh);
        } else if (cmd.equalsIgnoreCase("add")) {
            this.processS3ConfigAdd(oh);
        } else if (cmd.equalsIgnoreCase("remove")) {
            this.processS3ConfigRemove(oh);
        } else if (cmd.equalsIgnoreCase("show")) {
            this.processS3ConfigShow(oh);
        }
    }

    private CLDBProto.S3ServerConfigProperties makeS3ServerConfigProperties(String hostname, String port) throws UnknownHostException {
        Common.IPPort ipPort = Common.IPPort.newBuilder().addAllHosts(MapRCliUtil.getHostIps(hostname)).setPort(Integer.parseInt(port)).build();
        return CLDBProto.S3ServerConfigProperties.newBuilder().setHostname(hostname).setIpPort(ipPort).build();
    }

    private void processS3ConfigSet(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        byte[] data;
        CLDBProto.S3ServerConfigSetRequest.Builder req = CLDBProto.S3ServerConfigSetRequest.newBuilder().setCreds(this.getUserCredentials());
        if (this.isParamPresent(S3SERVER_PARAM)) {
            String[] hosts;
            for (String host : hosts = this.getParamTextValue(S3SERVER_PARAM, 0).split(MULTI_ARG_SEP)) {
                Object[] pair = host.split(":");
                if (pair.length != 2) {
                    LOG.error((Object)("Invalid <hostname:port> pair " + Arrays.toString(pair)));
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid <hostname:port> pair " + Arrays.toString(pair)));
                    return;
                }
                try {
                    req.addS3Servers(this.makeS3ServerConfigProperties((String)pair[0], (String)pair[1]));
                }
                catch (UnknownHostException e) {
                    LOG.error((Object)("s3config set failed to resolve host " + host));
                    oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "s3config set failed to resolve host " + host));
                    return;
                }
            }
        }
        if ((data = this.sendRequestInternal(CLDBProto.CLDBProg.S3ServerConfigSetProc, (MessageLite)req.build(), oh)) == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return;
        }
        CLDBProto.S3ServerConfigSetResponse resp = null;
        try {
            resp = CLDBProto.S3ServerConfigSetResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing s3Config set response."));
            LOG.error((Object)"s3Config set failed. Exception parsing s3Config set response.", (Throwable)e);
            return;
        }
        if (resp.getStatus() == 0) {
            LOG.info((Object)"s3 servers set to new values");
        } else {
            LOG.error((Object)("Failed to set s3 servers. Error " + resp.getErrMsg()));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
        }
    }

    private void processS3ConfigAdd(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        byte[] data;
        CLDBProto.S3ServerConfigAddRequest.Builder req = CLDBProto.S3ServerConfigAddRequest.newBuilder().setCreds(this.getUserCredentials());
        String host = null;
        if (this.isParamPresent(S3SERVER_PARAM)) {
            host = this.getParamTextValue(S3SERVER_PARAM, 0);
            Object[] pair = host.split(":");
            if (pair.length != 2) {
                LOG.error((Object)("Invalid <hostname:port> pair " + Arrays.toString(pair)));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid <hostname:port> pair " + Arrays.toString(pair)));
                return;
            }
            try {
                req.setS3Server(this.makeS3ServerConfigProperties((String)pair[0], (String)pair[1]));
            }
            catch (UnknownHostException e) {
                LOG.error((Object)("s3config add failed to resolve host " + host));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "s3config add failed to resolve host " + host));
                return;
            }
        }
        if ((data = this.sendRequestInternal(CLDBProto.CLDBProg.S3ServerConfigAddProc, (MessageLite)req.build(), oh)) == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return;
        }
        CLDBProto.S3ServerConfigAddResponse resp = null;
        try {
            resp = CLDBProto.S3ServerConfigAddResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing s3Config add response."));
            LOG.error((Object)"s3Config add failed. Exception parsing s3Config add response.", (Throwable)e);
            return;
        }
        if (resp.getStatus() == 0) {
            LOG.info((Object)("added s3 server to cldb " + host));
        } else {
            LOG.error((Object)("Failed to add s3 server. Error " + resp.getErrMsg()));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
        }
    }

    private void processS3ConfigRemove(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        byte[] data;
        CLDBProto.S3ServerConfigRemoveRequest.Builder req = CLDBProto.S3ServerConfigRemoveRequest.newBuilder().setCreds(this.getUserCredentials());
        String host = null;
        if (this.isParamPresent(S3SERVER_PARAM)) {
            host = this.getParamTextValue(S3SERVER_PARAM, 0);
            Object[] pair = host.split(":");
            if (pair.length != 2) {
                LOG.error((Object)("Invalid <hostname:port> pair " + Arrays.toString(pair)));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid <hostname:port> pair " + Arrays.toString(pair)));
                return;
            }
            try {
                req.setS3Server(this.makeS3ServerConfigProperties((String)pair[0], (String)pair[1]));
            }
            catch (UnknownHostException e) {
                LOG.error((Object)("s3Config remove failed to resolve host " + host));
                oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "s3config remove failed to resolve host " + host));
                return;
            }
        }
        if ((data = this.sendRequestInternal(CLDBProto.CLDBProg.S3ServerConfigRemoveProc, (MessageLite)req.build(), oh)) == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return;
        }
        CLDBProto.S3ServerConfigRemoveResponse resp = null;
        try {
            resp = CLDBProto.S3ServerConfigRemoveResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing s3Config remove response."));
            LOG.error((Object)"s3Config remove failed. Exception parsing s3Config remove response.", (Throwable)e);
            return;
        }
        if (resp.getStatus() == 0) {
            LOG.info((Object)("removed s3 server " + host + " from cldb"));
        } else {
            LOG.error((Object)("Failed to remove s3 server. Error " + resp.getErrMsg()));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
        }
    }

    private void processS3ConfigShow(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.ClusterInfoRequest req = CLDBProto.ClusterInfoRequest.newBuilder().setCreds(this.getUserCredentials()).build();
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.S3ServerConfigShowProc, (MessageLite)req, oh);
        if (data == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
            return;
        }
        CLDBProto.ClusterInfoResponse resp = null;
        try {
            resp = CLDBProto.ClusterInfoResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing s3Config show response."));
            LOG.error((Object)"s3Config show failed. Exception parsing s3Config show response.", (Throwable)e);
            return;
        }
        if (resp.getStatus() == 0) {
            this.formatS3ServerConfig(resp.getS3ServerLocationList(), oh);
        } else {
            int status = resp.getStatus();
            LOG.error((Object)("Failed to show s3 servers. Error " + Errno.toString((int)status)));
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(status, Errno.toString((int)status)));
        }
    }

    private void formatS3ServerConfig(List<CLDBProto.S3ServerConfigProperties> configs, CommandOutput.OutputHierarchy oh) {
        for (CLDBProto.S3ServerConfigProperties cfg : configs) {
            Common.IPPort ip;
            CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
            if (cfg.hasHostname()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("hostname", (Object)cfg.getHostname()));
            }
            if ((ip = cfg.getIpPort()) != null) {
                if (ip.getHostsCount() > 0) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("ip", (Object)Util.intToIp((int)ip.getHosts(0))));
                }
                if (ip.hasPort()) {
                    out.addChild(new CommandOutput.OutputHierarchy.OutputNode("port", ip.getPort()));
                }
            }
            oh.addNode(out);
        }
    }

    private void enableFeature(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        if (!this.isParamPresent(FEATURE_NAME) && !this.isParamPresent(FEATURE_ALL)) {
            oh.addMessage(this.getCommandUsage());
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(10001, "feature enable arguments missing. Pass either featurename or 'all'"));
            return;
        }
        if (this.isParamPresent(FEATURE_NAME) && this.isParamPresent(FEATURE_ALL)) {
            oh.addMessage(this.getCommandUsage());
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "feature enable arguments must not provide 'name' and 'all' together."));
            return;
        }
        boolean force = false;
        if (this.isParamPresent(FEATURE_FORCE)) {
            force = this.getParamBooleanValue(FEATURE_FORCE, 0);
        }
        CLDBProto.FeatureEnableRequest.Builder featureEnableReqBuilder = CLDBProto.FeatureEnableRequest.newBuilder().setCreds(this.getUserCredentials()).setForce(force);
        if (this.isParamPresent(FEATURE_NAME)) {
            String featureNames = this.getParamTextValue(FEATURE_NAME, 0);
            List<String> names = new ArrayList<String>();
            if (featureNames.contains(MULTI_ARG_SEP)) {
                names = Arrays.asList(featureNames.split(MULTI_ARG_SEP));
            } else {
                names.add(featureNames);
            }
            featureEnableReqBuilder.addAllFeatures(names);
        } else if (this.isParamPresent(FEATURE_ALL)) {
            featureEnableReqBuilder.addFeatures(FEATURE_ALL);
        }
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.FeatureEnableProc, (MessageLite)featureEnableReqBuilder.build(), oh);
        CLDBProto.FeatureEnableResponse resp = null;
        try {
            resp = CLDBProto.FeatureEnableResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing feature enable response."));
            LOG.error((Object)"Feature enable failed. Exception parsing feature enable response.", (Throwable)ipbe);
            return;
        }
        if (resp.getStatus() == 0) {
            CommandOutput.OutputHierarchy toh = this.formatMaprFeatureInfoList(resp.getFeaturesList());
            for (CommandOutput.OutputHierarchy.OutputNode a : toh.getOutputNodes()) {
                oh.addNode(a);
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), resp.getErrMsg()));
            LOG.error((Object)("Feature enable failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
        }
    }

    private void listFeatures(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.FeatureListRequest.Builder featureInfoRequestBuilder = CLDBProto.FeatureListRequest.newBuilder().setCreds(this.getUserCredentials());
        List<String> names = new ArrayList<String>();
        if (this.isParamPresent(FEATURE_NAME)) {
            String featureNames = this.getParamTextValue(FEATURE_NAME, 0);
            if (!featureNames.contains(MULTI_ARG_SEP)) {
                names.add(featureNames);
            } else {
                names = Arrays.asList(featureNames.split(MULTI_ARG_SEP));
            }
        } else {
            names.add(FEATURE_ALL);
        }
        featureInfoRequestBuilder.addAllFeatures(names);
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.FeatureListProc, (MessageLite)featureInfoRequestBuilder.build(), oh);
        CLDBProto.FeatureListResponse resp = null;
        try {
            resp = CLDBProto.FeatureListResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing feature list response."));
            LOG.error((Object)"Feature list failed. Exception parsing feature list response.", (Throwable)ipbe);
            return;
        }
        if (resp.getStatus() == 0) {
            CommandOutput.OutputHierarchy toh = this.formatMaprFeatureInfoList(resp.getFeaturesList());
            for (CommandOutput.OutputHierarchy.OutputNode a : toh.getOutputNodes()) {
                oh.addNode(a);
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Feature list failed: " + resp.getErrMsg()));
            LOG.error((Object)("Feature list failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
        }
    }

    private CommandOutput.OutputHierarchy formatMaprFeatureInfoList(List<CLDBProto.MaprFeatureInfo> mfList) throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        for (CLDBProto.MaprFeatureInfo mf : mfList) {
            if (!(this.isParamPresent(FEATURE_ENABLED) && mf.getEnabled() || this.isParamPresent(FEATURE_DISABLED) && !mf.getEnabled()) && (this.isParamPresent(FEATURE_ENABLED) || this.isParamPresent(FEATURE_DISABLED))) continue;
            oh.addNode(this.formatMaprFeatureInfo(mf));
        }
        return oh;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatMaprFeatureInfo(CLDBProto.MaprFeatureInfo mf) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        if (mf.hasFeatureName()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FEATURE_NAME, (Object)mf.getFeatureName()));
        }
        if (mf.hasEnabled()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FEATURE_ENABLED, (Object)mf.getEnabled()));
        }
        if (mf.hasDescription()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("description", (Object)mf.getDescription()));
        }
        if (mf.getDependenceInfoList().size() > 0) {
            CommandOutput.OutputHierarchy oh = this.formatMaprFeatureInfoList(mf.getDependenceInfoList());
            for (CommandOutput.OutputHierarchy.OutputNode a : oh.getOutputNodes()) {
                out.addChild(new CommandOutput.OutputHierarchy.OutputNode("dependency", (Object)a));
            }
        }
        return out;
    }

    private byte[] sendRequestInternal(CLDBProto.CLDBProg procId, MessageLite req, CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        Class<CLDBProto.FeatureEnableResponse> responseClass = null;
        switch (procId) {
            case FeatureEnableProc: {
                responseClass = CLDBProto.FeatureEnableResponse.class;
                break;
            }
            case FeatureListProc: {
                responseClass = CLDBProto.FeatureListResponse.class;
                break;
            }
            case GetMinMaxProc: {
                responseClass = CLDBProto.GetMinMaxResponse.class;
                break;
            }
            case S3ServerConfigSetProc: {
                responseClass = CLDBProto.S3ServerConfigSetResponse.class;
                break;
            }
            case S3ServerConfigAddProc: {
                responseClass = CLDBProto.S3ServerConfigAddResponse.class;
                break;
            }
            case S3ServerConfigRemoveProc: {
                responseClass = CLDBProto.S3ServerConfigRemoveResponse.class;
                break;
            }
            case S3ServerConfigShowProc: {
                responseClass = CLDBProto.ClusterInfoResponse.class;
            }
        }
        if (responseClass == null) {
            LOG.error((Object)("Unknown procId for send request " + procId));
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Unknown procId for send request " + procId));
            return null;
        }
        byte[] data = null;
        try {
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), procId.getNumber(), req, responseClass) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), procId.getNumber(), req, responseClass);
        }
        catch (Exception e) {
            throw new CLIProcessingException((Throwable)e);
        }
        return data;
    }

    private Common.IPAddress buildIPFromString(String ipstr) {
        if (ipstr.equalsIgnoreCase("localhost") || ipstr.equalsIgnoreCase("127.0.0.1")) {
            ipstr = "127.0.0.1";
        } else {
            List<String> ips = NodesCommonUtils.convertHostToIp(Collections.singletonList(ipstr));
            if (ips.isEmpty()) {
                return null;
            }
            ipstr = ips.get(0);
        }
        return Common.IPAddress.newBuilder().setHost(Util.ipToInt((String)ipstr)).build();
    }

    private void addAllContentsToOutput(CommandOutput.OutputHierarchy oh, VersionFileContents contents) {
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(CLASSIC_VERSION_TOKEN, (Object)contents.classic_version));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(YARN_VERSION_TOKEN, (Object)contents.yarn_version));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEFAULT_MODE_TOKEN, (Object)contents.default_mode));
        oh.addNode(node);
    }

    private void addContentsToOutput(CommandOutput.OutputHierarchy oh, VersionFileContents contents) {
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode(DEFAULT_MODE_TOKEN, (Object)contents.default_mode));
        String version = "";
        if (contents.default_mode != null) {
            version = contents.default_mode.equals("classic") ? contents.classic_version : contents.yarn_version;
        }
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode("mapreduce_version", (Object)version));
        oh.addNode(node);
    }

    public static VersionFileContents readHadoopVersionFile() {
        VersionFileContents contents = new VersionFileContents();
        contents.classic_version = "0.20.2";
        contents.default_mode = "yarn";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(hadoopVersionLocalFile));
            contents.yarn_version = reader.readLine();
            reader.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"Error while trying to get hadoop version", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Error while trying to get hadoop version", (Throwable)e);
        }
        return contents;
    }

    private void processInfo(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        if (this.isParamPresent(GET_MINMAX_PARAM)) {
            this.processGetMinMax(oh);
        }
    }

    private void processGetMinMax(CommandOutput.OutputHierarchy oh) throws CLIProcessingException {
        CLDBProto.GetMinMaxRequest.Builder GetMinMaxRequestBuilder = CLDBProto.GetMinMaxRequest.newBuilder().setCreds(this.getUserCredentials());
        HashMap<String, CLDBProto.MinMaxAttributes> nameToEnumMap = new HashMap<String, CLDBProto.MinMaxAttributes>();
        for (CLDBProto.MinMaxAttributes attrib : CLDBProto.MinMaxAttributes.values()) {
            nameToEnumMap.put(attrib.name().toLowerCase(), attrib);
        }
        String entityName = this.getParamTextValue(GET_MINMAX_PARAM, 0);
        ArrayList<CLDBProto.MinMaxAttributes> attribs = new ArrayList<CLDBProto.MinMaxAttributes>();
        CLDBProto.MinMaxAttributes attrib = null;
        if (entityName.contains(MULTI_ARG_SEP)) {
            List<String> entityList = Arrays.asList(entityName.split(MULTI_ARG_SEP));
            Iterator<String> iterator = entityList.iterator();
            while (iterator.hasNext()) {
                String name;
                entityName = name = iterator.next();
                attrib = (CLDBProto.MinMaxAttributes)nameToEnumMap.get(name = name.toLowerCase());
                if (attrib != null) {
                    attribs.add(attrib);
                    continue;
                }
                break;
            }
        } else {
            String name = entityName.toLowerCase();
            attrib = (CLDBProto.MinMaxAttributes)nameToEnumMap.get(name);
            if (attrib != null) {
                attribs.add(attrib);
            }
        }
        if (attrib == null) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing entityName " + entityName));
            LOG.error((Object)("info getminmax failed. " + entityName + " is not a valid keyword."));
            return;
        }
        GetMinMaxRequestBuilder.addAllMinMaxAttribs(attribs);
        byte[] data = this.sendRequestInternal(CLDBProto.CLDBProg.GetMinMaxProc, (MessageLite)GetMinMaxRequestBuilder.build(), oh);
        CLDBProto.GetMinMaxResponse resp = null;
        try {
            resp = CLDBProto.GetMinMaxResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException ipbe) {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(22, "error parsing info getminmax response."));
            LOG.error((Object)"info getminmax failed. Exception parsing info getminmax response.", (Throwable)ipbe);
            return;
        }
        if (resp.getStatus() == 0) {
            CommandOutput.OutputHierarchy toh = this.formatMinMaxResponse(resp.getEntityList());
            for (CommandOutput.OutputHierarchy.OutputNode a : toh.getOutputNodes()) {
                oh.addNode(a);
            }
        } else {
            oh.addError(new CommandOutput.OutputHierarchy.OutputError(resp.getStatus(), "Feature list failed: " + resp.getErrMsg()));
            LOG.error((Object)("Feature list failed. status: " + resp.getStatus() + " " + resp.getErrMsg()));
        }
    }

    private CommandOutput.OutputHierarchy formatMinMaxResponse(List<CLDBProto.GetMinMaxResponse.MinMaxEntity> eList) throws CLIProcessingException {
        CommandOutput.OutputHierarchy oh = new CommandOutput.OutputHierarchy();
        for (CLDBProto.GetMinMaxResponse.MinMaxEntity mf : eList) {
            oh.addNode(this.formatMinMaxEntity(mf));
        }
        return oh;
    }

    private CommandOutput.OutputHierarchy.OutputNode formatMinMaxEntity(CLDBProto.GetMinMaxResponse.MinMaxEntity mf) throws CLIProcessingException {
        CommandOutput.OutputHierarchy.OutputNode out = new CommandOutput.OutputHierarchy.OutputNode();
        if (mf.hasName()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode(FEATURE_NAME, (Object)mf.getName()));
        }
        if (mf.hasMinVal()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("min", (Object)mf.getMinVal()));
        }
        if (mf.hasMaxVal()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("max", (Object)mf.getMaxVal()));
        }
        if (mf.hasUnit()) {
            out.addChild(new CommandOutput.OutputHierarchy.OutputNode("unit", (Object)mf.getUnit()));
        }
        return out;
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (CLDBProto.MinMaxAttributes attrib : CLDBProto.MinMaxAttributes.values()) {
            if (sb.length() == 0) {
                sb.append(attrib.name().toLowerCase());
                continue;
            }
            sb.append("|" + attrib.name().toLowerCase());
        }
        supportedMinMaxEntities = "[" + sb.toString() + "]";
        infoCommand = new CLICommand("info", "usage: cluster info getminmax <comma seperated list of entities>", ClusterCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)GET_MINMAX_PARAM, (Object)new TextInputParameter(GET_MINMAX_PARAM, "list of entities to fetch min and max values from: " + supportedMinMaxEntities, true, null)).build(), null).setShortUsage("returns cluster wide min and max values for given list of comma seperated entities");
        featureCommand = new CLICommand("feature", "Enable or List features on the cluster", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{featureEnableCommand, featureListCommand});
        clusterCommands = new CLICommand("cluster", "set and get cluster wide info", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{mapreduceCommands, DbGatewayCommands.gatewayCommands, featureCommand, infoCommand, DbQueryServiceCommands.queryServiceCommands, s3ConfigCommands}).setShortUsage("cluster [mapreduce [get|set] | gateway | feature [enable|list] | info getminmax | s3config [set|add|remove|show]]");
    }

    public static class VersionFileContents {
        String classic_version;
        String yarn_version;
        String default_mode;
    }
}

