/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.TextCommandOutput;
import com.mapr.cliframework.base.inputparams.BaseInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.security.MaprSecurityException;
import java.util.Map;
import org.apache.log4j.Logger;

public class RlimitCommands
extends CLIBaseClass
implements CLIInterface {
    static final String RESOURCE_PARAM_NAME = "resource";
    static final String VALUE_PARAM_NAME = "value";
    private static final Logger LOG = Logger.getLogger(RlimitCommands.class);
    static final Map<String, BaseInputParameter> params = new ImmutableMap.Builder().put((Object)"resource", (Object)new TextInputParameter("resource", "resource name [disk]", true, null)).put((Object)"cluster", (Object)new TextInputParameter("cluster", "cluster name", false, null)).build();
    static final CLICommand getRlimitCommand = new CLICommand("get", "obtain limit for a resource", RlimitCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).build(), null).setShortUsage("get -resource disk");
    static final CLICommand setRlimitCommand = new CLICommand("set", "set limit for a resource", RlimitCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().putAll(params).put((Object)"value", (Object)new TextInputParameter("value", "limit value for the resource", true, null)).build(), null).setShortUsage("set -resource disk -value <limit>");
    static final CLICommand[] rlimitSubCommands = new CLICommand[]{getRlimitCommand, setRlimitCommand};
    static final String usageStr = "rlimit [set|get] -resource <resource>";
    public static final CLICommand rlimitCommands = new CLICommand("rlimit", "usage: rlimit [set|get] -resource <resource>", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, rlimitSubCommands).setShortUsage("rlimit [set|get] -resource <resource>");

    public RlimitCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    String unitToString(CLDBProto.ResourceUsageUnit unit) {
        switch (unit) {
            case B: {
                return "B";
            }
            case KB: {
                return "KB";
            }
            case MB: {
                return "MB";
            }
            case GB: {
                return "GB";
            }
            case TB: {
                return "TB";
            }
            case PB: {
                return "PB";
            }
        }
        return "";
    }

    CommandOutput getRlimit() throws CLIProcessingException {
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        String resourceType = this.getParamTextValue(RESOURCE_PARAM_NAME, 0);
        if (!resourceType.equalsIgnoreCase("disk")) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "rlimit get failed for resource type " + resourceType + ". Valid resources are disk.").setField(RESOURCE_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        CLDBProto.RLimitRequest.Builder req = CLDBProto.RLimitRequest.newBuilder().setCreds(this.getUserCredentials()).setRequestType(CLDBProto.RLimitRequestType.GET_REQUEST).setResource(CLDBProto.RLimitResourceType.DISK_RESOURCE);
        CLDBProto.RLimitResponse resp = null;
        try {
            byte[] data = null;
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.RLimitGetRequestProc.getNumber(), (MessageLite)req.build(), CLDBProto.RLimitResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.RLimitGetRequestProc.getNumber(), (MessageLite)req.build(), CLDBProto.RLimitResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            resp = CLDBProto.RLimitResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                String errMsg = resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString((int)status);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Obtaining rlimit for resource " + resourceType + " failed with error - " + errMsg));
                output.setOutput(out);
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error sending the RPC to obtain rlimit"));
            output.setOutput(out);
            return output;
        }
        CLDBProto.RLimitDiskUsage diskUsage = resp.getDiskUsage();
        String unitStr = this.unitToString(diskUsage.getLimit().getUnit());
        CommandOutput.OutputHierarchy.OutputNode node = new CommandOutput.OutputHierarchy.OutputNode();
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode("limit", (Object)(diskUsage.getLimit().getValue() + unitStr)));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode("clusterSize", (Object)(diskUsage.getClusterSpaceAvailableMB() + "MB")));
        node.addChild(new CommandOutput.OutputHierarchy.OutputNode("currentUsage", (Object)(diskUsage.getClusterSpaceProvisionedMB() + "MB")));
        out.addNode(node);
        output.setOutput(out);
        return output;
    }

    CLDBProto.ResourceUsageLimit getDiskSpace(String value) throws Exception {
        CLDBProto.ResourceUsageLimit.Builder result = CLDBProto.ResourceUsageLimit.newBuilder().setUnit(CLDBProto.ResourceUsageUnit.B);
        if (value.endsWith("B") || value.endsWith("b")) {
            value = value.substring(0, value.length() - 1);
        }
        if (value.endsWith("K") || value.endsWith("k")) {
            result.setUnit(CLDBProto.ResourceUsageUnit.KB);
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("M") || value.endsWith("m")) {
            result.setUnit(CLDBProto.ResourceUsageUnit.MB);
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("G") || value.endsWith("g")) {
            result.setUnit(CLDBProto.ResourceUsageUnit.GB);
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("T") || value.endsWith("t")) {
            result.setUnit(CLDBProto.ResourceUsageUnit.TB);
            value = value.substring(0, value.length() - 1);
        } else if (value.endsWith("P") || value.endsWith("p")) {
            result.setUnit(CLDBProto.ResourceUsageUnit.PB);
            value = value.substring(0, value.length() - 1);
        }
        long num = Long.valueOf(value);
        result.setValue(num);
        return result.build();
    }

    CommandOutput setRlimit() throws CLIProcessingException {
        CLDBProto.ResourceUsageLimit usageLimit;
        CommandOutput output = new CommandOutput();
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        String resourceType = this.getParamTextValue(RESOURCE_PARAM_NAME, 0);
        if (!resourceType.equalsIgnoreCase("disk")) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "rlimit set failed for resource type " + resourceType + ". Valid resources are disk.").setField(RESOURCE_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        String valueType = this.getParamTextValue(VALUE_PARAM_NAME, 0);
        try {
            usageLimit = this.getDiskSpace(valueType);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Invalid number for resource disk " + valueType + ". Valid numbers are <number>[KMGTP][B].").setField(VALUE_PARAM_NAME));
            output.setOutput(out);
            return output;
        }
        try {
            CLDBProto.RLimitRequest.Builder req = CLDBProto.RLimitRequest.newBuilder().setCreds(this.getUserCredentials()).setRequestType(CLDBProto.RLimitRequestType.SET_REQUEST).setResource(CLDBProto.RLimitResourceType.DISK_RESOURCE).setLimit(usageLimit);
            byte[] data = null;
            data = this.isParamPresent("cluster") ? CLDBRpcCommonUtils.getInstance().sendRequest(this.getParamTextValue("cluster", 0), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.RLimitSetRequestProc.getNumber(), (MessageLite)req.build(), CLDBProto.RLimitResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.RLimitSetRequestProc.getNumber(), (MessageLite)req.build(), CLDBProto.RLimitResponse.class);
            if (data == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10009, "Couldn't connect to the CLDB service"));
                output.setOutput(out);
                return output;
            }
            CLDBProto.RLimitResponse resp = CLDBProto.RLimitResponse.parseFrom((byte[])data);
            int status = resp.getStatus();
            if (status != 0) {
                String errMsg = resp.hasErrMsg() ? resp.getErrMsg() : Errno.toString((int)status);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Setting rlimit for resource " + resourceType + " failed with error - " + errMsg));
                output.setOutput(out);
                return output;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new CLIProcessingException("InvalidProtocolBufferException Exception", (Throwable)e);
        }
        catch (MaprSecurityException e) {
            throw new CLIProcessingException("MaprSecurityException Exception", (Throwable)e);
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Error sending the RPC to set rlimit"));
            output.setOutput(out);
            return output;
        }
        output.setOutput(out);
        return output;
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        if (!super.validateInput()) {
            CommandOutput output = new CommandOutput();
            CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
            output.setOutput(out);
            return output;
        }
        String command = this.cliCommand.getCommandName();
        if (command.equalsIgnoreCase("get")) {
            return this.getRlimit();
        }
        if (command.equalsIgnoreCase("set")) {
            return this.setRlimit();
        }
        return new TextCommandOutput(("rlimit command failed: unknown command " + command + " received.").getBytes());
    }

    public String getCommandUsage() {
        return usageStr;
    }
}

