/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mapr.fs.cldb.proto.CLDBProto;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kong.unirest.Unirest;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.zeppelin.client.ClientConfig;
import org.apache.zeppelin.client.ParagraphResult;
import org.apache.zeppelin.client.ZeppelinClient;

public class ZeppManager {
    public static final String SPARK_MASTER_PROP = "spark.master";
    public final String SPARK_MASTER_PROP_VAL;
    public static final String SPARK_DEPLOY_MODE_PROP = "spark.submit.deployMode";
    public static final String SPARK_DEPLOY_MODE_PROP_VAL = "client";
    public static final String SPARK_JARS_PROP = "spark.jars";
    public static final String SPARK_JARS_PROP_VAL = "/opt/mapr/lib/iceberg-spark-runtime-3.5_2.13-1.7.0.jar";
    public static final String SPARK_VER_CHECK_PROP = "zeppelin.spark.enableSupportedVersionCheck";
    public static final String SPARK_VER_CHECK_PROP_VAL = "false";
    public static final String SPARK_SQL_HVECATALOG_PROP = "spark.sql.catalog.hve_catalog";
    public static final String SPARK_SQL_HVECATALOG_PROP_VAL = "org.apache.iceberg.spark.SparkCatalog";
    public static final String SPARK_SQL_HVECATALOG_TYPE_PROP = "spark.sql.catalog.hve_catalog.type";
    public static final String SPARK_SQL_HVECATALOG_TYPE_PROP_VAL = "hive";
    public static final String SPARK_SQL_HVECATALOG_URI_PROP = "spark.sql.catalog.hve_catalog.uri";
    public final String SPARK_SQL_HVECATALOG_URI_PROP_VAL;
    public static final String SPARK_CORES_MAX_PROP = "spark.cores.max";
    public static final String SPARK_CORES_MAX_PROP_VAL = "2";
    private String zeppUrl;
    private ClientConfig clientConfig;
    private ZeppelinClient zClient;
    private HttpClient httpClient;
    private String jsessionId;
    private ObjectMapper objMapper;
    private static final Logger LOG = Logger.getLogger(ZeppManager.class);

    public ZeppManager(String zeppMaster, String hmsMaster, String sparkMaster, int zeppelinPortVal) {
        String zeppelinPort = String.valueOf(zeppelinPortVal);
        this.zeppUrl = "https://" + zeppMaster + ":" + zeppelinPort;
        this.SPARK_MASTER_PROP_VAL = "spark://" + sparkMaster + ":7077";
        this.SPARK_SQL_HVECATALOG_URI_PROP_VAL = "thrift://" + hmsMaster + ":9083";
        this.clientConfig = new ClientConfig(this.zeppUrl);
        this.objMapper = new ObjectMapper();
    }

    public int setupSession(String sessionId, String username, String password) {
        Unirest.config().verifySsl(false);
        try {
            this.zClient = new ZeppelinClient(this.clientConfig);
            this.jsessionId = sessionId;
            if (this.jsessionId != null) {
                Unirest.config().setDefaultHeader("Cookie", "JSESSIONID=" + this.jsessionId);
            } else {
                this.zClient.login(username, password);
            }
            String zeppelinVersion = this.zClient.getVersion();
            LOG.info((Object)("Zeppelin version: " + zeppelinVersion));
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to connect to zeppelin: " + this.zeppUrl + " Exception: " + e.getMessage()));
            return -2;
        }
        this.httpClient = this.getHttpClient();
        JsonNode respNode = this.httpGetJson(this.zeppUrl + "/api/security/ticket");
        String status = respNode.path("status").asText();
        if (status.equalsIgnoreCase("OK")) {
            return 0;
        }
        return -1;
    }

    private CloseableHttpClient getHttpClient() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to setup SSL, exception: " + e));
        }
        CloseableHttpClient httpClient = null;
        httpClient = sslsf != null ? HttpClientBuilder.create().useSystemProperties().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build() : HttpClientBuilder.create().build();
        return httpClient;
    }

    private int deletePara(String noteId, String paraId) {
        String apiUrl = this.zeppUrl + "/api/notebook/" + noteId + "/paragraph/" + paraId;
        HttpDelete request = new HttpDelete(apiUrl);
        request.setHeader("Content-Type", "application/json");
        request.setHeader("Cookie", "JSESSIONID=" + this.jsessionId);
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to perform http para delete, url: " + apiUrl));
            return -1;
        }
        String responseString = null;
        try {
            responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonNode rootNode = this.objMapper.readTree(responseString);
            String statusStr = this.getStrVal(rootNode, "status");
            if (statusStr == null) {
                LOG.error((Object)("No status in para delete response: " + responseString));
                return -1;
            }
            if (statusStr.equalsIgnoreCase("ok")) {
                LOG.info((Object)"Got ok for para delete");
                return 0;
            }
            LOG.error((Object)("Para delete, para id: " + paraId + ", Got status: " + statusStr));
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to decode response, url: " + apiUrl));
            return -1;
        }
        return -1;
    }

    public ParagraphResult runPara(String nbPath, int dashQueryId) {
        LOG.info((Object)("Running para for nb: " + nbPath + ", queryId: " + dashQueryId));
        String noteId = this.getNoteId(nbPath);
        String paraId = this.getParaId(nbPath, dashQueryId);
        LOG.info((Object)("noteId: " + noteId + " paraId: " + paraId));
        if (noteId == null || paraId == null) {
            LOG.error((Object)"Unable to find notebook or para with given queryId");
            return null;
        }
        try {
            ParagraphResult res = this.zClient.executeParagraph(noteId, paraId);
            return res;
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to run para successfully");
            return null;
        }
    }

    private int updateGraphMode(String noteId, String paragraphId, String graphMode, int dashQueryId, String dashQueryDesc, int configVer) {
        String apiUrl = this.zeppUrl + "/api/notebook/" + noteId + "/paragraph/" + paragraphId + "/config";
        String jsonConfig = "{  \"colWidth\": 12.0,  \"results\" : {      \"0\" : {          \"graph\" : {            \"mode\" : \"" + graphMode + "\"          }      }  },  \"insightCfg\" : {       \"queryId\" : " + dashQueryId + ",       \"desc\" : \"" + dashQueryDesc + "\",       \"configVer\" : " + configVer + "    }}";
        LOG.debug((Object)("json cfg: " + jsonConfig));
        int putStatus = this.httpPut(apiUrl, jsonConfig);
        if (putStatus == 200) {
            LOG.info((Object)("Got ok for chart type update for Query ID : " + dashQueryId));
            return 0;
        }
        LOG.info((Object)("Failed to update chart type. Status: " + putStatus));
        return -1;
    }

    private String getEmbedUrl(String noteId, String paraId) {
        return this.zeppUrl + "/#/notebook/" + noteId + "/paragraph/" + paraId + "?asIframe";
    }

    private String getParaId(String notebookPath, int dashQueryId) {
        LOG.info((Object)("Getting paraId: nbPath: " + notebookPath + ", queryId: " + dashQueryId));
        String noteId = this.getNoteId(notebookPath);
        if (noteId == null) {
            LOG.error((Object)("Unable to find para for nbpath: " + notebookPath + ", queryId: " + dashQueryId));
            return null;
        }
        String apiUrl = this.zeppUrl + "/api/notebook/" + noteId;
        JsonNode rootNode = this.httpGetJson(apiUrl);
        if (rootNode == null) {
            LOG.error((Object)"Did not get json response to find notebook id");
            return null;
        }
        JsonNode paras = rootNode.at("/body/paragraphs");
        for (JsonNode para : paras) {
            String paraId = this.getStrVal(para, "id");
            if (paraId == null) {
                LOG.info((Object)"no para id");
                continue;
            }
            int queryId = -1;
            JsonNode insightCfg = para.path("config").path("insightCfg");
            if (insightCfg.isMissingNode()) {
                LOG.info((Object)"missing node");
                continue;
            }
            queryId = this.getIntVal(insightCfg, "queryId");
            if (queryId != dashQueryId) continue;
            LOG.info((Object)"matching queryid");
            return paraId;
        }
        return null;
    }

    private JsonNode httpGetJson(String apiUrl) {
        String responseString = this.httpGet(apiUrl);
        if (responseString == null) {
            LOG.error((Object)("Unable to access url: " + apiUrl));
            return null;
        }
        JsonNode rootNode = null;
        try {
            rootNode = this.objMapper.readTree(responseString);
        }
        catch (Exception e) {
            LOG.error((Object)("Response not json compliant: " + responseString));
            return null;
        }
        return rootNode;
    }

    private int httpPut(String apiUrl, String body) {
        HttpPut request = new HttpPut(apiUrl);
        request.setHeader("Content-Type", "application/json");
        request.setHeader("Cookie", "JSESSIONID=" + this.jsessionId);
        try {
            request.setEntity((HttpEntity)new StringEntity(body));
        }
        catch (Exception e) {
            LOG.error((Object)("Error while setting the request body for the PUT call. Exception: " + e.getMessage()));
            return -1;
        }
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception e) {
            LOG.error((Object)("Error while requesting server with PUT call. Exception: " + e.getMessage()));
            return -1;
        }
        return response.getStatusLine().getStatusCode();
    }

    public String getNoteId(String notebookPath) {
        String apiUrl = this.zeppUrl + "/api/notebook";
        JsonNode rootNode = this.httpGetJson(apiUrl);
        JsonNode nbs = rootNode.at("/body");
        String noteId = null;
        for (JsonNode nb : nbs) {
            String npath = this.getStrVal(nb, "path");
            if (npath == null || !npath.trim().equalsIgnoreCase(notebookPath)) continue;
            noteId = this.getStrVal(nb, "id");
            if (noteId == null) {
                noteId = "";
            }
            LOG.info((Object)("Got notebook id: " + noteId));
            return noteId;
        }
        if (noteId == null) {
            LOG.error((Object)"Notebook with given name not found");
        }
        return null;
    }

    private String httpGet(String apiUrl) {
        String responseString = null;
        try {
            HttpGet request = new HttpGet(apiUrl);
            request.setHeader("Content-Type", "application/json");
            request.setHeader("Cookie", "JSESSIONID=" + this.jsessionId);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            responseString = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to talk to zeppelin node: " + e));
        }
        return responseString;
    }

    private int getIntVal(JsonNode node, String key) {
        if (!node.has(key)) {
            return -1;
        }
        String valStr = node.get(key).asText();
        int retVal = -1;
        try {
            retVal = (int)Double.parseDouble(valStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    private String getStrVal(JsonNode node, String key) {
        JsonNode valNode = node.get(key);
        if (valNode == null) {
            return null;
        }
        return valNode.asText();
    }

    private List<ZeppPara> getParas(String noteId) {
        ArrayList<ZeppPara> retParas = new ArrayList<ZeppPara>();
        String apiUrl = this.zeppUrl + "/api/notebook/" + noteId;
        String responseString = this.httpGet(apiUrl);
        JsonNode rootNode = null;
        try {
            rootNode = this.objMapper.readTree(responseString);
        }
        catch (Exception e) {
            LOG.error((Object)("Response from zeppelin not json compliant: " + responseString));
            return null;
        }
        JsonNode paras = rootNode.at("/body/paragraphs");
        int queryId = -1;
        int configVer = -1;
        String queryDesc = "";
        for (JsonNode para : paras) {
            String paraId = this.getStrVal(para, "id");
            JsonNode insightCfg = para.path("config").path("insightCfg");
            if (!insightCfg.isMissingNode()) {
                queryId = this.getIntVal(insightCfg, "queryId");
                configVer = this.getIntVal(insightCfg, "configVer");
                queryDesc = this.getStrVal(insightCfg, "desc");
            }
            String title = this.getStrVal(para, "title");
            String embedUrl = this.getEmbedUrl(noteId, paraId);
            LOG.info((Object)("query id: " + queryId + ", configVer: " + configVer + ", title: " + title + ", para id: " + paraId));
            LOG.info((Object)("embed url: " + embedUrl));
            ZeppPara zp = new ZeppPara(noteId, paraId, queryId, configVer, title, embedUrl, queryDesc);
            retParas.add(zp);
        }
        return retParas;
    }

    public void listParas(String notebookPath) {
        LOG.info((Object)("Printing paras for notebook: " + notebookPath));
        String noteId = this.getNoteId(notebookPath);
        if (noteId == null) {
            LOG.error((Object)("Didn't find notebook for path: " + notebookPath));
            return;
        }
        this.getParas(noteId);
    }

    private ZeppPara getPara(List<ZeppPara> paras, int dashQueryId) {
        for (ZeppPara para : paras) {
            if (para.dashQueryId != dashQueryId) continue;
            return para;
        }
        return null;
    }

    private void populateQueries(CLDBProto.InsightDashboardQueryResponse resp, ArrayList<String> queryNames, ArrayList<String> queryDescs, ArrayList<String> sqlQueries, ArrayList<String> chartTypes, ArrayList<Integer> dashQueryIds, ArrayList<Integer> inpConfigVers, ArrayList<Boolean> enabledList) {
        for (CLDBProto.InsightDashboardQuery insightDashboardQuery : resp.getQueriesList()) {
            if (insightDashboardQuery.hasQueryName()) {
                queryNames.add(insightDashboardQuery.getQueryName());
            }
            if (insightDashboardQuery.hasQueryDesc()) {
                queryDescs.add(insightDashboardQuery.getQueryDesc());
            }
            if (insightDashboardQuery.hasSqlSummaryQuery()) {
                sqlQueries.add(insightDashboardQuery.getSqlSummaryQuery());
            }
            if (insightDashboardQuery.hasChartType()) {
                chartTypes.add(insightDashboardQuery.getChartType());
            }
            if (insightDashboardQuery.hasQueryId()) {
                dashQueryIds.add(insightDashboardQuery.getQueryId());
            }
            if (insightDashboardQuery.hasConfigVer()) {
                inpConfigVers.add(insightDashboardQuery.getConfigVer());
            }
            if (!insightDashboardQuery.hasEnabled()) continue;
            enabledList.add(insightDashboardQuery.getEnabled());
        }
    }

    public int configInterpreter() {
        String apiUrl = this.zeppUrl + "/api/interpreter/setting";
        String interpreterId = "";
        boolean updateRequired = false;
        JsonNode interpreterProps = null;
        JsonNode rootNode = this.httpGetJson(apiUrl);
        if (rootNode == null) {
            LOG.error((Object)"Error while fetching interprerter settings.");
            return -1;
        }
        JsonNode interpreters = rootNode.at("/body");
        for (JsonNode interpreter : interpreters) {
            ObjectNode sparkCoresMaxProp;
            ObjectNode sparkSqlHveCatalogUriProp;
            ObjectNode sparkSqlHveCatalogTypeProp;
            ObjectNode sparkSqlHveCatalogProp;
            ObjectNode sparkEnableVersionCheckProp;
            ObjectNode sparkJarsProp;
            ObjectNode sparkDeployProp;
            ObjectNode sparkMasterProp;
            if (!interpreter.get("name").asText().equalsIgnoreCase("spark")) continue;
            interpreterProps = interpreter;
            interpreterId = interpreter.get("id").asText();
            ObjectNode properties = (ObjectNode)interpreter.get("properties");
            if (properties.has(SPARK_MASTER_PROP)) {
                sparkMasterProp = (ObjectNode)properties.get(SPARK_MASTER_PROP);
                if (sparkMasterProp.has("value") && !sparkMasterProp.get("value").asText().equalsIgnoreCase(this.SPARK_MASTER_PROP_VAL)) {
                    sparkMasterProp.put("value", this.SPARK_MASTER_PROP_VAL);
                    updateRequired = true;
                }
            } else {
                sparkMasterProp = this.objMapper.createObjectNode();
                sparkMasterProp.put("name", SPARK_MASTER_PROP);
                sparkMasterProp.put("value", this.SPARK_MASTER_PROP_VAL);
                sparkMasterProp.put("type", "string");
                properties.set(SPARK_MASTER_PROP, (JsonNode)sparkMasterProp);
                updateRequired = true;
            }
            if (properties.has(SPARK_DEPLOY_MODE_PROP)) {
                sparkDeployProp = (ObjectNode)properties.get(SPARK_DEPLOY_MODE_PROP);
                if (sparkDeployProp.has("value") && !sparkDeployProp.get("value").asText().equalsIgnoreCase(SPARK_DEPLOY_MODE_PROP_VAL)) {
                    sparkDeployProp.put("value", SPARK_DEPLOY_MODE_PROP_VAL);
                    updateRequired = true;
                }
            } else {
                sparkDeployProp = this.objMapper.createObjectNode();
                sparkDeployProp.put("name", SPARK_DEPLOY_MODE_PROP);
                sparkDeployProp.put("value", SPARK_DEPLOY_MODE_PROP_VAL);
                sparkDeployProp.put("type", "string");
                properties.set(SPARK_DEPLOY_MODE_PROP, (JsonNode)sparkDeployProp);
                updateRequired = true;
            }
            if (properties.has(SPARK_JARS_PROP)) {
                sparkJarsProp = (ObjectNode)properties.get(SPARK_JARS_PROP);
                if (sparkJarsProp.has("value") && !sparkJarsProp.get("value").asText().equalsIgnoreCase(SPARK_JARS_PROP_VAL)) {
                    sparkJarsProp.put("value", SPARK_JARS_PROP_VAL);
                    updateRequired = true;
                }
            } else {
                sparkJarsProp = this.objMapper.createObjectNode();
                sparkJarsProp.put("name", SPARK_JARS_PROP);
                sparkJarsProp.put("value", SPARK_JARS_PROP_VAL);
                sparkJarsProp.put("type", "string");
                properties.set(SPARK_JARS_PROP, (JsonNode)sparkJarsProp);
                updateRequired = true;
            }
            if (properties.has(SPARK_VER_CHECK_PROP)) {
                sparkEnableVersionCheckProp = (ObjectNode)properties.get(SPARK_VER_CHECK_PROP);
                if (sparkEnableVersionCheckProp.has("value") && !sparkEnableVersionCheckProp.get("value").asText().equalsIgnoreCase(SPARK_VER_CHECK_PROP_VAL)) {
                    sparkEnableVersionCheckProp.put("value", SPARK_VER_CHECK_PROP_VAL);
                    updateRequired = true;
                }
            } else {
                sparkEnableVersionCheckProp = this.objMapper.createObjectNode();
                sparkEnableVersionCheckProp.put("name", SPARK_VER_CHECK_PROP);
                sparkEnableVersionCheckProp.put("value", SPARK_VER_CHECK_PROP_VAL);
                sparkEnableVersionCheckProp.put("type", "checkbox");
                properties.set(SPARK_VER_CHECK_PROP, (JsonNode)sparkEnableVersionCheckProp);
                updateRequired = true;
            }
            if (properties.has(SPARK_SQL_HVECATALOG_PROP)) {
                sparkSqlHveCatalogProp = (ObjectNode)properties.get(SPARK_SQL_HVECATALOG_PROP);
                if (sparkSqlHveCatalogProp.has("value") && !sparkSqlHveCatalogProp.get("value").asText().equalsIgnoreCase(SPARK_SQL_HVECATALOG_PROP_VAL)) {
                    sparkSqlHveCatalogProp.put("value", SPARK_SQL_HVECATALOG_PROP_VAL);
                    updateRequired = true;
                }
            } else {
                sparkSqlHveCatalogProp = this.objMapper.createObjectNode();
                sparkSqlHveCatalogProp.put("name", SPARK_SQL_HVECATALOG_PROP);
                sparkSqlHveCatalogProp.put("value", SPARK_SQL_HVECATALOG_PROP_VAL);
                sparkSqlHveCatalogProp.put("type", "textarea");
                properties.set(SPARK_SQL_HVECATALOG_PROP, (JsonNode)sparkSqlHveCatalogProp);
                updateRequired = true;
            }
            if (properties.has(SPARK_SQL_HVECATALOG_TYPE_PROP)) {
                sparkSqlHveCatalogTypeProp = (ObjectNode)properties.get(SPARK_SQL_HVECATALOG_TYPE_PROP);
                if (sparkSqlHveCatalogTypeProp.has("value") && !sparkSqlHveCatalogTypeProp.get("value").asText().equalsIgnoreCase(SPARK_SQL_HVECATALOG_TYPE_PROP_VAL)) {
                    sparkSqlHveCatalogTypeProp.put("value", SPARK_SQL_HVECATALOG_TYPE_PROP_VAL);
                    updateRequired = true;
                }
            } else {
                sparkSqlHveCatalogTypeProp = this.objMapper.createObjectNode();
                sparkSqlHveCatalogTypeProp.put("name", SPARK_SQL_HVECATALOG_TYPE_PROP);
                sparkSqlHveCatalogTypeProp.put("value", SPARK_SQL_HVECATALOG_TYPE_PROP_VAL);
                sparkSqlHveCatalogTypeProp.put("type", "textarea");
                properties.set(SPARK_SQL_HVECATALOG_TYPE_PROP, (JsonNode)sparkSqlHveCatalogTypeProp);
                updateRequired = true;
            }
            if (properties.has(SPARK_SQL_HVECATALOG_URI_PROP)) {
                sparkSqlHveCatalogUriProp = (ObjectNode)properties.get(SPARK_SQL_HVECATALOG_URI_PROP);
                if (sparkSqlHveCatalogUriProp.has("value") && !sparkSqlHveCatalogUriProp.get("value").asText().equalsIgnoreCase(this.SPARK_SQL_HVECATALOG_URI_PROP_VAL)) {
                    sparkSqlHveCatalogUriProp.put("value", this.SPARK_SQL_HVECATALOG_URI_PROP_VAL);
                    updateRequired = true;
                }
            } else {
                sparkSqlHveCatalogUriProp = this.objMapper.createObjectNode();
                sparkSqlHveCatalogUriProp.put("name", SPARK_SQL_HVECATALOG_URI_PROP);
                sparkSqlHveCatalogUriProp.put("value", this.SPARK_SQL_HVECATALOG_URI_PROP_VAL);
                sparkSqlHveCatalogUriProp.put("type", "textarea");
                properties.set(SPARK_SQL_HVECATALOG_URI_PROP, (JsonNode)sparkSqlHveCatalogUriProp);
                updateRequired = true;
            }
            if (properties.has(SPARK_CORES_MAX_PROP)) {
                sparkCoresMaxProp = (ObjectNode)properties.get(SPARK_CORES_MAX_PROP);
                if (!sparkCoresMaxProp.has("value") || sparkCoresMaxProp.get("value").asText().equalsIgnoreCase(SPARK_CORES_MAX_PROP_VAL)) break;
                sparkCoresMaxProp.put("value", SPARK_CORES_MAX_PROP_VAL);
                updateRequired = true;
                break;
            }
            sparkCoresMaxProp = this.objMapper.createObjectNode();
            sparkCoresMaxProp.put("name", SPARK_CORES_MAX_PROP);
            sparkCoresMaxProp.put("value", SPARK_CORES_MAX_PROP_VAL);
            sparkCoresMaxProp.put("type", "textarea");
            properties.set(SPARK_CORES_MAX_PROP, (JsonNode)sparkCoresMaxProp);
            updateRequired = true;
            break;
        }
        if (!updateRequired) {
            LOG.info((Object)"Interpreter already configured!");
            return 0;
        }
        String putApiUrl = apiUrl + "/" + interpreterId;
        String updatedConfig = "";
        try {
            updatedConfig = this.objMapper.writeValueAsString((Object)interpreterProps);
        }
        catch (Exception e) {
            LOG.error((Object)("Exception caught while updating request body for put call." + e.getMessage()));
            return -1;
        }
        int putStatus = this.httpPut(putApiUrl, updatedConfig);
        if (putStatus == 200) {
            LOG.info((Object)"Interpreter setting updated successfully!");
            return 0;
        }
        LOG.info((Object)("Failed to update interpreter. Status: " + putStatus));
        return -1;
    }

    public List<ZeppPara> configQueries(String notebookPath, CLDBProto.InsightDashboardQueryResponse resp) {
        CLDBProto.InsightDashboardQueryRequest.Builder req = CLDBProto.InsightDashboardQueryRequest.newBuilder();
        req.setOpType(CLDBProto.InsightDashboardOpType.QUERY_LIST);
        Object data = null;
        ArrayList<String> queryNames = new ArrayList<String>();
        ArrayList<String> queryDescs = new ArrayList<String>();
        ArrayList<String> sqlQueries = new ArrayList<String>();
        ArrayList<String> chartTypes = new ArrayList<String>();
        ArrayList<Integer> dashQueryIds = new ArrayList<Integer>();
        ArrayList<Integer> inpConfigVers = new ArrayList<Integer>();
        ArrayList<Boolean> enabledList = new ArrayList<Boolean>();
        this.populateQueries(resp, queryNames, queryDescs, sqlQueries, chartTypes, dashQueryIds, inpConfigVers, enabledList);
        int nQueries = sqlQueries.size();
        String noteId = this.getNoteId(notebookPath);
        if (noteId == null) {
            try {
                noteId = this.zClient.createNote(notebookPath);
                LOG.info((Object)("Created Note: " + noteId));
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to create notebook: " + notebookPath));
                return null;
            }
        } else {
            LOG.info((Object)("Notebook exists already, no need to create, noteId: " + noteId));
        }
        String paragraphId = "";
        String embedUrl = "";
        List<ZeppPara> currParas = this.getParas(noteId);
        ArrayList<ZeppPara> finalParas = new ArrayList<ZeppPara>();
        for (int i = 0; i < nQueries; ++i) {
            String sqlQuery = sqlQueries.get(i);
            int dashQueryId = dashQueryIds.get(i);
            String queryName = queryNames.get(i);
            String queryDesc = queryDescs.get(i);
            String chartType = chartTypes.get(i);
            int configVer = inpConfigVers.get(i);
            boolean enabled = enabledList.get(i);
            ZeppPara currPara = this.getPara(currParas, dashQueryId);
            boolean addPara = false;
            if (currPara != null) {
                if (currPara.configVer != configVer) {
                    this.deletePara(noteId, currPara.paraId);
                    LOG.info((Object)("Deleted old para for query: " + dashQueryId));
                    if (enabled) {
                        addPara = true;
                        LOG.info((Object)("Creating new para for query: " + dashQueryId));
                    }
                } else {
                    paragraphId = currPara.paraId;
                    embedUrl = currPara.embedUrl;
                    LOG.info((Object)("Para exists with matching config ver, nothing to do, queryId: " + dashQueryId + ", paraId: " + currPara.paraId));
                }
            } else if (enabled) {
                addPara = true;
                LOG.info((Object)("creating new para for query: " + dashQueryId));
            }
            if (addPara) {
                try {
                    paragraphId = this.zClient.addParagraph(noteId, queryName, "%sql " + sqlQuery);
                    LOG.info((Object)("QueryId: " + dashQueryId + ", name: " + queryName + ", paraId: " + paragraphId));
                    embedUrl = this.getEmbedUrl(noteId, paragraphId);
                    LOG.info((Object)("embedUrl: " + embedUrl));
                }
                catch (Exception e) {
                    LOG.error((Object)"Unable to add paragraph");
                    return null;
                }
                try {
                    this.updateGraphMode(noteId, paragraphId, chartType, dashQueryId, queryDesc, configVer);
                    ParagraphResult result = this.zClient.executeParagraph(noteId, paragraphId);
                    LOG.info((Object)("Para result: " + result));
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to set graph mode, dashqueryId: " + dashQueryId + ", paraId: " + paragraphId));
                    return null;
                }
            }
            ZeppPara finalPara = new ZeppPara(noteId, paragraphId, dashQueryId, configVer, queryName, embedUrl, queryDesc);
            finalParas.add(finalPara);
        }
        return finalParas;
    }

    public class ZeppPara {
        public String notebookId;
        public String paraId;
        public int dashQueryId;
        public int configVer;
        public String title;
        public String embedUrl;
        public String queryDesc;

        public ZeppPara(String notebookId, String paraId, int dashQueryId, int configVer, String title, String embedUrl, String queryDesc) {
            this.notebookId = notebookId;
            this.paraId = paraId;
            this.dashQueryId = dashQueryId;
            this.configVer = configVer;
            this.title = title;
            this.embedUrl = embedUrl;
            this.queryDesc = queryDesc;
        }
    }
}

