/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.MapRTabletScanner;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.MapRDBMetadataMgr;
import com.mapr.fs.tables.MetadataEntry;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class DbMetadataCommands
extends CLIBaseClass
implements CLIInterface {
    private static final Logger LOG = Logger.getLogger(DbMetadataCommands.class);
    private static final String PATH_PARAM_NAME = "path";
    private static final String TERSE_PARAM_NAME = "terse";
    private static final String VERBOSE_PARAM_NAME = "verbose";
    private static final String INCLUDE_ALL_PARAM_NAME = "includeall";
    public static final CLICommand listCommand = new CLICommand("list", "usage: table metadata list", DbMetadataCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"terse", (Object)new BooleanInputParameter("terse", "Prints only the table paths", false, null).setIsValueRequired(false)).put((Object)"verbose", (Object)new BooleanInputParameter("verbose", "Prints additional table properties", false, null).setIsValueRequired(false).setInvisible(true)).put((Object)"includeall", (Object)new BooleanInputParameter("includeall", "Prints all tables including which aren't accessible to the current user.", false, null).setIsValueRequired(false).setInvisible(true)).build(), null).setShortUsage("table metadata list");
    public static final CLICommand updateCommand = new CLICommand("update", "usage: table metadata update", DbMetadataCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "Root path to scan and update. default: '/'", false, null)).build(), null).setShortUsage("table metadata update");
    public static final CLICommand metadataCommands = new CLICommand("metadata", "metadata [list|update]", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{listCommand, updateCommand}).setShortUsage("table metadata [list|update]");
    private boolean terse;
    private boolean verbose;
    private boolean includeAll;

    public DbMetadataCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        this.terse = this.getBooleanParam(TERSE_PARAM_NAME, false);
        this.verbose = this.getBooleanParam(VERBOSE_PARAM_NAME, false);
        if (this.terse && this.verbose) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "'-terse' and '-verbose' can not be specified together."));
            return output;
        }
        this.includeAll = this.getBooleanParam(INCLUDE_ALL_PARAM_NAME, false);
        String commandName = this.cliCommand.getCommandName();
        String user = this.getUserLoginId();
        try {
            if (commandName.equalsIgnoreCase(listCommand.getCommandName())) {
                this.listMetadata(user, out);
            } else if (commandName.equalsIgnoreCase(updateCommand.getCommandName())) {
                this.updateMetadata(user, out);
            }
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        return output;
    }

    private void listMetadata(String user, final CommandOutput.OutputHierarchy out) throws Exception {
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                     MapRDBMetadataMgr metadataMgr = new MapRDBMetadataMgr(mfs);){
                    for (MetadataEntry entry : metadataMgr.getMetaDataEntries()) {
                        DbMetadataCommands.this.addTableEntry(mfs, entry, out);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
                }
            }
        };
    }

    private void addTableEntry(MapRFileSystem mfs, MetadataEntry entry, CommandOutput.OutputHierarchy out) {
        String tablePathStr = entry.getPath();
        try {
            Dbserver.TabletDesc nextTablet;
            Path tablePath = new Path(tablePathStr);
            MapRFileStatus fStatus = mfs.getMapRFileStatus(tablePath);
            if (!fStatus.isTable()) {
                LOG.warn((Object)("The path  " + tablePathStr + " is not a table. It will be skipped from the output"));
                return;
            }
            CommandOutput.OutputHierarchy.OutputNode tableNode = new CommandOutput.OutputHierarchy.OutputNode();
            tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(PATH_PARAM_NAME, (Object)tablePathStr));
            out.addNode(tableNode);
            if (this.terse) {
                return;
            }
            MapRTabletScanner tabletScanner = mfs.getTabletScanner(tablePath, null, true, true);
            int numRegions = 0;
            long physicalSize = 0L;
            long logicalSize = 0L;
            while ((nextTablet = tabletScanner.next()) != null) {
                Dbserver.TabletStatResponse tsr = mfs.getTabletStat(tablePath, nextTablet.getFid());
                if (tsr != null && tsr.hasUsage()) {
                    Dbserver.SpaceUsage su = tsr.getUsage();
                    long blockSize = 8192L;
                    physicalSize += su.getNumPhysicalBlocks() * blockSize;
                    logicalSize += su.getNumLogicalBlocks() * blockSize;
                }
                ++numRegions;
            }
            tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numregions", numRegions));
            tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totallogicalsize", logicalSize));
            tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalphysicalsize", physicalSize));
            tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("owner", (Object)fStatus.getOwner()));
            if (this.verbose) {
                tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)entry.getFid()));
                tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("isCommitted", (Object)entry.isCommitted()));
            }
        }
        catch (IOException e) {
            if (this.includeAll) {
                this.addEmptyNode(tablePathStr, out);
            }
            LOG.debug((Object)("Cannot access the path " + tablePathStr + ". It will be skipped from the output."), (Throwable)e);
        }
    }

    private void addEmptyNode(String tablePathStr, CommandOutput.OutputHierarchy out) {
        CommandOutput.OutputHierarchy.OutputNode tableNode = new CommandOutput.OutputHierarchy.OutputNode();
        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(PATH_PARAM_NAME, (Object)tablePathStr));
        out.addNode(tableNode);
        if (!this.terse) {
            tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("numregions", -1));
            tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totallogicalsize", -1));
            tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("totalphysicalsize", -1));
            tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("owner", (Object)"---"));
            if (this.verbose) {
                tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("fid", (Object)"---"));
                tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("isCommitted", (Object)"---"));
            }
        }
    }

    private void updateMetadata(String user, final CommandOutput.OutputHierarchy out) throws Exception {
        String path = this.isParamPresent(PATH_PARAM_NAME) ? this.getParamTextValue(PATH_PARAM_NAME, 0) : "/";
        final Path rootPath = new Path(path);
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws CLIProcessingException, IOException {
                try (MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                     MapRDBMetadataMgr metadataMgr = new MapRDBMetadataMgr(mfs);){
                    int numEntries = metadataMgr.update(rootPath);
                    out.addMessage(numEntries + " entries were added or updated in table metadata.");
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
                }
            }
        };
    }
}

