/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.cli;

import com.google.common.collect.ImmutableMap;
import com.mapr.baseutils.BinaryString;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.utils.AceHelper;
import com.mapr.cli.ChangeLogReplicaCommands;
import com.mapr.cli.ClusterCommands;
import com.mapr.cli.DbCfCommands;
import com.mapr.cli.DbIndexCommands;
import com.mapr.cli.DbRegionCommands;
import com.mapr.cli.DbReplicaCommands;
import com.mapr.cli.DbSecurityPolicyCommands;
import com.mapr.cli.DbUpstreamCommands;
import com.mapr.cli.MapRCliUtil;
import com.mapr.cli.common.FileclientRun;
import com.mapr.cli.common.JobExecutor;
import com.mapr.cli.common.NodesCommonUtils;
import com.mapr.cli.common.ServicesEnum;
import com.mapr.cli.table.RecentTablesListManager;
import com.mapr.cli.table.RecentTablesListManagers;
import com.mapr.cli.table.TabletStats;
import com.mapr.cliframework.base.CLIBaseClass;
import com.mapr.cliframework.base.CLICommand;
import com.mapr.cliframework.base.CLIInterface;
import com.mapr.cliframework.base.CLIProcessingException;
import com.mapr.cliframework.base.CLIUsageOnlyCommand;
import com.mapr.cliframework.base.CommandOutput;
import com.mapr.cliframework.base.ProcessedInput;
import com.mapr.cliframework.base.inputparams.BooleanInputParameter;
import com.mapr.cliframework.base.inputparams.IntegerInputParameter;
import com.mapr.cliframework.base.inputparams.LongInputParameter;
import com.mapr.cliframework.base.inputparams.TextInputParameter;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.mapreduce.tools.CopyTable;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.hbase.CopyMetaHelper;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.tables.TableProperties;
import com.mapr.fs.util.Fids;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;

public class DbCommands
extends CLIBaseClass
implements CLIInterface,
AceHelper.DBPermission {
    private static final Logger LOG = Logger.getLogger(DbCommands.class);
    public static final String COLUMNS_PARAM_NAME = "columns";
    public static final String OUTPUT_PARAM_NAME = "output";
    public static final String START_PARAM_NAME = "start";
    public static final String LIMIT_PARAM_NAME = "limit";
    private static final String PATH_PARAM_NAME = "path";
    private static final String INDEX_PARAM_NAME = "index";
    private static final String BULKLOAD_PARAM_NAME = "bulkload";
    private static final String WIRE_ENCRYPTION_FROM_POLICIES_PARAM_NAME = "wireencryptionfrompolicies";
    private static final String TABLE_TYPE_PARAM_NAME = "tabletype";
    private static final String TABLE_TYPE_DEF_BIN = "binary";
    private static final String TABLE_TYPE_JSON = "json";
    private static final String AUTOSPLIT_PARAM_NAME = "autosplit";
    private static final String MAX_VALUES_SIZE_IN_MEM_NAME = "maxvalueszinmemindex";
    private static final String REGION_SIZE_MB_NAME = "regionsizemb";
    private static final String RECLAIM_THRESH_PCNT_FOR_PACK_NAME = "reclaimthreshpcntforpack";
    private static final String SIZE_THRESH_PCNT_FOR_PACK_NAME = "sizethreshpcntforpack";
    private static final String MAX_SPILLS_PARAM_NAME = "maxspills";
    private static final String MINI_PACK_PARAM_NAME = "minipack";
    private static final String DELETE_TTL_PARAM_NAME = "deletettl";
    private static final String HAS_REPLICATION_PARAM_NAME = "hasreplication";
    private static final String HAS_INDEX_PARAM_NAME = "hasindex";
    private static final String SYNC_REPL_TIMEOUT_PARAMNAME = "syncrepltimeout";
    private static final String DROP_LARGE_ROWS_PARAM_NAME = "droplargerows";
    private static final String TTL_COMPACT_PARAM_NAME = "ttlcompact";
    private static final String TTL_COMPACT_HRS_PARAM_NAME = "ttlcompacthrs";
    private static final String COPY_META_FROM_PARAM_NAME = "copymetafrom";
    private static final String COPY_META_TYPE_PARAM_NAME = "copymetatype";
    private static final String MULTI_ARG_SEP = ",";
    private static final String PERM_PACK_PARAM_NAME = "packperm";
    private static final String PERM_BULKLOAD_PARAM_NAME = "bulkloadperm";
    private static final String PERM_SPLITMERGE_PARAM_NAME = "splitmergeperm";
    private static final String PERM_CREATERENAMEFAMILY_PARAM_NAME = "createrenamefamilyperm";
    private static final String PERM_DELETEFAMILY_PARAM_NAME = "deletefamilyperm";
    private static final String PERM_ACEADMINACCESS_PARAM_NAME = "adminaccessperm";
    private static final String PERM_REPL_PARAM_NAME = "replperm";
    private static final String PERM_INDEX_PARAM_NAME = "indexperm";
    private static final String PERM_VERSIONS_PARAM_NAME = "defaultversionperm";
    private static final String PERM_COMPRESSION_PARAM_NAME = "defaultcompressionperm";
    private static final String PERM_MEMORY_PARAM_NAME = "defaultmemoryperm";
    private static final String PERM_WRITE_PARAM_NAME = "defaultwriteperm";
    private static final String PERM_TRAVERSE_PARAM_NAME = "defaulttraverseperm";
    private static final String PERM_APPEND_PARAM_NAME = "defaultappendperm";
    private static final String PERM_READ_PARAM_NAME = "defaultreadperm";
    private static final String PERM_UNMASKED_READ_PARAM_NAME = "defaultunmaskedreadperm";
    private static final String PERM_ENCRYPT_PARAM_NAME = "defaultencryptperm";
    private static final String SOURCE_TABLE_NAME = "src";
    private static final String DESTINATION_TABLE_NAME = "dst";
    private static final String REPLICA_PARAM_NAME = "replica";
    private static final String USER_PARAM_NAME = "user";
    private static final String MAX_VER_PARAM_NAME = "maxversions";
    private static final String START_TIME_PARAM_NAME = "starttime";
    private static final String END_TIME_PARAM_NAME = "endtime";
    private static final String USE_MR_PARAM_NAME = "mapreduce";
    private static final String AUDIT_PARAM_NAME = "audit";
    private static final String SECURITY_POLICY_PARAM_NAME = "securitypolicy";
    private static final String METRICS_INTERVAL_PARAM_NAME = "metricsinterval";
    private static final String SPLIT_KEYS_PARAM_NAME = "splitkeys";
    private static final String SYNC_PUT_PARAM_NAME = "syncput";
    private static final String USE_META_CONTAINER_PARAM_NAME = "usemetacontainers";
    private int metaTypeMask = 0;
    private List<String> securityPolicyTagList = new ArrayList<String>();
    private TableProperties tableProp;
    private static final TableProperties indexProp = new TableProperties(Dbserver.TableAttr.newBuilder().setJson(true).build(), Dbserver.TableAces.newBuilder().build(), null, false);
    private static final CLICommand createCommand = new CLICommand("create", "usage: table create -path <path>", DbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"copymetafrom", (Object)new TextInputParameter("copymetafrom", "SrcTablePath", false, null)).put((Object)"copymetatype", (Object)new TextInputParameter("copymetatype", "all|cfs|aces|splits|attrs", false, null)).put((Object)"regionsizemb", (Object)new LongInputParameter("regionsizemb", "Region Size in MB", false, null)).put((Object)"autosplit", (Object)new BooleanInputParameter("autosplit", "Auto Split table", false, null)).put((Object)"bulkload", (Object)new BooleanInputParameter("bulkload", "Bulk load", false, null)).put((Object)"audit", (Object)new TextInputParameter("audit", "Enable Audit", false, null)).put((Object)"tabletype", (Object)new TextInputParameter("tabletype", "Table Type - json or binary. default: binary", false, null)).put((Object)"packperm", (Object)new TextInputParameter("packperm", "Pack Permission settings", false, null)).put((Object)"bulkloadperm", (Object)new TextInputParameter("bulkloadperm", "Bulk load Permission settings", false, null)).put((Object)"splitmergeperm", (Object)new TextInputParameter("splitmergeperm", "Split and Merge Permission settings", false, null)).put((Object)"createrenamefamilyperm", (Object)new TextInputParameter("createrenamefamilyperm", "Add/Rename Family Permission settings", false, null)).put((Object)"deletefamilyperm", (Object)new TextInputParameter("deletefamilyperm", "Delete Family Permission settings", false, null)).put((Object)"adminaccessperm", (Object)new TextInputParameter("adminaccessperm", "Ace Admin Permission settings", false, null)).put((Object)"replperm", (Object)new TextInputParameter("replperm", "Replication Admin Permission settings", false, null)).put((Object)"indexperm", (Object)new TextInputParameter("indexperm", "Secondary Index Admin Permission settings", false, null)).put((Object)"defaultversionperm", (Object)new TextInputParameter("defaultversionperm", "CF Versions Default Permission for binary tabletype", false, null)).put((Object)"defaultcompressionperm", (Object)new TextInputParameter("defaultcompressionperm", "CF Compression Default Permission", false, null)).put((Object)"defaultmemoryperm", (Object)new TextInputParameter("defaultmemoryperm", "CF Memory Default Permission", false, null)).put((Object)"defaultreadperm", (Object)new TextInputParameter("defaultreadperm", "CF Read Default Permission", false, null)).put((Object)"defaultunmaskedreadperm", (Object)new TextInputParameter("defaultunmaskedreadperm", "CF Unmasked Read Default Permission", false, null)).put((Object)"defaultwriteperm", (Object)new TextInputParameter("defaultwriteperm", "CF Write Default Permission", false, null)).put((Object)"defaulttraverseperm", (Object)new TextInputParameter("defaulttraverseperm", "CF Traverse Default Permission for json tabletype", false, null)).put((Object)"defaultappendperm", (Object)new TextInputParameter("defaultappendperm", "CF Append Default Permission for binary tabletype", false, null)).put((Object)"defaultencryptperm", (Object)new TextInputParameter("defaultencryptperm", "CF Encrypt Default Permission", false, null).setInvisible(true)).put((Object)"droplargerows", (Object)new BooleanInputParameter("droplargerows", "Drop large rows in table", false, null).setInvisible(true)).put((Object)"ttlcompact", (Object)new BooleanInputParameter("ttlcompact", "Enable TTL-based compactions", false, null).setInvisible(true)).put((Object)"ttlcompacthrs", (Object)new IntegerInputParameter("ttlcompacthrs", "Minimum hours between TTL compactions", false, null).setInvisible(true)).put((Object)"metricsinterval", (Object)new IntegerInputParameter("metricsinterval", "Metrics collection interval, in seconds", false, null)).put((Object)"securitypolicy", (Object)new TextInputParameter("securitypolicy", "Security policy tags", false, null)).put((Object)"splitkeys", (Object)new TextInputParameter("splitkeys", "Tablet split points", false, null).setInvisible(true)).put((Object)"syncput", (Object)new BooleanInputParameter("syncput", "sync put attr", false, null).setInvisible(true)).put((Object)"usemetacontainers", (Object)new BooleanInputParameter("usemetacontainers", "use meta container", false, null).setInvisible(true)).build(), null).setShortUsage("table create -path <path>");
    private static final CLICommand editCommand = new CLICommand("edit", "usage: table edit -path <path>", DbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).put((Object)"autosplit", (Object)new BooleanInputParameter("autosplit", "Auto Split table", false, null)).put((Object)"maxvalueszinmemindex", (Object)new IntegerInputParameter("maxvalueszinmemindex", "Max Values Size in Memory", false, null).setInvisible(true)).put((Object)"regionsizemb", (Object)new LongInputParameter("regionsizemb", "Region Size in MB", false, null)).put((Object)"bulkload", (Object)new BooleanInputParameter("bulkload", "Bulk load", false, null)).put((Object)"audit", (Object)new BooleanInputParameter("audit", "Enable Audit", false, null)).put((Object)"reclaimthreshpcntforpack", (Object)new IntegerInputParameter("reclaimthreshpcntforpack", "Space reclaim percentage threshold to pack", false, null).setInvisible(true)).put((Object)"sizethreshpcntforpack", (Object)new IntegerInputParameter("sizethreshpcntforpack", "Size percentage threshold to pack", false, null).setInvisible(true)).put((Object)"maxspills", (Object)new IntegerInputParameter("maxspills", "Max Spills", false, null).setInvisible(true)).put((Object)"minipack", (Object)new BooleanInputParameter("minipack", "Mini Pack", false, null).setInvisible(true)).put((Object)"deletettl", (Object)new LongInputParameter("deletettl", "delete TTL in secs", false, null)).put((Object)"hasreplication", (Object)new BooleanInputParameter("hasreplication", "Table has replicaton with other tables", false, null).setInvisible(true)).put((Object)"hasindex", (Object)new BooleanInputParameter("hasindex", "Table has secondary index", false, null).setInvisible(true)).put((Object)"syncrepltimeout", (Object)new LongInputParameter("syncrepltimeout", "sync replica timeout in milli secs", false, null).setInvisible(true)).put((Object)"packperm", (Object)new TextInputParameter("packperm", "Pack Permission settings", false, null)).put((Object)"bulkloadperm", (Object)new TextInputParameter("bulkloadperm", "Bulk load Permission settings", false, null)).put((Object)"splitmergeperm", (Object)new TextInputParameter("splitmergeperm", "Split and Merge Permission settings", false, null)).put((Object)"createrenamefamilyperm", (Object)new TextInputParameter("createrenamefamilyperm", "Add/Rename Family Permission settings", false, null)).put((Object)"deletefamilyperm", (Object)new TextInputParameter("deletefamilyperm", "Delete Family Permission settings", false, null)).put((Object)"adminaccessperm", (Object)new TextInputParameter("adminaccessperm", "Ace Admin Permission settings", false, null)).put((Object)"replperm", (Object)new TextInputParameter("replperm", "Replication Admin Permission settings", false, null)).put((Object)"indexperm", (Object)new TextInputParameter("indexperm", "Secondary Index Admin Permission settings", false, null)).put((Object)"defaultversionperm", (Object)new TextInputParameter("defaultversionperm", "CF Versions Default Permission for binary tabletype", false, null)).put((Object)"defaultcompressionperm", (Object)new TextInputParameter("defaultcompressionperm", "CF Compression Default Permission", false, null)).put((Object)"defaultmemoryperm", (Object)new TextInputParameter("defaultmemoryperm", "CF Memory Default Permission", false, null)).put((Object)"defaultreadperm", (Object)new TextInputParameter("defaultreadperm", "CF Read Default Permission", false, null)).put((Object)"defaultunmaskedreadperm", (Object)new TextInputParameter("defaultunmaskedreadperm", "CF Unmasked Read Default Permission", false, null)).put((Object)"defaultwriteperm", (Object)new TextInputParameter("defaultwriteperm", "CF Write Default Permission", false, null)).put((Object)"defaulttraverseperm", (Object)new TextInputParameter("defaulttraverseperm", "CF Traverse Default Permission for json tabletype", false, null)).put((Object)"defaultappendperm", (Object)new TextInputParameter("defaultappendperm", "CF Append Default Permission for binary tabletype", false, null)).put((Object)"defaultencryptperm", (Object)new TextInputParameter("defaultencryptperm", "CF Encrypt Default Permission", false, null).setInvisible(true)).put((Object)"droplargerows", (Object)new BooleanInputParameter("droplargerows", "Drop large rows in table", false, null).setInvisible(true)).put((Object)"ttlcompact", (Object)new BooleanInputParameter("ttlcompact", "Enable TTL-based compactions", false, null).setInvisible(true)).put((Object)"ttlcompacthrs", (Object)new IntegerInputParameter("ttlcompacthrs", "Minimum hours between TTL compactions", false, null).setInvisible(true)).put((Object)"metricsinterval", (Object)new IntegerInputParameter("metricsinterval", "Metrics collection interval, in seconds", false, null)).put((Object)"securitypolicy", (Object)new TextInputParameter("securitypolicy", "Security policy tags", false, null).setInvisible(true)).build(), null).setShortUsage("table edit -path <path>");
    private static final CLICommand deleteCommand = new CLICommand("delete", "usage: table delete -path <path>", DbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).build(), null).setShortUsage("table delete -path <path>");
    private static final CLICommand genUuidCommand = new CLICommand("genuuid", "usage: table genuuid -path <path>", DbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "path", true, null)).build(), null).setShortUsage("table genuuid -path <path>").setUsageInVisible(true);
    private static final CLICommand listRecentCommand = new CLICommand("listrecent", "usage: table listrecent -columns <columns> -start <start> -limit <limit>", DbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", false, null).setInvisible(true)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).put((Object)"start", (Object)new IntegerInputParameter("start", "start", false, Integer.valueOf(0)).setInvisible(true)).put((Object)"limit", (Object)new IntegerInputParameter("limit", "limit", false, Integer.valueOf(Integer.MAX_VALUE)).setInvisible(true)).build(), null).setShortUsage("table listrecent -columns <columns> -start <start> -limit <limit>").setUsageInVisible(true);
    private static final CLICommand infoCommand = new CLICommand("info", "usage: table info -path <path> -columns <columns>", DbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"path", (Object)new TextInputParameter("path", "table path", true, null)).put((Object)"index", (Object)new TextInputParameter("index", "index name", false, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "columns", false, "all").setInvisible(true)).put((Object)"output", (Object)new TextInputParameter("output", "verbose|terse", false, "verbose").setInvisible(true)).build(), null).setShortUsage("table info -path <path> -columns <columns>");
    private static final CLICommand copyCommand = new CLICommand("copy", "usage: table copy -src <path> -dst <path> -columns <cf1[:col1],cf2,...> -maxversions <num> -starttime <start> -endtime <end>", DbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"src", (Object)new TextInputParameter("src", "sourcetable", true, null)).put((Object)"dst", (Object)new TextInputParameter("dst", "destinationTable", true, null)).put((Object)"columns", (Object)new TextInputParameter("columns", "comma separated list of <family>[:<column>]", false, null)).put((Object)"maxversions", (Object)new IntegerInputParameter("maxversions", "max versions to copy", false, null)).put((Object)"starttime", (Object)new LongInputParameter("starttime", "only copy columns from starttime (inclusive)", false, null)).put((Object)"endtime", (Object)new LongInputParameter("endtime", "only copy columns until endtime (exclusive)", false, null)).put((Object)"mapreduce", (Object)new BooleanInputParameter("mapreduce", "enable (if resources required to run MapReduce are available) or disable use of MapReduce", false, Boolean.valueOf(true))).put((Object)"bulkload", (Object)new BooleanInputParameter("bulkload", "enable or disable use of BulkLoad with MapReduce is used", false, Boolean.valueOf(true))).put((Object)"tabletype", (Object)new TextInputParameter("tabletype", "Table Type - json or binary. default: binary", false, null)).put((Object)"user", (Object)new TextInputParameter("user", "user", false, null)).build(), null).setUsageInVisible(true).setShortUsage("table copy -sourceTable <path> -destinationTable <path>");
    private static final CLICommand copyStatusCommand = new CLICommand("copystatus", "usage: table copystatus -srctable <path> -dsttable <path>", DbCommands.class, CLICommand.ExecutionTypeEnum.NATIVE, (Map)new ImmutableMap.Builder().put((Object)"src", (Object)new TextInputParameter("src", "sourcetable", true, null)).put((Object)"dst", (Object)new TextInputParameter("dst", "destinationTable", true, null)).build(), null).setUsageInVisible(true).setShortUsage("table copystatus -sourceTable <path> -destinationTable <path>");
    public static final CLICommand tableCommands = new CLICommand("table", "table", CLIUsageOnlyCommand.class, CLICommand.ExecutionTypeEnum.NATIVE, new CLICommand[]{createCommand, editCommand, deleteCommand, genUuidCommand, listRecentCommand, infoCommand, copyCommand, copyStatusCommand, DbCfCommands.cfCommands, DbRegionCommands.regionCommands, DbReplicaCommands.replicaCommands, DbUpstreamCommands.upstreamCommands, DbIndexCommands.indexCommands, ChangeLogReplicaCommands.replicaCommands, DbSecurityPolicyCommands.DbSecurityPolicyCommands}).setShortUsage("table [create|edit|delete|listrecent|info|cf|region|replica|upstream|index|changelog|securitypolicy]");
    private static final Map<String, String> verboseToTerseMap = new ImmutableMap.Builder().put((Object)"path", (Object)"p").put((Object)"autosplit", (Object)"as").put((Object)"bulkload", (Object)"bl").put((Object)"tabletype", (Object)"tt").put((Object)"maxvalueszinmemindex", (Object)"mvmi").put((Object)"regionsizemb", (Object)"rsmb").put((Object)"reclaimthreshpcntforpack", (Object)"rtfp").put((Object)"droplargerows", (Object)"dlr").put((Object)"ttlcompact", (Object)"ttlc").put((Object)"ttlcompacthrs", (Object)"ttlhrs").put((Object)"packperm", (Object)"ppack").put((Object)"bulkloadperm", (Object)"blperm").put((Object)"adminaccessperm", (Object)"aaperm").put((Object)"replperm", (Object)"rperm").put((Object)"indexperm", (Object)"siperm").put((Object)"splitmergeperm", (Object)"smperm").put((Object)"createrenamefamilyperm", (Object)"crfperm").put((Object)"deletefamilyperm", (Object)"dfperm").put((Object)"defaultversionperm", (Object)"pver").put((Object)"defaultcompressionperm", (Object)"pcomp").put((Object)"defaultmemoryperm", (Object)"pmem").put((Object)"defaultreadperm", (Object)"pread").put((Object)"defaultunmaskedreadperm", (Object)"punmasked").put((Object)"defaultwriteperm", (Object)"pwrite").put((Object)"defaultencryptperm", (Object)"pencrypt").put((Object)"defaultappendperm", (Object)"pappend").put((Object)"totalrows", (Object)"tr").put((Object)"totalphysicalsize", (Object)"tps").put((Object)"totallogicalsize", (Object)"tls").put((Object)"totalcopypendingsize", (Object)"tcps").put((Object)"totalnumberofspills", (Object)"tsp").put((Object)"totalnumberofsegments", (Object)"tsg").put((Object)"securitypolicy", (Object)"sp").put((Object)"wireencryptionfrompolicies", (Object)"wirep").build();
    public static final Dbserver.ColumnFamilyAttr JSON_DEFAULT_COL_FAM_ATTR;

    public DbCommands(ProcessedInput input, CLICommand cliCommand) {
        super(input, cliCommand);
    }

    public CommandOutput executeRealCommand() throws CLIProcessingException {
        CommandOutput.OutputHierarchy out = new CommandOutput.OutputHierarchy();
        CommandOutput output = new CommandOutput();
        output.setOutput(out);
        if (!super.validateInput()) {
            return output;
        }
        if (this.cliCommand.getCommandName().equalsIgnoreCase(createCommand.getCommandName())) {
            this.createTable(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(editCommand.getCommandName())) {
            this.editTable(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(deleteCommand.getCommandName())) {
            this.deleteTable(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(genUuidCommand.getCommandName())) {
            this.genTableUuid(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(listRecentCommand.getCommandName())) {
            this.listRecentTables(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(infoCommand.getCommandName())) {
            this.tableInfo(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(copyCommand.getCommandName())) {
            this.copyTable(out);
        } else if (this.cliCommand.getCommandName().equalsIgnoreCase(copyStatusCommand.getCommandName())) {
            this.copyTableStatus(out);
        }
        return output;
    }

    private void createTable(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            String srcPath;
            int auditValue = -1;
            if (this.isParamPresent(AUDIT_PARAM_NAME)) {
                String auditStr = this.getParamTextValue(AUDIT_PARAM_NAME, 0);
                if (auditStr.equals("true") || auditStr.equals("1")) {
                    auditValue = 1;
                } else if (auditStr.equals("false") || auditStr.equals("0")) {
                    auditValue = 0;
                } else if (!auditStr.equals(" ")) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "audit value can only be true/false"));
                    return;
                }
            }
            String path = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
            Boolean autosplit = null;
            Boolean bulkload = null;
            Boolean droplarge = null;
            Boolean ttlcompact = null;
            Boolean isJson = null;
            Integer ttlcompacthrs = null;
            Long regionsize = null;
            if (this.isParamPresent(AUTOSPLIT_PARAM_NAME)) {
                autosplit = this.getParamBooleanValue(AUTOSPLIT_PARAM_NAME, 0);
            }
            if (this.isParamPresent(BULKLOAD_PARAM_NAME)) {
                bulkload = this.getParamBooleanValue(BULKLOAD_PARAM_NAME, 0);
            }
            if (this.isParamPresent(TABLE_TYPE_PARAM_NAME)) {
                String tableType = this.getParamTextValue(TABLE_TYPE_PARAM_NAME, 0);
                if (!tableType.toLowerCase().equals(TABLE_TYPE_DEF_BIN) && !tableType.toLowerCase().equals(TABLE_TYPE_JSON)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Create table -> Path: " + path + " - table type cannot be " + tableType + ". Choose one of binary or json."));
                    return;
                }
                isJson = tableType.toLowerCase().equals(TABLE_TYPE_JSON);
            } else {
                isJson = false;
            }
            String splitKeys = null;
            List<String> splitPoints = null;
            if (this.isParamPresent(SPLIT_KEYS_PARAM_NAME) && (splitKeys = this.getParamTextValue(SPLIT_KEYS_PARAM_NAME, 0)) != null) {
                splitPoints = Arrays.asList(splitKeys.split(MULTI_ARG_SEP));
            }
            if (this.isParamPresent(REGION_SIZE_MB_NAME) && (regionsize = Long.valueOf(this.getParamLongValue(REGION_SIZE_MB_NAME, 0))) < 256L) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "attr regionsizemb value must be >= 256"));
                return;
            }
            if (this.isParamPresent(DROP_LARGE_ROWS_PARAM_NAME)) {
                droplarge = this.getParamBooleanValue(DROP_LARGE_ROWS_PARAM_NAME, 0);
            }
            if (this.isParamPresent(TTL_COMPACT_PARAM_NAME)) {
                ttlcompact = this.getParamBooleanValue(TTL_COMPACT_PARAM_NAME, 0);
            }
            if (this.isParamPresent(TTL_COMPACT_HRS_PARAM_NAME)) {
                if (!ttlcompact.booleanValue()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "attr ttlcompacthrs can only be set when ttlcompact is set to true"));
                    return;
                }
                ttlcompacthrs = this.getParamIntValue(TTL_COMPACT_HRS_PARAM_NAME, 0);
            }
            Integer metricsInterval = null;
            if (this.isParamPresent(METRICS_INTERVAL_PARAM_NAME) && Dbserver.TableMetricsInterval.valueOf((int)(metricsInterval = Integer.valueOf(this.getParamIntValue(METRICS_INTERVAL_PARAM_NAME, 0)))) == null) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "attr metricsinterval can only be 10, 60, 600 (seconds)"));
                return;
            }
            String string = srcPath = this.isParamPresent(COPY_META_FROM_PARAM_NAME) ? this.getParamTextValue(COPY_META_FROM_PARAM_NAME, 0) : null;
            if (this.isParamPresent(COPY_META_TYPE_PARAM_NAME)) {
                if (splitKeys != null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "copyMetaFrom cannot be specified along with splitKeys"));
                    return;
                }
                if (!this.isParamPresent(COPY_META_FROM_PARAM_NAME)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "copyMetaType provided without specifying copyMetaFrom"));
                    return;
                }
                String metaStr = this.getParamTextValue(COPY_META_TYPE_PARAM_NAME, 0);
                for (String metaType : metaStr.split(MULTI_ARG_SEP)) {
                    if (metaType.equals("all")) {
                        this.metaTypeMask = 15;
                        break;
                    }
                    if (metaType.equals("cfs")) {
                        this.metaTypeMask |= 1;
                        continue;
                    }
                    if (metaType.equals("attrs")) {
                        this.metaTypeMask |= 2;
                        continue;
                    }
                    if (metaType.equals("aces")) {
                        this.metaTypeMask |= 4;
                        continue;
                    }
                    if (metaType.equals("splits")) {
                        this.metaTypeMask |= 8;
                        continue;
                    }
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid MetaType specified " + metaType));
                    return;
                }
            } else {
                this.metaTypeMask = 15;
            }
            if (this.isParamPresent(SECURITY_POLICY_PARAM_NAME)) {
                String securityPolicyTags = this.getParamTextValue(SECURITY_POLICY_PARAM_NAME, 0);
                if (!this.validateAndAddSecurityPolicyTags(this.securityPolicyTagList, securityPolicyTags, false)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid security policy tag. Specify non-null comma-separated tags").setField(SECURITY_POLICY_PARAM_NAME));
                    return;
                }
                if (!isJson.booleanValue()) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Security policy tags are supported for JSON DB tables only").setField(SECURITY_POLICY_PARAM_NAME));
                    return;
                }
            }
            boolean syncPut = false;
            if (this.isParamPresent(SYNC_PUT_PARAM_NAME)) {
                syncPut = this.getParamBooleanValue(SYNC_PUT_PARAM_NAME, 0);
            }
            boolean isMeta = false;
            if (this.isParamPresent(USE_META_CONTAINER_PARAM_NAME)) {
                isMeta = this.getParamBooleanValue(USE_META_CONTAINER_PARAM_NAME, 0);
            }
            DbCommands.createTable(path, autosplit, bulkload, regionsize, droplarge, ttlcompact, ttlcompacthrs, this.getUserLoginId(), srcPath, this, this.metaTypeMask, null, auditValue, isJson, metricsInterval, this.securityPolicyTagList, splitPoints, syncPut, isMeta);
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static void createTable(String path, Boolean autoSplit, Boolean bulkLoad, Long regionSize, Boolean dropLarge, Boolean ttlCompact, Integer ttlCompactHrs, String user, String srcPath, AceHelper.DBPermission dbPerm, int metaTypeMask, List<String> cfList, int auditValue, Boolean isJson, Integer metricsInterval) throws IOException, CLIProcessingException {
        DbCommands.createTable(path, autoSplit, bulkLoad, regionSize, dropLarge, ttlCompact, ttlCompactHrs, user, srcPath, dbPerm, metaTypeMask, cfList, auditValue, isJson, metricsInterval, null, null, false, false);
    }

    public static void createTable(final String path, Boolean autoSplit, Boolean bulkLoad, Long regionSize, Boolean dropLarge, Boolean ttlCompact, Integer ttlCompactHrs, final String user, final String srcPath, final AceHelper.DBPermission dbPerm, final int metaTypeMask, final List<String> cfList, final int auditValue, final Boolean isJson, Integer metricsInterval, final List<String> securityPolicyTagList, final List<String> splitPoints, boolean syncPut, boolean isMeta) throws IOException, CLIProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Attempting to create table for user: " + user));
        }
        Dbserver.TableAttr.Builder attrBuilder = Dbserver.TableAttr.newBuilder();
        if (autoSplit != null) {
            attrBuilder.setAutoSplit(autoSplit.booleanValue());
        }
        if (bulkLoad != null) {
            attrBuilder.setBulkLoad(bulkLoad.booleanValue());
        }
        if (regionSize != null) {
            attrBuilder.setRegionSizeMB(regionSize.longValue());
        }
        if (dropLarge != null) {
            attrBuilder.setDropLargeRows(dropLarge.booleanValue());
        }
        if (ttlCompact != null) {
            attrBuilder.setTtlCompaction(ttlCompact.booleanValue());
            if (ttlCompactHrs != null) {
                attrBuilder.setTtlCompactionHrs(ttlCompactHrs.intValue());
            }
        }
        if (isJson != null) {
            attrBuilder.setJson(isJson.booleanValue());
        }
        if (metricsInterval != null) {
            attrBuilder.setMetricsInterval(Dbserver.TableMetricsInterval.valueOf((int)metricsInterval));
        }
        if (syncPut) {
            attrBuilder.setEnableSyncPut(syncPut);
        }
        if (isMeta) {
            attrBuilder.setIsMeta(isMeta);
        }
        final Dbserver.TableAttr attr = attrBuilder.build();
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws IOException, CLIProcessingException {
                if (srcPath != null) {
                    CopyMetaHelper.createTable((String)srcPath, (String)path, (int)metaTypeMask, (Dbserver.TableAttr)attr, (List)cfList);
                } else {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    byte[][] encodedSplitKeys = null;
                    if (splitPoints != null && splitPoints.size() > 0) {
                        encodedSplitKeys = new byte[splitPoints.size()][];
                        for (int i = 0; i < splitPoints.size(); ++i) {
                            encodedSplitKeys[i] = isJson != false ? IdCodec.encodeAsBytes((String)((String)splitPoints.get(i))) : Bytes.toBytesBinary((String)((String)splitPoints.get(i)));
                        }
                    }
                    mfs.createTable(new Path(path), user, attr, dbPerm, (byte[][])encodedSplitKeys, auditValue, securityPolicyTagList);
                    if (isJson.booleanValue()) {
                        mfs.createColumnFamily(new Path(path), Dbserver.DBInternalDefaults.getDefaultInstance().getJsonDefaultCFName(), JSON_DEFAULT_COL_FAM_ATTR, null);
                    }
                }
                RecentTablesListManagers.getRecentTablesListManagerForUser(user).add(path);
            }
        };
    }

    private void editTable(final CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            final String path = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
            Dbserver.TableAttr oldTableAttr = MapRCliUtil.getMapRFileSystem().getTableProperties(new Path(path)).getAttr();
            boolean isJson = oldTableAttr.getJson();
            final Dbserver.TableAttr.Builder builder = Dbserver.TableAttr.newBuilder();
            if (this.isParamPresent(AUTOSPLIT_PARAM_NAME)) {
                builder.setAutoSplit(this.getParamBooleanValue(AUTOSPLIT_PARAM_NAME, 0));
            }
            if (this.isParamPresent(BULKLOAD_PARAM_NAME)) {
                builder.setBulkLoad(this.getParamBooleanValue(BULKLOAD_PARAM_NAME, 0));
            }
            if (this.isParamPresent(TABLE_TYPE_PARAM_NAME)) {
                String tableType = this.getParamTextValue(TABLE_TYPE_PARAM_NAME, 0);
                if (!tableType.toLowerCase().equals(TABLE_TYPE_DEF_BIN) && !tableType.toLowerCase().equals(TABLE_TYPE_JSON)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, "Edit table -> Path: " + path + " - table type cannot be " + tableType + ". Choose one of binary or json."));
                    return;
                }
                isJson = tableType.toLowerCase().equals(TABLE_TYPE_JSON);
                builder.setJson(isJson);
            }
            if (this.isParamPresent(METRICS_INTERVAL_PARAM_NAME)) {
                int intervalSeconds = this.getParamIntValue(METRICS_INTERVAL_PARAM_NAME, 0);
                Dbserver.TableMetricsInterval interval = Dbserver.TableMetricsInterval.valueOf((int)intervalSeconds);
                if (interval == null) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "attr metricsinterval can be 10, 60, 600 (seconds)"));
                    return;
                }
                builder.setMetricsInterval(interval);
            }
            if (this.isParamPresent(MAX_VALUES_SIZE_IN_MEM_NAME)) {
                int maxval = this.getParamIntValue(MAX_VALUES_SIZE_IN_MEM_NAME, 0);
                if (maxval <= 0) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "attr maxvalueszinmemindex value must be >= 0"));
                    return;
                }
                builder.setMaxValueSzInMemIndex(maxval);
            }
            if (this.isParamPresent(REGION_SIZE_MB_NAME)) {
                long regionsize = this.getParamLongValue(REGION_SIZE_MB_NAME, 0);
                if (regionsize < 256L) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "attr regionsizemb value must be >= 256"));
                    return;
                }
                builder.setRegionSizeMB(regionsize);
            }
            if (this.isParamPresent(RECLAIM_THRESH_PCNT_FOR_PACK_NAME)) {
                int val = this.getParamIntValue(RECLAIM_THRESH_PCNT_FOR_PACK_NAME, 0);
                if (val < 0 || val > 100) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "attr reclaimthreshpcntforpack value must be >=0 and <= 100"));
                    return;
                }
                builder.setReclaimThreshPcntForPack(val);
            }
            if (this.isParamPresent(SIZE_THRESH_PCNT_FOR_PACK_NAME)) {
                int val = this.getParamIntValue(SIZE_THRESH_PCNT_FOR_PACK_NAME, 0);
                if (val != 0 && val <= 100) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "attr sizethreshpcntforpack value must be 0 or > 100"));
                    return;
                }
                builder.setSizeThreshPcntForPack(val);
            }
            if (this.isParamPresent(MAX_SPILLS_PARAM_NAME)) {
                int val = this.getParamIntValue(MAX_SPILLS_PARAM_NAME, 0);
                if (val != 0 && (val < 3 || val > 6)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "attr maxspills value must be >=3 and <=6"));
                    return;
                }
                builder.setMaxSpills(val);
            }
            if (this.isParamPresent(MINI_PACK_PARAM_NAME)) {
                builder.setMiniPack(this.getParamBooleanValue(MINI_PACK_PARAM_NAME, 0));
            }
            if (this.isParamPresent(DELETE_TTL_PARAM_NAME)) {
                builder.setDeleteTTL(this.getParamLongValue(DELETE_TTL_PARAM_NAME, 0));
            }
            if (this.isParamPresent(HAS_REPLICATION_PARAM_NAME)) {
                builder.setHasReplication(this.getParamBooleanValue(HAS_REPLICATION_PARAM_NAME, 0));
            }
            if (this.isParamPresent(HAS_INDEX_PARAM_NAME)) {
                builder.setHasSecondaryIndex(this.getParamBooleanValue(HAS_INDEX_PARAM_NAME, 0));
            }
            if (this.isParamPresent(SYNC_REPL_TIMEOUT_PARAMNAME)) {
                builder.setSyncReplTimeoutMillis(this.getParamLongValue(SYNC_REPL_TIMEOUT_PARAMNAME, 0));
            }
            if (this.isParamPresent(DROP_LARGE_ROWS_PARAM_NAME)) {
                builder.setDropLargeRows(this.getParamBooleanValue(DROP_LARGE_ROWS_PARAM_NAME, 0));
            }
            if (this.isParamPresent(TTL_COMPACT_PARAM_NAME)) {
                builder.setTtlCompaction(this.getParamBooleanValue(TTL_COMPACT_PARAM_NAME, 0));
            }
            if (this.isParamPresent(TTL_COMPACT_HRS_PARAM_NAME)) {
                builder.setTtlCompactionHrs(this.getParamIntValue(TTL_COMPACT_HRS_PARAM_NAME, 0));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Attempting to edit table for user: " + this.getUserLoginId()));
            }
            if (this.isParamPresent(SECURITY_POLICY_PARAM_NAME)) {
                String securityPolicyTags = this.getParamTextValue(SECURITY_POLICY_PARAM_NAME, 0);
                if (!this.validateAndAddSecurityPolicyTags(this.securityPolicyTagList, securityPolicyTags, true)) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Invalid security policy tag. Specify non-null comma-separated tags").setField(SECURITY_POLICY_PARAM_NAME));
                    return;
                }
                if (!isJson) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Security policy tags are supported for JSON DB tables only").setField(SECURITY_POLICY_PARAM_NAME));
                    return;
                }
            }
            final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
            final DbCommands self = this;
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    boolean needUuidGeneration = false;
                    if (DbCommands.this.isParamPresent(DbCommands.PERM_REPL_PARAM_NAME)) {
                        DbCommands.this.getTableProps(new Path(path));
                        if (DbCommands.this.tableProp.getUuid() == null || DbCommands.this.tableProp.getUuid().length == 0) {
                            needUuidGeneration = true;
                        }
                    }
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (DbCommands.this.isParamPresent(DbCommands.SECURITY_POLICY_PARAM_NAME)) {
                        if (DbCommands.this.securityPolicyTagList != null) {
                            mfs.modifyDbSecurityPolicy(new Path(path), self, DbCommands.this.securityPolicyTagList, Dbserver.SecurityPolicyOperation.SPOP_SET);
                        } else {
                            mfs.modifyDbSecurityPolicy(new Path(path), self, new ArrayList(), Dbserver.SecurityPolicyOperation.SPOP_SET);
                        }
                    }
                    Dbserver.TableAttr attr = builder.build();
                    mfs.modifyTableAttr(new Path(path), attr, self, needUuidGeneration);
                    manager.moveToTop(path);
                    if (!DbCommands.this.isParamPresent(DbCommands.AUDIT_PARAM_NAME)) {
                        return;
                    }
                    boolean audit = DbCommands.this.getParamBooleanValue(DbCommands.AUDIT_PARAM_NAME, 0);
                    int err = mfs.modifyAudit(new Path(path), audit);
                    if (err != 0) {
                        out.addError(new CommandOutput.OutputHierarchy.OutputError(err, "Failed to modify audit for table " + path));
                        return;
                    }
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void genTableUuid(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        String path = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        DbCommands dbPerm = this;
        try {
            DbCommands.genTableUuid(path, dbPerm, this.getUserLoginId());
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static void genTableUuid(final String tablePath, final AceHelper.DBPermission dbPerm, String user) throws CLIProcessingException, Exception {
        final RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(user);
        final Dbserver.TableAttr attr = Dbserver.TableAttr.newBuilder().build();
        new FileclientRun(user){

            @Override
            public void runAsProxyUser() throws IOException, CLIProcessingException {
                MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                mfs.modifyTableAttr(new Path(tablePath), attr, dbPerm, true);
                manager.moveToTop(tablePath);
            }
        };
    }

    private void deleteTable(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        final String path = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
        try {
            new FileclientRun(this.getUserLoginId()){

                @Override
                public void runAsProxyUser() throws IOException, CLIProcessingException {
                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                    if (mfs.getMapRFileStatus(new Path(path)).isTable()) {
                        boolean result;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Attempting to delete table from File System");
                        }
                        if (!(result = mfs.delete(new Path(path)))) {
                            throw new CLIProcessingException("Table delete failed for path: " + path);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Deleting table from recent table list");
                        }
                    } else {
                        throw new CLIProcessingException("Table delete failed. Path '" + path + "' is not a MapR table.");
                    }
                    RecentTablesListManagers.getRecentTablesListManagerForUser(DbCommands.this.getUserLoginId()).delete(path);
                }
            };
        }
        catch (CLIProcessingException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private void listRecentTables(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        block12: {
            RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
            boolean hasHomeDir = manager.hasHomeDir();
            if (LOG.isDebugEnabled() && hasHomeDir) {
                LOG.debug((Object)("Home Directory /user/" + this.getUserLoginId() + " found"));
            }
            if (this.isParamPresent(PATH_PARAM_NAME)) {
                String path = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
                try {
                    if (MapRCliUtil.getMapRFileSystem().getMapRFileStatus(new Path(path)).isTable()) {
                        CommandOutput.OutputHierarchy.OutputNode tableNode = new CommandOutput.OutputHierarchy.OutputNode();
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(PATH_PARAM_NAME), (Object)path));
                        out.addNode(tableNode);
                        break block12;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Deleting table from recent table list");
                    }
                    manager.delete(path);
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Table not found. Path: " + path));
                }
                catch (IOException e) {
                    out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
                }
            } else if (!hasHomeDir) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Home directory (/user/" + this.getUserLoginId() + ") is missing for this user. Please create it in order to cache the recent tables administered by this user."));
            } else {
                HashSet<String> recentPaths = new HashSet<String>();
                String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
                for (String path : manager.getListFromFile()) {
                    String recentPath = null;
                    String[] splitPaths = path.split("/");
                    if (path.startsWith("/mapr/") && splitPaths.length > 3 && path.split("/")[2].equals(currentClusterName)) {
                        String clusterPath = path.substring("/mapr/".length());
                        recentPath = clusterPath.substring(clusterPath.indexOf(47));
                    } else {
                        recentPath = path;
                    }
                    if (recentPaths.contains(recentPath)) continue;
                    CommandOutput.OutputHierarchy.OutputNode tableNode = new CommandOutput.OutputHierarchy.OutputNode();
                    tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(PATH_PARAM_NAME), (Object)recentPath));
                    out.addNode(tableNode);
                    recentPaths.add(recentPath);
                }
            }
        }
    }

    private void getTableProps(final Path tablePath) throws IOException, CLIProcessingException {
        new FileclientRun(this.getUserLoginId()){

            @Override
            public void runAsProxyUser() throws IOException, CLIProcessingException {
                MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                TableProperties tableProp = mfs.getTableProperties(tablePath);
                DbCommands.this.setTableProps(tableProp);
            }
        };
    }

    private void setTableProps(TableProperties tableProp) {
        this.tableProp = tableProp;
    }

    private boolean isJsonTable(String path) throws CLIProcessingException {
        try {
            return MapRCliUtil.getMapRFileSystem().getTableProperties(new Path(path)).getAttr().getJson();
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CLIProcessingException((Throwable)e);
        }
    }

    private void tableInfo(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        block48: {
            RecentTablesListManager manager = RecentTablesListManagers.getRecentTablesListManagerForUser(this.getUserLoginId());
            boolean hasHomeDir = manager.hasHomeDir();
            if (LOG.isDebugEnabled() && hasHomeDir) {
                LOG.debug((Object)("Home Directory /user/" + this.getUserLoginId() + " found"));
            }
            String path = DbCommands.getTransformedPath(this.getParamTextValue(PATH_PARAM_NAME, 0), this.getUserLoginId());
            boolean wantIndexInfo = this.isParamPresent(INDEX_PARAM_NAME);
            String indexName = wantIndexInfo ? this.getParamTextValue(INDEX_PARAM_NAME, 0) : null;
            String indexFid = null;
            final Path tablePath = new Path(path);
            TabletStats tabletStats = new TabletStats(path, this.getUserLoginId());
            try {
                if (MapRCliUtil.getMapRFileSystem().getMapRFileStatus(tablePath).isTable()) {
                    if (wantIndexInfo) {
                        boolean isJson = this.isJsonTable(path);
                        if (!isJson) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, tablePath + " is not a json table."));
                            return;
                        }
                        final ArrayList rlist = new ArrayList();
                        try {
                            new FileclientRun(this.getUserLoginId()){

                                @Override
                                public void runAsProxyUser() throws CLIProcessingException {
                                    MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                                    try {
                                        Dbserver.TableReplicaListResponse resp = mfs.listTableIndexes(tablePath, false, true, true);
                                        rlist.add(resp);
                                    }
                                    catch (IOException e) {
                                        throw new CLIProcessingException(e.getMessage());
                                    }
                                }
                            };
                        }
                        catch (CLIProcessingException e) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                            return;
                        }
                        catch (IOException e) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
                            return;
                        }
                        Dbserver.TableReplicaListResponse resp = (Dbserver.TableReplicaListResponse)rlist.get(0);
                        for (Dbserver.TableReplicaDesc rd : resp.getReplicasList()) {
                            Dbserver.SIndexInfo siInfo = rd.getSiInfo();
                            if (!siInfo.getIndexName().equals(indexName)) continue;
                            indexFid = Fids.fidToString((Common.FidMsg)siInfo.getIndexFid());
                            break;
                        }
                        if (indexFid == null) {
                            out.addError(new CommandOutput.OutputHierarchy.OutputError(22, tablePath + " does not have an index named '" + indexName + "'"));
                            return;
                        }
                        this.setTableProps(indexProp);
                    } else {
                        this.getTableProps(tablePath);
                    }
                    long physicalSize = 0L;
                    long logicalSize = 0L;
                    long numRows = 0L;
                    long remoteSize = 0L;
                    long numSpills = 0L;
                    long numSegments = 0L;
                    int numRegions = 0;
                    boolean numSegmentsValid = true;
                    boolean numSpillsValid = true;
                    boolean remoteSizeValid = true;
                    List<Dbserver.TabletDesc> tablets = tabletStats.getTablets(out, 0, Integer.MAX_VALUE, indexFid);
                    if (tablets == null) {
                        return;
                    }
                    numRegions += tablets.size();
                    for (Dbserver.TabletDesc tablet : tablets) {
                        try {
                            Dbserver.TabletStatResponse tsr = tabletStats.getTabletStatResponse(tablet);
                            if (tsr == null || !tsr.hasUsage()) continue;
                            Dbserver.SpaceUsage su = tsr.getUsage();
                            long blockSize = 8192L;
                            physicalSize += su.getNumPhysicalBlocks() * blockSize;
                            logicalSize += su.getNumLogicalBlocks() * blockSize;
                            numRows += su.getNumRows();
                            if (su.hasNumRemoteBlocks()) {
                                remoteSize += su.getNumRemoteBlocks() * blockSize;
                            } else {
                                remoteSizeValid = false;
                            }
                            if (su.hasNumSpills()) {
                                numSpills += su.getNumSpills();
                            } else {
                                numSpillsValid = false;
                            }
                            if (su.hasNumSegments()) {
                                numSegments += su.getNumSegments();
                                continue;
                            }
                            numSegmentsValid = false;
                        }
                        catch (Exception e) {
                            LOG.error((Object)("Error fetching tablet stats for fid: " + MapRCliUtil.getFidAsString(tablet.getFid())), (Throwable)e);
                        }
                    }
                    Dbserver.TableAttr attr = this.tableProp.getAttr();
                    Dbserver.TableAces aces = this.tableProp.getAces();
                    CommandOutput.OutputHierarchy.OutputNode tableNode = new CommandOutput.OutputHierarchy.OutputNode();
                    if (!wantIndexInfo) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(PATH_PARAM_NAME), (Object)path));
                    } else {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("primarytablepath"), (Object)path));
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("indexname"), (Object)indexName));
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("indexfid"), (Object)indexFid));
                    }
                    tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("numregions"), numRegions));
                    tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totallogicalsize"), logicalSize));
                    tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalphysicalsize"), physicalSize));
                    if (remoteSizeValid && !wantIndexInfo) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalcopypendingsize"), remoteSize));
                    }
                    tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalrows"), numRows));
                    if (numSpillsValid) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalnumberofspills"), numSpills));
                    }
                    if (numSegmentsValid) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("totalnumberofsegments"), numSegments));
                    }
                    if (!wantIndexInfo) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(AUTOSPLIT_PARAM_NAME), (Object)attr.getAutoSplit()));
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(BULKLOAD_PARAM_NAME), (Object)attr.getBulkLoad()));
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(WIRE_ENCRYPTION_FROM_POLICIES_PARAM_NAME), (Object)attr.getWireSecurityEnabledFromPolicies()));
                    }
                    String tblType = attr.getJson() ? TABLE_TYPE_JSON : TABLE_TYPE_DEF_BIN;
                    tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(TABLE_TYPE_PARAM_NAME), (Object)tblType));
                    if (!wantIndexInfo && tblType.equals(TABLE_TYPE_JSON)) {
                        ArrayList<String> securityPolicyTagsList = new ArrayList<String>();
                        if (attr.hasSecurityPolicyIdTags()) {
                            MapRFileSystem mfs = MapRCliUtil.getMapRFileSystem();
                            Dbserver.SecurityPolicyIds ids = attr.getSecurityPolicyIdTags();
                            for (int i = 0; i < ids.getIdsCount(); ++i) {
                                String securityPolicyTag = mfs.getSecurityPolicyNameOrId(ids.getIds(i));
                                securityPolicyTagsList.add(securityPolicyTag);
                            }
                        }
                        CommandOutput.OutputHierarchy.OutputNode tableSecurityPolicyTagsNode = new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(SECURITY_POLICY_PARAM_NAME), securityPolicyTagsList);
                        tableNode.addChild(tableSecurityPolicyTagsNode);
                    }
                    if (!wantIndexInfo) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(REGION_SIZE_MB_NAME), attr.getRegionSizeMB()));
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(AUDIT_PARAM_NAME), (Object)this.tableProp.getAuditEnabled()));
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(METRICS_INTERVAL_PARAM_NAME), attr.getMetricsInterval().getNumber()));
                    }
                    if (attr.hasMaxValueSzInMemIndex()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(MAX_VALUES_SIZE_IN_MEM_NAME), attr.getMaxValueSzInMemIndex()));
                    }
                    if (attr.hasReclaimThreshPcntForPack()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(RECLAIM_THRESH_PCNT_FOR_PACK_NAME), attr.getReclaimThreshPcntForPack()));
                    }
                    if (attr.hasSizeThreshPcntForPack()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(SIZE_THRESH_PCNT_FOR_PACK_NAME), attr.getSizeThreshPcntForPack()));
                    }
                    if (attr.hasMaxSpills()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(MAX_SPILLS_PARAM_NAME), attr.getMaxSpills()));
                    }
                    if (attr.hasMiniPack()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(MINI_PACK_PARAM_NAME), (Object)attr.getMiniPack()));
                    }
                    if (attr.hasDeleteTTL()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(DELETE_TTL_PARAM_NAME), attr.getDeleteTTL()));
                    }
                    if (attr.hasHasReplication()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(HAS_REPLICATION_PARAM_NAME), (Object)attr.getHasReplication()));
                    }
                    if (attr.hasHasSecondaryIndex()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(HAS_INDEX_PARAM_NAME), (Object)attr.getHasSecondaryIndex()));
                    }
                    if (attr.hasSyncReplTimeoutMillis()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(SYNC_REPL_TIMEOUT_PARAMNAME), attr.getSyncReplTimeoutMillis()));
                    }
                    if (attr.hasDropLargeRows()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(DROP_LARGE_ROWS_PARAM_NAME), (Object)attr.getDropLargeRows()));
                    }
                    if (attr.hasTtlCompaction()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(TTL_COMPACT_PARAM_NAME), (Object)attr.getTtlCompaction()));
                        if (attr.getTtlCompaction() && attr.hasTtlCompactionHrs()) {
                            tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName(TTL_COMPACT_HRS_PARAM_NAME), attr.getTtlCompactionHrs()));
                        }
                    }
                    for (Dbserver.AccessControlExpression ace : aces.getAcesList()) {
                        if (ace.getAccessType() == Dbserver.DBAccessType.Index && !attr.getJson()) continue;
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName((String)AceHelper.tblPermissionMap.get(ace.getAccessType())), (Object)AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8())));
                    }
                    for (Dbserver.AccessControlExpression ace : aces.getDefaultColumnFamilyAcesList()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName((String)AceHelper.cfDefPermissionMap.get(ace.getAccessType())), (Object)AceHelper.toInfix((String)ace.getBooleanExpression().toStringUtf8())));
                    }
                    byte[] uuid = this.tableProp.getUuid();
                    if (uuid != null && uuid.length != 0) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode(this.getOutputFieldName("uuid"), (Object)BinaryString.toUUIDString((byte[])uuid)));
                    }
                    if (attr.hasIsMarlinTable()) {
                        tableNode.addChild(new CommandOutput.OutputHierarchy.OutputNode("ismarlintable", (Object)attr.getIsMarlinTable()));
                    }
                    out.addNode(tableNode);
                    break block48;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Deleting table from recent table list");
                }
                manager.delete(path);
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, "Table not found. Path: " + path));
            }
            catch (IOException e) {
                out.addError(new CommandOutput.OutputHierarchy.OutputError(22, e.getMessage()));
            }
        }
    }

    private void copyTable(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Home Directory /user/" + this.getUserLoginId() + " found"));
            }
            String srcTable = DbCommands.getTransformedPath(this.getParamTextValue(SOURCE_TABLE_NAME, 0), this.getUserLoginId());
            String dstTable = DbCommands.getTransformedPath(this.getParamTextValue(DESTINATION_TABLE_NAME, 0), this.getUserLoginId());
            String colList = this.isParamPresent(COLUMNS_PARAM_NAME) ? this.getParamTextValue(COLUMNS_PARAM_NAME, 0) : null;
            String user = this.isParamPresent(USER_PARAM_NAME) ? this.getParamTextValue(USER_PARAM_NAME, 0) : this.getUserLoginId();
            int maxVersions = this.isParamPresent(MAX_VER_PARAM_NAME) ? this.getParamIntValue(MAX_VER_PARAM_NAME, 0) : Integer.MAX_VALUE;
            long startTime = this.isParamPresent(START_TIME_PARAM_NAME) ? this.getParamLongValue(START_TIME_PARAM_NAME, 0) : 0L;
            long endTime = this.isParamPresent(END_TIME_PARAM_NAME) ? this.getParamLongValue(END_TIME_PARAM_NAME, 0) : Long.MAX_VALUE;
            boolean useMR = this.getParamBooleanValue(USE_MR_PARAM_NAME, 0);
            boolean useBulkLoad = this.getParamBooleanValue(BULKLOAD_PARAM_NAME, 0);
            boolean isExternal = DbReplicaCommands.isExternalDestination(dstTable);
            this.getTableProps(new Path(srcTable));
            boolean isJson = this.tableProp.getAttr().getJson();
            if (isJson && (this.isParamPresent(MAX_VER_PARAM_NAME) || this.isParamPresent(START_TIME_PARAM_NAME) || this.isParamPresent(END_TIME_PARAM_NAME))) {
                throw new CLIProcessingException("CopyTable for JSON-DB tables does not support multiple versions.");
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add("-src");
            args.add(srcTable);
            args.add("-dst");
            args.add(dstTable);
            if (maxVersions < Integer.MAX_VALUE) {
                args.add("-maxversions");
                args.add(String.valueOf(maxVersions));
            }
            if (startTime > 0L) {
                args.add("-starttime");
                args.add(String.valueOf(startTime));
            }
            if (endTime < Long.MAX_VALUE) {
                args.add("-endtime");
                args.add(String.valueOf(endTime));
            }
            if (colList != null) {
                args.add("-columns");
                args.add(colList);
            }
            if (!isExternal) {
                args.add("-bulkload");
                args.add(String.valueOf(useBulkLoad));
            }
            String zkConnectString = CLDBRpcCommonUtils.getInstance().getZkConnect();
            LOG.info((Object)("Looking up ticket for user: " + user + " in location " + System.getenv("MAPR_TICKETFILE_LOCATION")));
            if (useMR && (NodesCommonUtils.isServiceAvailable(zkConnectString, ServicesEnum.jobtracker.name()) || NodesCommonUtils.isServiceAvailable(zkConnectString, ServicesEnum.resourcemanager.name()))) {
                ClusterCommands.VersionFileContents fileContents = ClusterCommands.readHadoopVersionFile();
                if (fileContents.default_mode.equalsIgnoreCase("yarn") && !NodesCommonUtils.isServiceAvailable(zkConnectString, ServicesEnum.resourcemanager.name())) {
                    throw new CLIProcessingException("Please check if map-reduce mode is yarn and RM is installed and running");
                }
                if (fileContents.default_mode.equalsIgnoreCase("classic") && !NodesCommonUtils.isServiceAvailable(zkConnectString, ServicesEnum.jobtracker.name())) {
                    throw new CLIProcessingException("Please check if map-reduce mode is classic and JT is installed and running");
                }
                boolean result = false;
                LOG.info((Object)("Calling copytable job for tables: " + srcTable + MULTI_ARG_SEP + dstTable + " by user: " + user));
                args.add("-mapreduce");
                args.add(String.valueOf(true));
                if (isExternal) {
                    DbReplicaCommands.verifyExternalDstSanity(dstTable);
                    result = DbCommands.copyTableExternal(args.toArray(new String[args.size()]), user, true, isJson);
                } else {
                    result = DbCommands.copyTable(args.toArray(new String[args.size()]), user, isJson);
                }
                if (!result) {
                    throw new CLIProcessingException("CopyTable job failed for tables: " + srcTable + " " + dstTable);
                }
                LOG.info((Object)("Finished copy table from table: " + srcTable + " to " + dstTable + " by user: " + user));
            } else {
                boolean result = false;
                LOG.info((Object)("Job tracker or Resource Manager not found. Running non-mapreduce copytable for tables: " + srcTable + MULTI_ARG_SEP + dstTable + " by user: " + user));
                args.add("-mapreduce");
                args.add(String.valueOf(false));
                if (isExternal) {
                    DbReplicaCommands.verifyExternalDstSanity(dstTable);
                    result = DbCommands.copyTableExternal(args.toArray(new String[args.size()]), user, false, isJson);
                } else {
                    result = DbCommands.copyTableNoMR(args.toArray(new String[args.size()]), user, isJson);
                }
                if (!result) {
                    throw new CLIProcessingException("Non-mapreduce copyTable job failed for tables: " + srcTable + " " + dstTable);
                }
                LOG.info((Object)("Finished non-mapreduce copy table from table: " + srcTable + " to " + dstTable + " by user: " + user));
            }
        }
        catch (IOException e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    public static boolean copyTable(String[] args, String user, boolean isJson) throws IOException, CLIProcessingException, Exception {
        if (!isJson) {
            return com.mapr.fs.hbase.tools.mapreduce.CopyTable.copy((String[])args, (String)user);
        }
        return CopyTable.copy((String[])args, (String)user);
    }

    private static boolean copyTableExternal(String[] args, String user, boolean useMR, boolean isJson) throws IOException, CLIProcessingException {
        String BINARY_COPYTABLE_NAME = "com.mapr.fs.gateway.external.tools.CopyTableExt";
        String JSON_COPYTABLE_NAME = "com.mapr.fs.gateway.external.tools.CopyTableJsonExt";
        String COPY_METHOD_NAME = "copy";
        String className = isJson ? "com.mapr.fs.gateway.external.tools.CopyTableJsonExt" : "com.mapr.fs.gateway.external.tools.CopyTableExt";
        boolean result = false;
        try {
            ClassLoader parentLoader = ClassLoader.getSystemClassLoader();
            Class<?> copyClass = parentLoader.loadClass(className);
            Class[] copyArgs = new Class[]{String[].class, String.class, Boolean.TYPE};
            Method copyMethod = copyClass.getDeclaredMethod("copy", copyArgs);
            result = (Boolean)copyMethod.invoke(null, args, user, useMR);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Could not find class " + className));
            throw new CLIProcessingException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)("Copy class " + className + " does not contain a copy method"));
            throw new CLIProcessingException(e.getMessage());
        }
        catch (Exception e) {
            throw new CLIProcessingException(e.getMessage());
        }
        return result;
    }

    public static boolean copyTableNoMR(String[] args, String user, boolean isJson) throws IOException, CLIProcessingException, Exception {
        if (!isJson) {
            return com.mapr.fs.hbase.tools.mapreduce.CopyTable.copy((String[])args, (String)user);
        }
        return CopyTable.copy((String[])args, (String)user);
    }

    private void copyTableStatus(CommandOutput.OutputHierarchy out) throws CLIProcessingException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Home Directory /user/" + this.getUserLoginId() + " found"));
            }
            String srcTable = DbCommands.getTransformedPath(this.getParamTextValue(SOURCE_TABLE_NAME, 0), this.getUserLoginId());
            String dstTable = DbCommands.getTransformedPath(this.getParamTextValue(DESTINATION_TABLE_NAME, 0), this.getUserLoginId());
            LOG.info((Object)("Retrieving the copy table status for tables: " + srcTable + MULTI_ARG_SEP + dstTable));
            if (JobExecutor.getStatus(srcTable + "_" + dstTable) != null) {
                LOG.info((Object)("Status: " + JobExecutor.getStatus(srcTable + "_" + dstTable)));
                out.addNode(new CommandOutput.OutputHierarchy.OutputNode("Status", (Object)JobExecutor.getStatus(srcTable + "_" + dstTable)));
            }
        }
        catch (Exception e) {
            out.addError(new CommandOutput.OutputHierarchy.OutputError(10003, e.getMessage()));
        }
    }

    private String getOutputFieldName(String verboseName) throws CLIProcessingException {
        return "terse".equals(this.getParamTextValue(OUTPUT_PARAM_NAME, 0)) ? verboseToTerseMap.get(verboseName) : verboseName;
    }

    public static String getTransformedPath(String path, String user) {
        if (((String)path).contains("\\")) {
            path = ((String)path).replace('\\', '/');
        }
        if (!((String)path).startsWith("/")) {
            path = "/user/" + user + "/" + (String)path;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Query path: " + (String)path + ", User: " + user));
        }
        return path;
    }

    public String getCliParam(String key) throws IOException {
        String ret = null;
        try {
            if (this.isParamPresent(key) && (ret = this.getParamTextValue(key, 0)) != null) {
                ret = ret.trim();
            }
        }
        catch (CLIProcessingException e) {
            throw new IOException(e);
        }
        return ret;
    }

    private UserGroupInformation getProxyUser() throws IOException {
        UserGroupInformation currUser = UserGroupInformation.getLoginUser();
        if (currUser.getUserName().equals(this.getUserLoginId())) {
            return currUser;
        }
        return UserGroupInformation.createProxyUser((String)this.getUserLoginId(), (UserGroupInformation)currUser);
    }

    boolean validateAndAddSecurityPolicyTags(List<String> securityPolicyList, String securityPolicies, boolean allowNullTags) {
        if (allowNullTags && (securityPolicies == null || securityPolicies.length() == 0)) {
            return true;
        }
        String[] tokens = securityPolicies.split("[,]");
        for (int i = 0; i < tokens.length; ++i) {
            String next = tokens[i];
            if (next.length() == 0) {
                return false;
            }
            if (securityPolicyList.contains(next)) continue;
            securityPolicyList.add(next);
        }
        return true;
    }

    static {
        Dbserver.SchemaFamily.Builder schemaFamily = Dbserver.SchemaFamily.newBuilder().setInMemory(false).setMinVersions(0).setMaxVersions(1).setCompression(Common.FileCompressionType.FCT_LZ4).setName(Dbserver.DBInternalDefaults.getDefaultInstance().getJsonDefaultCFName());
        JSON_DEFAULT_COL_FAM_ATTR = Dbserver.ColumnFamilyAttr.newBuilder().setSchFamily(schemaFamily).build();
    }
}

