/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.shaded.com.google.common.hash;

import java.io.Serializable;
import org.kitesdk.shaded.com.google.common.annotations.Beta;
import org.kitesdk.shaded.com.google.common.annotations.VisibleForTesting;
import org.kitesdk.shaded.com.google.common.base.Preconditions;
import org.kitesdk.shaded.com.google.common.hash.BloomFilterStrategies;
import org.kitesdk.shaded.com.google.common.hash.Funnel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class BloomFilter<T>
implements Serializable {
    private final BloomFilterStrategies.BitArray bits;
    private final int numHashFunctions;
    private final Funnel<T> funnel;
    private final Strategy strategy;
    private static final double LN2 = Math.log(2.0);
    private static final double LN2_SQUARED = LN2 * LN2;

    private BloomFilter(BloomFilterStrategies.BitArray bits, int numHashFunctions, Funnel<T> funnel, Strategy strategy) {
        Preconditions.checkArgument(numHashFunctions > 0, "numHashFunctions zero or negative");
        this.bits = Preconditions.checkNotNull(bits);
        this.numHashFunctions = numHashFunctions;
        this.funnel = Preconditions.checkNotNull(funnel);
        this.strategy = strategy;
    }

    public boolean mightContain(T object) {
        return this.strategy.mightContain(object, this.funnel, this.numHashFunctions, this.bits);
    }

    public void put(T object) {
        this.strategy.put(object, this.funnel, this.numHashFunctions, this.bits);
    }

    @VisibleForTesting
    int getHashCount() {
        return this.numHashFunctions;
    }

    @VisibleForTesting
    double computeExpectedFalsePositiveRate(int insertions) {
        return Math.pow(1.0 - Math.exp((double)(-this.numHashFunctions) * ((double)insertions / (double)this.bits.size())), this.numHashFunctions);
    }

    public static <T> BloomFilter<T> create(Funnel<T> funnel, int expectedInsertions, double falsePositiveProbability) {
        Preconditions.checkNotNull(funnel);
        Preconditions.checkArgument(expectedInsertions > 0, "Expected insertions must be positive");
        Preconditions.checkArgument(falsePositiveProbability > 0.0 & falsePositiveProbability < 1.0, "False positive probability in (0.0, 1.0)");
        int numBits = BloomFilter.optimalNumOfBits(expectedInsertions, falsePositiveProbability);
        int numHashFunctions = BloomFilter.optimalNumOfHashFunctions(expectedInsertions, numBits);
        return new BloomFilter<T>(new BloomFilterStrategies.BitArray(numBits), numHashFunctions, funnel, BloomFilterStrategies.MURMUR128_MITZ_32);
    }

    public static <T> BloomFilter<T> create(Funnel<T> funnel, int expectedInsertions) {
        return BloomFilter.create(funnel, expectedInsertions, 0.03);
    }

    @VisibleForTesting
    static int optimalNumOfHashFunctions(int n, int m) {
        return Math.max(1, (int)Math.round((double)(m / n) * LN2));
    }

    @VisibleForTesting
    static int optimalNumOfBits(int n, double p) {
        return (int)((double)(-n) * Math.log(p) / LN2_SQUARED);
    }

    private Object writeReplace() {
        return new SerialForm(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerialForm<T>
    implements Serializable {
        final long[] data;
        final int numHashFunctions;
        final Funnel<T> funnel;
        final Strategy strategy;
        private static final long serialVersionUID = 1L;

        SerialForm(BloomFilter<T> bf) {
            this.data = ((BloomFilter)bf).bits.data;
            this.numHashFunctions = ((BloomFilter)bf).numHashFunctions;
            this.funnel = ((BloomFilter)bf).funnel;
            this.strategy = ((BloomFilter)bf).strategy;
        }

        Object readResolve() {
            return new BloomFilter(new BloomFilterStrategies.BitArray(this.data), this.numHashFunctions, this.funnel, this.strategy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Strategy
    extends Serializable {
        public <T> void put(T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.BitArray var4);

        public <T> boolean mightContain(T var1, Funnel<? super T> var2, int var3, BloomFilterStrategies.BitArray var4);
    }
}

