/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.data.spi.hive;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.kitesdk.data.Dataset;
import org.kitesdk.data.DatasetDescriptor;
import org.kitesdk.data.spi.DatasetRepository;
import org.kitesdk.data.spi.DefaultConfiguration;
import org.kitesdk.data.spi.MetadataProvider;
import org.kitesdk.data.spi.filesystem.FileSystemDataset;
import org.kitesdk.data.spi.hive.HiveAbstractDatasetRepository;
import org.kitesdk.data.spi.hive.HiveExternalDatasetRepository;
import org.kitesdk.data.spi.hive.HiveManagedMetadataProvider;

public class HiveManagedDatasetRepository
extends HiveAbstractDatasetRepository {
    HiveManagedDatasetRepository(Configuration conf) {
        super(conf, (MetadataProvider)new HiveManagedMetadataProvider(conf));
    }

    HiveManagedDatasetRepository(Configuration conf, MetadataProvider provider) {
        super(conf, provider);
    }

    public <E> Dataset<E> create(String namespace, String name, DatasetDescriptor descriptor) {
        this.getMetadataProvider().create(namespace, name, descriptor);
        FileSystemDataset dataset = (FileSystemDataset)this.load(namespace, name);
        dataset.addExistingPartitions();
        return dataset;
    }

    public <E> Dataset<E> create(String namespace, String name, DatasetDescriptor descriptor, Class<E> type) {
        this.getMetadataProvider().create(namespace, name, descriptor);
        return this.load(namespace, name, type);
    }

    public static class Builder {
        private Path rootDirectory;
        private Configuration configuration;

        public Builder rootDirectory(Path path) {
            this.rootDirectory = path;
            return this;
        }

        public Builder rootDirectory(URI uri) {
            this.rootDirectory = new Path(uri);
            return this;
        }

        public Builder rootDirectory(String uri) throws URISyntaxException {
            this.rootDirectory = new Path(new URI(uri));
            return this;
        }

        public Builder configuration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public DatasetRepository build() {
            if (this.configuration == null) {
                this.configuration = DefaultConfiguration.get();
            }
            if (this.rootDirectory != null) {
                return new HiveExternalDatasetRepository(this.configuration, this.rootDirectory);
            }
            return new HiveManagedDatasetRepository(this.configuration);
        }
    }
}

