/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.javah;

import java.io.File;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.javah.AbstractJavah;
import org.codehaus.mojo.natives.javah.JavahConfiguration;
import org.codehaus.mojo.natives.util.CommandLineUtil;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.cli.Commandline;

public class JavahExecutable
extends AbstractJavah {
    public void compile(JavahConfiguration config) throws NativeBuildException {
        Commandline cl = this.createJavahCommand(config);
        CommandLineUtil.execute((Commandline)cl, (Logger)this.getLogger());
    }

    protected Commandline createJavahCommand(JavahConfiguration config) throws NativeBuildException {
        this.validateConfiguration(config);
        Commandline cl = new Commandline();
        if (config.getWorkingDirectory() != null) {
            cl.setWorkingDirectory(config.getWorkingDirectory().getPath());
        }
        cl.setExecutable(this.getJavaHExecutable(config));
        if (config.getFileName() != null && config.getFileName().length() > 0) {
            File outputFile = new File(config.getOutputDirectory(), config.getFileName());
            cl.createArg().setValue("-o");
            cl.createArg().setFile(outputFile);
        } else if (config.getOutputDirectory() != null) {
            cl.createArg().setValue("-d");
            cl.createArg().setFile(config.getOutputDirectory());
        }
        String[] classPaths = config.getClassPaths();
        StringBuffer classPathBuffer = new StringBuffer();
        for (int i = 0; i < classPaths.length; ++i) {
            classPathBuffer.append(classPaths[i]);
            if (i == classPaths.length - 1) continue;
            classPathBuffer.append(File.pathSeparatorChar);
        }
        cl.createArg().setValue("-classpath");
        cl.createArg().setValue(classPathBuffer.toString());
        if (config.getVerbose()) {
            cl.createArg().setValue("-verbose");
        }
        cl.addArguments(config.getClassNames());
        return cl;
    }

    private void validateConfiguration(JavahConfiguration config) throws NativeBuildException {
        if (config.getClassPaths() == null || config.getClassPaths().length == 0) {
            throw new NativeBuildException("javah classpaths can not be empty.");
        }
        if (config.getOutputDirectory() == null) {
            throw new NativeBuildException("javah destDir can not be empty.");
        }
        if (!config.getOutputDirectory().exists()) {
            config.getOutputDirectory().mkdirs();
        }
        if (config.getClassNames() == null || config.getClassNames().length == 0) {
            throw new NativeBuildException("javah: java classes can not be empty.");
        }
    }

    protected String getJavaHExecutable(JavahConfiguration config) {
        String path = "javah";
        if (config.getJavahPath() != null) {
            path = config.getJavahPath().getAbsolutePath();
        }
        return path;
    }
}

