/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;

public class NativeSources {
    private File directory;
    private String[] fileNames = new String[0];
    private boolean dependencyAnalysisParticipation = true;
    private boolean deployable = false;
    private String[] includes;
    private String[] excludes;

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public void setFileNames(String[] fileNames) {
        if (fileNames == null) {
            this.fileNames = new String[0];
        }
        this.fileNames = fileNames;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public boolean getDependencyAnalysisParticipation() {
        return this.dependencyAnalysisParticipation;
    }

    public void setDependencyAnalysisParticipation(boolean flag) {
        this.dependencyAnalysisParticipation = flag;
    }

    public boolean isDeployable() {
        return this.deployable;
    }

    public void setDeployable(boolean deployable) {
        this.deployable = deployable;
    }

    public List getFiles() {
        int i;
        String[] filePaths = new String[]{};
        if (this.includes != null || this.excludes != null) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(this.directory);
            scanner.setIncludes(this.includes);
            scanner.setExcludes(this.excludes);
            scanner.addDefaultExcludes();
            scanner.scan();
            filePaths = scanner.getIncludedFiles();
        }
        ArrayList<File> files = new ArrayList<File>(filePaths.length + this.fileNames.length);
        for (i = 0; i < filePaths.length; ++i) {
            files.add(new File(this.directory, filePaths[i]));
        }
        for (i = 0; i < this.fileNames.length; ++i) {
            File file = new File(this.directory, this.fileNames[i]);
            boolean found = false;
            for (int k = 0; k < filePaths.length; ++k) {
                if (!files.get(k).equals(file)) continue;
                found = true;
                break;
            }
            if (found) continue;
            files.add(file);
        }
        return files;
    }

    public static File[] getAllSourceFiles(NativeSources[] sources) {
        if (sources == null) {
            return new File[0];
        }
        ArrayList sourceFiles = new ArrayList();
        for (int i = 0; i < sources.length; ++i) {
            sourceFiles.addAll(sources[i].getFiles());
        }
        return sourceFiles.toArray(new File[sourceFiles.size()]);
    }

    public static File[] getIncludePaths(NativeSources[] sources) {
        if (sources == null) {
            return new File[0];
        }
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < sources.length; ++i) {
            if (!sources[i].getDependencyAnalysisParticipation()) continue;
            list.add(sources[i].getDirectory());
        }
        return list.toArray(new File[0]);
    }

    public static File[] getSystemIncludePaths(NativeSources[] sources) {
        if (sources == null) {
            return new File[0];
        }
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < sources.length; ++i) {
            if (sources[i].getDependencyAnalysisParticipation()) continue;
            list.add(sources[i].getDirectory());
        }
        return list.toArray(new File[0]);
    }
}

