/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.RandomTextWriterJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.tez.mapreduce.examples.MRRSleepJob;
import org.apache.tez.test.MiniTezCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMRRJobs {
    private static final Log LOG = LogFactory.getLog(TestMRRJobs.class);
    protected static MiniTezCluster mrrTezCluster;
    protected static MiniDFSCluster dfsCluster;
    private static Configuration conf;
    private static FileSystem remoteFs;
    private static String TEST_ROOT_DIR;
    private static final String OUTPUT_ROOT_DIR;

    @BeforeClass
    public static void setup() throws IOException {
        try {
            conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (!new File(MiniTezCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniTezCluster.APPJAR + " not found. Not running test."));
            return;
        }
        if (mrrTezCluster == null) {
            mrrTezCluster = new MiniTezCluster(TestMRRJobs.class.getName(), 1, 1, 1);
            Configuration conf = new Configuration();
            conf.set("fs.defaultFS", remoteFs.getUri().toString());
            conf.set("yarn.app.mapreduce.am.staging-dir", "/apps_staging_dir");
            conf.setLong("yarn.nodemanager.delete.debug-delay-sec", 0L);
            mrrTezCluster.init(conf);
            mrrTezCluster.start();
        }
    }

    @AfterClass
    public static void tearDown() {
        if (mrrTezCluster != null) {
            mrrTezCluster.stop();
            mrrTezCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    @Test(timeout=60000L)
    public void testMRRSleepJob() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testMRRSleepJob().");
        if (!new File(MiniTezCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniTezCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Configuration sleepConf = new Configuration(mrrTezCluster.getConfig());
        MRRSleepJob sleepJob = new MRRSleepJob();
        sleepJob.setConf(sleepConf);
        Job job = sleepJob.createJob(1, 1, 1, 1, 1L, 1, 1L, 1, 1L, 1);
        job.setJarByClass(MRRSleepJob.class);
        job.setMaxMapAttempts(1);
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((boolean)succeeded);
        Assert.assertEquals((Object)JobStatus.State.SUCCEEDED, (Object)job.getJobState());
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
    }

    @Test(timeout=60000L)
    public void testRandomWriter() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testRandomWriter().");
        if (!new File(MiniTezCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniTezCluster.APPJAR + " not found. Not running test."));
            return;
        }
        RandomTextWriterJob randomWriterJob = new RandomTextWriterJob();
        mrrTezCluster.getConfig().set("mapreduce.randomtextwriter.totalbytes", "3072");
        mrrTezCluster.getConfig().set("mapreduce.randomtextwriter.bytespermap", "1024");
        Job job = randomWriterJob.createJob(mrrTezCluster.getConfig());
        Path outputDir = new Path(OUTPUT_ROOT_DIR, "random-output");
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        job.setSpeculativeExecution(false);
        job.setJarByClass(RandomTextWriterJob.class);
        job.setMaxMapAttempts(1);
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((boolean)succeeded);
        Assert.assertEquals((Object)JobStatus.State.SUCCEEDED, (Object)job.getJobState());
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
        RemoteIterator iterator = FileContext.getFileContext((Configuration)mrrTezCluster.getConfig()).listStatus(outputDir);
        int count = 0;
        while (iterator.hasNext()) {
            FileStatus file = (FileStatus)iterator.next();
            if (file.getPath().getName().equals("_SUCCESS")) continue;
            ++count;
        }
        Assert.assertEquals((String)"Number of part files is wrong!", (long)3L, (long)count);
    }

    @Test(timeout=60000L)
    public void testFailingJob() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testFailingJob().");
        if (!new File(MiniTezCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniTezCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Configuration sleepConf = new Configuration(mrrTezCluster.getConfig());
        MRRSleepJob sleepJob = new MRRSleepJob();
        sleepJob.setConf(sleepConf);
        Job job = sleepJob.createJob(1, 1, 1, 1, 1L, 1, 1L, 1, 1L, 1);
        job.setJarByClass(MRRSleepJob.class);
        job.setMaxMapAttempts(1);
        job.getConfiguration().setBoolean("mrr.sleepjob.map.fatal.error", true);
        job.getConfiguration().set("mrr.sleepjob.map.error.task.ids", "*");
        job.submit();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertFalse((boolean)succeeded);
        Assert.assertEquals((Object)JobStatus.State.FAILED, (Object)job.getJobState());
    }

    @Test(timeout=60000L)
    public void testFailingAttempt() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testFailingAttempt().");
        if (!new File(MiniTezCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniTezCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Configuration sleepConf = new Configuration(mrrTezCluster.getConfig());
        MRRSleepJob sleepJob = new MRRSleepJob();
        sleepJob.setConf(sleepConf);
        Job job = sleepJob.createJob(1, 1, 1, 1, 1L, 1, 1L, 1, 1L, 1);
        job.setJarByClass(MRRSleepJob.class);
        job.setMaxMapAttempts(3);
        job.getConfiguration().setBoolean("mrr.sleepjob.map.throw.error", true);
        job.getConfiguration().set("mrr.sleepjob.map.error.task.ids", "0");
        job.submit();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((boolean)succeeded);
        Assert.assertEquals((Object)JobStatus.State.SUCCEEDED, (Object)job.getJobState());
    }

    @Test(timeout=60000L)
    public void testMRRSleepJobWithCompression() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting testMRRSleepJobWithCompression().");
        if (!new File(MiniTezCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniTezCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Configuration sleepConf = new Configuration(mrrTezCluster.getConfig());
        MRRSleepJob sleepJob = new MRRSleepJob();
        sleepJob.setConf(sleepConf);
        Job job = sleepJob.createJob(1, 1, 2, 1, 1L, 1, 1L, 1, 1L, 1);
        job.setJarByClass(MRRSleepJob.class);
        job.setMaxMapAttempts(1);
        job.getConfiguration().setBoolean("mapreduce.map.output.compress", true);
        job.getConfiguration().set("mapreduce.map.output.compress.codec", DefaultCodec.class.getName());
        job.submit();
        String trackingUrl = job.getTrackingURL();
        String jobId = job.getJobID().toString();
        boolean succeeded = job.waitForCompletion(true);
        Assert.assertTrue((boolean)succeeded);
        Assert.assertEquals((Object)JobStatus.State.SUCCEEDED, (Object)job.getJobState());
        Assert.assertTrue((String)("Tracking URL was " + trackingUrl + " but didn't Match Job ID " + jobId), (boolean)trackingUrl.endsWith(jobId.substring(jobId.lastIndexOf("_")) + "/"));
    }

    static {
        conf = new Configuration();
        TEST_ROOT_DIR = "target/" + TestMRRJobs.class.getName() + "-tmpDir";
        OUTPUT_ROOT_DIR = "/tmp/" + TestMRRJobs.class.getSimpleName();
    }
}

