/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test.dag;

import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.test.TestProcessor;
import org.apache.tez.test.dag.TwoLevelsFailingDAG;

public class ThreeLevelsFailingDAG
extends TwoLevelsFailingDAG {
    protected static Vertex l3v1;
    protected static Vertex l3v2;

    protected static void addDAGVerticesAndEdges() {
        TwoLevelsFailingDAG.addDAGVerticesAndEdges();
        l3v1 = new Vertex("l3v1", TestProcessor.getProcDesc(payload), 4, defaultResource);
        dag.addVertex(l3v1);
        ThreeLevelsFailingDAG.addEdge(l2v1, l3v1, EdgeProperty.DataMovementType.SCATTER_GATHER);
        ThreeLevelsFailingDAG.addEdge(l2v2, l3v1, EdgeProperty.DataMovementType.SCATTER_GATHER);
        l3v2 = new Vertex("l3v2", TestProcessor.getProcDesc(payload), 4, defaultResource);
        dag.addVertex(l3v2);
        ThreeLevelsFailingDAG.addEdge(l2v2, l3v2, EdgeProperty.DataMovementType.BROADCAST);
        ThreeLevelsFailingDAG.addEdge(l2v3, l3v2, EdgeProperty.DataMovementType.SCATTER_GATHER);
        ThreeLevelsFailingDAG.addEdge(l2v4, l3v2, EdgeProperty.DataMovementType.SCATTER_GATHER);
    }

    public static DAG createDAG(String name, Configuration conf) throws Exception {
        if (conf != null) {
            payload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        }
        dag = new DAG(name);
        ThreeLevelsFailingDAG.addDAGVerticesAndEdges();
        return dag;
    }

    public static DAG createDAG(Configuration conf) throws Exception {
        return ThreeLevelsFailingDAG.createDAG("ThreeLevelsFailingDAG", conf);
    }
}

