/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.client.AMConfiguration;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.StatusGetOpts;
import org.apache.tez.mapreduce.examples.ExampleDriver;
import org.apache.tez.runtime.library.processor.SleepProcessor;
import org.apache.tez.test.MiniTezCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTezJobs {
    private static final Log LOG = LogFactory.getLog(TestTezJobs.class);
    protected static MiniTezCluster mrrTezCluster;
    protected static MiniDFSCluster dfsCluster;
    private static Configuration conf;
    private static FileSystem remoteFs;
    private static String TEST_ROOT_DIR;

    @BeforeClass
    public static void setup() throws IOException {
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (mrrTezCluster == null) {
            mrrTezCluster = new MiniTezCluster(TestTezJobs.class.getName(), 1, 1, 1);
            Configuration conf = new Configuration();
            conf.set("fs.defaultFS", remoteFs.getUri().toString());
            mrrTezCluster.init(conf);
            mrrTezCluster.start();
        }
    }

    @AfterClass
    public static void tearDown() {
        if (mrrTezCluster != null) {
            mrrTezCluster.stop();
            mrrTezCluster = null;
        }
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    @Test(timeout=60000L)
    public void testSleepJob() throws TezException, IOException, InterruptedException {
        SleepProcessor.SleepProcessorConfig spConf = new SleepProcessor.SleepProcessorConfig(1);
        DAG dag = new DAG("TezSleepProcessor");
        Vertex vertex = new Vertex("SleepVertex", new ProcessorDescriptor(SleepProcessor.class.getName()).setUserPayload(spConf.toUserPayload()), 1, Resource.newInstance((int)1024, (int)1));
        dag.addVertex(vertex);
        TezConfiguration tezConf = new TezConfiguration(mrrTezCluster.getConfig());
        Path remoteStagingDir = remoteFs.makeQualified(new Path("/tmp", String.valueOf(new Random().nextInt(100000))));
        remoteFs.mkdirs(remoteStagingDir);
        tezConf.set("tez.staging-dir", remoteStagingDir.toString());
        TezClient tezClient = new TezClient(tezConf);
        AMConfiguration amConf = new AMConfiguration(new HashMap(), new HashMap(), tezConf, null);
        DAGClient dagClient = tezClient.submitDAGApplication(dag, amConf);
        DAGStatus dagStatus = dagClient.getDAGStatus(null);
        while (!dagStatus.isCompleted()) {
            LOG.info((Object)("Waiting for job to complete. Sleeping for 500ms. Current state: " + dagStatus.getState()));
            Thread.sleep(500L);
            dagStatus = dagClient.getDAGStatus(null);
        }
        dagStatus = dagClient.getDAGStatus((Set)Sets.newHashSet((Object[])new StatusGetOpts[]{StatusGetOpts.GET_COUNTERS}));
        Assert.assertEquals((Object)DAGStatus.State.SUCCEEDED, (Object)dagStatus.getState());
        Assert.assertNotNull((Object)dagStatus.getDAGCounters());
        Assert.assertNotNull((Object)dagStatus.getDAGCounters().getGroup(FileSystemCounter.class.getName()));
        Assert.assertNotNull((Object)dagStatus.getDAGCounters().findCounter((Enum)TaskCounter.GC_TIME_MILLIS));
        ExampleDriver.printDAGStatus((DAGClient)dagClient, (String[])new String[]{"SleepVertex"}, (boolean)true, (boolean)true);
    }

    static {
        conf = new Configuration();
        TEST_ROOT_DIR = "target/" + TestTezJobs.class.getName() + "-tmpDir";
    }
}

