/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.output;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.MemoryUpdateCallback;
import org.apache.tez.runtime.api.TezOutputContext;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;
import org.apache.tez.runtime.library.api.KeyValueWriter;
import org.apache.tez.runtime.library.common.MemoryUpdateCallbackHandler;
import org.apache.tez.runtime.library.common.sort.impl.ExternalSorter;
import org.apache.tez.runtime.library.common.sort.impl.PipelinedSorter;
import org.apache.tez.runtime.library.common.sort.impl.TezIndexRecord;
import org.apache.tez.runtime.library.common.sort.impl.TezSpillRecord;
import org.apache.tez.runtime.library.common.sort.impl.dflt.DefaultSorter;
import org.apache.tez.runtime.library.shuffle.common.ShuffleUtils;
import org.apache.tez.runtime.library.shuffle.impl.ShuffleUserPayloads;

public class OnFileSortedOutput
implements LogicalOutput {
    private static final Log LOG = LogFactory.getLog(OnFileSortedOutput.class);
    protected ExternalSorter sorter;
    protected Configuration conf;
    protected int numOutputs;
    protected TezOutputContext outputContext;
    protected MemoryUpdateCallbackHandler memoryUpdateCallbackHandler;
    private long startTime;
    private long endTime;
    private boolean sendEmptyPartitionDetails;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public synchronized List<Event> initialize(TezOutputContext outputContext) throws IOException {
        this.startTime = System.nanoTime();
        this.outputContext = outputContext;
        this.conf = TezUtils.createConfFromUserPayload((byte[])outputContext.getUserPayload());
        this.conf.setStrings("tez.runtime.local.dirs", outputContext.getWorkDirs());
        this.memoryUpdateCallbackHandler = new MemoryUpdateCallbackHandler();
        outputContext.requestInitialMemory(ExternalSorter.getInitialMemoryRequirement(this.conf, outputContext.getTotalMemoryAvailableToTask()), (MemoryUpdateCallback)this.memoryUpdateCallbackHandler);
        this.sendEmptyPartitionDetails = this.conf.getBoolean("tez.runtime.empty.partitions.info-via-events.enabled", true);
        return Collections.emptyList();
    }

    public synchronized void start() throws Exception {
        if (!this.isStarted.get()) {
            this.memoryUpdateCallbackHandler.validateUpdateReceived();
            this.sorter = this.conf.getInt("tez.runtime.sort.threads", 1) > 1 ? new PipelinedSorter(this.outputContext, this.conf, this.numOutputs, this.memoryUpdateCallbackHandler.getMemoryAssigned()) : new DefaultSorter(this.outputContext, this.conf, this.numOutputs, this.memoryUpdateCallbackHandler.getMemoryAssigned());
            this.isStarted.set(true);
        }
    }

    public synchronized KeyValueWriter getWriter() throws IOException {
        Preconditions.checkState((boolean)this.isStarted.get(), (Object)"Cannot get writer before starting the Output");
        return new KeyValueWriter(){

            @Override
            public void write(Object key, Object value) throws IOException {
                OnFileSortedOutput.this.sorter.write(key, value);
            }
        };
    }

    public synchronized void handleEvents(List<Event> outputEvents) {
    }

    public synchronized void setNumPhysicalOutputs(int numOutputs) {
        this.numOutputs = numOutputs;
    }

    public synchronized List<Event> close() throws IOException {
        if (this.sorter != null) {
            this.sorter.flush();
            this.sorter.close();
            this.endTime = System.nanoTime();
            return this.generateEventsOnClose();
        }
        LOG.warn((Object)("Attempting to close output " + this.outputContext.getDestinationVertexName() + " before it was started"));
        return Collections.emptyList();
    }

    protected List<Event> generateEventsOnClose() throws IOException {
        String host = System.getenv(ApplicationConstants.Environment.NM_HOST.toString());
        ByteBuffer shuffleMetadata = this.outputContext.getServiceProviderMetaData(ShuffleUtils.SHUFFLE_HANDLER_SERVICE_ID);
        int shufflePort = ShuffleUtils.deserializeShuffleProviderMetaData(shuffleMetadata);
        ShuffleUserPayloads.DataMovementEventPayloadProto.Builder payloadBuilder = ShuffleUserPayloads.DataMovementEventPayloadProto.newBuilder();
        if (this.sendEmptyPartitionDetails) {
            Path indexFile = this.sorter.getMapOutput().getOutputIndexFile();
            TezSpillRecord spillRecord = new TezSpillRecord(indexFile, this.conf);
            BitSet emptyPartitionDetails = new BitSet();
            int emptyPartitions = 0;
            for (int i = 0; i < spillRecord.size(); ++i) {
                TezIndexRecord indexRecord = spillRecord.getIndex(i);
                if (indexRecord.hasData()) continue;
                emptyPartitionDetails.set(i);
                ++emptyPartitions;
            }
            if (emptyPartitions > 0) {
                ByteString emptyPartitionsBytesString = TezUtils.compressByteArrayToByteString((byte[])TezUtils.toByteArray((BitSet)emptyPartitionDetails));
                payloadBuilder.setEmptyPartitions(emptyPartitionsBytesString);
                LOG.info((Object)("EmptyPartition bitsetSize=" + emptyPartitionDetails.cardinality() + ", numOutputs=" + this.numOutputs + ", emptyPartitions=" + emptyPartitions + ", compressedSize=" + emptyPartitionsBytesString.size()));
            }
        }
        payloadBuilder.setHost(host);
        payloadBuilder.setPort(shufflePort);
        payloadBuilder.setPathComponent(this.outputContext.getUniqueIdentifier());
        payloadBuilder.setRunDuration((int)((this.endTime - this.startTime) / 1000L));
        ShuffleUserPayloads.DataMovementEventPayloadProto payloadProto = payloadBuilder.build();
        byte[] payloadBytes = payloadProto.toByteArray();
        long outputSize = this.outputContext.getCounters().findCounter((Enum)TaskCounter.OUTPUT_BYTES).getValue();
        ShuffleUserPayloads.VertexManagerEventPayloadProto.Builder vmBuilder = ShuffleUserPayloads.VertexManagerEventPayloadProto.newBuilder();
        vmBuilder.setOutputSize(outputSize);
        VertexManagerEvent vmEvent = new VertexManagerEvent(this.outputContext.getDestinationVertexName(), vmBuilder.build().toByteArray());
        ArrayList events = Lists.newArrayListWithCapacity((int)(this.numOutputs + 1));
        events.add(vmEvent);
        CompositeDataMovementEvent csdme = new CompositeDataMovementEvent(0, this.numOutputs, payloadBytes);
        events.add(csdme);
        return events;
    }
}

