/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common.shuffle.impl;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.WritableUtils;
import org.apache.tez.runtime.library.common.sort.impl.IFile;
import org.apache.tez.runtime.library.common.sort.impl.IFileOutputStream;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class InMemoryWriter
extends IFile.Writer {
    private static final Log LOG = LogFactory.getLog(InMemoryWriter.class);
    private DataOutputStream out;

    public InMemoryWriter(BoundedByteArrayOutputStream arrayStream) {
        super(null, null);
        this.out = new DataOutputStream(new IFileOutputStream((OutputStream)arrayStream));
    }

    @Override
    public void append(Object key, Object value) throws IOException {
        throw new UnsupportedOperationException("InMemoryWriter.append(K key, V value");
    }

    @Override
    public void append(DataInputBuffer key, DataInputBuffer value) throws IOException {
        int keyLength = key.getLength() - key.getPosition();
        if (keyLength < 0) {
            throw new IOException("Negative key-length not allowed: " + keyLength + " for " + key);
        }
        boolean sameKey = key == IFile.REPEAT_KEY;
        int valueLength = value.getLength() - value.getPosition();
        if (valueLength < 0) {
            throw new IOException("Negative value-length not allowed: " + valueLength + " for " + value);
        }
        if (sameKey) {
            WritableUtils.writeVInt((DataOutput)this.out, (int)-2);
            WritableUtils.writeVInt((DataOutput)this.out, (int)valueLength);
            this.out.write(value.getData(), value.getPosition(), valueLength);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("InMemWriter.append key.data=" + key.getData() + " key.pos=" + key.getPosition() + " key.len=" + key.getLength() + " val.data=" + value.getData() + " val.pos=" + value.getPosition() + " val.len=" + value.getLength()));
            }
            WritableUtils.writeVInt((DataOutput)this.out, (int)keyLength);
            WritableUtils.writeVInt((DataOutput)this.out, (int)valueLength);
            this.out.write(key.getData(), key.getPosition(), keyLength);
            this.out.write(value.getData(), value.getPosition(), valueLength);
        }
    }

    @Override
    public void close() throws IOException {
        WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
        WritableUtils.writeVInt((DataOutput)this.out, (int)-1);
        this.out.close();
        this.out = null;
    }
}

