/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.partition;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.HashPartitioner;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tez.runtime.library.common.ConfigUtils;

public class MRPartitioner
implements org.apache.tez.runtime.library.api.Partitioner {
    static final Log LOG = LogFactory.getLog(MRPartitioner.class);
    private final boolean useNewApi;
    private int partitions = 1;
    private Partitioner newPartitioner;
    private org.apache.hadoop.mapred.Partitioner oldPartitioner;

    public MRPartitioner(Configuration conf) {
        this.useNewApi = ConfigUtils.useNewApi((Configuration)conf);
        this.partitions = conf.getInt("tez.runtime.num.expected.partitions", 1);
        if (this.useNewApi) {
            this.newPartitioner = this.partitions > 1 ? (Partitioner)ReflectionUtils.newInstance((Class)conf.getClass("mapreduce.job.partitioner.class", org.apache.hadoop.mapreduce.lib.partition.HashPartitioner.class), (Configuration)conf) : new Partitioner(){

                public int getPartition(Object key, Object value, int numPartitions) {
                    return numPartitions - 1;
                }
            };
        } else {
            this.oldPartitioner = this.partitions > 1 ? (org.apache.hadoop.mapred.Partitioner)ReflectionUtils.newInstance((Class)conf.getClass("mapred.partitioner.class", HashPartitioner.class), (Configuration)conf) : new org.apache.hadoop.mapred.Partitioner(){

                public void configure(JobConf job) {
                }

                public int getPartition(Object key, Object value, int numPartitions) {
                    return numPartitions - 1;
                }
            };
        }
    }

    public int getPartition(Object key, Object value, int numPartitions) {
        if (this.useNewApi) {
            return this.newPartitioner.getPartition(key, value, numPartitions);
        }
        return this.oldPartitioner.getPartition(key, value, numPartitions);
    }
}

