/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.hadoop;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.tez.mapreduce.combine.MRCombiner;
import org.apache.tez.mapreduce.hadoop.DeprecatedKeys;
import org.apache.tez.mapreduce.hadoop.MultiStageMRConfigUtil;
import org.apache.tez.mapreduce.partition.MRPartitioner;

public class MultiStageMRConfToTezTranslator {
    private static final Log LOG = LogFactory.getLog(MultiStageMRConfToTezTranslator.class);

    public static Configuration convertMRToLinearTez(Configuration srcConf) {
        int i;
        Configuration newConf = new Configuration(srcConf);
        int numIntermediateStages = MultiStageMRConfigUtil.getNumIntermediateStages(srcConf);
        boolean hasFinalReduceStage = srcConf.getInt("mapreduce.job.reduces", 0) > 0;
        int totalStages = numIntermediateStages + (hasFinalReduceStage ? 2 : 1);
        int numEdges = totalStages - 1;
        Configuration[] allConfs = MultiStageMRConfToTezTranslator.extractStageConfs(newConf, numEdges);
        for (i = 0; i < allConfs.length; ++i) {
            MultiStageMRConfToTezTranslator.setStageKeysFromBaseConf(allConfs[i], srcConf, Integer.toString(i));
            MultiStageMRConfToTezTranslator.processDirectConversion(allConfs[i]);
        }
        for (i = 0; i < allConfs.length - 1; ++i) {
            MultiStageMRConfToTezTranslator.translateMultiStageWithSuccessor(allConfs[i], allConfs[i + 1]);
        }
        MultiStageMRConfToTezTranslator.translateMultiStageWithSuccessor(allConfs[allConfs.length - 1], null);
        for (i = 0; i < allConfs.length; ++i) {
            String vertexName = i == 0 ? MultiStageMRConfigUtil.getInitialMapVertexName() : (i == allConfs.length - 1 ? MultiStageMRConfigUtil.getFinalReduceVertexName() : MultiStageMRConfigUtil.getIntermediateStageVertexName(i));
            MultiStageMRConfigUtil.addConfigurationForVertex(newConf, vertexName, allConfs[i]);
        }
        return newConf;
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive, Pig"})
    @InterfaceStability.Unstable
    public static void translateVertexConfToTez(Configuration conf, Configuration predecessorConf) {
        MultiStageMRConfToTezTranslator.convertVertexConfToTez(conf, predecessorConf);
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive, Pig"})
    @InterfaceStability.Unstable
    public static Configuration getOutputConfOnEdge(Configuration srcVertex, Configuration destVertex) {
        Preconditions.checkNotNull((Object)srcVertex, (Object)"srcVertex cannot be null for an edge");
        Preconditions.checkNotNull((Object)destVertex, (Object)"destVertex cannot be null for an edge");
        return srcVertex;
    }

    @InterfaceAudience.LimitedPrivate(value={"Hive, Pig"})
    @InterfaceStability.Unstable
    public static Configuration getInputConfOnEdge(Configuration srcVertex, Configuration destVertex) {
        Preconditions.checkNotNull((Object)srcVertex, (Object)"srcVertex cannot be null for an edge");
        Preconditions.checkNotNull((Object)destVertex, (Object)"destVertex cannot be null for an edge");
        return destVertex;
    }

    private static void convertVertexConfToTez(Configuration vertexConf, Configuration predecessorConf) {
        MultiStageMRConfToTezTranslator.setStageKeysFromBaseConf(vertexConf, vertexConf, "unknown");
        MultiStageMRConfToTezTranslator.processDirectConversion(vertexConf);
        MultiStageMRConfToTezTranslator.translateMultiStageWithPredecessor(vertexConf, predecessorConf);
    }

    private static Configuration[] extractStageConfs(Configuration conf, int totalEdges) {
        int numStages = totalEdges + 1;
        Configuration[] confs = new Configuration[numStages];
        Configuration nonIntermediateConf = MultiStageMRConfigUtil.getAndRemoveBasicNonIntermediateStageConf(conf);
        if (numStages == 1) {
            confs[0] = nonIntermediateConf;
        } else {
            confs[0] = nonIntermediateConf;
            confs[numStages - 1] = new Configuration(nonIntermediateConf);
        }
        if (numStages > 2) {
            for (int i = 1; i < numStages - 1; ++i) {
                confs[i] = MultiStageMRConfigUtil.getAndRemoveBasicIntermediateStageConf(conf, i);
            }
        }
        return confs;
    }

    @InterfaceAudience.Private
    public static Configuration[] getStageConfs(Configuration conf) {
        int numIntermediateStages = MultiStageMRConfigUtil.getNumIntermediateStages(conf);
        boolean hasFinalReduceStage = conf.getInt("mapreduce.job.reduces", 0) > 0;
        int numStages = numIntermediateStages + (hasFinalReduceStage ? 2 : 1);
        conf.setBoolean("mapreduce.tez.splits.via.events", false);
        conf.set("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        boolean useNewApi = conf.getBoolean("mapred.mapper.new-api", false);
        if (useNewApi) {
            if (conf.get("mapreduce.job.combine.class") != null) {
                conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
            }
        } else if (conf.get("mapred.combiner.class") != null) {
            conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
        }
        Configuration[] confs = new Configuration[numStages];
        Configuration nonItermediateConf = MultiStageMRConfigUtil.extractStageConf(conf, "");
        if (numStages == 1) {
            confs[0] = nonItermediateConf;
            confs[0].setBoolean("tez.mapreduce.is_map_processor", true);
        } else {
            confs[0] = nonItermediateConf;
            confs[numStages - 1] = new Configuration(nonItermediateConf);
            confs[numStages - 1].setBoolean("tez.mapreduce.is_map_processor", false);
        }
        if (numStages > 2) {
            for (int i = 1; i < numStages - 1; ++i) {
                confs[i] = MultiStageMRConfigUtil.extractStageConf(conf, MultiStageMRConfigUtil.getPropertyNameForIntermediateStage(i, ""));
                confs[i].setBoolean("tez.mapreduce.is_map_processor", false);
            }
        }
        return confs;
    }

    private static void processDirectConversion(Configuration conf) {
        for (Map.Entry<String, String> dep : DeprecatedKeys.getMRToTezRuntimeParamMap().entrySet()) {
            if (conf.get(dep.getKey()) == null) continue;
            String value = conf.get(dep.getKey());
            conf.unset(dep.getKey());
            conf.set(dep.getValue(), value, DeprecationReason.DEPRECATED_DIRECT_TRANSLATION.name());
        }
    }

    private static void translateMultiStageWithPredecessor(Configuration vertexConf, Configuration predecessorConf) {
        Preconditions.checkNotNull((Object)vertexConf, (Object)"Configuration for vertex being translated cannot be null");
        for (Map.Entry<String, Map<DeprecatedKeys.MultiStageKeys, String>> dep : DeprecatedKeys.getMultiStageParamMap().entrySet()) {
            String expPredecessorKey;
            if (vertexConf.get(dep.getKey()) != null) {
                String value = vertexConf.get(dep.getKey());
                vertexConf.unset(dep.getKey());
                vertexConf.set(dep.getValue().get((Object)DeprecatedKeys.MultiStageKeys.OUTPUT), value, DeprecationReason.DEPRECATED_MULTI_STAGE.name());
            }
            if (predecessorConf == null || predecessorConf.get(expPredecessorKey = dep.getValue().get((Object)DeprecatedKeys.MultiStageKeys.OUTPUT)) == null) continue;
            String value = predecessorConf.get(expPredecessorKey);
            vertexConf.set(dep.getValue().get((Object)DeprecatedKeys.MultiStageKeys.INPUT), value);
        }
    }

    private static void translateMultiStageWithSuccessor(Configuration srcVertexConf, Configuration destVertexConf) {
        for (Map.Entry<String, Map<DeprecatedKeys.MultiStageKeys, String>> dep : DeprecatedKeys.getMultiStageParamMap().entrySet()) {
            if (srcVertexConf.get(dep.getKey()) == null) continue;
            if (destVertexConf != null) {
                String value = srcVertexConf.get(dep.getKey());
                srcVertexConf.unset(dep.getKey());
                srcVertexConf.set(dep.getValue().get((Object)DeprecatedKeys.MultiStageKeys.OUTPUT), value, DeprecationReason.DEPRECATED_MULTI_STAGE.name());
                destVertexConf.set(dep.getValue().get((Object)DeprecatedKeys.MultiStageKeys.INPUT), value, DeprecationReason.DEPRECATED_MULTI_STAGE.name());
                continue;
            }
            srcVertexConf.unset(dep.getKey());
        }
    }

    private static void setStageKeysFromBaseConf(Configuration conf, Configuration baseConf, String stage) {
        JobConf jobConf = new JobConf(baseConf);
        if (conf.get("tez.runtime.intermediate-output.key.class") == null && conf.get("mapreduce.map.output.key.class") == null) {
            conf.set("mapreduce.map.output.key.class", jobConf.getMapOutputKeyClass().getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting mapreduce.map.output.key.class for stage: " + stage + " based on job level configuration. Value: " + conf.get("mapreduce.map.output.key.class")));
            }
        }
        if (conf.get("tez.runtime.intermediate-output.value.class") == null && conf.get("mapreduce.map.output.value.class") == null) {
            conf.set("mapreduce.map.output.value.class", jobConf.getMapOutputValueClass().getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting mapreduce.map.output.value.class for stage: " + stage + " based on job level configuration. Value: " + conf.get("mapreduce.map.output.value.class")));
            }
        }
    }

    private static enum DeprecationReason {
        DEPRECATED_DIRECT_TRANSLATION,
        DEPRECATED_MULTI_STAGE;

    }
}

