/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.committer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileOutputCommitter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.client.VertexStatus;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.runtime.api.OutputCommitterContext;

public class MROutputCommitter
extends org.apache.tez.runtime.api.OutputCommitter {
    private static final Log LOG = LogFactory.getLog(MROutputCommitter.class);
    private OutputCommitterContext context;
    private OutputCommitter committer = null;
    private org.apache.hadoop.mapred.JobContext jobContext = null;
    private volatile boolean initialized = false;
    private JobConf jobConf = null;
    private boolean newApiCommitter;

    public void initialize(OutputCommitterContext context) throws IOException {
        byte[] userPayload = context.getUserPayload();
        this.jobConf = userPayload == null ? new JobConf() : new JobConf(MRHelpers.createConfFromUserPayload(context.getUserPayload()));
        this.jobConf.getCredentials().mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
        this.jobConf.setInt("mapreduce.job.application.attempt.id", context.getDAGAttemptNumber());
        this.context = context;
        this.committer = this.getOutputCommitter(this.context);
        this.jobContext = this.getJobContextFromVertexContext(context);
        this.initialized = true;
    }

    public void setupOutput() throws IOException {
        if (!this.initialized) {
            throw new RuntimeException("Committer not initialized");
        }
        this.committer.setupJob((JobContext)this.jobContext);
    }

    public void commitOutput() throws IOException {
        if (!this.initialized) {
            throw new RuntimeException("Committer not initialized");
        }
        this.committer.commitJob((JobContext)this.jobContext);
    }

    public void abortOutput(VertexStatus.State finalState) throws IOException {
        if (!this.initialized) {
            throw new RuntimeException("Committer not initialized");
        }
        JobStatus.State jobState = this.getJobStateFromVertexStatusState(finalState);
        this.committer.abortJob((JobContext)this.jobContext, jobState);
    }

    private OutputCommitter getOutputCommitter(OutputCommitterContext context) {
        OutputCommitter committer = null;
        this.newApiCommitter = false;
        if (this.jobConf.getBoolean("mapred.reducer.new-api", false) || this.jobConf.getBoolean("mapred.mapper.new-api", false)) {
            this.newApiCommitter = true;
            LOG.info((Object)"Using mapred newApiCommitter.");
        }
        LOG.info((Object)("OutputCommitter set in config for outputName=" + context.getOutputName() + ", vertexName=" + context.getVertexName() + ", outputCommitterClass=" + this.jobConf.get("mapred.output.committer.class")));
        if (this.newApiCommitter) {
            TaskAttemptID taskAttemptID = new TaskAttemptID(Long.toString(context.getApplicationId().getClusterTimestamp()), context.getApplicationId().getId(), this.jobConf.getBoolean("tez.mapreduce.is_map_processor", false) ? TaskType.MAP : TaskType.REDUCE, 0, context.getDAGAttemptNumber());
            TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl((Configuration)this.jobConf, taskAttemptID);
            try {
                OutputFormat outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)taskContext.getOutputFormatClass(), (Configuration)this.jobConf);
                committer = outputFormat.getOutputCommitter((TaskAttemptContext)taskContext);
            }
            catch (Exception e) {
                throw new TezUncheckedException((Throwable)e);
            }
        } else {
            committer = (OutputCommitter)ReflectionUtils.newInstance((Class)this.jobConf.getClass("mapred.output.committer.class", FileOutputCommitter.class, org.apache.hadoop.mapred.OutputCommitter.class), (Configuration)this.jobConf);
        }
        LOG.info((Object)("OutputCommitter for outputName=" + context.getOutputName() + ", vertexName=" + context.getVertexName() + ", outputCommitterClass=" + committer.getClass().getName()));
        return committer;
    }

    private org.apache.hadoop.mapred.JobContext getJobContextFromVertexContext(OutputCommitterContext context) throws IOException {
        JobID jobId = TypeConverter.fromYarn((ApplicationId)context.getApplicationId());
        return new MRJobContextImpl(this.jobConf, jobId);
    }

    private JobStatus.State getJobStateFromVertexStatusState(VertexStatus.State state) {
        switch (state) {
            case INITED: {
                return JobStatus.State.PREP;
            }
            case RUNNING: {
                return JobStatus.State.RUNNING;
            }
            case SUCCEEDED: {
                return JobStatus.State.SUCCEEDED;
            }
            case KILLED: {
                return JobStatus.State.KILLED;
            }
            case FAILED: 
            case ERROR: {
                return JobStatus.State.FAILED;
            }
        }
        throw new TezUncheckedException("Unknown VertexStatus.State: " + state);
    }

    public boolean isTaskRecoverySupported() {
        if (!this.initialized) {
            throw new RuntimeException("Committer not initialized");
        }
        return this.committer.isRecoverySupported();
    }

    public void recoverTask(int taskIndex, int attemptId) throws IOException {
        if (!this.initialized) {
            throw new RuntimeException("Committer not initialized");
        }
        TaskAttemptID taskAttemptID = new TaskAttemptID(Long.toString(this.context.getApplicationId().getClusterTimestamp()) + String.valueOf(this.context.getVertexIndex()), this.context.getApplicationId().getId(), this.jobConf.getBoolean("tez.mapreduce.is_map_processor", false) ? TaskType.MAP : TaskType.REDUCE, taskIndex, attemptId);
        TaskAttemptContextImpl taskContext = new TaskAttemptContextImpl((Configuration)this.jobConf, taskAttemptID);
        this.committer.recoverTask((TaskAttemptContext)taskContext);
    }

    private static class MRJobContextImpl
    extends JobContextImpl {
        public MRJobContextImpl(JobConf jobConf, JobID jobId) {
            super(jobConf, jobId);
        }
    }
}

