/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.File;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.log4j.FileAppender;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TezContainerLogAppender
extends FileAppender {
    private String containerLogDir;
    private String logFileName = "syslog";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateOptions() {
        TezContainerLogAppender tezContainerLogAppender = this;
        synchronized (tezContainerLogAppender) {
            this.setFile(new File(this.containerLogDir, this.logFileName).toString());
            this.setAppend(true);
            super.activateOptions();
        }
    }

    public void setLogFileName(String fileName) {
        if (fileName == null || fileName.contains(File.pathSeparator)) {
            throw new RuntimeException("Invalid filename specified: " + fileName + " . FileName should not have a path component and should not be empty.");
        }
        this.logFileName = fileName;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getContainerLogDir() {
        return this.containerLogDir;
    }

    public void setContainerLogDir(String containerLogDir) {
        this.containerLogDir = containerLogDir;
    }
}

