/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.DataMovementEvent;

@InterfaceAudience.Public
public class CompositeDataMovementEvent
extends Event {
    protected final int sourceIndexStart;
    protected final int count;
    protected int version;
    protected final ByteBuffer userPayload;

    private CompositeDataMovementEvent(int srcIndexStart, int count, ByteBuffer userPayload) {
        this.sourceIndexStart = srcIndexStart;
        this.count = count;
        this.userPayload = userPayload;
    }

    public static CompositeDataMovementEvent create(int srcIndexStart, int count, ByteBuffer userPayload) {
        return new CompositeDataMovementEvent(srcIndexStart, count, userPayload);
    }

    public int getSourceIndexStart() {
        return this.sourceIndexStart;
    }

    public int getCount() {
        return this.count;
    }

    public ByteBuffer getUserPayload() {
        return this.userPayload == null ? null : this.userPayload.asReadOnlyBuffer();
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public Iterable<DataMovementEvent> getEvents() {
        return new Iterable<DataMovementEvent>(){

            @Override
            public Iterator<DataMovementEvent> iterator() {
                return new Iterator<DataMovementEvent>(){
                    int currentPos;
                    {
                        this.currentPos = CompositeDataMovementEvent.this.sourceIndexStart;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.currentPos < CompositeDataMovementEvent.this.count + CompositeDataMovementEvent.this.sourceIndexStart;
                    }

                    @Override
                    public DataMovementEvent next() {
                        DataMovementEvent dmEvent = DataMovementEvent.create(this.currentPos, CompositeDataMovementEvent.this.userPayload);
                        ++this.currentPos;
                        dmEvent.setVersion(CompositeDataMovementEvent.this.version);
                        return dmEvent;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove not supported");
                    }
                };
            }
        };
    }
}

