/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.security.authorization;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MPersistableEntity;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.model.MResource;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryManager;
import org.apache.sqoop.security.AuthorizationHandler;
import org.apache.sqoop.security.AuthorizationManager;

public class AuthorizationEngine {
    private static final Logger LOG = Logger.getLogger(AuthorizationEngine.class);

    public static <T extends MPersistableEntity> List<T> filterResource(final MResource.TYPE type, List<T> resources) throws SqoopException {
        Collection collection = Collections2.filter(resources, (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                try {
                    String name = String.valueOf(input.getPersistenceId());
                    AuthorizationEngine.checkPrivilege(new MPrivilege[]{AuthorizationEngine.getPrivilege(type, name, MPrivilege.ACTION.READ)});
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        return Lists.newArrayList((Collection)collection);
    }

    public static void readConnector(String connectorId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.CONNECTOR, connectorId, MPrivilege.ACTION.READ));
    }

    public static void readLink(String linkId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkId, MPrivilege.ACTION.READ));
    }

    public static void createLink(String connectorId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.CONNECTOR, connectorId, MPrivilege.ACTION.READ));
    }

    public static void updateLink(String connectorId, String linkId) throws SqoopException {
        MPrivilege privilege1 = AuthorizationEngine.getPrivilege(MResource.TYPE.CONNECTOR, connectorId, MPrivilege.ACTION.READ);
        MPrivilege privilege2 = AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkId, MPrivilege.ACTION.WRITE);
        AuthorizationEngine.checkPrivilege(privilege1, privilege2);
    }

    public static void deleteLink(String linkId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkId, MPrivilege.ACTION.WRITE));
    }

    public static void enableDisableLink(String linkId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkId, MPrivilege.ACTION.WRITE));
    }

    public static void readJob(String jobId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobId, MPrivilege.ACTION.READ));
    }

    public static void createJob(String linkId1, String linkId2) throws SqoopException {
        MPrivilege privilege1 = AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkId1, MPrivilege.ACTION.READ);
        MPrivilege privilege2 = AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkId2, MPrivilege.ACTION.READ);
        AuthorizationEngine.checkPrivilege(privilege1, privilege2);
    }

    public static void updateJob(String linkId1, String linkId2, String jobId) throws SqoopException {
        MPrivilege privilege1 = AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkId1, MPrivilege.ACTION.READ);
        MPrivilege privilege2 = AuthorizationEngine.getPrivilege(MResource.TYPE.LINK, linkId2, MPrivilege.ACTION.READ);
        MPrivilege privilege3 = AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobId, MPrivilege.ACTION.WRITE);
        AuthorizationEngine.checkPrivilege(privilege1, privilege2, privilege3);
    }

    public static void deleteJob(String jobId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobId, MPrivilege.ACTION.WRITE));
    }

    public static void enableDisableJob(String jobId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobId, MPrivilege.ACTION.WRITE));
    }

    public static void startJob(String jobId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobId, MPrivilege.ACTION.WRITE));
    }

    public static void stopJob(String jobId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobId, MPrivilege.ACTION.WRITE));
    }

    public static void statusJob(String jobId) throws SqoopException {
        AuthorizationEngine.checkPrivilege(AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobId, MPrivilege.ACTION.READ));
    }

    public static List<MSubmission> filterSubmission(List<MSubmission> submissions) throws SqoopException {
        Collection collection = Collections2.filter(submissions, (Predicate)new Predicate<MSubmission>(){

            public boolean apply(MSubmission input) {
                try {
                    String jobId = String.valueOf(input.getJobId());
                    AuthorizationEngine.checkPrivilege(new MPrivilege[]{AuthorizationEngine.getPrivilege(MResource.TYPE.JOB, jobId, MPrivilege.ACTION.READ)});
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        return Lists.newArrayList((Collection)collection);
    }

    private static MPrivilege getPrivilege(MResource.TYPE resourceType, String resourceId, MPrivilege.ACTION privilegeAction) {
        return new MPrivilege(new MResource(resourceId, resourceType), privilegeAction, false);
    }

    private static void checkPrivilege(MPrivilege ... privileges) {
        AuthorizationHandler handler = AuthorizationManager.getAuthorizationHandler();
        UserGroupInformation user = HttpUserGroupInformation.get();
        String user_name = user == null ? "" : user.getShortUserName();
        MPrincipal principal = new MPrincipal(user_name, MPrincipal.TYPE.USER);
        ArrayList<MPrivilege> privilegesNeedCheck = new ArrayList<MPrivilege>();
        for (MPrivilege privilege : privileges) {
            Repository repository = RepositoryManager.getInstance().getRepository();
            if (MResource.TYPE.LINK.name().equalsIgnoreCase(privilege.getResource().getType())) {
                MLink link = repository.findLink(Long.valueOf(privilege.getResource().getName()).longValue());
                if (user_name.equals(link.getCreationUser())) continue;
                privilegesNeedCheck.add(privilege);
                continue;
            }
            if (MResource.TYPE.JOB.name().equalsIgnoreCase(privilege.getResource().getType())) {
                MJob job = repository.findJob(Long.valueOf(privilege.getResource().getName()).longValue());
                if (user_name.equals(job.getCreationUser())) continue;
                privilegesNeedCheck.add(privilege);
                continue;
            }
            privilegesNeedCheck.add(privilege);
        }
        handler.checkPrivileges(principal, privilegesNeedCheck);
    }
}

