/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.schema.type;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.schema.type.AbstractNumber;
import org.apache.sqoop.schema.type.ColumnType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class FloatingPoint
extends AbstractNumber {
    private Long byteSize;

    public FloatingPoint(String name, Long byteSize) {
        super(name);
        this.byteSize = byteSize;
    }

    public FloatingPoint(String name, Boolean nullable, Long byteSize) {
        super(name, nullable);
        this.byteSize = byteSize;
    }

    public Long getByteSize() {
        return this.byteSize;
    }

    @Override
    public ColumnType getType() {
        return ColumnType.FLOATING_POINT;
    }

    @Override
    public String toString() {
        return "FloatingPoint{" + super.toString() + ",byteSize=" + this.byteSize + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatingPoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FloatingPoint that = (FloatingPoint)o;
        return !(this.byteSize != null ? !this.byteSize.equals(that.byteSize) : that.byteSize != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.byteSize != null ? this.byteSize.hashCode() : 0);
        return result;
    }
}

