/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.schema.type;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.schema.type.AbstractDateTime;
import org.apache.sqoop.schema.type.ColumnType;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class DateTime
extends AbstractDateTime {
    private Boolean hasFraction;
    private Boolean hasTimezone;

    public DateTime(String name, Boolean hasFraction, Boolean hasTimezone) {
        super(name);
        this.hasFraction = hasFraction;
        this.hasTimezone = hasTimezone;
    }

    public DateTime(String name, Boolean nullable, Boolean hasFraction, Boolean hasTimezone) {
        super(name, nullable);
        this.hasFraction = hasFraction;
        this.hasTimezone = hasTimezone;
    }

    public Boolean hasFraction() {
        return this.hasFraction;
    }

    public DateTime setFraction(Boolean fraction) {
        this.hasFraction = fraction;
        return this;
    }

    public Boolean hasTimezone() {
        return this.hasTimezone;
    }

    @Override
    public ColumnType getType() {
        return ColumnType.DATE_TIME;
    }

    @Override
    public String toString() {
        return "Date{" + super.toString() + ",hasFraction=" + this.hasFraction + ",hasTimezone=" + this.hasTimezone + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateTime)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateTime dateTime = (DateTime)o;
        if (this.hasFraction != null ? !this.hasFraction.equals(dateTime.hasFraction) : dateTime.hasFraction != null) {
            return false;
        }
        return !(this.hasTimezone != null ? !this.hasTimezone.equals(dateTime.hasTimezone) : dateTime.hasTimezone != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.hasFraction != null ? this.hasFraction.hashCode() : 0);
        result = 31 * result + (this.hasTimezone != null ? this.hasTimezone.hashCode() : 0);
        return result;
    }
}

