/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.InputEditable;
import org.apache.sqoop.model.MBooleanInput;
import org.apache.sqoop.model.MClonable;
import org.apache.sqoop.model.MEnumInput;
import org.apache.sqoop.model.MInput;
import org.apache.sqoop.model.MIntegerInput;
import org.apache.sqoop.model.MLongInput;
import org.apache.sqoop.model.MMapInput;
import org.apache.sqoop.model.MStringInput;
import org.apache.sqoop.model.MValidatedElement;
import org.apache.sqoop.model.ModelError;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class MConfig
extends MValidatedElement
implements MClonable {
    private final List<MInput<?>> inputs;
    private Set<String> inputNames = new HashSet<String>();
    private Set<String> userOnlyEditableInputNames = new HashSet<String>();

    public MConfig(String name, List<MInput<?>> inputs) {
        super(name);
        this.inputs = inputs;
        if (inputs != null && inputs.size() > 0) {
            for (MInput<?> input : inputs) {
                this.inputNames.add(input.getName());
                if (!input.getEditable().equals((Object)InputEditable.USER_ONLY)) continue;
                this.userOnlyEditableInputNames.add(input.getName());
            }
        }
    }

    public List<MInput<?>> getInputs() {
        return this.inputs;
    }

    public Set<String> getInputNames() {
        return this.inputNames;
    }

    public Set<String> getUserOnlyEditableInputNames() {
        return this.userOnlyEditableInputNames;
    }

    public MInput<?> getInput(String inputName) {
        for (MInput<?> input : this.inputs) {
            if (!inputName.equals(input.getName())) continue;
            return input;
        }
        throw new SqoopException((ErrorCode)ModelError.MODEL_011, "Input name: " + inputName);
    }

    public MStringInput getStringInput(String inputName) {
        return (MStringInput)this.getInput(inputName);
    }

    public MEnumInput getEnumInput(String inputName) {
        return (MEnumInput)this.getInput(inputName);
    }

    public MIntegerInput getIntegerInput(String inputName) {
        return (MIntegerInput)this.getInput(inputName);
    }

    public MLongInput getLongInput(String inputName) {
        return (MLongInput)this.getInput(inputName);
    }

    public MBooleanInput getBooleanInput(String inputName) {
        return (MBooleanInput)this.getInput(inputName);
    }

    public MMapInput getMapInput(String inputName) {
        return (MMapInput)this.getInput(inputName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("config-").append(this.getName());
        sb.append(":").append(this.getPersistenceId()).append(":").append(this.inputs);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MConfig)) {
            return false;
        }
        MConfig mf = (MConfig)other;
        return this.getName().equals(mf.getName()) && this.inputs.equals(mf.inputs);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getName().hashCode();
        for (MInput<?> mi : this.inputs) {
            result = 31 * result + mi.hashCode();
        }
        return result;
    }

    @Override
    public MConfig clone(boolean cloneWithValue) {
        ArrayList copyInputs = new ArrayList();
        for (MInput<?> itr : this.getInputs()) {
            copyInputs.add((MInput)itr.clone(cloneWithValue));
        }
        MConfig copyConfig = new MConfig(this.getName(), copyInputs);
        return copyConfig;
    }
}

