/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.common;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.common.Direction;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class SupportedDirections
implements Comparable<SupportedDirections> {
    private static final char SUPPORTED_DIRECTIONS_SEPARATOR = '/';
    private boolean from;
    private boolean to;

    public SupportedDirections(boolean from, boolean to) {
        this.from = from;
        this.to = to;
    }

    public boolean isDirectionSupported(Direction direction) {
        return direction == Direction.FROM && this.from || direction == Direction.TO && this.to;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isDirectionSupported(Direction.FROM)) {
            buffer.append((Object)Direction.FROM);
            if (this.isDirectionSupported(Direction.TO)) {
                buffer.append('/');
                buffer.append((Object)Direction.TO);
            }
        } else if (this.isDirectionSupported(Direction.TO)) {
            buffer.append((Object)Direction.TO);
        }
        return buffer.toString();
    }

    public static SupportedDirections fromString(String supportedDirections) {
        boolean from = false;
        boolean to = false;
        if (supportedDirections != null && !supportedDirections.equals("")) {
            block4: for (String direction : supportedDirections.split("/")) {
                switch (Direction.valueOf(direction)) {
                    case FROM: {
                        from = true;
                        continue block4;
                    }
                    case TO: {
                        to = true;
                    }
                }
            }
        }
        return new SupportedDirections(from, to);
    }

    public static SupportedDirections fromDirection(Direction direction) {
        boolean from = false;
        boolean to = false;
        switch (direction) {
            case FROM: {
                from = true;
                break;
            }
            case TO: {
                to = true;
            }
        }
        return new SupportedDirections(from, to);
    }

    @Override
    public int compareTo(SupportedDirections o) {
        int hash = 0;
        if (this.isDirectionSupported(Direction.FROM)) {
            hash |= 1;
        }
        if (this.isDirectionSupported(Direction.TO)) {
            hash |= 2;
        }
        int oHash = 0;
        if (this.isDirectionSupported(Direction.FROM)) {
            oHash |= 1;
        }
        if (this.isDirectionSupported(Direction.TO)) {
            oHash |= 2;
        }
        return hash - oHash;
    }
}

